/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.model;

import de.bos_bremen.common.ArrayUtil;
import de.bos_bremen.gov2.jca_provider.ocf.model.CollectionHolderInvocationHandler;
import de.bos_bremen.gov2.jca_provider.ocf.model.CollectionTypedHolderProxy;
import de.bos_bremen.gov2.jca_provider.ocf.model.Disposeable;
import de.bos_bremen.gov2.jca_provider.ocf.model.ID;
import de.bos_bremen.gov2.jca_provider.ocf.model.Named;
import de.bos_bremen.gov2.jca_provider.ocf.model.Type;
import de.bos_bremen.gov2.jca_provider.ocf.model.Typed;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.NamedIDTypedMap;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public abstract class Util {
    private Util() {
    }

    public static <S extends Typed & Disposeable> CollectionTypedHolderProxy<S> getCollectionTypedHolderProxy(Class<S> instanceClass) {
        return Util.getCollectionTypedHolderProxy(instanceClass, Disposeable.NO_LOCK);
    }

    public static <S extends Typed & Disposeable> CollectionTypedHolderProxy<S> getCollectionTypedHolderProxy(Class<S> instanceClass, Object lock) {
        if (!instanceClass.isInterface()) {
            throw new IllegalArgumentException("proxy only can be created for an interface");
        }
        Object p = Proxy.newProxyInstance(instanceClass.getClassLoader(), ArrayUtil.addClass(new Class[]{instanceClass}, new Class[]{CollectionTypedHolderProxy.class}), new CollectionHolderInvocationHandler(lock));
        CollectionTypedHolderProxy<Object> result = Util.castProxy(p);
        result.setProxy((Typed)instanceClass.cast(p));
        return result;
    }

    private static <X extends Typed & Disposeable> CollectionTypedHolderProxy<X> castProxy(Object o) {
        return (CollectionTypedHolderProxy)o;
    }

    public static <X extends Typed & Disposeable> CollectionTypedHolderProxy<X> castProxy(X x) {
        return (CollectionTypedHolderProxy)x;
    }

    public static <S extends Named & ID, R extends Named & ID> NamedIDTypedMap<S> castNamedIDMap(Class<S> typeClass, NamedIDTypedMap<R> namedIDMap) {
        return namedIDMap;
    }

    public static Collection<Type> createUnmodifiableTypeCollection(Typed[] values) {
        ArrayList<Type> tmp = new ArrayList<Type>();
        ArrayList<Integer> typeValueList = new ArrayList<Integer>();
        ArrayList<String> typeNameList = new ArrayList<String>();
        for (int i = 0; i < values.length; ++i) {
            Type type = values[i].getType();
            Integer typeValue = type.getType();
            if (typeValueList.contains(typeValue)) {
                throw new IllegalArgumentException("wrong types configuration, type " + values[i].getType() + " with same type value already exists");
            }
            if (typeNameList.contains(type.getName())) {
                throw new IllegalArgumentException("wrong types configuration, type " + values[i].getType() + " with same type name already exists");
            }
            typeValueList.add(typeValue);
            typeNameList.add(type.getName());
            tmp.add(values[i].getType());
        }
        return Collections.unmodifiableCollection(tmp);
    }
}

