/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.model;

import de.bos_bremen.gov2.jca_provider.ocf.model.BitTypedAccessStrategy;
import de.bos_bremen.gov2.jca_provider.ocf.model.Disposeable;
import de.bos_bremen.gov2.jca_provider.ocf.model.NaturalTypedAccessStrategy;
import de.bos_bremen.gov2.jca_provider.ocf.model.Type;
import de.bos_bremen.gov2.jca_provider.ocf.model.TypeConstants;
import de.bos_bremen.gov2.jca_provider.ocf.model.Typed;
import de.bos_bremen.gov2.jca_provider.ocf.model.TypedManagementStrategy;
import de.bos_bremen.gov2.jca_provider.ocf.model.map.TypeImpl;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public interface TypedType {
    public TypedTypeEnum getTypedType();

    public static enum TypedTypeEnum {
        NATURAL("NATURAL", 0),
        BIT("BIT", 1);

        private String name = null;
        private int type = -1;
        private Type unknownType = null;

        private TypedTypeEnum(String name, int type) {
            this.name = name;
            this.type = type;
            this.unknownType = new TypeImpl(new Object(), this, "UNKNOWN", 0, Type.Util.NO_TYPE_INTERFACES_LIST_DOUBLE);
        }

        public String getName() {
            return this.name;
        }

        public Type getUnknownType() {
            return this.unknownType;
        }

        public int combineTypeValues(int[] typeValues) {
            int result = 0;
            if (typeValues == null || typeValues.length == 0) {
                result = 0;
            } else if (this == BIT) {
                for (int i = 0; i < typeValues.length; ++i) {
                    result += typeValues[i];
                }
            } else if (this == NATURAL) {
                result = 0;
            }
            return result;
        }

        public int[] splitTypeValues(int typeValue) throws IllegalArgumentException {
            if (typeValue < 0) {
                throw new IllegalArgumentException("illegal type value for splitting, value greater equals than 0 expected");
            }
            int[] result = null;
            if (this == BIT) {
                if (typeValue == 0) {
                    return new int[]{0};
                }
                BigInteger tmp = BigInteger.valueOf(typeValue);
                int l = 0;
                for (int i = 0; i < tmp.bitLength(); ++i) {
                    if (!tmp.testBit(i)) continue;
                    ++l;
                }
                result = new int[l];
                l = 0;
                int value = 1;
                while (typeValue != 0) {
                    if (typeValue % 2 == 1) {
                        result[l] = value;
                        ++l;
                    }
                    typeValue >>= 1;
                    value *= 2;
                }
            } else if (this == NATURAL) {
                result = new int[]{typeValue};
            }
            return result;
        }

        public Type combineTypes(Type[] types) throws IllegalArgumentException {
            Type result = TypeConstants.UNKNOWN_TYPE_NATURAL;
            if (types == null || types.length == 0) {
                result = null;
            } else {
                if (this == NATURAL) {
                    for (int i = 0; i < types.length; ++i) {
                        if (types[i].getTypedType() == this) continue;
                        throw new IllegalArgumentException("illegal kind of type for combining");
                    }
                    return TypeConstants.UNKNOWN_TYPE_NATURAL;
                }
                if (this == BIT) {
                    StringBuffer nameBuffer = new StringBuffer();
                    int type = 0;
                    TypedTypeEnum kind = this;
                    ArrayList interfacesList = new ArrayList();
                    Arrays.sort(types, Type.TYPE_COMPARATOR);
                    ArrayList<String> nameList = new ArrayList<String>();
                    for (int i = 0; i < types.length; ++i) {
                        if (types[i].getTypedType() != this) {
                            throw new IllegalArgumentException("illegal kind of type for combining");
                        }
                        if (this.splitTypeValues(types[i].getType()).length != 1) {
                            throw new IllegalArgumentException("illegal type for combining, type value is not represented by a single bit");
                        }
                        if (nameList.indexOf(types[i].getName()) < 0 && (type & types[i].getType()) != types[i].getType()) {
                            if (i != 0) {
                                nameBuffer.append(",");
                            }
                            type += types[i].getType();
                            nameBuffer.append(types[i].getName());
                            nameList.add(types[i].getName());
                            interfacesList.add(types[i].getTypeInterfaceList().size() == 1 ? types[i].getTypeInterfaceList().get(0) : Type.Util.NO_TYPE_INTERFACES_LIST_SINGLE);
                            continue;
                        }
                        if (nameList.indexOf(types[i].getName()) >= 0 && (type & types[i].getType()) == types[i].getType()) continue;
                        if (nameList.indexOf(types[i].getName()) >= 0) {
                            throw new IllegalArgumentException("name used before, types contains double entry or same name used for different types: " + types[i]);
                        }
                        if ((type & types[i].getType()) != types[i].getType()) continue;
                        throw new IllegalArgumentException("type value used before, types contains double entry or type value used for different types: " + types[i]);
                    }
                    result = new TypeImpl(Disposeable.NO_LOCK, kind, nameBuffer.toString(), type, interfacesList);
                }
            }
            return result;
        }

        public Type[] splitTypes(Type type) throws IllegalArgumentException {
            Type[] result = null;
            if (type == null) {
                result = new Type[]{};
            } else if (this == NATURAL) {
                if (type.getTypedType() != this) {
                    throw new IllegalArgumentException("illegal kind of type for splitting");
                }
                result = new Type[]{type};
            } else if (this == BIT) {
                int[] typeValues;
                if (type.getTypedType() != this) {
                    throw new IllegalArgumentException("illegal kind of type for splitting");
                }
                String[] names = type.getName().split(",");
                if (names.length != (typeValues = this.splitTypeValues(type.getType())).length) {
                    throw new IllegalArgumentException("count of type names and single types does not fit together");
                }
                result = new Type[names.length];
                for (int i = 0; i < typeValues.length; ++i) {
                    result[i] = new TypeImpl(BIT, names[i], typeValues[i], type.getTypeInterfaceList().get(i) != null ? type.getTypeInterfaceList().get(i).toArray(new Class[0]) : Type.Util.NO_TYPE_INTERFACES_LIST_SINGLE.toArray(new Class[0]));
                }
            }
            return result;
        }

        public int[] splitTypeValues(Type type) {
            int[] result = null;
            if (this == BIT) {
                if (type.getTypedType() != this) {
                    throw new IllegalArgumentException("illegal kind of type for splitting");
                }
                result = this.splitTypeValues(type.getType());
            } else if (this == NATURAL) {
                if (type.getTypedType() != this) {
                    throw new IllegalArgumentException("illegal kind of type for splitting");
                }
                result = this.splitTypeValues(type.getType());
            }
            return result;
        }

        public int getType() {
            return this.type;
        }

        public <T extends Typed & Disposeable> TypedManagementStrategy<T> createTypedManagementStrategy(Collection<Type> admittedTypeValueList) {
            if (this == NATURAL) {
                return new NaturalTypedAccessStrategy(Disposeable.NO_LOCK, this, admittedTypeValueList);
            }
            if (this == BIT) {
                return new BitTypedAccessStrategy(Disposeable.NO_LOCK, this, admittedTypeValueList);
            }
            return null;
        }
    }
}

