/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.model;

import de.bos_bremen.gov2.jca_provider.ocf.model.Described;
import de.bos_bremen.gov2.jca_provider.ocf.model.Disposeable;
import de.bos_bremen.gov2.jca_provider.ocf.model.ID;
import de.bos_bremen.gov2.jca_provider.ocf.model.Named;
import de.bos_bremen.gov2.jca_provider.ocf.model.Type;
import de.bos_bremen.gov2.jca_provider.ocf.model.TypeRuleInfo;
import de.bos_bremen.gov2.jca_provider.ocf.model.Typed;
import de.bos_bremen.gov2.jca_provider.ocf.model.TypedType;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public interface TypeRule
extends Named,
ID,
Disposeable,
Described {
    public static final int RULE_TYPE_AND = 0;
    public static final int RULE_TYPE_OR_ONE_OR_MORE_OF_TYPE_SET = 1;
    public static final int RULE_TYPE_OR_ONLY_ONE_OF_TYPE_SET = 2;
    public static final int ERROR_TYPE_ERROR = 1;
    public static final int ERROR_TYPE_WARNING = 2;

    public TypeRuleInfo getDependencyInfo();

    public TypeRuleInfo getIndicatorInfo();

    public Set<Type> getIndicatorSet();

    public int getIndicatorType();

    public Set<Type> getDependencySet();

    public int getDependencyType();

    public int getErrorType();

    public TypedType.TypedTypeEnum getTypedType();

    public boolean isResponsibleFor(Typed var1);

    public boolean isResponsibleFor(Type var1);

    public boolean isSatisfiedBy(Typed var1) throws IllegalArgumentException;

    public boolean isSatisfiedBy(Type var1) throws IllegalArgumentException;

    public static class Util {
        private Util() {
        }

        public static Set<Type> getTypeSet(TypedType.TypedTypeEnum typedType, Type type) {
            Type[] types = typedType.splitTypes(type);
            List<Type> typeCollection = Arrays.asList(types);
            HashSet<Type> typeSet = new HashSet<Type>(typeCollection);
            return typeSet;
        }

        public static boolean isSatisfied(TypeRuleInfo info, Set<Type> typeSet) throws IllegalArgumentException {
            boolean result = false;
            switch (info.getType()) {
                case 0: {
                    result = typeSet.containsAll(info.getTypeSet());
                    break;
                }
                case 1: {
                    typeSet.retainAll(info.getTypeSet());
                    result = typeSet.size() >= 1;
                    break;
                }
                case 2: {
                    typeSet.retainAll(info.getTypeSet());
                    result = typeSet.size() == 1;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown info type");
                }
            }
            return result;
        }
    }
}

