/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.model;

import de.bos_bremen.gov2.jca_provider.ocf.model.Described;
import de.bos_bremen.gov2.jca_provider.ocf.model.Disposeable;
import de.bos_bremen.gov2.jca_provider.ocf.model.Named;
import de.bos_bremen.gov2.jca_provider.ocf.model.TypeRule;
import de.bos_bremen.gov2.jca_provider.ocf.model.TypedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

public interface Type
extends TypedType,
Named,
Disposeable,
Described {
    public static final Comparator<Type> TYPE_COMPARATOR = new Comparator<Type>(){

        @Override
        public int compare(Type o1, Type o2) {
            int diff = o1.getType() - o2.getType();
            if (diff > 0) {
                return 1;
            }
            if (diff < 0) {
                return -1;
            }
            return 0;
        }
    };

    public int getType();

    public List<List<Class<?>>> getTypeInterfaceList();

    public Set<TypeRule> getTypeRuleSet();

    public void initTypeRuleSet(Object var1, Set<TypeRule> var2);

    public boolean equals(Object var1);

    public int hashCode();

    public static class Util {
        public static final List<Class<?>> NO_TYPE_INTERFACES_LIST_SINGLE = Collections.unmodifiableList(new ArrayList());
        public static final List<List<Class<?>>> NO_TYPE_INTERFACES_LIST_DOUBLE;

        private Util() {
        }

        public static int hashCode(Type type) {
            int hashCode = 43;
            hashCode = hashCode * 43 + type.getType() * 7;
            hashCode = hashCode * 43 + (type.getTypedType() == TypedType.TypedTypeEnum.BIT ? 1 : 0) * 7;
            hashCode = hashCode * 43 + Arrays.hashCode(type.getName().toCharArray()) * 7;
            if (type.getTypeInterfaceList() != null) {
                for (int i = 0; i < type.getTypeInterfaceList().size(); ++i) {
                    hashCode = type.getTypeInterfaceList().get(i) != null ? hashCode * 43 + Arrays.hashCode(type.getTypeInterfaceList().get(i).toArray(new Class[0])) * 7 : hashCode * 43 + 7;
                }
            }
            if (type.getTypeRuleSet() != null) {
                hashCode = hashCode * 43 + Arrays.hashCode(type.getTypeRuleSet().toArray(new TypeRule[0])) * 7;
            }
            return hashCode;
        }

        public boolean equals(Type type, Object obj) {
            if (type == obj) {
                return true;
            }
            if (type.hashCode() == obj.hashCode()) {
                return true;
            }
            if (!Type.class.isInstance(obj)) {
                return false;
            }
            Type anotherObject = (Type)obj;
            return type.getTypedType() == anotherObject.getTypedType() && type.getType() == anotherObject.getType() && type.getName().equals(anotherObject.getName());
        }

        public static List<List<Class<?>>> createDoubleListFromArray(Class<?>[] classes) {
            ArrayList result = new ArrayList();
            List<Class<?>> classList = Util.createSingleListFromArray(classes);
            if (classList != null) {
                result.add(classList);
            }
            return result;
        }

        public static List<Class<?>> createSingleListFromArray(Class<?>[] classes) {
            List<Class<?>> result = null;
            if (classes != null && classes.length > 0) {
                result = Arrays.asList(classes);
                result = Collections.unmodifiableList(result);
            }
            return result;
        }

        static {
            ArrayList tmp = new ArrayList();
            tmp.add(NO_TYPE_INTERFACES_LIST_SINGLE);
            NO_TYPE_INTERFACES_LIST_DOUBLE = Collections.unmodifiableList(tmp);
        }
    }
}

