/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.model;

import de.bos_bremen.gov2.jca_provider.ocf.model.AbstractDisposeableObject;
import de.bos_bremen.gov2.jca_provider.ocf.model.CollectionTypedHolderProxy;
import de.bos_bremen.gov2.jca_provider.ocf.model.Disposeable;
import de.bos_bremen.gov2.jca_provider.ocf.model.Typed;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class CollectionHolderInvocationHandler<T extends Typed & Disposeable>
extends AbstractDisposeableObject
implements InvocationHandler,
CollectionTypedHolderProxy<T> {
    private static final List<String> collectionHolderMethodNames;
    private Object lock = null;
    private Collection<T> collection = null;
    private Collection<T> unmodifiableCollection = null;
    private T proxyInstance = null;

    public CollectionHolderInvocationHandler() {
        this(NO_LOCK);
    }

    public CollectionHolderInvocationHandler(Object lock) {
        super(lock);
        this.lock = lock;
        this.collection = new ArrayList<T>();
        this.unmodifiableCollection = Collections.unmodifiableCollection(this.collection);
    }

    @Override
    public Object invoke(Object instance, Method method, Object[] arguments) throws Throwable {
        if (collectionHolderMethodNames.indexOf(method.getName()) >= 0) {
            return method.invoke((Object)this, arguments);
        }
        if ("toString".equals(method.getName())) {
            return this.toString();
        }
        if ("equals".equals(method.getName())) {
            return this == arguments[0];
        }
        return method.invoke(this.proxyInstance, arguments);
    }

    @Override
    public Collection<T> getCollection() {
        return this.collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean disposeInt() {
        CollectionHolderInvocationHandler collectionHolderInvocationHandler = this;
        synchronized (collectionHolderInvocationHandler) {
            for (Typed tmp : this.collection) {
                if (((Disposeable)((Object)tmp)).isDisposed()) continue;
                Typed typed = tmp;
                synchronized (typed) {
                    if (((Disposeable)((Object)tmp)).isLock(NO_LOCK)) {
                        ((Disposeable)((Object)tmp)).dispose(NO_LOCK);
                    } else if (((Disposeable)((Object)tmp)).isLock(this.lock)) {
                        ((Disposeable)((Object)tmp)).dispose(this.lock);
                    }
                }
            }
            this.collection.clear();
            this.collection = null;
            this.unmodifiableCollection = null;
            this.lock = null;
            return true;
        }
    }

    @Override
    public T getProxy() {
        return this.proxyInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProxy(T proxyInstance) {
        CollectionHolderInvocationHandler collectionHolderInvocationHandler = this;
        synchronized (collectionHolderInvocationHandler) {
            if (!super.isDisposed() && this.proxyInstance == null) {
                this.proxyInstance = proxyInstance;
            }
        }
    }

    @Override
    public Collection<T> getUnmodifiableCollection() {
        return this.unmodifiableCollection;
    }

    static {
        ArrayList<String> tmp = new ArrayList<String>();
        Method[] methods = CollectionTypedHolderProxy.class.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            tmp.add(methods[i].getName());
        }
        collectionHolderMethodNames = Collections.unmodifiableList(tmp);
    }
}

