/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.model;

import de.bos_bremen.gov2.jca_provider.ocf.FileEntry;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardObject;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardObjectManager;
import de.bos_bremen.gov2.jca_provider.ocf.model.Type;
import de.bos_bremen.gov2.jca_provider.ocf.model.Typed;
import de.bos_bremen.gov2.jca_provider.ocf.model.TypedType;
import de.bos_bremen.gov2.jca_provider.ocf.model.Util;
import de.bos_bremen.gov2.jca_provider.ocf.model.map.TypeImpl;
import iso.std.iso_iec._24727.tech.schema.CardApplicationType;
import java.security.KeyStore;
import java.util.Collection;
import java.util.List;

public interface CardApplication
extends CardObject<CardApplicationType>,
CardObjectManager {
    public static final long ID_BASE = 1000000L;
    public static final String TYPE_NAME_UNKNOWN = "UNKNOWN";
    public static final int TYPE_VALUE_UNKNOWN = 0;
    public static final String TYPE_NAME_SIGNATURE = "SignatureApplication";
    public static final int TYPE_VALUE_SIGNATURE = 1;
    public static final String TYPE_NAME_DECRYPTION = "DecryptionApplication";
    public static final int TYPE_VALUE_DECRYPTION = 2;
    public static final String TYPE_NAME_ENCRYPTION = "EncryptionApplication";
    public static final int TYPE_VALUE_ENCRYPTION = 4;
    public static final String TYPE_NAME_AUTHENTICATION = "AuthenticationApplication";
    public static final int TYPE_VALUE_AUTHENTICATION = 8;
    public static final String TYPE_NAME_ESIGN = "ESIGN";
    public static final int TYPE_VALUE_ESIGN = 16;
    public static final String TYPE_NAME_QUALIFIED_SIGNATURE = "QualifiedSignatureApplication";
    public static final int TYPE_VALUE_QUALIFIED_SIGNATURE = 32;
    public static final String TYPE_NAME_DSIG = "DSIG";
    public static final int TYPE_VALUE_DSIG = 64;
    public static final String TYPE_NAME_PKCS15 = "PKCS15";
    public static final int TYPE_VALUE_PKCS15 = 128;
    public static final String TYPE_NAME_CIA = "CIA";
    public static final int TYPE_VALUE_CIA = 256;
    public static final String TYPE_NAME_HCA = "HCA";
    public static final int TYPE_VALUE_HCA = 512;
    public static final String TYPE_NAME_HPA = "HPA";
    public static final int TYPE_VALUE_HPA = 1024;
    public static final String TYPE_NAME_KVK = "KVK";
    public static final int TYPE_VALUE_KVK = 2048;
    public static final String TYPE_NAME_MF = "MF";
    public static final int TYPE_VALUE_MF = 4096;
    public static final String TYPE_NAME_USAGE_UNKNOWN = "UNKNOWN";
    public static final int TYPE_VALUE_USAGE_UNKNOWN = 0;
    public static final String TYPE_NAME_USAGE_EGOVERNMENT = "EGOVERNMENT";
    public static final int TYPE_VALUE_USAGE_EGOVERNMENT = 1;
    public static final String TYPE_NAME_USAGE_EHEALTH = "EHEALTH";
    public static final int TYPE_VALUE_USAGE_EHEALTH = 2;
    public static final String TYPE_NAME_USAGE_EPAYMENT = "EPAYMENT";
    public static final int TYPE_VALUE_USAGE_EPAYMENT = 4;
    public static final TypedType.TypedTypeEnum TYPE_KIND = TypedType.TypedTypeEnum.BIT;

    public GovCS getCardService();

    public OCFCertificateInfo[] getAllCertificates();

    public OCFCertificateInfo[] getCertificates();

    public boolean isRootApplication();

    public KeyStore getKeyStore();

    public List<String> getKeyNameList();

    public FileEntry getFileEntry();

    public static enum CardApplicationUsageTypeEnum implements Typed
    {
        UNKNOWN("UNKNOWN", 0),
        EGOVERNMENT("EGOVERNMENT", 1),
        EHEALTH("EHEALTH", 2),
        EPAYMENT("EPAYMENT", 4);

        public static final Collection<Type> TYPES;
        private Type type = null;

        private CardApplicationUsageTypeEnum(String name, int typeValue) {
            this.type = "UNKNOWN".equals(name) ? TYPE_KIND.getUnknownType() : new TypeImpl(TYPE_KIND, name, typeValue, Type.Util.NO_TYPE_INTERFACES_LIST_DOUBLE);
        }

        public List<List<Class<?>>> getTypeInterfaceList() {
            return this.type.getTypeInterfaceList();
        }

        @Override
        public TypedType.TypedTypeEnum getTypedType() {
            return this.type.getTypedType();
        }

        public String getName() {
            return this.type.getName();
        }

        public void initName(String name) {
        }

        public boolean changeLock(Object oldLock, Object newLock) throws IllegalStateException, IllegalArgumentException {
            return false;
        }

        public boolean dispose(Object lock) throws IllegalArgumentException, IllegalStateException {
            return false;
        }

        public void initLock(Object lock) {
        }

        public boolean isDisposed() {
            return false;
        }

        public boolean isLock(Object lock) {
            return false;
        }

        public String getDescription() {
            return null;
        }

        @Override
        public Type getType() {
            return this.type;
        }

        @Override
        public int getTypeValue() {
            return this.type.getType();
        }

        @Override
        public void initType(Type type) {
        }

        static {
            Typed[] values = CardApplicationUsageTypeEnum.values();
            TYPES = Util.createUnmodifiableTypeCollection(values);
        }
    }

    public static enum CardApplicationTypeEnum implements Typed
    {
        UNKNOWN("UNKNOWN", 0),
        SIGNATURE("SignatureApplication", 1),
        DECRYPTION("DecryptionApplication", 2),
        ENCRYPTION("EncryptionApplication", 4),
        AUTHENTICATION("AuthenticationApplication", 8),
        ESIGN("ESIGN", 16),
        QUALIFIED_SIGNATURE("QualifiedSignatureApplication", 32),
        DSIG("DSIG", 64),
        PKCS15("PKCS15", 128),
        CIA("CIA", 256),
        HCA("HCA", 512),
        HPA("HPA", 1024),
        KVK("KVK", 2048),
        MF("MF", 4096);

        public static final Collection<Type> TYPES;
        private Type type = null;

        private CardApplicationTypeEnum(String name, int typeValue) {
            this.type = "UNKNOWN".equals(name) ? TYPE_KIND.getUnknownType() : new TypeImpl(TYPE_KIND, name, typeValue, Type.Util.NO_TYPE_INTERFACES_LIST_DOUBLE);
        }

        public List<List<Class<?>>> getTypeInterfaceList() {
            return this.type.getTypeInterfaceList();
        }

        @Override
        public TypedType.TypedTypeEnum getTypedType() {
            return this.type.getTypedType();
        }

        public String getName() {
            return this.type.getName();
        }

        public void initName(String name) {
        }

        public boolean changeLock(Object oldLock, Object newLock) throws IllegalStateException, IllegalArgumentException {
            return false;
        }

        public boolean dispose(Object lock) throws IllegalArgumentException, IllegalStateException {
            return false;
        }

        public void initLock(Object lock) {
        }

        public boolean isDisposed() {
            return false;
        }

        public boolean isLock(Object lock) {
            return false;
        }

        public String getDescription() {
            return null;
        }

        @Override
        public Type getType() {
            return this.type;
        }

        @Override
        public int getTypeValue() {
            return this.type.getType();
        }

        @Override
        public void initType(Type type) {
        }

        static {
            Typed[] values = CardApplicationTypeEnum.values();
            TYPES = Util.createUnmodifiableTypeCollection(values);
        }
    }
}

