/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.model;

import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardApplication;
import de.bos_bremen.gov2.jca_provider.ocf.model.TerminalObject;
import de.bos_bremen.gov2.jca_provider.ocf.model.Type;
import de.bos_bremen.gov2.jca_provider.ocf.model.Typed;
import de.bos_bremen.gov2.jca_provider.ocf.model.TypedType;
import de.bos_bremen.gov2.jca_provider.ocf.model.Util;
import de.bos_bremen.gov2.jca_provider.ocf.model.map.TypeImpl;
import iso.std.iso_iec._24727.tech.schema.CardInfoType;
import java.util.Collection;
import java.util.List;
import opencard.core.service.SmartCard;

public interface Card
extends TerminalObject,
CardApplication {
    public static final TypedType.TypedTypeEnum TYPE_KIND = TypedType.TypedTypeEnum.NATURAL;
    public static final String TYPE_NAME_UNKNOWN = "UNKNOWN";
    public static final int TYPE_VALUE_UNKNOWN = 0;
    public static final String TYPE_NAME_TELESEC_PKS = "TeleSec PKS";
    public static final int TYPE_VALUE_TELESEC_PKS = 1;
    public static final String TYPE_NAME_TELESEC_NETKEY10 = "TeleSec NetKey10";
    public static final int TYPE_VALUE_TELESEC_NETKEY10 = 2;
    public static final String TYPE_NAME_TELESEC_NETKEY2000 = "TeleSec NetKey2000";
    public static final int TYPE_VALUE_TELESEC_NETKEY2000 = 3;
    public static final String TYPE_NAME_TELESEC_NETKEYE4 = "TeleSec NetKeyE4";
    public static final int TYPE_VALUE_TELESEC_NETKEYE4 = 4;
    public static final String TYPE_NAME_TELESEC_NETKEY30 = "TeleSec NetKey30";
    public static final int TYPE_VALUE_TELESEC_NETKEY30 = 5;
    public static final String TYPE_NAME_TELESEC_NETKEY30M = "TeleSec NetKey30M";
    public static final int TYPE_VALUE_TELESEC_NETKEY30M = 6;
    public static final String TYPE_NAME_IHK_CHAMBERCARD10 = "IHK ChamberCard 1.0";
    public static final int TYPE_VALUE_IHK_CHAMBERCARD10 = 7;
    public static final String TYPE_NAME_IHK_CHAMBERCARD20 = "IHK ChamberCard 2.0";
    public static final int TYPE_VALUE_IHK_CHAMBERCARD20 = 8;
    public static final String TYPE_NAME_DTRUST_10 = "DTrust 1.0";
    public static final int TYPE_VALUE_DTRUST_10 = 9;
    public static final String TYPE_NAME_DTRUST_11 = "DTrust 1.1";
    public static final int TYPE_VALUE_DTRUST_11 = 10;
    public static final String TYPE_NAME_DTRUST_10_BURGERCARD = "DTrust-BC 1.0";
    public static final int TYPE_VALUE_DTRUST_10_BURGERCARD = 11;
    public static final String TYPE_NAME_DTRUST_11_BURGERCARD = "DTrust-BC 1.1";
    public static final int TYPE_VALUE_DTRUST_11_BURGERCARD = 12;
    public static final String TYPE_NAME_DTRUST_22_2CC = "DTrust 2.2 2cc";
    public static final int TYPE_VALUE_DTRUST_22_2CC = 13;
    public static final String TYPE_NAME_DTRUST_22_3CC = "DTrust 2.2 3cc";
    public static final int TYPE_VALUE_DTRUST_22_3CC = 14;
    public static final String TYPE_NAME_DTRUST_22_2CC_MULTISIGN = "DTrust 2.2 2cc (multisign)";
    public static final int TYPE_VALUE_DTRUST_22_2CC_MULTISIGN = 15;
    public static final String TYPE_NAME_DTRUST_22_3CC_MULTISIGN = "DTrust 2.2 3cc (multisign)";
    public static final int TYPE_VALUE_DTRUST_22_3CC_MULTISIGN = 16;
    public static final String TYPE_NAME_DTRUST_23_2CC = "DTrust 2.3 2cc";
    public static final int TYPE_VALUE_DTRUST_23_2CC = 17;
    public static final String TYPE_NAME_DTRUST_23_3CC = "DTrust 2.3 3cc";
    public static final int TYPE_VALUE_DTRUST_23_3CC = 18;
    public static final String TYPE_NAME_DTRUST_23_2CC_MULTISIGN = "DTrust 2.3 2cc (multisign)";
    public static final int TYPE_VALUE_DTRUST_23_2CC_MULTISIGN = 19;
    public static final String TYPE_NAME_DTRUST_23_3CC_MULTISIGN = "DTrust 2.3 3cc (multisign)";
    public static final int TYPE_VALUE_DTRUST_23_3CC_MULTISIGN = 20;
    public static final String TYPE_NAME_DTRUST_24_2CC = "DTrust 2.4 2cc";
    public static final int TYPE_VALUE_DTRUST_24_2CC = 21;
    public static final String TYPE_NAME_DTRUST_24_3CC = "DTrust 2.4 3cc";
    public static final int TYPE_VALUE_DTRUST_24_3CC = 22;
    public static final String TYPE_NAME_DTRUST_24_2CC_MULTISIGN = "DTrust 2cc (multisign)";
    public static final int TYPE_VALUE_DTRUST_24_2CC_MULTISIGN = 23;
    public static final String TYPE_NAME_DTRUST_24_3CC_MULTISIGN = "DTrust 2.4 3cc (multisign)";
    public static final int TYPE_VALUE_DTRUST_24_3CC_MULTISIGN = 24;
    public static final String TYPE_NAME_SIGNTRUST_DP_MEDIZON_10 = "SignTrust/Medizon 1.0";
    public static final int TYPE_VALUE_SIGNTRUST_DP_MEDIZON_10 = 25;
    public static final String TYPE_NAME_SIGNTRUST_2048BIT = "SignTrust 2048bit";
    public static final int TYPE_VALUE_SIGNTRUST_2048BIT = 26;
    public static final String TYPE_NAME_SIGNTRUST_2048BIT_M100 = "SignTrust 2048bit (M100)";
    public static final int TYPE_VALUE_SIGNTRUST_2048BIT_M100 = 27;
    public static final String TYPE_NAME_SIGNTRUST_2048BIT_MCARD = "SignTrust 2048bit (MCARD)";
    public static final int TYPE_VALUE_SIGNTRUST_2048BIT_MCARD = 28;
    public static final String TYPE_NAME_BNOTK = "Bundesnotarkammer Karte";
    public static final int TYPE_VALUE_BNOTK = 29;
    public static final String TYPE_NAME_DGN = "DGNService";
    public static final int TYPE_VALUE_DGN = 30;
    public static final String TYPE_NAME_BNOTK2 = "Bundesnotarkammer Karte (v2)";
    public static final int TYPE_VALUE_BNOTK2 = 31;
    public static final String TYPE_NAME_SIGNTRUST_V2 = "SignTrust 2048bit (v2)";
    public static final int TYPE_VALUE_SIGNTRUST_V2 = 32;
    public static final String TYPE_NAME_SIGNTRUST_2048BIT_M100_V2 = "SignTrust 2048bit (v2) (M100)";
    public static final int TYPE_VALUE_SIGNTRUST_2048BIT_M100_V2 = 33;
    public static final String TYPE_NAME_SIGNTRUST_2048BIT_MCARD_V2 = "SignTrust 2048bit (v2) (MCARD)";
    public static final int TYPE_VALUE_SIGNTRUST_2048BIT_MCARD_V2 = 34;
    public static final String TYPE_NAME_DATEV_2048BIT_V2 = "Datev 2048bit (v2)";
    public static final int TYPE_VALUE_DATEV_2048BIT_V2 = 35;
    public static final String TYPE_NAME_EHC = "eHC/eGK";
    public static final int TYPE_VALUE_EHC = 36;
    public static final String TYPE_NAME_HPC = "HPC/HBA";
    public static final int TYPE_VALUE_HPC = 37;
    public static final String TYPE_NAME_KVK = "KVK";
    public static final int TYPE_VALUE_KVK = 38;
    public static final String TYPE_NAME_ATRUST10 = "ATrust 1.0";
    public static final int TYPE_VALUE_ATRUST10 = 39;
    public static final String TYPE_NAME_EU_ATRUST20 = "ATrust 2.0";
    public static final int TYPE_VALUE_EU_ATRUST20 = 40;
    public static final String TYPE_NAME_STARTRUST = "StarTrust";
    public static final int TYPE_VALUE_STARTRUST = 41;
    public static final String TYPE_NAME_TCTRUST10 = "TC Trust 1.0";
    public static final int TYPE_VALUE_TCTRUST10 = 42;
    public static final String TYPE_NAME_TCTRUST_QSIGN = "TC Trust QSign";
    public static final int TYPE_VALUE_TCTRUST_QSIGN = 43;
    public static final String TYPE_NAME_TCTRUST_QSIGN_UNLIMITED = "TC Trust QSign Unlimited";
    public static final int TYPE_VALUE_TCTRUST_QSIGN_UNLIMITED = 44;
    public static final String TYPE_NAME_DATEV = "Datev";
    public static final int TYPE_VALUE_DATEV = 45;
    public static final String TYPE_NAME_MEDISIGN_10 = "Medisign";
    public static final int TYPE_VALUE_MEDISIGN_10 = 46;
    public static final String TYPE_NAME_DR_MULTISIGN = "DR MultiSign";
    public static final int TYPE_VALUE_DR_MULTISIGN = 47;
    public static final String TYPE_NAME_BFA_BERLIN = "BfA Berlin";
    public static final int TYPE_VALUE_BFA_BERLIN = 48;
    public static final String TYPE_NAME_INFO_NOTARY = "InfoNotary";
    public static final int TYPE_VALUE_INFO_NOTARY = 49;
    public static final String TYPE_NAME_STAR_CERT_21 = "StarCert 2.1";
    public static final int TYPE_VALUE_STAR_CERT_21 = 50;
    public static final String TYPE_NAME_STAR_CERT_23 = "StarCert 2.3";
    public static final int TYPE_VALUE_STAR_CERT_23 = 51;
    public static final String TYPE_NAME_DSV_10 = "DSV 1.0";
    public static final int TYPE_VALUE_DSV_10 = 52;
    public static final String TYPE_NAME_DSV_20 = "DSV 2.0";
    public static final int TYPE_VALUE_DSV_20 = 53;
    public static final String TYPE_NAME_DSV_30 = "DSV 3.0";
    public static final int TYPE_VALUE_DSV_30 = 54;
    public static final String TYPE_NAME_DSV_40 = "DSV 4.0";
    public static final int TYPE_VALUE_DSV_40 = 55;
    public static final String TYPE_NAME_HVB_10 = "HVB 1.0";
    public static final int TYPE_VALUE_HVB_10 = 56;
    public static final String TYPE_NAME_HVB_20 = "HVB 2.0";
    public static final int TYPE_VALUE_HVB_20 = 57;
    public static final String TYPE_NAME_HVB_30 = "HVB 3.0";
    public static final int TYPE_VALUE_HVB_30 = 58;
    public static final String TYPE_NAME_EU_FINEID_21 = "FinEID 2.1";
    public static final int TYPE_VALUE_EU_FINEID_21 = 59;
    public static final String TYPE_NAME_UNKNOWN_STARCOS30 = "Unknown StarCOS 3.0";
    public static final int TYPE_VALUE_UNKNOWN_STARCOS30 = 60;
    public static final String TYPE_NAME_UNKNOWN_STARCOS32 = "Unknown StarCOS 3.2";
    public static final int TYPE_VALUE_UNKNOWN_STARCOS32 = 61;
    public static final String TYPE_NAME_UNKNOWN_STARCOS34 = "Unknown StarCOS 3.4";
    public static final int TYPE_VALUE_UNKNOWN_STARCOS34 = 62;
    public static final String TYPE_NAME_EU_EPO = "EPO 1.0";
    public static final int TYPE_VALUE_EU_EPO = 63;
    public static final String TYPE_NAME_NPA = "NPA";
    public static final int TYPE_VALUE_NPA = 64;
    public static final String TYPE_NAME_EU_AT_ATRUST = "ATRUST";
    public static final int TYPE_VALUE_EU_AT_ATRUST = 65;
    public static final String TYPE_NAME_EU_IT_INFOCERT = "InfoCert";
    public static final int TYPE_VALUE_EU_IT_INFOCERT = 66;
    public static final String TYPE_NAME_EU_F_CERTINOMIS = "Certinomis";
    public static final int TYPE_VALUE_EU_F_CERTINOMIS = 67;
    public static final String TYPE_NAME_EU_F_CERTIGNA_TOKEN = "CertignaToken";
    public static final int TYPE_VALUE_EU_F_CERTIGNA_TOKEN = 68;
    public static final String TYPE_NAME_CH_QUO_VADIS_SUISSEID = "QuoVadis-SuisseID";
    public static final int TYPE_VALUE_CH_QUO_VADIS_SUISSEID = 69;
    public static final String TYPE_NAME_CH_SWISSCOM_SUISSEID = "Swisscom SuisseID";
    public static final int TYPE_VALUE_CH_SWISSCOM_SUISSEID = 70;
    public static final String TYPE_NAME_CH_SWISSCOM_SUISSEID_MULTISIGN = "Swisscom SuisseID Multisign";
    public static final int TYPE_VALUE_CH_SWISSCOM_SUISSEID_MULTISIGN = 71;
    public static final String TYPE_NAME_CH_POST_MAIL_SUISSEID = "PostMail SuisseID";
    public static final int TYPE_VALUE_CH_POST_MAIL_SUISSEID = 72;
    public static final String TYPE_NAME_CH_QUO_VADIS_TOKEN = "QuoVadis-TokenD";
    public static final int TYPE_VALUE_CH_QUO_VADIS_TOKEN = 73;
    public static final String TYPE_NAME_VR_10 = "VR-BankCard/VR-Networld-Card 1.0";
    public static final int TYPE_VALUE_VR_10 = 74;
    public static final String TYPE_NAME_EA_LIGHT_PRE = "eArztausweis (AK Nordrhein, pre)";
    public static final int TYPE_VALUE_EA_LIGHT_PRE = 75;
    public static final String TYPE_NAME_EA_LIGHT = "eArztausweis (AK Nordrhein)";
    public static final int TYPE_VALUE_EA_LIGHT = 76;
    public static final String TYPE_NAME_DTRUST_30_STANDARD = "DTrust 3.0 (standard)";
    public static final int TYPE_VALUE_DTRUST_30_STANDARD = 77;
    public static final String TYPE_NAME_DTRUST_30_ADVANCED = "DTrust 3.0 (advanced)";
    public static final int TYPE_VALUE_DTRUST_30_ADVANCED = 78;
    public static final String TYPE_NAME_DTRUST_30_BATCH = "DTrust 3.0 (batch)";
    public static final int TYPE_VALUE_DTRUST_30_BATCH = 79;
    public static final String TYPE_NAME_DTRUST_30_MULTICARD = "DTrust 3.0 (multicard)";
    public static final int TYPE_VALUE_DTRUST_30_MULTICARD = 80;
    public static final String TYPE_NAME_BA_V2 = "BA Version2";
    public static final int TYPE_VALUE_BA_V2 = 81;
    public static final String TYPE_NAME_TCOS30_SC20 = "TCOS 3.0 Signature Card 2.0";
    public static final int TYPE_VALUE_TCOS30_SC20 = 82;
    public static final String TYPE_NAME_TCOS30_SC20_RFID = "TCOS 3.0 Signature Card 2.0 (RFID)";
    public static final int TYPE_VALUE_TCOS30_SC20_RFID = 83;
    public static final String TYPE_NAME_TCOS30_SC20_M = "TCOS 3.0 Signature Card 2.0 (multisign)";
    public static final int TYPE_VALUE_TCOS30_SC20_M = 84;
    public static final String TYPE_NAME_TCOS30_SC20_M_RFID = "TCOS 3.0 Signature Card 2.0 (multisign, RFID)";
    public static final int TYPE_VALUE_TCOS30_SC20_M_RFID = 85;
    public static final String TYPE_NAME_BA = "Bundesagentur f\u00fcr Arbeit";
    public static final int TYPE_VALUE_BA = 86;
    public static final String TYPE_NAME_STARCOS35_UNKNOWN = "Unknown StarCOS 3.5";
    public static final int TYPE_VALUE_STARCOS35_UNKNOWN = 87;
    public static final String TYPE_NAME_STARCOS35_SIGNTRUST_STANDARD = "SignTrust Standard (v3)";
    public static final int TYPE_VALUE_STARCOS35_SIGNTRUST_STANDARD = 88;
    public static final String TYPE_NAME_STARCOS35_SIGNTRUST_M100 = "SignTrust M100 (v3)";
    public static final int TYPE_VALUE_STARCOS35_SIGNTRUST_M100 = 89;
    public static final String TYPE_NAME_STARCOS35_SIGNTRUST_MCARD = "SignTrust MCard (v3)";
    public static final int TYPE_VALUE_STARCOS35_SIGNTRUST_MCARD = 90;
    public static final String TYPE_NAME_CARDOS50_UNKNOWN = "Unknown CardOS 5.0";
    public static final int TYPE_VALUE_CARDOS50_UNKNOWN = 91;
    public static final String TYPE_NAME_DR_V2_MULTISIGN = "DR V2 MultiSign";
    public static final int TYPE_VALUE_DR_V2_MULTISIGN = 92;
    public static final String TYPE_NAME_DR_V2_IDCARD = "DR V2 IDCard";
    public static final int TYPE_VALUE_DR_V2_IDCARD = 93;
    public static final String TYPE_NAME_DGN2_BUSINESS = "DGNService (business)";
    public static final int TYPE_VALUE_DGN2_BUSINESS = 94;
    public static final String TYPE_NAME_DGN2_SPRINT = "DGNService (sprint)";
    public static final int TYPE_VALUE_DGN2_SPRINT = 95;
    public static final String TYPE_NAME_BNOTK3_STAPLE = "Bundesnotarkammer Karte (v3, staple)";
    public static final int TYPE_VALUE_BNOTK3_STAPLE = 96;
    public static final String TYPE_NAME_CARDOS43B_EIDV = "CardOS 4.3 EIDV (QuoVadis, multisign)";
    public static final int TYPE_VALUE_CARDOS43B_EIDV = 97;
    public static final String TYPE_NAME_CARDOS44_BTC = "CardOS 4.4 BTC(QuoVadis, multisign)";
    public static final int TYPE_VALUE_CARDOS44_BTC = 98;
    public static final String TYPE_NAME_TCOS3_DOI = "TOCS 3.0 DOI";
    public static final int TYPE_VALUE_TCOS3_DOI = 99;
    public static final String TYPE_NAME_STARCOS35_DGN_HPC_SINGLE = "StarCOS 3.5 HPC (DGN, singlesign)";
    public static final int TYPE_VALUE_STARCOS35_DGN_HPC_SINGLE = 100;
    public static final String TYPE_NAME_STARCOS35_DGN_HPC_STAPLE = "StarCOS 3.5 HPC (DGN, staplesign)";
    public static final int TYPE_VALUE_STARCOS35_DGN_HPC_STAPLE = 101;
    public static final String TYPE_NAME_STARCOS35_DGN_ZOD_HPC = "StarCOS 3.5 ZOD-HPC";
    public static final int TYPE_VALUE_STARCOS35_DGN_ZOD_HPC = 102;
    public static final String TYPE_NAME_STARCOS34_DATEV_V3 = "StarCOS 3.4 DATEV V.3";
    public static final int TYPE_VALUE_STARCOS34_DATEV_V3 = 103;
    public static final String TYPE_NAME_BNOTK3_MULTI = "Bundesnotarkammer Karte (v3, multi)";
    public static final int TYPE_VALUE_BNOTK3_MULTI = 104;
    public static final String TYPE_NAME_DGN3_BUSINESS = "DGNService3 (business)";
    public static final int TYPE_VALUE_DGN3_BUSINESS = 105;
    public static final String TYPE_NAME_DGN3_SPRINT = "DGNService3 (sprint)";
    public static final int TYPE_VALUE_DGN3_SPRINT = 106;
    public static final String TYPE_NAME_BA_MULTISIGN_V2 = "BA MultiSign Version2";
    public static final int TYPE_VALUE_BA_MULTISIGN_V2 = 107;
    public static final String TYPE_NAME_BNOTK_BEA_MA = "beA Mitarbeiterkarte";
    public static final int TYPE_VALUE_BNOTK_BEA_MA = 108;
    public static final String TYPE_NAME_BW_PKI14 = "BW PKI 1.4 Karte";
    public static final int TYPE_VALUE_BW_PK14 = 109;
    public static final String TYPE_NAME_DTRUST31_STANDARD = "D-Trust 3.1 Standard";
    public static final int TYPE_VALUE_DTRUST31_STANDARD = 110;
    public static final String TYPE_NAME_DTRUST31_MULTICARD100 = "D-Trust 3.1 Multicard100";
    public static final int TYPE_VALUE_DTRUST31_MULTICARD100 = 111;
    public static final String TYPE_NAME_DTRUST31_MULTICARD = "D-Trust 3.1 Multicard";
    public static final int TYPE_VALUE_DTRUST31_MULTICARD = 112;
    public static final String TYPE_NAME_DTRUST34_STANDARD = "D-Trust 3.4 Standard";
    public static final int TYPE_VALUE_DTRUST34_STANDARD = 113;
    public static final String TYPE_NAME_DTRUST34_MULTICARD = "D-Trust 3.4 Multicard";
    public static final int TYPE_VALUE_DTRUST34_MULTICARD = 114;
    public static final String TYPE_NAME_BNOTK3_BEA_STAPLE = "bea Basis Bundesnotarkammer Karte (v3, staple)";
    public static final int TYPE_VALUE_BNOTK3_BEA_STAPLE = 115;
    public static final String TYPE_NAME_DTRUST41_MULTICARD_ECC = "D-Trust 3.4 Multicard ECC";
    public static final int TYPE_VALUE_DTRUST41_MULTICARD_ECC = 116;
    public static final String TYPE_NAME_DTRUST41_MULTICARD100_ECC = "D-Trust 4.1 M100 ECC";
    public static final int TYPE_VALUE_DTRUST41_MULTICARD100_ECC = 117;
    public static final String TYPE_NAME_DTRUST41_STANDARD_RSA = "D-Trust 4.1 Standard RSA";
    public static final int TYPE_VALUE_DTRUST41_STANDARD_RSA = 118;
    public static final String TYPE_NAME_DTRUST44_MULTICARD_ECC_SEAL = "D-Trust 4.4 Multicard Seal ECC";
    public static final int TYPE_VALUE_DTRUST44_MULTICARD_ECC_SEAL = 119;
    public static final String TYPE_NAME_DTRUST44_STANDARD_RSA_SEAL = "D-Trust 4.4 Standard Seal RSA";
    public static final int TYPE_VALUE_DTRUST44_STANDARD_RSA_SEAL = 120;
    public static final String TYPE_NAME_BNOTK_V2_GP = "BNotK V.2 (GP)";
    public static final int TYPE_VALUE_BNOTK_V2_GP = 121;
    public static final String TYPE_NAME_DGN4 = "DGNService4";
    public static final int TYPE_VALUE_DGN4 = 122;
    public static final String TYPE_NAME_EHBA_G2 = "eHBA_G2";
    public static final int TYPE_VALUE_EHBA_G2 = 123;
    public static final String TYPE_NAME_DTRUST51_MULTICARD_ECC = "D-Trust 5.1 Multicard ECC";
    public static final int TYPE_VALUE_DTRUST51_MULTICARD_ECC = 124;
    public static final String TYPE_NAME_DTRUST51_MULTICARD100_ECC = "D-Trust 5.1 M100 ECC";
    public static final int TYPE_VALUE_DTRUST51_MULTICARD100_ECC = 125;
    public static final String TYPE_NAME_DTRUST51_STANDARD_RSA = "D-Trust 5.1 Standard RSA";
    public static final int TYPE_VALUE_DTRUST51_STANDARD_RSA = 126;
    public static final String TYPE_NAME_DTRUST54_MULTICARD_ECC = "D-Trust 5.4 Seal Multicard ECC";
    public static final int TYPE_VALUE_DTRUST54_MULTICARD_ECC = 127;
    public static final String TYPE_NAME_DTRUST54_STANDARD_RSA = "D-Trust 5.4 Seal Standard RSA";
    public static final int TYPE_VALUE_DTRUST54_STANDARD_RSA = 128;
    public static final String TYPE_NAME_CARDOS60_UNKNOWN = "Unknown CardOS 6.0";
    public static final int TYPE_VALUE_CARDOS60_UNKNOWN = 129;
    public static final String CARD_ISSUER_UNKNOWN = "UnknownIssuer";
    public static final String TYPE_NAME_DR_V3_IDCARD = "DR V3 IDCard";
    public static final int TYPE_VALUE_DR_V3_IDCARD = 130;
    public static final String TYPE_NAME_TCOS30_SC30 = "TCOS 3.0 Signature Card 3.0";
    public static final int TYPE_VALUE_TCOS30_SC30 = 131;
    public static final String TYPE_NAME_TCOS30_SC30_RFID = "TCOS 3.0 Signature Card 3.0 (RFID)";
    public static final int TYPE_VALUE_TCOS30_SC30_RFID = 132;
    public static final String TYPE_NAME_TCOS30_SC30_M = "TCOS 3.0 Signature Card 3.0 (multisign)";
    public static final int TYPE_VALUE_TCOS30_SC30_M = 133;
    public static final String TYPE_NAME_TCOS30_SC30_M_RFID = "TCOS 3.0 Signature Card 3.0 (multisign, RFID)";
    public static final int TYPE_VALUE_TCOS30_SC30_M_RFID = 134;
    public static final String CARD_ISSUER_DTRUST = "DTrust";
    public static final String CARD_ISSUER_TELESEC = "TeleSec";
    public static final String CARD_ISSUER_TCTRUST = "TCTrust";
    public static final String CARD_ISSUER_DSV = "DSV";
    public static final String CARD_ISSUER_VR = "VR";
    public static final String CARD_ISSUER_SIGNTRUST_DP_MEDIZON = "SignTrust/Deutsche Post/Medizon";
    public static final String CARD_ISSUER_SIGNTRUST = "SignTrust";
    public static final String CARD_ISSUER_EU_ATRUST = "ATrust";
    public static final String CARD_ISSUER_HVB = "HypoVereinsbank";
    public static final String CARD_ISSUER_DATEV = "Datev";
    public static final String CARD_ISSUER_MEDISIGN = "MediSign";
    public static final String CARD_ISSUER_DGNSERVICE = "DGNService";
    public static final String CARD_ISSUER_STARTRUST = "Startrust";
    public static final String CARD_ISSUER_GD = "G&D";
    public static final String CARD_ISSUER_IHK = "IHK";
    public static final String CARD_ISSUER_BNOTK = "BNOTK";
    public static final String CARD_ISSUER_DR = "Deutsche Rente";
    public static final String CARD_ISSUER_BFA_BERLIN = "BfA Berlin";
    public static final String CARD_ISSUER_BA = "Bundesagentur fuer Arbeit";
    public static final String CARD_ISSUER_AK_NORDRHEIN = "\u00c4rztekammer Nordrhein";
    public static final String CARD_ISSUER_EU_INFO_NOTARY = "InfoNotary";
    public static final String CARD_ISSUER_EU_FINEID = "FinEID";
    public static final String CARD_ISSUER_EU_EPO = "European Patent Office";
    public static final String CARD_ISSUER_DP_COM = "DPCom";
    public static final String CARD_ISSUER_BUNDESDRUCKEREI = "Bundesdruckerei";
    public static final String CARD_ISSUER_EU_F_CERTINOMIS = "Certinomis";
    public static final String CARD_ISSUER_EU_F_CERTIGNA = "Certigna";
    public static final String CARD_ISSUER_EU_IT_INFOCERT = "InfoCert";
    public static final String CARD_ISSUER_CH_SUISSEID2 = "SuisseID";
    public static final String CARD_ISSUER_CH_QUO_VADIS = "QuoVadis";
    public static final String CARD_ISSUER_CH_SWISSCOM = "Swisscom";
    public static final String CARD_ISSUER_GEMATIK = "gematik";
    public static final String CARD_ISSUER_CH_POST = "PostCH";
    public static final String CARD_ISSUER_BW = "Bundeswehr";
    public static final String CARD_ISSUER_DOI = "DOI";
    public static final String TYPE_NAME_COS_UNKNOWN = "UNKNOWN";
    public static final int TYPE_VALUE_COS_UNKNOWN = 0;
    public static final String TYPE_NAME_COS_TCOS10 = "TCOS10";
    public static final int TYPE_VALUE_COS_TCOS10 = 1;
    public static final String TYPE_NAME_COS_TCOS2R3 = "TCOS2R3";
    public static final int TYPE_VALUE_COS_TCOS2R3 = 2;
    public static final String TYPE_NAME_COS_TCOS30 = "TCOS30";
    public static final int TYPE_VALUE_COS_TCOS30 = 3;
    public static final String TYPE_NAME_COS_MICARDO13 = "MICARDO13";
    public static final int TYPE_VALUE_COS_MICARDO13 = 4;
    public static final String TYPE_NAME_COS_MICARDO21 = "MICARDO21";
    public static final int TYPE_VALUE_COS_MICARDO21 = 5;
    public static final String TYPE_NAME_COS_MICARDO30 = "MICARDO30";
    public static final int TYPE_VALUE_COS_MICARDO30 = 6;
    public static final String TYPE_NAME_COS_MICARDO31 = "MICARDO31";
    public static final int TYPE_VALUE_COS_MICARDO31 = 7;
    public static final String TYPE_NAME_COS_STARCOS21 = "STARCOS21";
    public static final int TYPE_VALUE_COS_STARCOS21 = 8;
    public static final String TYPE_NAME_COS_STARCOS23 = "STARCOS23";
    public static final int TYPE_VALUE_COS_STARCOS23 = 9;
    public static final String TYPE_NAME_COS_STARCOS30 = "STARCOS30";
    public static final int TYPE_VALUE_COS_STARCOS30 = 10;
    public static final String TYPE_NAME_COS_STARCOS31 = "STARCOS31";
    public static final int TYPE_VALUE_COS_STARCOS31 = 11;
    public static final String TYPE_NAME_COS_STARCOS32 = "STARCOS32";
    public static final int TYPE_VALUE_COS_STARCOS32 = 12;
    public static final String TYPE_NAME_COS_STARCOS34 = "STARCOS34";
    public static final int TYPE_VALUE_COS_STARCOS34 = 13;
    public static final String TYPE_NAME_COS_SECCOS10 = "SECCOS10";
    public static final int TYPE_VALUE_COS_SECCOS10 = 14;
    public static final String TYPE_NAME_COS_SECCOS50 = "SECCOS50";
    public static final int TYPE_VALUE_COS_SECCOS50 = 15;
    public static final String TYPE_NAME_COS_SECCOS60 = "SECCOS60";
    public static final int TYPE_VALUE_COS_SECCOS60 = 16;
    public static final String TYPE_NAME_COS_CARDOS10 = "CARDOS10";
    public static final int TYPE_VALUE_COS_CARDOS10 = 17;
    public static final String TYPE_NAME_COS_CARDOS43B = "CARDOS43B";
    public static final int TYPE_VALUE_COS_CARDOS43B = 18;
    public static final String TYPE_NAME_COS_CARDOS44 = "CARDOS44";
    public static final int TYPE_VALUE_COS_CARDOS44 = 19;
    public static final String TYPE_NAME_COS_CARDOS50 = "CARDOS50";
    public static final int TYPE_VALUE_COS_CARDOS50 = 20;
    public static final String TYPE_NAME_COS_ABACOS10 = "ABACOS10";
    public static final int TYPE_VALUE_COS_ABACOS10 = 21;
    public static final String TYPE_NAME_COS_GPK = "GPK";
    public static final int TYPE_VALUE_COS_GPK = 22;
    public static final String TYPE_NAME_COS_NPA = "NPA-COS";
    public static final int TYPE_VALUE_COS_NPA = 23;
    public static final String TYPE_NAME_COS_ACOS = "ACOS";
    public static final int TYPE_VALUE_COS_ACOS = 24;
    public static final String TYPE_NAME_COS_STARCOS35 = "STARCOS35";
    public static final int TYPE_VALUE_COS_STARCOS35 = 25;
    public static final String TYPE_NAME_COS_GLOBALPLAFORM_2_1_1 = "GLOBALPLAFORM_2_1_1";
    public static final int TYPE_VALUE_COS_GLOBALPLAFORM_2_1_1 = 26;
    public static final String COS_MANUFACTURER_UNKNOWN = "UnknownManufacturer";
    public static final String TYPE_NAME_COS_CARDOS54 = "CARDOS54";
    public static final int TYPE_VALUE_COS_CARDOS54 = 27;
    public static final String TYPE_NAME_COS_GLOBALPLAFORM_2_3_1 = "GLOBALPLAFORM_2_3_1";
    public static final int TYPE_VALUE_COS_GLOBALPLAFORM_2_3_1 = 28;
    public static final String TYPE_NAME_COS_STARCOS37 = "STARCOS37";
    public static final int TYPE_VALUE_COS_STARCOS37 = 29;
    public static final String TYPE_NAME_COS_GEMATIK_3_13_1 = "Gematik COS 3.13.1";
    public static final int TYPE_VALUE_COS_GEMATIK_3_13_1 = 30;
    public static final String TYPE_NAME_COS_CARDOS60 = "CARDOS60";
    public static final int TYPE_VALUE_COS_CARDOS60 = 31;
    public static final String COS_MANUFACTURER_SAGEM_ORGA = "Sagem Orga";
    public static final String COS_MANUFACTURER_SIEMENS = "Siemens";
    public static final String COS_MANUFACTURER_ATOS_SIEMENS = "ATOS/Siemens";
    public static final String COS_MANUFACTURER_GD = "G&D";
    public static final String COS_MANUFACTURER_TELESEC = "TeleSec";
    public static final String COS_MANUFACTURER_GEMPLUS = "GemPlus";
    public static final String COS_MANUFACTURER_PAV = "PAV";
    public static final String COS_MANUFACTURER_ZKA = "ZKA";
    public static final String COS_MANUFACTURER_NPA = "Bundesdruckerei";
    public static final String COS_MANUFACTURER_ATRUST = "ATrust";
    public static final String COS_SPECIFICATOR_GLOBAL_PLATFORM = "Global Platform";
    public static final String COS_MANUFACTURER_GEMATIK = "gematik";
    public static final boolean CARD_ASYNCHRON = true;
    public static final boolean CARD_SYNCHRON = false;
    public static final String NO_ICCSN_HEXSTRING = "";
    public static final byte[] NO_ICCSN = new byte[0];

    public CardApplication getMasterApplication();

    @Override
    public SmartCard getSmartCard();

    @Override
    public GovCS getCardService();

    public String getICCSNAsHexString();

    public byte[] getICCSN();

    public CardInfoType getCif();

    public void setCif(CardInfoType var1);

    public static enum CardOSTypeEnum implements Typed
    {
        UNKNOWN("UNKNOWN", 0, "UnknownManufacturer"),
        TCOS10("TCOS10", 1, "TeleSec"),
        TCOS2R3("TCOS2R3", 2, "TeleSec"),
        TCOS30("TCOS30", 3, "TeleSec"),
        MICARDO13("MICARDO13", 4, "Sagem Orga"),
        MICARDO21("MICARDO21", 5, "Sagem Orga"),
        MICARDO30("MICARDO30", 6, "Sagem Orga"),
        MICARDO31("MICARDO31", 7, "Sagem Orga"),
        STARCOS21("STARCOS21", 8, "G&D"),
        STARCOS23("STARCOS23", 9, "G&D"),
        STARCOS30("STARCOS30", 10, "G&D"),
        STARCOS31("STARCOS31", 11, "G&D"),
        STARCOS32("STARCOS32", 12, "G&D"),
        STARCOS34("STARCOS34", 13, "G&D"),
        SECCOS10("SECCOS10", 14, "ZKA"),
        SECCOS50("SECCOS50", 15, "ZKA"),
        SECCOS60("SECCOS60", 16, "ZKA"),
        CARDOS10("CARDOS10", 17, "Siemens"),
        CARDOS43B("CARDOS43B", 18, "Siemens"),
        CARDOS44("CARDOS44", 19, "ATOS/Siemens"),
        CARDOS50("CARDOS50", 20, "ATOS/Siemens"),
        ABACOS10("ABACOS10", 21, "PAV"),
        GPK("GPK", 22, "GemPlus"),
        NPA("NPA-COS", 23, "Bundesdruckerei"),
        ACOS("ACOS", 24, "ATrust"),
        STARCOS35("STARCOS35", 25, "G&D"),
        STARCOS37("STARCOS37", 29, "G&D"),
        GLOBAL_PLATFORM_211("GLOBALPLAFORM_2_1_1", 26, "Global Platform"),
        GLOBAL_PLATFORM_231("GLOBALPLAFORM_2_3_1", 28, "Global Platform"),
        CARDOS54("CARDOS54", 27, "ATOS/Siemens"),
        GEMATIK_COS_3_13_1("Gematik COS 3.13.1", 30, "gematik"),
        CARDOS60("CARDOS60", 31, "ATOS/Siemens");

        public static final Collection<Type> TYPES;
        private Type type = null;
        private String manufacturer = null;

        private CardOSTypeEnum(String name, int typeValue, String manufacturer) {
            this.type = "UNKNOWN".equals(name) ? TYPE_KIND.getUnknownType() : new TypeImpl(TYPE_KIND, name, typeValue, Type.Util.NO_TYPE_INTERFACES_LIST_DOUBLE);
            this.manufacturer = manufacturer;
        }

        public static CardOSTypeEnum valueOf(int typeValue) {
            CardOSTypeEnum[] oss = CardOSTypeEnum.values();
            CardOSTypeEnum result = null;
            for (CardOSTypeEnum os : oss) {
                if (os.type.getType() != typeValue) continue;
                result = os;
                break;
            }
            return result;
        }

        public List<List<Class<?>>> getTypeInterfaceList() {
            return this.type.getTypeInterfaceList();
        }

        @Override
        public TypedType.TypedTypeEnum getTypedType() {
            return this.type.getTypedType();
        }

        public String getName() {
            return this.type.getName();
        }

        public void initName(String name) {
        }

        public boolean changeLock(Object oldLock, Object newLock) throws IllegalStateException, IllegalArgumentException {
            return false;
        }

        public boolean dispose(Object lock) throws IllegalStateException {
            return false;
        }

        public void initLock(Object lock) {
        }

        public boolean isDisposed() {
            return false;
        }

        public boolean isLock(Object lock) {
            return false;
        }

        public String getDescription() {
            return null;
        }

        public String getManufacturer() {
            return this.manufacturer;
        }

        @Override
        public Type getType() {
            return this.type;
        }

        @Override
        public int getTypeValue() {
            return this.type.getType();
        }

        @Override
        public void initType(Type type) {
        }

        static {
            Typed[] values = CardOSTypeEnum.values();
            TYPES = Util.createUnmodifiableTypeCollection(values);
        }
    }

    public static enum CardTypeEnum implements Typed
    {
        UNKNOWN("UNKNOWN", 0, "UnknownIssuer", CardOSTypeEnum.UNKNOWN),
        TELESEC_PKS("TeleSec PKS", 1, "TeleSec", CardOSTypeEnum.TCOS2R3),
        TELESEC_NETKEY10("TeleSec NetKey10", 2, "TeleSec", CardOSTypeEnum.TCOS10),
        TELESEC_NETKEY2000("TeleSec NetKey2000", 3, "TeleSec", CardOSTypeEnum.TCOS2R3),
        TELESEC_NETKEYE4("TeleSec NetKeyE4", 4, "TeleSec", CardOSTypeEnum.TCOS2R3),
        TELESEC_NETKEY30("TeleSec NetKey30", 5, "TeleSec", CardOSTypeEnum.TCOS30),
        TELESEC_NETKEY30M("TeleSec NetKey30M", 6, "TeleSec", CardOSTypeEnum.TCOS30),
        TCOS30_SC20("TCOS 3.0 Signature Card 2.0", 82, "TeleSec", CardOSTypeEnum.TCOS30),
        TCOS30_SC20_RFID("TCOS 3.0 Signature Card 2.0 (RFID)", 83, "TeleSec", CardOSTypeEnum.TCOS30),
        TCOS30_SC20M("TCOS 3.0 Signature Card 2.0 (multisign)", 84, "TeleSec", CardOSTypeEnum.TCOS30),
        TCOS30_SC20M_RFID("TCOS 3.0 Signature Card 2.0 (multisign, RFID)", 85, "TeleSec", CardOSTypeEnum.TCOS30),
        DATEV_10("Datev", 45, "Datev", CardOSTypeEnum.TCOS2R3),
        SIGNTRUST_DP_MEDIZON_10("SignTrust/Medizon 1.0", 25, "SignTrust/Deutsche Post/Medizon", CardOSTypeEnum.TCOS2R3),
        MEDISIGN_10("Medisign", 46, "MediSign", CardOSTypeEnum.TCOS2R3),
        EHC_EGK("eHC/eGK", 36, "UnknownIssuer", CardOSTypeEnum.UNKNOWN),
        HPC_HBA("HPC/HBA", 37, "UnknownIssuer", CardOSTypeEnum.UNKNOWN),
        KVK("KVK", 38, "UnknownIssuer", CardOSTypeEnum.UNKNOWN, false),
        FINEID_21("FinEID 2.1", 59, "FinEID", CardOSTypeEnum.UNKNOWN),
        EPO("EPO 1.0", 63, "European Patent Office", CardOSTypeEnum.GPK),
        ATRUST_20("ATrust 2.0", 40, "ATrust", CardOSTypeEnum.ACOS),
        STARCERT21("StarCert 2.1", 50, "G&D", CardOSTypeEnum.STARCOS21),
        DSV_10("DSV 1.0", 52, "DSV", CardOSTypeEnum.STARCOS23),
        DSV_20("DSV 2.0", 53, "DSV", CardOSTypeEnum.STARCOS23),
        DSV_30("DSV 3.0", 54, "DSV", CardOSTypeEnum.STARCOS23),
        ATRUST_10("ATrust 1.0", 39, "ATrust", CardOSTypeEnum.STARCOS23),
        TCTRUST_10("TC Trust 1.0", 42, "TCTrust", CardOSTypeEnum.STARCOS23),
        STARTRUST("StarTrust", 41, "Startrust", CardOSTypeEnum.STARCOS23),
        STARCERT23("StarCert 2.3", 51, "G&D", CardOSTypeEnum.STARCOS23),
        SIGNTRUST_2048BIT("SignTrust 2048bit", 26, "SignTrust", CardOSTypeEnum.STARCOS30),
        SIGNTRUST_2048BIT_M100("SignTrust 2048bit (M100)", 27, "SignTrust", CardOSTypeEnum.STARCOS30),
        SIGNTRUST_2048BIT_MCARD("SignTrust 2048bit (MCARD)", 28, "SignTrust", CardOSTypeEnum.STARCOS30),
        BNOTK("Bundesnotarkammer Karte", 29, "BNOTK", CardOSTypeEnum.STARCOS30),
        DGN("DGNService", 30, "DGNService", CardOSTypeEnum.STARCOS30),
        DGN2BUSINESS("DGNService (business)", 94, "DGNService", CardOSTypeEnum.STARCOS32),
        DGN2SPRINT("DGNService (sprint)", 95, "DGNService", CardOSTypeEnum.STARCOS32),
        DGN3BUSINESS("DGNService3 (business)", 105, "DGNService", CardOSTypeEnum.STARCOS35),
        DGN3SPRINT("DGNService3 (sprint)", 106, "DGNService", CardOSTypeEnum.STARCOS35),
        BNOTK2("Bundesnotarkammer Karte (v2)", 31, "BNOTK", CardOSTypeEnum.STARCOS32),
        BNOTK3_STAPLE("Bundesnotarkammer Karte (v3, staple)", 96, "BNOTK", CardOSTypeEnum.STARCOS35),
        BNOTK3_BEA_STAPLE("bea Basis Bundesnotarkammer Karte (v3, staple)", 115, "BNOTK", CardOSTypeEnum.STARCOS35),
        BNOTK3_MULTI("Bundesnotarkammer Karte (v3, multi)", 104, "BNOTK", CardOSTypeEnum.STARCOS35),
        SIGNTRUST_2048BIT_V2("SignTrust 2048bit (v2)", 32, "SignTrust", CardOSTypeEnum.STARCOS32),
        SIGNTRUST_2048BIT_M100_V2("SignTrust 2048bit (v2) (M100)", 33, "SignTrust", CardOSTypeEnum.STARCOS32),
        SIGNTRUST_2048BIT_MCARD_V2("SignTrust 2048bit (v2) (MCARD)", 34, "SignTrust", CardOSTypeEnum.STARCOS32),
        DATEV_2048BIT_V2("Datev 2048bit (v2)", 35, "Datev", CardOSTypeEnum.STARCOS32),
        HVB_10("HVB 1.0", 56, "HypoVereinsbank", CardOSTypeEnum.SECCOS10),
        HVB_20("HVB 2.0", 57, "HypoVereinsbank", CardOSTypeEnum.SECCOS10),
        HVB_30("HVB 3.0", 58, "HypoVereinsbank", CardOSTypeEnum.SECCOS10),
        DSV_40("DSV 4.0", 55, "DSV", CardOSTypeEnum.SECCOS50),
        DTRUST_10("DTrust 1.0", 9, "DTrust", CardOSTypeEnum.MICARDO21),
        DTRUST_11("DTrust 1.1", 10, "DTrust", CardOSTypeEnum.MICARDO21),
        DTRUST_10_BURGERCARD("DTrust-BC 1.0", 11, "DTrust", CardOSTypeEnum.MICARDO21),
        DTRUST_11_BURGERCARD("DTrust-BC 1.1", 12, "DTrust", CardOSTypeEnum.MICARDO21),
        IHK_CHAMBERCARD_10("IHK ChamberCard 1.0", 7, "IHK", CardOSTypeEnum.MICARDO21),
        DTRUST_22_2CC("DTrust 2.2 2cc", 13, "DTrust", CardOSTypeEnum.CARDOS43B),
        DTRUST_22_3CC("DTrust 2.2 3cc", 14, "DTrust", CardOSTypeEnum.CARDOS43B),
        DTRUST_22_2CC_MULTISIGN("DTrust 2.2 2cc (multisign)", 15, "DTrust", CardOSTypeEnum.CARDOS43B),
        DTRUST_22_3CC_MULTISIGN("DTrust 2.2 3cc (multisign)", 16, "DTrust", CardOSTypeEnum.CARDOS43B),
        DTRUST_23_2CC("DTrust 2.3 2cc", 17, "DTrust", CardOSTypeEnum.CARDOS43B),
        DTRUST_23_3CC("DTrust 2.3 3cc", 18, "DTrust", CardOSTypeEnum.CARDOS43B),
        DTRUST_23_2CC_MULTISIGN("DTrust 2.3 2cc (multisign)", 19, "DTrust", CardOSTypeEnum.CARDOS43B),
        DTRUST_23_3CC_MULTISIGN("DTrust 2.3 3cc (multisign)", 20, "DTrust", CardOSTypeEnum.CARDOS43B),
        DTRUST_24_2CC("DTrust 2.4 2cc", 21, "DTrust", CardOSTypeEnum.CARDOS43B),
        DTRUST_24_3CC("DTrust 2.4 3cc", 22, "DTrust", CardOSTypeEnum.CARDOS43B),
        DTRUST_24_2CC_MULTISIGN("DTrust 2cc (multisign)", 23, "DTrust", CardOSTypeEnum.CARDOS43B),
        DTRUST_24_3CC_MULTISIGN("DTrust 2.4 3cc (multisign)", 24, "DTrust", CardOSTypeEnum.CARDOS43B),
        DTRUST_30_STANDARD("DTrust 3.0 (standard)", 77, "DTrust", CardOSTypeEnum.STARCOS34),
        DTRUST_30_ADVANCED("DTrust 3.0 (advanced)", 78, "DTrust", CardOSTypeEnum.STARCOS34),
        DTRUST_30_BATCH("DTrust 3.0 (batch)", 79, "DTrust", CardOSTypeEnum.STARCOS34),
        DTRUST_30_MULTICARD("DTrust 3.0 (multicard)", 80, "DTrust", CardOSTypeEnum.STARCOS34),
        BA_VERSION2("BA Version2", 81, "Bundesagentur fuer Arbeit", CardOSTypeEnum.STARCOS34),
        BA_MULTISIGN_VERSION2("BA MultiSign Version2", 107, "Bundesagentur fuer Arbeit", CardOSTypeEnum.STARCOS34),
        INFO_NOTARY("InfoNotary", 49, "InfoNotary", CardOSTypeEnum.CARDOS43B),
        TCTRUST_QSIGN("TC Trust QSign", 43, "TCTrust", CardOSTypeEnum.CARDOS43B),
        TCTRUST_QSIGN_UNLIMITED("TC Trust QSign Unlimited", 44, "TCTrust", CardOSTypeEnum.CARDOS43B),
        DR("DR MultiSign", 47, "Deutsche Rente", CardOSTypeEnum.CARDOS43B),
        BFA("BfA Berlin", 48, "BfA Berlin", CardOSTypeEnum.CARDOS43B),
        EA_LIGHT_PRE("eArztausweis (AK Nordrhein, pre)", 75, "\u00c4rztekammer Nordrhein", CardOSTypeEnum.CARDOS44),
        EA_LIGHT("eArztausweis (AK Nordrhein)", 76, "\u00c4rztekammer Nordrhein", CardOSTypeEnum.CARDOS50),
        UNKNOWN_STARCOS30("Unknown StarCOS 3.0", 60, "UnknownIssuer", CardOSTypeEnum.STARCOS30),
        UNKNOWN_STARCOS32("Unknown StarCOS 3.2", 61, "UnknownIssuer", CardOSTypeEnum.STARCOS32),
        UNKNOWN_STARCOS34("Unknown StarCOS 3.4", 62, "UnknownIssuer", CardOSTypeEnum.STARCOS34),
        NPA("NPA", 64, "Bundesdruckerei", CardOSTypeEnum.NPA),
        ATRUST("ATRUST", 65, "ATrust", CardOSTypeEnum.ACOS),
        INFOCERT("InfoCert", 66, "InfoCert", CardOSTypeEnum.GPK),
        CERTINOMIS("Certinomis", 67, "Certinomis", CardOSTypeEnum.GPK),
        CERTIGNA_TOKEN("CertignaToken", 68, "Certigna", CardOSTypeEnum.GPK),
        QUOVADIS_SUISSEID("QuoVadis-SuisseID", 69, "QuoVadis", CardOSTypeEnum.CARDOS43B),
        QUOVADIS_TOKEN("QuoVadis-TokenD", 73, "QuoVadis", CardOSTypeEnum.CARDOS43B),
        SWISSCOM_SUISSEID("Swisscom SuisseID", 70, "Swisscom", CardOSTypeEnum.CARDOS43B),
        SWISSCOM_SUISSEID_MULTISIGN("Swisscom SuisseID Multisign", 71, "Swisscom", CardOSTypeEnum.CARDOS43B),
        POSTMAIL_SUISSEID("PostMail SuisseID", 72, "PostCH", CardOSTypeEnum.CARDOS43B),
        VR_10("VR-BankCard/VR-Networld-Card 1.0", 74, "VR", CardOSTypeEnum.SECCOS60),
        BA("Bundesagentur f\u00fcr Arbeit", 86, "Bundesagentur fuer Arbeit", CardOSTypeEnum.STARCOS34),
        UNKNOWN_STARCOS35("Unknown StarCOS 3.5", 87, "UnknownIssuer", CardOSTypeEnum.STARCOS35),
        SIGNTRUST_STANDARD_V3("SignTrust Standard (v3)", 88, "SignTrust", CardOSTypeEnum.STARCOS35),
        SIGNTRUST_M100_V3("SignTrust M100 (v3)", 89, "SignTrust", CardOSTypeEnum.STARCOS35),
        SIGNTRUST_MCARD_V3("SignTrust MCard (v3)", 90, "SignTrust", CardOSTypeEnum.STARCOS35),
        UNKNOWN_CARDOS50("Unknown CardOS 5.0", 91, "UnknownIssuer", CardOSTypeEnum.CARDOS50),
        DRV2MultiSign("DR V2 MultiSign", 92, "Deutsche Rente", CardOSTypeEnum.CARDOS50),
        DRV2IDCard("DR V2 IDCard", 93, "Deutsche Rente", CardOSTypeEnum.CARDOS50),
        QUOVADIS_EIDV("CardOS 4.3 EIDV (QuoVadis, multisign)", 97, "QuoVadis", CardOSTypeEnum.CARDOS43B),
        QUOVADIS_BTC("CardOS 4.4 BTC(QuoVadis, multisign)", 98, "QuoVadis", CardOSTypeEnum.CARDOS44),
        DOI("TOCS 3.0 DOI", 99, "DOI", CardOSTypeEnum.TCOS30),
        HPC_DGN_SINGLE("StarCOS 3.5 HPC (DGN, singlesign)", 100, "DGNService", CardOSTypeEnum.STARCOS35),
        HPC_DGN_STAPLE("StarCOS 3.5 HPC (DGN, staplesign)", 101, "DGNService", CardOSTypeEnum.STARCOS35),
        HPC_ZOD_DGN("StarCOS 3.5 ZOD-HPC", 102, "DGNService", CardOSTypeEnum.STARCOS35),
        DATEV_V3("StarCOS 3.4 DATEV V.3", 103, "Datev", CardOSTypeEnum.STARCOS34),
        BNOTK_BEA_MA("beA Mitarbeiterkarte", 108, "BNOTK", CardOSTypeEnum.GLOBAL_PLATFORM_211),
        BNOTK_V2_GP("BNotK V.2 (GP)", 121, "BNOTK", CardOSTypeEnum.GLOBAL_PLATFORM_231),
        BW_PKI42("BW PKI 1.4 Karte", 109, "Bundeswehr", CardOSTypeEnum.CARDOS50),
        DTRUST_31_STANDARD("D-Trust 3.1 Standard", 110, "DTrust", CardOSTypeEnum.CARDOS50),
        DTRUST_31_MULTICARD100("D-Trust 3.1 Multicard100", 111, "DTrust", CardOSTypeEnum.CARDOS50),
        DTRUST_31_MULTICARD("D-Trust 3.1 Multicard", 112, "DTrust", CardOSTypeEnum.CARDOS50),
        DTRUST_34_STANDARD("D-Trust 3.4 Standard", 113, "DTrust", CardOSTypeEnum.CARDOS50),
        DTRUST_34_MULTICARD("D-Trust 3.4 Multicard", 114, "DTrust", CardOSTypeEnum.CARDOS50),
        DTRUST_41_MULTICARD_ECC("D-Trust 3.4 Multicard ECC", 116, "DTrust", CardOSTypeEnum.CARDOS54),
        DTRUST_41_MULTICARD100_ECC("D-Trust 4.1 M100 ECC", 117, "DTrust", CardOSTypeEnum.CARDOS54),
        DTRUST_41_STANDARD_RSA("D-Trust 4.1 Standard RSA", 118, "DTrust", CardOSTypeEnum.CARDOS54),
        DTRUST_44_MULTICARD_ECC_SEAL("D-Trust 4.4 Multicard Seal ECC", 119, "DTrust", CardOSTypeEnum.CARDOS54),
        DTRUST_44_STANDARD_RSA_SEAL("D-Trust 4.4 Standard Seal RSA", 120, "DTrust", CardOSTypeEnum.CARDOS54),
        DGN4("DGNService4", 122, "DGNService", CardOSTypeEnum.STARCOS37),
        EHBA_G2("eHBA_G2", 123, "gematik", CardOSTypeEnum.GEMATIK_COS_3_13_1),
        DTRUST_51_MULTICARD_ECC("D-Trust 5.1 Multicard ECC", 124, "DTrust", CardOSTypeEnum.CARDOS60),
        DTRUST_51_MULTICARD100_ECC("D-Trust 5.1 M100 ECC", 125, "DTrust", CardOSTypeEnum.CARDOS60),
        DTRUST_51_STANDARD_RSA("D-Trust 5.1 Standard RSA", 126, "DTrust", CardOSTypeEnum.CARDOS60),
        DTRUST_54_MULTICARD_ECC("D-Trust 5.4 Seal Multicard ECC", 127, "DTrust", CardOSTypeEnum.CARDOS60),
        DTRUST_54_STANDARD_RSA("D-Trust 5.4 Seal Standard RSA", 128, "DTrust", CardOSTypeEnum.CARDOS60),
        UNKNOWN_CARDOS60("Unknown CardOS 6.0", 129, "UnknownIssuer", CardOSTypeEnum.CARDOS60),
        DRV3_IDCARD("DR V3 IDCard", 130, "Deutsche Rente", CardOSTypeEnum.CARDOS60),
        TCOS30_SC30("TCOS 3.0 Signature Card 3.0", 131, "TeleSec", CardOSTypeEnum.TCOS30),
        TCOS30_SC30_RFID("TCOS 3.0 Signature Card 3.0 (RFID)", 132, "TeleSec", CardOSTypeEnum.TCOS30),
        TCOS30_SC30M("TCOS 3.0 Signature Card 3.0 (multisign)", 133, "TeleSec", CardOSTypeEnum.TCOS30),
        TCOS30_SC30M_RFID("TCOS 3.0 Signature Card 3.0 (multisign, RFID)", 134, "TeleSec", CardOSTypeEnum.TCOS30);

        public static final Collection<Type> TYPES;
        private Type type = null;
        private Type cosType = null;
        private String issuer = null;
        private boolean asynchronCard = true;

        private CardTypeEnum(String name, int typeValue, String issuer, CardOSTypeEnum cardOSType) {
            this(name, typeValue, issuer, cardOSType, true);
        }

        private CardTypeEnum(String name, int typeValue, String issuer, CardOSTypeEnum cardOSType, boolean asynchronCard) {
            this.type = "UNKNOWN".equals(name) ? TYPE_KIND.getUnknownType() : new TypeImpl(TYPE_KIND, name, typeValue, Type.Util.NO_TYPE_INTERFACES_LIST_DOUBLE);
            this.issuer = issuer;
            this.cosType = cardOSType.getType();
            this.asynchronCard = asynchronCard;
        }

        public static CardTypeEnum valueOf(int typeValue) {
            CardTypeEnum[] cards = CardTypeEnum.values();
            CardTypeEnum result = null;
            for (CardTypeEnum card : cards) {
                if (card.type.getType() != typeValue) continue;
                result = card;
                break;
            }
            return result;
        }

        public List<List<Class<?>>> getTypeInterfaceList() {
            return this.type.getTypeInterfaceList();
        }

        @Override
        public TypedType.TypedTypeEnum getTypedType() {
            return this.type.getTypedType();
        }

        public String getName() {
            return this.type.getName();
        }

        public void initName(String name) {
        }

        public boolean changeLock(Object oldLock, Object newLock) throws IllegalStateException, IllegalArgumentException {
            return false;
        }

        public boolean dispose(Object lock) throws IllegalStateException {
            return false;
        }

        public void initLock(Object lock) {
        }

        public boolean isDisposed() {
            return false;
        }

        public boolean isLock(Object lock) {
            return false;
        }

        public String getDescription() {
            return null;
        }

        public String getIssuer() {
            return this.issuer;
        }

        @Override
        public Type getType() {
            return this.type;
        }

        @Override
        public int getTypeValue() {
            return this.type.getType();
        }

        @Override
        public void initType(Type type) {
        }

        public Type getCosType() {
            return this.cosType;
        }

        public boolean isAsynchronCard() {
            return this.asynchronCard;
        }

        static {
            Typed[] values = CardTypeEnum.values();
            TYPES = Util.createUnmodifiableTypeCollection(values);
        }
    }
}

