/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.model;

import de.bos_bremen.gov2.jca_provider.ocf.model.AbstractTypedAccessStrategy;
import de.bos_bremen.gov2.jca_provider.ocf.model.CollectionTypedHolderProxy;
import de.bos_bremen.gov2.jca_provider.ocf.model.Disposeable;
import de.bos_bremen.gov2.jca_provider.ocf.model.Type;
import de.bos_bremen.gov2.jca_provider.ocf.model.Typed;
import de.bos_bremen.gov2.jca_provider.ocf.model.TypedType;
import de.bos_bremen.gov2.jca_provider.ocf.model.Util;
import de.bos_bremen.gov2.jca_provider.ocf.model.map.NamedMap;
import de.bos_bremen.gov2.jca_provider.ocf.model.map.TypeMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

class BitTypedAccessStrategy<T extends Typed & Disposeable>
extends AbstractTypedAccessStrategy<T> {
    public BitTypedAccessStrategy(Object lock, TypedType.TypedTypeEnum kind, Collection<Type> admittedTypeValueList) {
        super(lock, kind, admittedTypeValueList);
        if (kind != TypedType.TypedTypeEnum.BIT) {
            throw new IllegalArgumentException("type of enum not fit to strategy");
        }
    }

    @Override
    public T getInt(Map<Integer, T> valueMap, Integer key) {
        Typed result = null;
        Collection<T> collection = this.getCollectionInt(valueMap, key);
        if (collection != null && !collection.isEmpty() && collection.size() > 0) {
            result = (Typed)collection.iterator().next();
        }
        return (T)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<T> getCollectionInt(Map<Integer, T> valueMap, Integer key) {
        ArrayList<Typed> result = new ArrayList<Typed>();
        if (key == null) {
            return result;
        }
        BitTypedAccessStrategy bitTypedAccessStrategy = this;
        synchronized (bitTypedAccessStrategy) {
            Map<Integer, T> map = valueMap;
            synchronized (map) {
                int unknownType = this.kind.getUnknownType().getType();
                if (key == unknownType) {
                    Typed tmp = (Typed)valueMap.get(unknownType);
                    CollectionTypedHolderProxy<Typed> proxy = Util.castProxy(tmp);
                    result.addAll(proxy.getUnmodifiableCollection());
                } else if (key > 0) {
                    int[] typeValues = this.kind.splitTypeValues(key);
                    for (int i = 0; i < typeValues.length; ++i) {
                        Typed tmp = (Typed)valueMap.get(typeValues[i]);
                        CollectionTypedHolderProxy<Typed> proxy = Util.castProxy(tmp);
                        for (Typed tmpEntry : proxy.getUnmodifiableCollection()) {
                            if (result.contains(tmpEntry)) continue;
                            result.add(tmpEntry);
                        }
                    }
                } else if (key < 0) {
                    Typed tmp = (Typed)valueMap.get(unknownType);
                    CollectionTypedHolderProxy<Typed> proxy = Util.castProxy(tmp);
                    result.addAll(proxy.getUnmodifiableCollection());
                    int[] typeValues = this.kind.splitTypeValues(Math.abs(key));
                    for (int i = 0; i < typeValues.length; ++i) {
                        Typed tmp2 = (Typed)valueMap.get(typeValues[i]);
                        CollectionTypedHolderProxy<Typed> proxy2 = Util.castProxy(tmp2);
                        result.retainAll(proxy2.getUnmodifiableCollection());
                    }
                }
                return result;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putInt(Map<Integer, T> valueMap, Integer key, T value, NamedMap<Type> typeNameTypeMap, TypeMap<Type> typeValueTypeMap) {
        if (key.intValue() != value.getTypeValue()) {
            throw new IllegalArgumentException("key does not fit value of Typed and its TypeValue");
        }
        BitTypedAccessStrategy bitTypedAccessStrategy = this;
        synchronized (bitTypedAccessStrategy) {
            Map<Integer, T> map = valueMap;
            synchronized (map) {
                Type[] types = this.kind.splitTypes(value.getType());
                for (int i = 0; i < types.length; ++i) {
                    this.putForType(valueMap, value, types[i], typeValueTypeMap);
                }
                this.putForType(valueMap, value, this.kind.getUnknownType(), typeValueTypeMap);
            }
        }
    }

    private void putForType(Map<Integer, T> valueMap, T value, Type type, TypeMap<Type> typeValueTypeMap) {
        if (!typeValueTypeMap.values().contains(type)) {
            throw new IllegalArgumentException("illegal type value, type not admitted for this map:\ntype = " + type + ",\nvalue = " + value + ",\nexpected: " + typeValueTypeMap.values());
        }
        Integer tmp = type.getType();
        CollectionTypedHolderProxy<Typed> proxy = Util.castProxy((Typed)valueMap.get(tmp));
        Collection<Typed> collection = proxy.getCollection();
        if (collection != null && !collection.contains(value)) {
            collection.add((Typed)value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeInt(Map<Integer, T> valueMap, Integer key, T value, NamedMap<Type> typeNameTypeMap, TypeMap<Type> typeValueTypeMap) {
        BitTypedAccessStrategy bitTypedAccessStrategy = this;
        synchronized (bitTypedAccessStrategy) {
            Map<Integer, T> map = valueMap;
            synchronized (map) {
                int[] typeValues = this.kind.splitTypeValues(value.getTypeValue());
                for (int i = 0; i < typeValues.length; ++i) {
                    this.removeForType(typeValueTypeMap, valueMap, value, typeValues[i]);
                }
                this.removeForType(typeValueTypeMap, valueMap, value, this.kind.getUnknownType().getType());
            }
        }
    }

    private void removeForType(TypeMap<Type> typeValueTypeMap, Map<Integer, T> valueMap, T value, int typeValue) {
        if (!typeValueTypeMap.containsKey(Integer.valueOf(typeValue))) {
            throw new IllegalArgumentException("illegal type value, type not admitted for this map");
        }
        Integer tmp = typeValue;
        CollectionTypedHolderProxy<Typed> proxy = Util.castProxy((Typed)valueMap.get(tmp));
        Collection<Typed> collection = proxy.getCollection();
        if (collection != null && collection.contains(value)) {
            collection.remove(value);
        }
    }
}

