/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.model;

import de.bos_bremen.gov2.jca_provider.ocf.model.AbstractDisposeableObject;
import de.bos_bremen.gov2.jca_provider.ocf.model.ID;
import de.bos_bremen.gov2.jca_provider.ocf.model.Named;
import de.bos_bremen.gov2.jca_provider.ocf.model.NamedConstants;
import de.bos_bremen.gov2.jca_provider.ocf.model.Type;
import de.bos_bremen.gov2.jca_provider.ocf.model.TypeConstants;
import de.bos_bremen.gov2.jca_provider.ocf.model.Typed;
import de.bos_bremen.gov2.jca_provider.ocf.model.TypedConstants;
import de.bos_bremen.gov2.jca_provider.ocf.model.TypedType;
import de.bos_bremen.gov2.jca_provider.ocf.model.TypedTypeConstants;
import java.util.List;

public abstract class AbstractNamedIDTypedObject<T>
extends AbstractDisposeableObject
implements Named,
ID,
Typed {
    private String name = NamedConstants.NO_NAME;
    private long id = -1L;
    private Type type = TypeConstants.NO_TYPE;
    private T innerObject = null;

    protected AbstractNamedIDTypedObject(String name, long id, Type type, T innerObject) {
        this(NO_LOCK, name, id, type, innerObject);
    }

    protected AbstractNamedIDTypedObject(Object disposeLock, String name, long id, Type type, T innerObject) {
        super(disposeLock);
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("name as null or empty String not admitted");
        }
        this.name = name;
        this.id = id;
        this.type = type;
        this.innerObject = innerObject;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final long getID() {
        return this.id;
    }

    public final T getInnerObject() {
        return this.innerObject;
    }

    public String toString() {
        return super.toString() + "(name: " + this.name + ", id: " + this.id + ", type: " + this.type + ", innerObject: " + (this.innerObject != null ? this.innerObject.toString() : null);
    }

    public String toString(String indent) {
        return indent + super.toString() + "(name: " + this.name + ", id: " + this.id + ", type: " + this.type + ", innerObject: " + this.innerObject.toString();
    }

    @Override
    public final void initName(String name) {
    }

    @Override
    public final void initID(long id) {
    }

    @Override
    public final void initType(Type type) {
    }

    @Override
    public final Type getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int getTypeValue() {
        AbstractNamedIDTypedObject abstractNamedIDTypedObject = this;
        synchronized (abstractNamedIDTypedObject) {
            if (super.isDisposed()) {
                return 0;
            }
            return this.type.getType();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final TypedType.TypedTypeEnum getTypedType() {
        AbstractNamedIDTypedObject abstractNamedIDTypedObject = this;
        synchronized (abstractNamedIDTypedObject) {
            if (super.isDisposed()) {
                return TypedTypeConstants.NO_TYPED_TYPE;
            }
            return this.type.getTypedType();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<List<Class<?>>> getTypeInterfaceList() {
        AbstractNamedIDTypedObject abstractNamedIDTypedObject = this;
        synchronized (abstractNamedIDTypedObject) {
            if (super.isDisposed()) {
                return TypedConstants.NO_TYPE_INTERFACES_LIST_DOUBLE;
            }
            return this.type.getTypeInterfaceList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean disposeInt() {
        AbstractNamedIDTypedObject abstractNamedIDTypedObject = this;
        synchronized (abstractNamedIDTypedObject) {
            this.name = NamedConstants.NO_NAME;
            this.id = -1L;
            this.type = TypeConstants.NO_TYPE;
            this.innerObject = null;
            return true;
        }
    }
}

