/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.model;

import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.model.AbstractNamedIDTypedObject;
import de.bos_bremen.gov2.jca_provider.ocf.model.Card;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardApplication;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardObject;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardRegistry;
import de.bos_bremen.gov2.jca_provider.ocf.model.Terminal;
import de.bos_bremen.gov2.jca_provider.ocf.model.Type;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectRegistryImpl;
import java.security.KeyStore;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardTerminal;

public abstract class AbstractCardObject<T, S>
extends AbstractNamedIDTypedObject<T>
implements CardObject<S> {
    private long cardID = -1L;
    private Card card = null;
    private Terminal terminal = null;
    private long parentApplicationID = -1L;
    private long terminalID = -1L;
    private int slotID = -1;
    private GovCS cs = null;
    private CardRegistry cardRegistry = null;
    private CardApplication parentApplication = null;
    private S cifNode = null;

    public AbstractCardObject(String name, long id, Type type, T innerObject, long cardID, long parentApplicationID, long terminalID, int slotID, GovCS cs, CardRegistry cardRegistry) {
        this(NO_LOCK, name, id, type, innerObject, cardID, parentApplicationID, terminalID, slotID, cs, cardRegistry);
    }

    public AbstractCardObject(Object disposeLock, String name, long id, Type type, T innerObject, long cardID, long parentApplicationID, long terminalID, int slotID, GovCS cs, CardRegistry cardRegistry) {
        super(disposeLock, name, id, type, innerObject);
        this.cardID = cardID;
        this.parentApplicationID = parentApplicationID;
        this.terminalID = terminalID;
        this.slotID = slotID;
        this.terminal = CardObjectRegistryImpl.getInstance().getTerminalByID(this.terminalID);
        this.cs = cs;
        this.cardRegistry = cardRegistry;
        if (this.cardRegistry == null) {
            this.cardRegistry = CardObjectRegistryImpl.getInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean disposeInt() {
        AbstractCardObject abstractCardObject = this;
        synchronized (abstractCardObject) {
            this.card = null;
            this.terminal = null;
            this.cardID = -1L;
            this.terminalID = -1L;
            this.parentApplicationID = -1L;
            this.slotID = -1;
            this.cs = null;
            this.cardRegistry = null;
            this.parentApplication = null;
        }
        return true;
    }

    @Override
    public final long getParentApplicationID() {
        return this.parentApplicationID;
    }

    @Override
    public final synchronized CardApplication getParentApplication() {
        if (this.parentApplication == null) {
            if (this.card == null) {
                this.getCard();
            }
            this.parentApplication = CardApplication.class.isInstance(this) && this.getID() == this.parentApplicationID ? (CardApplication)((Object)this) : this.card.getApplicationByID(this.parentApplicationID, 1);
        }
        return this.parentApplication;
    }

    @Override
    public final synchronized Card getCard() {
        if (this.card == null) {
            this.card = this.cardRegistry.getCardByID(this.cardID);
        }
        return this.card;
    }

    @Override
    public final long getCardID() {
        return this.cardID;
    }

    @Override
    public final Terminal getTerminal() {
        return this.terminal;
    }

    @Override
    public final CardTerminal getCardTerminal() {
        return this.terminal.getCardTerminal();
    }

    @Override
    public final SmartCard getSmartCard() {
        return Card.class.isInstance(this) ? (SmartCard)super.getInnerObject() : this.getCard().getSmartCard();
    }

    @Override
    public final long getTerminalID() {
        return this.terminalID;
    }

    @Override
    public final int getSlotID() {
        return this.slotID;
    }

    public final GovCS getCardService() {
        return this.cs;
    }

    @Override
    public String toString() {
        return super.toString("");
    }

    @Override
    public String toString(String indent) {
        return indent + super.toString() + "\n" + indent + "parent application ID: " + this.parentApplicationID;
    }

    public KeyStore getKeyStore() {
        return this.getCard().getKeyStore();
    }

    @Override
    public final S getCifNode() {
        return this.cifNode;
    }

    @Override
    public final void setCifNode(S cifNode) {
        this.cifNode = cifNode;
    }
}

