/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cif;

import de.bos_bremen.gov2.jca_provider.ocf.cif.JAXBUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

public class LocalResourceResolver
implements LSResourceResolver {
    private DOMImplementationLS domImplLS = null;
    private URL localResourceBaseURL = null;
    private Map<String, String> xsdMappingMap = new HashMap<String, String>();
    private Document catalogDocument = null;

    public LocalResourceResolver(URL localResourceBaseURL, Map<String, String> xsdMappingMap) {
        this.localResourceBaseURL = localResourceBaseURL;
        this.xsdMappingMap = new HashMap<String, String>();
        if (xsdMappingMap != null) {
            this.xsdMappingMap.putAll(xsdMappingMap);
        }
        try {
            DOMImplementationRegistry reg = DOMImplementationRegistry.newInstance();
            DOMImplementation domImpl = reg.getDOMImplementation("LS 3.0");
            this.domImplLS = (DOMImplementationLS)((Object)domImpl);
        }
        catch (Exception reg) {
            // empty catch block
        }
        try {
            this.catalogDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element rootElement = this.catalogDocument.createElement("catalog");
            rootElement.setAttribute("xmlns", "urn:oasis:names:tc:entity:xmlns:xml:catalog");
            this.catalogDocument.appendChild(rootElement);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        LSInput input = this.domImplLS.createLSInput();
        Object localName = JAXBUtil.getLocalResourceName(systemId);
        if (this.xsdMappingMap != null && this.xsdMappingMap.containsKey(localName)) {
            localName = this.xsdMappingMap.get(localName);
        }
        localName = this.localResourceBaseURL.toString() + (String)localName;
        URL localURL = null;
        try {
            localURL = new URL((String)localName);
        }
        catch (Exception e) {
            return null;
        }
        try {
            input.setByteStream(localURL.openStream());
            if (JAXBUtil.isHTTPResource(systemId) && this.catalogDocument != null && this.catalogDocument.getDocumentElement() != null) {
                try {
                    Element catalogEntry = this.catalogDocument.createElement("uri");
                    catalogEntry.setAttribute("name", systemId);
                    catalogEntry.setAttribute("uri", localURL.toString());
                    this.catalogDocument.getDocumentElement().appendChild(catalogEntry);
                }
                catch (Exception catalogEntry) {}
            }
        }
        catch (IOException e) {
            if (!JAXBUtil.isHTTPResource(systemId)) {
                return null;
            }
            try {
                input.setByteStream(new URL(systemId).openStream());
            }
            catch (MalformedURLException e1) {
                return null;
            }
            catch (IOException e1) {
                return null;
            }
        }
        input.setSystemId(systemId);
        input.setBaseURI(baseURI);
        return input;
    }

    public final Document getCatalogDocument() {
        return this.catalogDocument;
    }
}

