/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cif;

import de.bos_bremen.gov2.jca_provider.ocf.cif.JAXBWrapperElement;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class JAXBUtil {
    private JAXBUtil() {
    }

    public static <T> JAXBWrapperElement<T> parseAny(String packageName, Document xsd, Class<?> anyClass, Object childNode, Class<T> typeClass, Unmarshaller unmarshaller) {
        Object objectNode = childNode;
        Node node = null;
        Element element = null;
        Object parsedNode = null;
        if (xsd != null && childNode != null && Node.class.isInstance(childNode)) {
            node = (Node)childNode;
            element = JAXBUtil.assertElement(childNode);
            objectNode = null;
            parsedNode = JAXBUtil.getParsedNodeWithUnmarshaller(packageName, typeClass, unmarshaller, node, xsd, anyClass);
        }
        parsedNode = JAXBUtil.assertParsedNode(childNode, typeClass, parsedNode);
        return new JAXBWrapperElement<Object>(objectNode, element, node, parsedNode);
    }

    private static Element assertElement(Object childNode) {
        Element result = null;
        if (Element.class.isInstance(childNode)) {
            result = (Element)Element.class.cast(childNode);
        }
        return result;
    }

    private static <T> T assertParsedNode(Object childNode, Class<T> typeClass, T parsedNode) {
        T result = parsedNode;
        if (parsedNode == null && typeClass.isInstance(childNode)) {
            result = typeClass.cast(childNode);
        }
        return result;
    }

    private static <T> T getParsedNodeWithUnmarshaller(String packageName, Class<T> typeClass, Unmarshaller unmarshaller, Node node, Document xsd, Class<?> anyClass) {
        String classname = Object.class.equals(typeClass) ? JAXBUtil.getClassname(packageName, xsd, anyClass.getSimpleName(), node) : typeClass.getName();
        T parsedNode = null;
        if (classname != null) {
            try {
                JAXBElement je;
                Object v;
                if (unmarshaller == null) {
                    JAXBContext jc = JAXBContext.newInstance((String)packageName);
                    unmarshaller = jc.createUnmarshaller();
                }
                if (typeClass.isInstance(v = (je = unmarshaller.unmarshal(node, Class.forName(classname))).getValue())) {
                    parsedNode = typeClass.cast(v);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return parsedNode;
    }

    public static String getClassname(String packageName, Document xsd, String anyType, Node node) {
        String classname = null;
        try {
            XPathFactory xpf = XPathFactory.newInstance();
            XPath xp = xpf.newXPath();
            XPathExpression xpe = null;
            String nodeName = node.getLocalName();
            xpe = anyType != null ? xp.compile("//complexType[@name=\"" + anyType + "\"]//element[@name=\"" + nodeName + "\"]") : xp.compile("//element[@name=\"" + nodeName + "\"]");
            Object result = xpe.evaluate(xsd, XPathConstants.NODESET);
            NodeList nl = (NodeList)result;
            if (nl.getLength() == 0 && ((nl = (NodeList)(result = (xpe = xp.compile("//complexType[@name=\"" + anyType + "\"]//element[@ref=\"" + node.getNodeName() + "\"]")).evaluate(xsd, XPathConstants.NODESET))) == null || nl.getLength() == 0)) {
                xpe = xp.compile("//element[@name=\"" + nodeName + "\"]");
                result = xpe.evaluate(xsd, XPathConstants.NODESET);
                nl = (NodeList)result;
            }
            String sn = nl.item(0).getAttributes().getNamedItem("type").getNodeValue();
            String s = "@name=\"" + sn + "\"";
            String prefix = "";
            if (s.contains(":")) {
                prefix = sn.substring(0, sn.lastIndexOf(":"));
                s = s + " or @name=\"" + sn.substring(sn.lastIndexOf(":") + 1) + "\"";
            }
            xpe = xp.compile("//complexType[" + s + "]");
            result = xpe.evaluate(xsd, XPathConstants.NODESET);
            nl = (NodeList)result;
            String pkgName = packageName;
            classname = JAXBUtil.assertClass(pkgName + "." + prefix.toUpperCase(Locale.ENGLISH) + nl.item(0).getAttributes().getNamedItem("name").getNodeValue());
            if (classname == null) {
                classname = JAXBUtil.assertClass(pkgName + "." + nl.item(0).getAttributes().getNamedItem("name").getNodeValue());
            }
        }
        catch (Exception e) {
            classname = null;
        }
        return classname;
    }

    private static String assertClass(String classname) {
        String result = classname;
        try {
            Class.forName(classname);
        }
        catch (ClassNotFoundException e1) {
            result = null;
        }
        return result;
    }

    public static URL getParentURL(URL url) throws MalformedURLException {
        return new URL(url.toString().substring(0, url.toString().lastIndexOf("/") + 1));
    }

    public static Document readSchemaAsDocument(URL schemaURL, Map<String, String> xsdMappingMap) {
        Document d;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            JAXBUtil.secureDocumentBuilderFactory(dbf);
            DocumentBuilder db = dbf.newDocumentBuilder();
            d = db.parse(schemaURL.toString());
            JAXBUtil.resolveIncludesAndImports(JAXBUtil.getParentURL(schemaURL), d, dbf, xsdMappingMap);
        }
        catch (Exception e) {
            d = null;
        }
        return d;
    }

    private static void secureDocumentBuilderFactory(DocumentBuilderFactory dbf) {
        dbf.setXIncludeAware(false);
        dbf.setExpandEntityReferences(true);
        try {
            dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        try {
            dbf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            dbf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public static boolean isHTTPResource(URL resourceId) {
        return JAXBUtil.isHTTPResource(resourceId.toString());
    }

    public static boolean isHTTPResource(String resourceURI) {
        return resourceURI != null && resourceURI.startsWith("http:") && resourceURI.contains("/");
    }

    public static String getLocalResourceName(String resourceURI) {
        if (!JAXBUtil.isHTTPResource(resourceURI)) {
            return resourceURI;
        }
        return resourceURI.substring(resourceURI.lastIndexOf("/") + 1);
    }

    private static void resolveIncludesAndImports(URL resourcesURL, Document schemaDocument, DocumentBuilderFactory dbf, Map<String, String> xsdMappingMap) throws XPathExpressionException, ParserConfigurationException, SAXException, IOException {
        XPathFactory xpf = XPathFactory.newInstance();
        XPath xp = xpf.newXPath();
        XPathExpression xpe = xp.compile("//include");
        Object result = xpe.evaluate(schemaDocument, XPathConstants.NODESET);
        if (NodeList.class.isInstance(result)) {
            JAXBUtil.insertImportInclude((NodeList)NodeList.class.cast(result), resourcesURL, schemaDocument, dbf, xsdMappingMap);
        }
        if (NodeList.class.isInstance(result = (xpe = xp.compile("//import")).evaluate(schemaDocument, XPathConstants.NODESET))) {
            JAXBUtil.insertImportInclude((NodeList)NodeList.class.cast(result), resourcesURL, schemaDocument, dbf, xsdMappingMap);
        }
    }

    private static void insertImportInclude(NodeList nodeList, URL resourcesURL, Document schemaDocument, DocumentBuilderFactory dbf, Map<String, String> xsdMappingMap) throws ParserConfigurationException, SAXException, IOException, XPathExpressionException {
        if (nodeList == null || nodeList.getLength() == 0) {
            return;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            boolean isHTTP = JAXBUtil.isHTTPResource(resourcesURL);
            Node node = nodeList.item(i);
            String location = node.getAttributes().getNamedItem("schemaLocation").getNodeValue();
            String string = location = isHTTP ? location : JAXBUtil.getLocalResourceName(location);
            if (xsdMappingMap != null && xsdMappingMap.containsKey(location)) {
                location = xsdMappingMap.get(location);
            }
            URL docURL = new URL(resourcesURL.toString() + location);
            JAXBUtil.secureDocumentBuilderFactory(dbf);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document di = db.parse(docURL.toString());
            JAXBUtil.resolveIncludesAndImports(resourcesURL, di, dbf, xsdMappingMap);
            Node ni = schemaDocument.importNode(di.getDocumentElement(), true);
            schemaDocument.getDocumentElement().replaceChild(ni, node);
        }
    }
}

