/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cif;

import de.bos_bremen.basecard.common.pin.coding.PinEncoder;
import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.gov2.jca_provider.ocf.cards.APDUCommands;
import de.bos_bremen.gov2.jca_provider.ocf.cards.APDUConstants;
import de.bos_bremen.gov2.jca_provider.ocf.cards.ISO247273TemplateEngine;
import de.bos_bremen.gov2.jca_provider.ocf.cards.iso24737.ApplicationPurpose;
import de.bos_bremen.gov2.jca_provider.ocf.cards.iso24737.CardPurpose;
import de.bos_bremen.gov2.jca_provider.ocf.cards.iso24737.FilePurpose;
import de.bos_bremen.gov2.jca_provider.ocf.cards.iso24737.KeyPurpose;
import de.bos_bremen.gov2.jca_provider.ocf.cards.iso24737.Phase;
import de.bos_bremen.gov2.jca_provider.ocf.cards.iso24737.PinPurpose;
import de.bos_bremen.gov2.jca_provider.ocf.cards.iso24737.Purpose;
import de.bos_bremen.gov2.jca_provider.ocf.cif.CIFCard;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardObject;
import iso.std.iso_iec._24727.tech.schema.AlgorithmInfoType;
import iso.std.iso_iec._24727.tech.schema.CardApplicationType;
import iso.std.iso_iec._24727.tech.schema.CardInfoType;
import iso.std.iso_iec._24727.tech.schema.CryptoKeyInfoType;
import iso.std.iso_iec._24727.tech.schema.DIDInfoType;
import iso.std.iso_iec._24727.tech.schema.DIDScopeType;
import iso.std.iso_iec._24727.tech.schema.DataSetInfoType;
import iso.std.iso_iec._24727.tech.schema.KeyRefType;
import iso.std.iso_iec._24727.tech.schema.PasswordAttributesType;
import iso.std.iso_iec._24727.tech.schema.PasswordTypeType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import opencard.core.terminal.CommandAPDU;

public class DefaultCIFTemplateEngine
implements ISO247273TemplateEngine<CardInfoType, CardApplicationType, DataSetInfoType, DIDInfoType, DIDInfoType, CardObject<?>>,
APDUConstants {
    private static final String SIGNATURE_GENERATION_CMD_MSE_HASH = "MSE_HASH";
    private static final String SIGNATURE_GENERATION_CMD_PSO_HASH = "PSO_HASH";
    private static final String SIGNATURE_GENERATION_CMD_MSE_KEY_DS = "MSE_KEY_DS";
    private static final String SIGNATURE_GENERATION_CMD_PSO_CDS = "PSO_CDS";
    private static DefaultCIFTemplateEngine defaultTemplateEngineSingleton = null;

    private DefaultCIFTemplateEngine() {
    }

    public static synchronized ISO247273TemplateEngine<CardInfoType, CardApplicationType, DataSetInfoType, DIDInfoType, DIDInfoType, CardObject<?>> getDefault() {
        if (defaultTemplateEngineSingleton == null) {
            defaultTemplateEngineSingleton = new DefaultCIFTemplateEngine();
        }
        return defaultTemplateEngineSingleton;
    }

    @Override
    public List<CommandAPDU> createApplicationTemplate(ApplicationPurpose purpose, Phase phase, CardApplicationType application, Object parameters) throws IllegalArgumentException {
        AssertUtil.notNull(purpose, "purpose");
        AssertUtil.notNull((Object)phase, "phase");
        AssertUtil.notNull(application, "application");
        if (purpose == ApplicationPurpose.SELECT && phase == Phase.EXECUTE_OPERATION) {
            ArrayList<CommandAPDU> cmdList = new ArrayList<CommandAPDU>();
            cmdList.add(APDUCommands.createSelectCommand(4, 12, application.getApplicationIdentifier(), 1024));
            return cmdList;
        }
        return null;
    }

    @Override
    public List<CommandAPDU> createCardTemplate(CardPurpose purpose, Phase phase, CardInfoType card, Object parameters) throws IllegalArgumentException {
        return null;
    }

    @Override
    public List<CommandAPDU> createFileTemplate(FilePurpose purpose, Phase phase, DataSetInfoType file, Object parameters) throws IllegalArgumentException {
        AssertUtil.notNull(purpose, "purpose");
        AssertUtil.notNull((Object)phase, "phase");
        if (purpose == FilePurpose.SELECT && phase == Phase.EXECUTE_OPERATION) {
            AssertUtil.notNull(file, "data set info");
            byte[] efid = file.getDataSetPath().getEfIdOrPath();
            if (efid != null) {
                ArrayList<CommandAPDU> cmdList = new ArrayList<CommandAPDU>();
                if (efid.length == 2) {
                    cmdList.add(APDUCommands.createSelectCommand(2, 12, efid, 1024));
                } else if (efid.length > 2 && efid.length % 2 == 0) {
                    if (efid[0] == 63 && efid[1] == 0) {
                        cmdList.add(APDUCommands.createSelectCommand(8, 12, efid, 1024));
                    } else {
                        cmdList.add(APDUCommands.createSelectCommand(9, 12, efid, 1024));
                    }
                } else {
                    return null;
                }
                return cmdList;
            }
            return null;
        }
        if (purpose == FilePurpose.READ) {
            if (phase == Phase.PREPARE_OPERATION) {
                ArrayList<CommandAPDU> cmdList = new ArrayList<CommandAPDU>();
                cmdList.add(APDUCommands.createReadBinaryCommand(0, 10));
                return cmdList;
            }
            if (phase == Phase.EXECUTE_OPERATION) {
                int chunkSize;
                int MAXIMUM_CHUNK_SIZE = 240;
                Integer[] params = (Integer[])parameters;
                if (params == null || params.length != 2) {
                    throw new IllegalArgumentException("required data not available");
                }
                int offset = params[0];
                int readLength = params[1];
                ArrayList<CommandAPDU> cmdList = new ArrayList<CommandAPDU>();
                for (int currentRead = 0; currentRead < readLength; currentRead += chunkSize) {
                    chunkSize = Math.min(readLength - currentRead, MAXIMUM_CHUNK_SIZE);
                    CommandAPDU cmd = APDUCommands.createReadBinaryCommand(offset + currentRead, chunkSize);
                    cmdList.add(cmd);
                }
                return cmdList;
            }
        }
        return null;
    }

    @Override
    public List<CommandAPDU> createKeyTemplate(KeyPurpose purpose, Phase phase, DIDInfoType key, Object parameters) throws IllegalArgumentException {
        AssertUtil.notNull(purpose, "purpose");
        AssertUtil.notNull((Object)phase, "phase");
        AssertUtil.notNull(key, "DID info");
        if (purpose == KeyPurpose.SIGNATURE && phase == Phase.EXECUTE_OPERATION) {
            List elements = null;
            String signatureGeneration = null;
            try {
                elements = key.getDifferentialIdentity().getDIDMarker().getCryptoMarker().getAny();
                signatureGeneration = CIFCard.getNode(elements, new String[]{"iso:SignatureGenerationInfo"}).getFirstChild().getNodeValue();
            }
            catch (NullPointerException e) {
                throw new IllegalArgumentException("required data not available", e);
            }
            StringTokenizer st = new StringTokenizer(signatureGeneration);
            CryptoKeyInfoType ckit = CIFCard.findInElements(elements, CryptoKeyInfoType.class);
            if (ckit == null) {
                throw new IllegalArgumentException("required data not available");
            }
            byte[] keyID = null;
            try {
                keyID = ckit.getKeyRef().getKeyRef();
            }
            catch (NullPointerException e) {
                throw new IllegalArgumentException("required data not available", e);
            }
            if (keyID != null && keyID.length == 1 && key.getDifferentialIdentity().getDIDScope() == DIDScopeType.LOCAL) {
                keyID[0] = (byte)(keyID[0] | 0x80);
            }
            AlgorithmInfoType ait = CIFCard.findInElements(elements, AlgorithmInfoType.class);
            ArrayList<String> requestedCommandList = new ArrayList<String>();
            while (st.hasMoreTokens()) {
                requestedCommandList.add(st.nextToken());
            }
            ArrayList<CommandAPDU> cmdList = new ArrayList<CommandAPDU>();
            byte[] data = (byte[])parameters;
            for (String nextCommand : requestedCommandList) {
                if (nextCommand.equals(SIGNATURE_GENERATION_CMD_MSE_HASH)) {
                    byte[] hashAlgRef = ait.getHashAlgRef();
                    if (hashAlgRef == null) {
                        throw new IllegalArgumentException("required data not available");
                    }
                    cmdList.add(DefaultCIFTemplateEngine.createMSEHash(hashAlgRef));
                    continue;
                }
                if (nextCommand.equals(SIGNATURE_GENERATION_CMD_PSO_HASH)) {
                    cmdList.add(DefaultCIFTemplateEngine.createPSOHash(data));
                    continue;
                }
                if (nextCommand.equals(SIGNATURE_GENERATION_CMD_MSE_KEY_DS)) {
                    byte[] cardAlgRef = ait.getCardAlgRef();
                    if (cardAlgRef == null) {
                        throw new IllegalArgumentException("required data not available");
                    }
                    cmdList.add(DefaultCIFTemplateEngine.createMSEKeyDS(keyID, cardAlgRef));
                    continue;
                }
                if (!nextCommand.equals(SIGNATURE_GENERATION_CMD_PSO_CDS)) continue;
                if (requestedCommandList.contains(SIGNATURE_GENERATION_CMD_PSO_HASH)) {
                    cmdList.add(DefaultCIFTemplateEngine.createPSOCDS(null));
                    continue;
                }
                cmdList.add(DefaultCIFTemplateEngine.createPSOCDS(data));
            }
            return cmdList;
        }
        return null;
    }

    @Override
    public List<CommandAPDU> createPinTemplate(PinPurpose purpose, Phase phase, DIDInfoType pin, Object parameters) throws IllegalArgumentException {
        AssertUtil.notNull(purpose, "purpose");
        AssertUtil.notNull((Object)phase, "phase");
        AssertUtil.notNull(pin, "DID info");
        if (purpose == PinPurpose.VERIFY && phase == Phase.EXECUTE_OPERATION) {
            List elements = null;
            try {
                elements = pin.getDifferentialIdentity().getDIDMarker().getPinCompareMarker().getAny();
            }
            catch (NullPointerException e) {
                throw new IllegalArgumentException("required data not available", e);
            }
            KeyRefType krt = CIFCard.findInElements(elements, KeyRefType.class);
            byte[] keyRef = krt.getKeyRef();
            PasswordAttributesType pat = CIFCard.findInElements(elements, PasswordAttributesType.class);
            if (pat == null) {
                throw new IllegalArgumentException("required data not available");
            }
            PasswordTypeType pwdType = pat.getPwdType();
            PinEncoder encoder = CIFCard.getEncoderFromPasswordType(pwdType);
            char[] pinValue = (char[])parameters;
            byte[] encodedPin = null;
            if (pat.getPwdFlags().contains("needs-padding")) {
                byte[] padChars = pat.getPadChar();
                Byte padChar = null;
                if (padChars != null) {
                    padChar = padChars[0];
                }
                int padLength = pat.getStoredLength().intValue();
                encodedPin = encoder.encode(pinValue, (Integer)padLength, padChar);
            } else {
                encodedPin = encoder.encode(pinValue);
            }
            if (keyRef.length == 1) {
                if (pin.getDifferentialIdentity().getDIDScope() == DIDScopeType.LOCAL) {
                    keyRef[0] = (byte)(keyRef[0] | 0x80);
                }
                ArrayList<CommandAPDU> cmdList = new ArrayList<CommandAPDU>();
                cmdList.add(DefaultCIFTemplateEngine.createVerifyPin(keyRef[0], encodedPin));
                return cmdList;
            }
        }
        return null;
    }

    @Override
    public List<CommandAPDU> createObjectTemplate(Purpose purpose, Phase phase, CardObject<?> cardObject, Object parameters) throws IllegalArgumentException {
        return null;
    }

    private static CommandAPDU createMSEHash(byte[] hashAlg) throws IllegalArgumentException {
        AssertUtil.notNullOrEmpty(hashAlg, "hash algorithm");
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        data.write(-128);
        data.write(hashAlg.length);
        try {
            data.write(hashAlg);
        }
        catch (IOException e1) {
            return null;
        }
        return APDUCommands.createManageSecurityEnvironmentCommand((byte)65, (byte)-86, data.toByteArray());
    }

    private static CommandAPDU createPSOHash(byte[] data) throws IllegalArgumentException {
        AssertUtil.notNullOrEmpty(data, "hash data");
        byte[] buffer = new byte[7 + data.length];
        buffer[0] = 0;
        buffer[1] = 42;
        buffer[2] = -112;
        buffer[3] = -96;
        buffer[4] = (byte)(data.length + 2);
        buffer[5] = -112;
        buffer[6] = (byte)data.length;
        System.arraycopy(data, 0, buffer, 7, data.length);
        return new CommandAPDU(buffer);
    }

    private static CommandAPDU createMSEKeyDS(byte[] keyID, byte[] keyAlg) throws IllegalArgumentException {
        AssertUtil.notNullOrEmpty(keyID, "key ID");
        AssertUtil.notNullOrEmpty(keyAlg, "key algorithm");
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        data.write(-124);
        data.write(keyID.length);
        try {
            data.write(keyID);
            data.write(-128);
            data.write(keyAlg.length);
            data.write(keyAlg);
            return APDUCommands.createManageSecurityEnvironmentCommand((byte)65, (byte)-74, data.toByteArray());
        }
        catch (IOException e) {
            return null;
        }
    }

    private static CommandAPDU createPSOCDS(byte[] data) {
        byte[] buffer = new byte[5 + (data == null ? 0 : 1 + data.length)];
        buffer[0] = 0;
        buffer[1] = 42;
        buffer[2] = -98;
        buffer[3] = -102;
        if (data != null) {
            buffer[4] = (byte)data.length;
            System.arraycopy(data, 0, buffer, 5, data.length);
        }
        buffer[buffer.length - 1] = 0;
        return new CommandAPDU(buffer);
    }

    private static CommandAPDU createVerifyPin(byte pinID, byte[] pinValue) {
        byte[] commandBytes = new byte[4 + (pinValue == null ? 0 : 1 + pinValue.length)];
        int index = 0;
        commandBytes[index++] = 0;
        commandBytes[index++] = 32;
        commandBytes[index++] = 0;
        commandBytes[index++] = pinID;
        if (pinValue != null) {
            commandBytes[index++] = (byte)pinValue.length;
            System.arraycopy(pinValue, 0, commandBytes, index, pinValue.length);
        }
        return new CommandAPDU(commandBytes);
    }
}

