/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cif;

import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.ByteUtil;
import de.bos_bremen.gov2.jca_provider.ocf.cards.DefaultCardServiceFactory;
import de.bos_bremen.gov2.jca_provider.ocf.cif.CIFCard;
import de.bos_bremen.gov2.jca_provider.ocf.cif.CIFCardType;
import de.bos_bremen.gov2.jca_provider.ocf.cif.CIFTypeConverterListener;
import de.bos_bremen.gov2.jca_provider.ocf.cif.JAXBUtil;
import de.bos_bremen.gov2.jca_provider.ocf.cif.LocalResourceResolver;
import iso.std.iso_iec._24727.tech.schema.ATRInterfaceBytesType;
import iso.std.iso_iec._24727.tech.schema.ATRType;
import iso.std.iso_iec._24727.tech.schema.ATSType;
import iso.std.iso_iec._24727.tech.schema.ByteMaskType;
import iso.std.iso_iec._24727.tech.schema.CardCallSequenceType;
import iso.std.iso_iec._24727.tech.schema.CardCallType;
import iso.std.iso_iec._24727.tech.schema.CardInfoType;
import iso.std.iso_iec._24727.tech.schema.ResponseAPDUType;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import opencard.core.service.CardChannel;
import opencard.core.service.CardService;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceScheduler;
import opencard.core.service.CardType;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class CIFCardFactory
extends DefaultCardServiceFactory {
    private Unmarshaller unmarshaller = null;

    public CIFCardFactory() throws IllegalStateException, MalformedURLException {
        HashMap<String, String> xsdMappingMap = new HashMap<String, String>();
        xsdMappingMap.put("oasis-sstc-saml-schema-protocol-1.1.xsd", "oasis-sstc-saml-schema-protocol-1.xsd");
        URL xsdURL = this.getClass().getResource("/resources/xmlschema/cif/CardInfo.xsd");
        Document d = JAXBUtil.readSchemaAsDocument(xsdURL, null);
        try {
            JAXBContext jc = JAXBContext.newInstance((String)"iso.std.iso_iec._24727.tech.schema");
            SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            sf.setResourceResolver(new LocalResourceResolver(JAXBUtil.getParentURL(xsdURL), xsdMappingMap));
            Schema schema = sf.newSchema(xsdURL);
            this.unmarshaller = jc.createUnmarshaller();
            this.unmarshaller.setListener((Unmarshaller.Listener)new CIFTypeConverterListener(d, jc.createUnmarshaller()));
            this.unmarshaller.setSchema(schema);
        }
        catch (JAXBException e) {
            throw new IllegalStateException("missing required files for CIF decoding", e);
        }
        catch (SAXException e) {
            throw new IllegalStateException("missing required files for CIF decoding", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CardType getCardType(CardID cid, CardServiceScheduler scheduler) throws CardTerminalException, IllegalStateException, IllegalArgumentException {
        AssertUtil.notNull(cid, "card id");
        AssertUtil.notNull(scheduler, "scheduler");
        CardChannel channel = scheduler.allocateCardChannel(null, true);
        byte[] cardATRBytes = cid.getATR();
        CardInfoType cif = null;
        try {
            CIFCardType cIFCardType;
            try {
                URL cifURL = this.getClass().getResource("/resources/cif/starcos32.cif.xml");
                cif = (CardInfoType)((JAXBElement)this.unmarshaller.unmarshal(cifURL)).getValue();
            }
            catch (JAXBException e) {
                throw new IllegalStateException("CIF could not be decoded");
            }
            if (CIFCardFactory.checkCIF(channel, cardATRBytes, cif)) {
                cIFCardType = new CIFCardType(cif);
                return cIFCardType;
            }
            cIFCardType = null;
            return cIFCardType;
        }
        finally {
            scheduler.releaseCardChannel(channel);
        }
    }

    @Override
    protected Enumeration getClasses(CardType type) {
        return new DefaultCardServiceFactory.SingleEnumeration(CIFCard.class);
    }

    @Override
    protected CardService newCardServiceInstance(Class clazz, CardType type, CardServiceScheduler scheduler, SmartCard card, boolean blocking) throws CardServiceException, IllegalArgumentException {
        if (clazz != CIFCard.class) {
            throw new IllegalArgumentException("newCardServiceInstance of CIFCardFactory accepting only CIFCard.class as clazz argument");
        }
        if (!(type instanceof CIFCardType)) {
            throw new IllegalArgumentException("newCardServiceInstance of CIFCardFactory accepting only CIFCardType as type argument");
        }
        CIFCard instance = null;
        try {
            instance = (CIFCard)clazz.newInstance();
        }
        catch (NoSuchMethodError noSuchMethodError) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        if (instance != null) {
            CardInfoType cif = ((CIFCardType)type).getAssociatedCIF();
            instance.initialize(scheduler, card, blocking, CIFCardFactory.isSigned(cif), cif);
        }
        return instance;
    }

    private static boolean checkCIF(CardChannel channel, byte[] cardATRBytes, CardInfoType cif) throws CardTerminalException {
        ATSType ats;
        boolean atrFound = false;
        List atrList = cif.getCardIdentification().getATR();
        for (ATRType atr : atrList) {
            if (!CIFCardFactory.checkATR(atr, cardATRBytes)) continue;
            atrFound = true;
            break;
        }
        if (!(atrFound || (ats = cif.getCardIdentification().getATS()) != null && CIFCardFactory.checkATS(ats, cardATRBytes))) {
            return false;
        }
        boolean cifTrustworthySigned = CIFCardFactory.isSigned(cif);
        for (CardCallSequenceType cc : cif.getCardIdentification().getCharacteristicFeature()) {
            for (CardCallType c : cc.getCardCall()) {
                if (!cifTrustworthySigned && CIFCard.unsafeCommand(c.getCommandAPDU())) {
                    return false;
                }
                CommandAPDU command = new CommandAPDU(c.getCommandAPDU());
                ResponseAPDU response = channel.sendCommandAPDU(command);
                boolean match = false;
                for (ResponseAPDUType r : c.getResponseAPDU()) {
                    if (!CIFCard.matchResponse(response, r)) continue;
                    match = true;
                    break;
                }
                if (match) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean checkATR(ATRType cifATR, byte[] cardATRBytes) {
        byte[] cifATRBytes = new byte[]{};
        int i = 0;
        ATRByteContainer abc = new ATRByteContainer(cardATRBytes, cifATRBytes);
        try {
            i = CIFCardFactory.performByteMaskStep(abc, i, cifATR.getTS());
            i = CIFCardFactory.performByteMaskStep(abc, i, cifATR.getT0());
            i = CIFCardFactory.checkATRInterfaceBytes(abc, i, cifATR.getInterfaceBytes().getTx1());
            i = CIFCardFactory.checkATRInterfaceBytes(abc, i, cifATR.getInterfaceBytes().getTx2());
            i = CIFCardFactory.checkATRInterfaceBytes(abc, i, cifATR.getInterfaceBytes().getTx3());
            i = CIFCardFactory.checkATRInterfaceBytes(abc, i, cifATR.getInterfaceBytes().getTx4());
            ATRType.HistoricalBytes hb = cifATR.getHistoricalBytes();
            if (hb != null) {
                for (ByteMaskType bmt : hb.getTi()) {
                    i = CIFCardFactory.performByteMaskStep(abc, i, bmt);
                }
            }
            if (cifATR.getTCK() != null) {
                CIFCardFactory.performByteMaskStep(abc, i, cifATR.getTCK());
            }
            if (ByteUtil.equals(abc.getCardATR(), abc.getCifATR())) {
                return true;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return false;
    }

    private static boolean checkATS(ATSType cifATS, byte[] cardATSBytes) {
        byte[] cifATSBytes = new byte[]{};
        int i = 0;
        ATRByteContainer abc = new ATRByteContainer(cardATSBytes, cifATSBytes);
        try {
            ATSType.HistoricalBytes hb;
            i = CIFCardFactory.performByteMaskStep(abc, i, cifATS.getTL());
            i = CIFCardFactory.performByteMaskStep(abc, i, cifATS.getT0());
            if (cifATS.getInterfaceBytes().getTA1() != null) {
                i = CIFCardFactory.performByteMaskStep(abc, i, cifATS.getInterfaceBytes().getTA1());
            }
            if (cifATS.getInterfaceBytes().getTB1() != null) {
                i = CIFCardFactory.performByteMaskStep(abc, i, cifATS.getInterfaceBytes().getTB1());
            }
            if (cifATS.getInterfaceBytes().getTC1() != null) {
                i = CIFCardFactory.performByteMaskStep(abc, i, cifATS.getInterfaceBytes().getTC1());
            }
            if ((hb = cifATS.getHistoricalBytes()) != null) {
                for (ByteMaskType bmt : hb.getTi()) {
                    i = CIFCardFactory.performByteMaskStep(abc, i, bmt);
                }
            }
            i = CIFCardFactory.performByteMaskStep(abc, i, cifATS.getCRC1());
            if (cifATS.getCRC2() != null) {
                CIFCardFactory.performByteMaskStep(abc, i, cifATS.getCRC2());
            }
            if (ByteUtil.equals(abc.getCardATR(), abc.getCifATR())) {
                return true;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return false;
    }

    private static int performByteMaskStep(ATRByteContainer cont, int i, ByteMaskType bmt) {
        byte[] cardATRBytes = cont.getCardATR();
        cardATRBytes[i] = (byte)(cardATRBytes[i] & bmt.getMask()[0]);
        cont.setCardATR(cardATRBytes);
        cont.setCifATR(ByteUtil.combine(cont.getCifATR(), bmt.getValue()));
        return ++i;
    }

    private static int checkATRInterfaceBytes(ATRByteContainer cont, int i, ATRInterfaceBytesType ib) {
        if (ib.getTAi() != null) {
            i = CIFCardFactory.performByteMaskStep(cont, i, ib.getTAi());
        }
        if (ib.getTBi() != null) {
            i = CIFCardFactory.performByteMaskStep(cont, i, ib.getTBi());
        }
        if (ib.getTCi() != null) {
            i = CIFCardFactory.performByteMaskStep(cont, i, ib.getTCi());
        }
        if (ib.getTDi() != null) {
            i = CIFCardFactory.performByteMaskStep(cont, i, ib.getTDi());
        }
        return i;
    }

    private static boolean isSigned(CardInfoType cif) throws IllegalArgumentException {
        AssertUtil.notNull(cif, "CIF");
        return false;
    }

    private static class ATRByteContainer {
        private byte[] cardATR = null;
        private byte[] cifATR = null;

        public ATRByteContainer(byte[] cardATRBytes, byte[] cifATRBytes) {
            this.cardATR = cardATRBytes;
            this.cifATR = cifATRBytes;
        }

        public void setCardATR(byte[] cardATR) {
            this.cardATR = cardATR;
        }

        public byte[] getCardATR() {
            return this.cardATR;
        }

        public void setCifATR(byte[] cifATR) {
            this.cifATR = cifATR;
        }

        public byte[] getCifATR() {
            return this.cifATR;
        }
    }
}

