/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cif;

import de.bos_bremen.basecard.common.pin.coding.PinEncoder;
import de.bos_bremen.common.ArrayUtil;
import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.ByteUtil;
import de.bos_bremen.common.HexUtil;
import de.bos_bremen.common.asn1.ASN1;
import de.bos_bremen.common.asn1.DigestInfo;
import de.bos_bremen.common.asn1.HashAlgorithm;
import de.bos_bremen.gov2.jca_provider.ocf.FileEntry;
import de.bos_bremen.gov2.jca_provider.ocf.NotYetInitializedException;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.OperationCancelledException;
import de.bos_bremen.gov2.jca_provider.ocf.PinDeactivatedException;
import de.bos_bremen.gov2.jca_provider.ocf.ResponseCodeException;
import de.bos_bremen.gov2.jca_provider.ocf.RetryCounterExpiredException;
import de.bos_bremen.gov2.jca_provider.ocf.cards.CardChannelManager;
import de.bos_bremen.gov2.jca_provider.ocf.cards.FileReference;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.ISO247273CardService;
import de.bos_bremen.gov2.jca_provider.ocf.cards.ISO247273TemplateEngine;
import de.bos_bremen.gov2.jca_provider.ocf.cards.KeyID;
import de.bos_bremen.gov2.jca_provider.ocf.cards.iso24737.ApplicationPurpose;
import de.bos_bremen.gov2.jca_provider.ocf.cards.iso24737.CardPurpose;
import de.bos_bremen.gov2.jca_provider.ocf.cards.iso24737.FilePurpose;
import de.bos_bremen.gov2.jca_provider.ocf.cards.iso24737.KeyPurpose;
import de.bos_bremen.gov2.jca_provider.ocf.cards.iso24737.Phase;
import de.bos_bremen.gov2.jca_provider.ocf.cards.iso24737.PinPurpose;
import de.bos_bremen.gov2.jca_provider.ocf.cards.iso24737.Purpose;
import de.bos_bremen.gov2.jca_provider.ocf.cif.DefaultCIFTemplateEngine;
import de.bos_bremen.gov2.jca_provider.ocf.cif.JAXBWrapperElement;
import de.bos_bremen.gov2.jca_provider.ocf.model.Card;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardApplication;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardFile;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardKey;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardObject;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardObjectManager;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardPin;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardRegistry;
import de.bos_bremen.gov2.jca_provider.ocf.model.Disposeable;
import de.bos_bremen.gov2.jca_provider.ocf.model.Terminal;
import de.bos_bremen.gov2.jca_provider.ocf.model.Type;
import de.bos_bremen.gov2.jca_provider.ocf.model.TypedType;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardApplicationImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardFileImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardKeyImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectManagerImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectRegistryImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardPinImpl;
import iso.std.iso_iec._24727.tech.schema.AccessRuleType;
import iso.std.iso_iec._24727.tech.schema.AlgorithmInfoType;
import iso.std.iso_iec._24727.tech.schema.ApplicationCapabilitiesType;
import iso.std.iso_iec._24727.tech.schema.CardApplicationType;
import iso.std.iso_iec._24727.tech.schema.CardCallType;
import iso.std.iso_iec._24727.tech.schema.CardInfoType;
import iso.std.iso_iec._24727.tech.schema.CertificateRefType;
import iso.std.iso_iec._24727.tech.schema.ConclusionType;
import iso.std.iso_iec._24727.tech.schema.CryptoKeyInfoType;
import iso.std.iso_iec._24727.tech.schema.CryptoMarkerType;
import iso.std.iso_iec._24727.tech.schema.DIDInfoType;
import iso.std.iso_iec._24727.tech.schema.DIDMarkerType;
import iso.std.iso_iec._24727.tech.schema.DIDScopeType;
import iso.std.iso_iec._24727.tech.schema.DataMaskType;
import iso.std.iso_iec._24727.tech.schema.DataSetInfoType;
import iso.std.iso_iec._24727.tech.schema.DifferentialIdentityType;
import iso.std.iso_iec._24727.tech.schema.KeyRefType;
import iso.std.iso_iec._24727.tech.schema.MatchingDataType;
import iso.std.iso_iec._24727.tech.schema.MatchingRuleType;
import iso.std.iso_iec._24727.tech.schema.PasswordAttributesType;
import iso.std.iso_iec._24727.tech.schema.PasswordTypeType;
import iso.std.iso_iec._24727.tech.schema.PathType;
import iso.std.iso_iec._24727.tech.schema.ResponseAPDUType;
import iso.std.iso_iec._24727.tech.schema.StateInfoType;
import iso.std.iso_iec._24727.tech.schema.StateType;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oasis.names.tc.dss._1_0.core.schema.AnyType;
import oasis.names.tc.dss._1_0.core.schema.InternationalStringType;
import opencard.core.service.CardChannel;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceScheduler;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.util.HexString;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CIFCard
extends GovCS
implements ISO247273CardService<CardInfoType, CardApplicationType, DataSetInfoType, DIDInfoType, DIDInfoType, CardObject<?>> {
    public static final String CIF_PACKAGE_NAME = "iso.std.iso_iec._24727.tech.schema";
    private static final int KEY_USAGE_FLAG_INDEX_DIGITAL_SIGNATURE = 0;
    private static final int KEY_USAGE_FLAG_INDEX_NON_REPUDIATION = 1;
    private static final Log log = LogFactory.getLog(CIFCard.class);
    private ISO247273TemplateEngine<CardInfoType, CardApplicationType, DataSetInfoType, DIDInfoType, DIDInfoType, CardObject<?>> engine = null;
    private final Map<String, Integer> pinStateMap = new HashMap<String, Integer>();
    private boolean isTrustworthySigned = false;
    private CardInfoType cif = null;

    @Override
    public List<CommandAPDU> createApplicationTemplate(ApplicationPurpose purpose, Phase phase, CardApplicationType application, Object parameters) throws IllegalArgumentException {
        return this.engine.createApplicationTemplate(purpose, phase, application, parameters);
    }

    @Override
    public List<CommandAPDU> createCardTemplate(CardPurpose purpose, Phase phase, CardInfoType card, Object parameters) throws IllegalArgumentException {
        return this.engine.createCardTemplate(purpose, phase, card, parameters);
    }

    @Override
    public List<CommandAPDU> createObjectTemplate(Purpose purpose, Phase phase, CardObject<?> cardObject, Object parameters) throws IllegalArgumentException {
        return this.engine.createObjectTemplate(purpose, phase, cardObject, parameters);
    }

    @Override
    public List<CommandAPDU> createFileTemplate(FilePurpose purpose, Phase phase, DataSetInfoType file, Object parameters) throws IllegalArgumentException {
        return this.engine.createFileTemplate(purpose, phase, file, parameters);
    }

    @Override
    public List<CommandAPDU> createKeyTemplate(KeyPurpose purpose, Phase phase, DIDInfoType key, Object parameters) throws IllegalArgumentException {
        return this.engine.createKeyTemplate(purpose, phase, key, parameters);
    }

    @Override
    public List<CommandAPDU> createPinTemplate(PinPurpose purpose, Phase phase, DIDInfoType pin, Object parameters) throws IllegalArgumentException {
        return this.engine.createPinTemplate(purpose, phase, pin, parameters);
    }

    public CIFCard() {
        this.engine = DefaultCIFTemplateEngine.getDefault();
    }

    @Override
    protected Card createCardInt(Terminal terminal, int slotID) {
        if (this.cif != null && this.cif.getApplicationCapabilities() != null) {
            HashMap<String, Long> fileMap = new HashMap<String, Long>();
            ArrayList<String> usedFiles = new ArrayList<String>();
            HashMap<String, Long> pinMap = new HashMap<String, Long>();
            HashMap<String, Long> keyMap = new HashMap<String, Long>();
            long idOfCard = CARD_OBJECT_REGISTRY.createNewCardID();
            long idOfAppl = 1000000L;
            long idOfFile = 3000000L;
            long idOfPin = 2000000L;
            long idOfKey = 4000000L;
            ApplicationCapabilitiesType applications = this.cif.getApplicationCapabilities();
            for (Object cifAppl : applications.getCardApplication()) {
                for (DIDInfoType didInfo : cifAppl.getDIDInfo()) {
                    DIDMarkerType marker = didInfo.getDifferentialIdentity().getDIDMarker();
                    if (marker.getPinCompareMarker() != null) {
                        pinMap.put(didInfo.getDifferentialIdentity().getDIDName(), idOfPin++);
                        continue;
                    }
                    if (marker.getCryptoMarker() == null) continue;
                    keyMap.put(didInfo.getDifferentialIdentity().getDIDName(), idOfKey++);
                }
                for (DataSetInfoType dataSet : cifAppl.getDataSetInfo()) {
                    fileMap.put(dataSet.getDataSetName(), idOfFile++);
                }
            }
            CardApplicationImpl firstAppl = null;
            for (CardApplicationType cifAppl : applications.getCardApplication()) {
                Object didInfo22;
                ArrayList<CardKeyImpl> cardKeyList = new ArrayList<CardKeyImpl>();
                ArrayList<CardPinImpl> cardPinList = new ArrayList<CardPinImpl>();
                ArrayList<CardFileImpl> cardFileList = new ArrayList<CardFileImpl>();
                Object supportedOperationsAppl = "";
                for (Object didInfo22 : cifAppl.getDIDInfo()) {
                    DIDMarkerType marker = didInfo22.getDifferentialIdentity().getDIDMarker();
                    if (marker.getPinCompareMarker() != null) {
                        String pinName = didInfo22.getDifferentialIdentity().getDIDName();
                        ArrayList<Long> arrayList = new ArrayList<Long>();
                        for (CardApplicationType a : applications.getCardApplication()) {
                            for (DIDInfoType di : a.getDIDInfo()) {
                                String pName;
                                DifferentialIdentityType did = di.getDifferentialIdentity();
                                if (did.getDIDMarker().getCryptoMarker() == null || !pinName.equals(pName = ((AccessRuleType)di.getDIDACL().getAccessRule().get(0)).getSecurityCondition().getDIDAuthentication().getDIDName())) continue;
                                arrayList.add((Long)keyMap.get(did.getDIDName()));
                            }
                        }
                        KeyRefType krt = CIFCard.findInElements(marker.getPinCompareMarker().getAny(), KeyRefType.class);
                        byte pinRef = krt.getKeyRef()[0];
                        if (didInfo22.getDifferentialIdentity().getDIDScope() == DIDScopeType.LOCAL) {
                            pinRef = (byte)(pinRef | 0x80);
                        }
                        CardPinImpl pin = new CardPinImpl(Disposeable.NO_LOCK, pinName, (long)((Long)pinMap.get(pinName)), CardPin.CardPinTypeEnum.UNKNOWN.getType(), null, idOfCard, idOfAppl, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinRef, ArrayUtil.to(arrayList.toArray(new Long[arrayList.size()])));
                        pin.setCifNode(didInfo22);
                        cardPinList.add(pin);
                        continue;
                    }
                    if (marker.getCryptoMarker() == null) continue;
                    long keyID = (Long)keyMap.get(didInfo22.getDifferentialIdentity().getDIDName());
                    long pinID = (Long)pinMap.get(((AccessRuleType)didInfo22.getDIDACL().getAccessRule().get(0)).getSecurityCondition().getDIDAuthentication().getDIDName());
                    CertificateRefType crt = CIFCard.findInElements(marker.getCryptoMarker().getAny(), CertificateRefType.class);
                    if (crt == null) continue;
                    String certName = crt.getDataSetName();
                    long fileID = (Long)fileMap.get(certName);
                    usedFiles.add(certName);
                    KeyID k = null;
                    try {
                        CryptoKeyInfoType ckit = CIFCard.findInElements(marker.getCryptoMarker().getAny(), CryptoKeyInfoType.class);
                        byte keyRef = ckit.getKeyRef().getKeyRef()[0];
                        if (didInfo22.getDifferentialIdentity().getDIDScope() == DIDScopeType.LOCAL) {
                            keyRef = (byte)(keyRef | 0x80);
                        }
                        k = new KeyID(HexUtil.hexify(keyRef));
                    }
                    catch (NullPointerException e) {
                        continue;
                    }
                    Object supportedOperations = "";
                    AlgorithmInfoType ait = CIFCard.findInElements(marker.getCryptoMarker().getAny(), AlgorithmInfoType.class);
                    for (String op : ait.getSupportedOperations()) {
                        supportedOperations = (String)supportedOperations + op;
                    }
                    supportedOperationsAppl = (String)supportedOperationsAppl + (String)supportedOperations;
                    OCFCertificateInfo info = new OCFCertificateInfo(idOfCard, pinID, fileID, keyID, OCFCertificateInfo.ChainEntry.UNKNOWN, CIFCard.createUsage((String)supportedOperations), null);
                    CardKeyImpl key = new CardKeyImpl(Disposeable.NO_LOCK, didInfo22.getDifferentialIdentity().getDIDName(), keyID, CIFCard.createKeyType((String)supportedOperations), null, idOfCard, idOfAppl, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info, fileID, pinID, k);
                    key.setCifNode(didInfo22);
                    cardKeyList.add(key);
                }
                FileReference applRef = new FileReference(4, HexUtil.hexify(cifAppl.getApplicationIdentifier()));
                didInfo22 = cifAppl.getDataSetInfo().iterator();
                while (didInfo22.hasNext()) {
                    DataSetInfoType dsi = (DataSetInfoType)didInfo22.next();
                    FileReference fileRef = null;
                    PathType pathType = dsi.getDataSetPath();
                    byte[] efIDOrPath = pathType.getEfIdOrPath();
                    if (efIDOrPath == null) continue;
                    if (efIDOrPath.length == 2) {
                        fileRef = new FileReference(2, HexUtil.hexify(efIDOrPath));
                    } else if (efIDOrPath.length > 2 && efIDOrPath.length % 2 == 0) {
                        fileRef = efIDOrPath[0] == 63 && efIDOrPath[1] == 0 ? new FileReference(8, HexUtil.hexify(efIDOrPath)) : new FileReference(9, HexUtil.hexify(efIDOrPath));
                    }
                    FileEntry fe = new FileEntry(applRef, fileRef);
                    if (usedFiles.contains(dsi.getDataSetName())) {
                        CardFileImpl file = new CardFileImpl(dsi.getDataSetName(), (long)((Long)fileMap.get(dsi.getDataSetName())), CardFile.CardFileTypeEnum.UNKNOWN.getType(), fe, idOfCard, idOfAppl, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
                        file.setCifNode(dsi);
                        cardFileList.add(file);
                        continue;
                    }
                    OCFCertificateInfo info = new OCFCertificateInfo(idOfCard, -1L, (Long)fileMap.get(dsi.getDataSetName()), -1L, OCFCertificateInfo.ChainEntry.UNKNOWN, OCFCertificateInfo.Usage.UNK, null);
                    CardFileImpl file = new CardFileImpl(Disposeable.NO_LOCK, dsi.getDataSetName(), (Long)fileMap.get(dsi.getDataSetName()), CardFile.CardFileTypeEnum.UNKNOWN.getType(), fe, idOfCard, idOfAppl, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L, info);
                    file.setCifNode(dsi);
                    cardFileList.add(file);
                }
                CardObjectManagerImpl managerApp = new CardObjectManagerImpl(idOfAppl);
                CardApplicationImpl application = new CardApplicationImpl(cifAppl.getApplicationName(), idOfAppl, CIFCard.createApplicationType((String)supportedOperationsAppl), new FileEntry(applRef, applRef), (CardObjectManager)managerApp, idOfCard, firstAppl == null ? 0L : 1000000L, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
                application.setCifNode(cifAppl);
                for (CardKey cardKey : cardKeyList) {
                    application.putKey(cardKey);
                }
                for (CardPin cardPin : cardPinList) {
                    application.putPin(cardPin);
                }
                for (CardFile cardFile : cardFileList) {
                    application.putFile(cardFile);
                }
                if (firstAppl == null) {
                    firstAppl = application;
                } else {
                    firstAppl.putApplication(application);
                }
                ++idOfAppl;
            }
            CardImpl c = new CardImpl(this.getDisplayName(), idOfCard, super.getCard(), firstAppl, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance());
            c.setCif(this.cif);
            return c;
        }
        return null;
    }

    private static OCFCertificateInfo.Usage createUsage(String supportedOperations) {
        if (supportedOperations.contains("Compute-signature")) {
            return OCFCertificateInfo.Usage.SIG;
        }
        if (supportedOperations.contains("Encipher") || supportedOperations.contains("Decipher")) {
            return OCFCertificateInfo.Usage.ENC;
        }
        return OCFCertificateInfo.Usage.UNK;
    }

    private static Type createKeyType(String supportedOperations) {
        ArrayList<Type> typeList = new ArrayList<Type>();
        if (supportedOperations.contains("Compute-signature")) {
            typeList.add(CardKey.CardKeyTypeEnum.SIGNATURE.getType());
        }
        if (supportedOperations.contains("Encipher")) {
            typeList.add(CardKey.CardKeyTypeEnum.ENCRYPTION.getType());
        }
        if (supportedOperations.contains("Decipher")) {
            typeList.add(CardKey.CardKeyTypeEnum.DECRYPTION.getType());
        }
        return TypedType.TypedTypeEnum.BIT.combineTypes(typeList.toArray(new Type[typeList.size()]));
    }

    private static Type createApplicationType(String supportedOperations) {
        ArrayList<Type> typeList = new ArrayList<Type>();
        if (supportedOperations.contains("Compute-signature")) {
            typeList.add(CardApplication.CardApplicationTypeEnum.SIGNATURE.getType());
        }
        if (supportedOperations.contains("Encipher")) {
            typeList.add(CardApplication.CardApplicationTypeEnum.ENCRYPTION.getType());
        }
        if (supportedOperations.contains("Decipher")) {
            typeList.add(CardApplication.CardApplicationTypeEnum.DECRYPTION.getType());
        }
        return TypedType.TypedTypeEnum.BIT.combineTypes(typeList.toArray(new Type[typeList.size()]));
    }

    @Override
    protected OCFCertificateInfo[] createCertificateInfos() {
        return null;
    }

    @Override
    protected final CommandAPDU createMSECommand(CardChannel _channel, OCFCertificateInfo _info, int _type, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        return null;
    }

    @Override
    protected byte[] getHistoricals() {
        return null;
    }

    @Override
    protected String getIssuerConstant() {
        return null;
    }

    @Override
    public synchronized int getRetryCount(OCFCertificateInfo _info) throws NotYetInitializedException, RetryCounterExpiredException, PinDeactivatedException {
        return this.getRetryCount(_info.getPin());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int getRetryCount(CardPin _pin) throws NotYetInitializedException, RetryCounterExpiredException, PinDeactivatedException {
        CardChannelManager cardChannelManager = new CardChannelManager();
        try {
            CardChannel channel = cardChannelManager.init(this);
            int n = this.getRetryCount(channel, _pin);
            return n;
        }
        catch (InvalidCardChannelException e) {
            e.printStackTrace();
        }
        catch (CardTerminalException e) {
            e.printStackTrace();
        }
        catch (ResponseCodeException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        finally {
            cardChannelManager.destroy();
        }
        return -1;
    }

    @Override
    protected int getRetryCount(CardChannel _channel, CardPin pin) throws RetryCounterExpiredException, NotYetInitializedException, InvalidCardChannelException, CardTerminalException, ResponseCodeException, PinDeactivatedException, IllegalArgumentException {
        String stateName;
        AssertUtil.notNull(_channel, "channel");
        AssertUtil.notNull(pin, "pin");
        StateInfoType sit = CIFCard.findInElements(((DIDInfoType)pin.getCifNode()).getDifferentialIdentity().getDIDMarker().getPinCompareMarker().getAny(), StateInfoType.class);
        if (sit == null) {
            throw new IllegalArgumentException("required data not available");
        }
        if (!this.pinStateMap.containsKey(((StateType)sit.getState().get(0)).getStateName())) {
            for (StateType state : sit.getState()) {
                BigInteger rc = state.getRetryCounter();
                if (rc != null) {
                    this.pinStateMap.put(state.getStateName(), rc.intValue());
                    continue;
                }
                this.pinStateMap.put(state.getStateName(), -1);
            }
        }
        if (sit.getStateRecognition() != null && (stateName = CIFCard.detectPinState(_channel, sit.getStateRecognition().getCardCall())) != null) {
            return this.pinStateMap.get(stateName);
        }
        return -1;
    }

    @Override
    protected int getRetryCount(CardChannel _channel, OCFCertificateInfo _info) throws RetryCounterExpiredException, NotYetInitializedException, InvalidCardChannelException, CardTerminalException, ResponseCodeException, PinDeactivatedException {
        return this.getRetryCount(_channel, _info.getPin());
    }

    private static String detectPinState(CardChannel channel, List<CardCallType> callList) throws CardTerminalException, IllegalArgumentException {
        AssertUtil.notNull(channel, "card channel");
        AssertUtil.notNullOrEmpty(callList, "list of card calls");
        for (CardCallType call : callList) {
            byte[] cmdBytes = call.getCommandAPDU();
            CommandAPDU cmd = new CommandAPDU(cmdBytes);
            ResponseAPDU res = channel.sendCommandAPDU(cmd);
            boolean match = false;
            for (ResponseAPDUType expectedRes : call.getResponseAPDU()) {
                if (!CIFCard.matchResponse(res, expectedRes)) continue;
                if (expectedRes.getConclusion() != null) {
                    return CIFCard.followConclusion(channel, expectedRes.getConclusion());
                }
                match = true;
                break;
            }
            if (match) continue;
            return null;
        }
        return null;
    }

    private static String followConclusion(CardChannel channel, ConclusionType conclusion) throws CardTerminalException, IllegalArgumentException {
        AssertUtil.notNull(channel, "card channel");
        AssertUtil.notNull(conclusion, "conclusion");
        if (conclusion.getRecognizedState() != null) {
            return ((StateType)conclusion.getRecognizedState()).getStateName();
        }
        if (conclusion.getCardCall() != null) {
            return CIFCard.detectPinState(channel, conclusion.getCardCall());
        }
        return "";
    }

    @Override
    public List<String> getAvailableHashAlgorithmNames(OCFCertificateInfo _info) {
        ArrayList<String> list = new ArrayList<String>();
        if (_info == null) {
            return list;
        }
        X509Certificate x509certificate = _info.getX509Certificate();
        if (x509certificate == null) {
            return list;
        }
        boolean[] keyUsage = x509certificate.getKeyUsage();
        if (!keyUsage[0] && !keyUsage[1]) {
            return list;
        }
        CardKey ck = _info.getKey();
        if (ck != null && ck.getCifNode() != null && ((DIDInfoType)ck.getCifNode()).getDifferentialIdentity() != null && ((DIDInfoType)ck.getCifNode()).getDifferentialIdentity().getDIDMarker() != null && ((DIDInfoType)ck.getCifNode()).getDifferentialIdentity().getDIDMarker().getCryptoMarker() != null) {
            CryptoMarkerType cm = ((DIDInfoType)ck.getCifNode()).getDifferentialIdentity().getDIDMarker().getCryptoMarker();
            AlgorithmInfoType ait = CIFCard.findInElements(cm.getAny(), AlgorithmInfoType.class);
            String cardAlgRef = HexUtil.hexify(ait.getCardAlgRef());
            String hashAlgRef = HexUtil.hexify(ait.getHashAlgRef());
            if (cardAlgRef.length() == 2 && hashAlgRef.length() == 2) {
                if (hashAlgRef.startsWith("1")) {
                    list.add("SHA1");
                } else if (hashAlgRef.startsWith("2")) {
                    list.add("RIPEMD160");
                } else if (hashAlgRef.startsWith("3")) {
                    list.add("SHA224");
                } else if (hashAlgRef.startsWith("4")) {
                    list.add("SHA256");
                } else if (hashAlgRef.startsWith("5")) {
                    list.add("SHA384");
                } else if (hashAlgRef.startsWith("6")) {
                    list.add("SHA512");
                }
            }
        }
        return list;
    }

    public void initialize(CardServiceScheduler scheduler, SmartCard smartcard, boolean blocking, boolean signed, CardInfoType cif) throws CardServiceException {
        super.initialize(scheduler, smartcard, blocking);
        this.isTrustworthySigned = signed;
        this.cif = cif;
    }

    @Override
    public String getDisplayName() {
        if (this.cif != null) {
            try {
                return "CIFCard: " + ((InternationalStringType)this.cif.getCardType().getCardTypeName().get(0)).getValue();
            }
            catch (NullPointerException e) {
                return "CIFCard: no name in CIF";
            }
        }
        return "CIFCard: not yet initialized";
    }

    @Override
    protected String getOSName() {
        return "(unknown OS)";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<T> executeTemplate(List<CommandAPDU> template, Class<T> resultClass) throws IllegalArgumentException, CardTerminalException, CardServiceException, Exception {
        if (!ResponseAPDU.class.equals(resultClass)) {
            throw new IllegalArgumentException("not supported result class");
        }
        CardChannelManager cm = new CardChannelManager();
        ArrayList<T> resultList = new ArrayList<T>();
        ResponseAPDU result = null;
        try {
            CardChannel channel = cm.init(this);
            for (CommandAPDU cmd : template) {
                log.debug((Object)("CMD: " + cmd));
                result = channel.sendCommandAPDU(cmd);
                log.debug((Object)("RESP: " + result));
                resultList.add(resultClass.cast(result));
                if (result.sw() == 36864) continue;
                break;
            }
        }
        finally {
            cm.destroy();
        }
        return resultList;
    }

    @Override
    protected void selectFile(CardChannel _channel, OCFCertificateInfo _info, boolean _selectFile) throws ResponseCodeException, InvalidCardChannelException, CardTerminalException {
        if (_info != null) {
            CardFile cf = _info.getCerFile();
            List<CommandAPDU> selectApplicationTemplate = this.createApplicationTemplate(ApplicationPurpose.SELECT, Phase.EXECUTE_OPERATION, (CardApplicationType)cf.getParentApplication().getCifNode(), (Object)null);
            try {
                this.executeTemplate(selectApplicationTemplate, ResponseAPDU.class);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (_selectFile) {
                List<CommandAPDU> selectFileTemplate = this.createFileTemplate(FilePurpose.SELECT, Phase.EXECUTE_OPERATION, (DataSetInfoType)cf.getCifNode(), (Object)null);
                try {
                    this.executeTemplate(selectFileTemplate, ResponseAPDU.class);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        this.setChannelState(_channel, _info);
    }

    public static Node getNode(AnyType anyType, String name, Integer minIndex, Integer maxIndex) {
        if (anyType == null) {
            return null;
        }
        return CIFCard.getNode(anyType.getAny(), name, minIndex, maxIndex);
    }

    public static Node getNode(AnyType anyType, int index) throws IllegalArgumentException {
        if (anyType == null) {
            return null;
        }
        return CIFCard.getNode(anyType.getAny(), index);
    }

    public static Node getNode(List<Object> objectList, String name, Integer minIndex, Integer maxIndex) {
        if (name == null || name.length() == 0) {
            return null;
        }
        if (objectList == null || objectList.size() == 0) {
            return null;
        }
        if (minIndex == null) {
            minIndex = 0;
        }
        if (maxIndex == null) {
            maxIndex = objectList.size();
        }
        if (minIndex > maxIndex) {
            return null;
        }
        Object obj = null;
        Node node = null;
        for (int i = minIndex.intValue(); i < maxIndex; ++i) {
            obj = objectList.get(i);
            if (obj == null || !Node.class.isInstance(obj) || !(node = (Node)Node.class.cast(obj)).getNodeName().equals(name)) continue;
            return node;
        }
        return null;
    }

    public static Node getNode(List<Object> objectList, int index) throws IllegalArgumentException {
        if (index < 0) {
            throw new IllegalArgumentException("invalid index: " + index);
        }
        if (objectList == null || objectList.size() == 0) {
            return null;
        }
        if (index >= objectList.size()) {
            return null;
        }
        Object obj = objectList.get(index);
        if (obj != null && Node.class.isInstance(obj)) {
            return (Node)Node.class.cast(obj);
        }
        return null;
    }

    public static Node getNode(NodeList nodeList, String name, Integer minIndex, Integer maxIndex) {
        if (name == null || name.length() == 0) {
            return null;
        }
        if (nodeList == null || nodeList.getLength() == 0) {
            return null;
        }
        if (minIndex == null) {
            minIndex = 0;
        }
        if (maxIndex == null) {
            maxIndex = nodeList.getLength();
        }
        if (minIndex > maxIndex) {
            return null;
        }
        Node node = null;
        for (int i = minIndex.intValue(); i < maxIndex; ++i) {
            node = nodeList.item(i);
            if (!nodeList.item(i).getNodeName().equals(name)) continue;
            return node;
        }
        return null;
    }

    public static Node getNode(NodeList nodeList, int index) throws IllegalArgumentException {
        if (index < 0) {
            throw new IllegalArgumentException("invalid index: " + index);
        }
        if (nodeList == null || nodeList.getLength() == 0) {
            return null;
        }
        if (index >= nodeList.getLength()) {
            return null;
        }
        return nodeList.item(index);
    }

    public static Element getElement(List<Element> elementList, String name, Integer minIndex, Integer maxIndex) {
        if (elementList == null || elementList.size() == 0) {
            return null;
        }
        if (name == null || name.length() == 0) {
            return null;
        }
        if (minIndex == null) {
            minIndex = 0;
        }
        if (maxIndex == null) {
            maxIndex = elementList.size();
        }
        if (minIndex > maxIndex) {
            return null;
        }
        Element element = null;
        for (int i = minIndex.intValue(); i < maxIndex; ++i) {
            element = elementList.get(i);
            if (!element.getNodeName().equals(name)) continue;
            return element;
        }
        return null;
    }

    public static Element getElement(List<Element> elementList, int index) throws IllegalArgumentException {
        if (index < 0) {
            throw new IllegalArgumentException("invalid index: " + index);
        }
        if (elementList == null || elementList.size() == 0) {
            return null;
        }
        if (index >= elementList.size()) {
            return null;
        }
        return elementList.get(index);
    }

    public static Node getNode(List<Element> elementList, String[] path) {
        if (elementList == null || elementList.size() == 0) {
            return null;
        }
        if (path == null || path.length == 0) {
            return null;
        }
        Node node = CIFCard.getElement(elementList, path[0], null, null);
        for (int i = 1; node != null && i < path.length; ++i) {
            node = CIFCard.getNode(node.getChildNodes(), path[i], null, null);
        }
        return node;
    }

    @Override
    protected GovCS.ResultObject readSelectedFile(CardChannel _channel, int _offset, int _length) throws ResponseCodeException, InvalidCardChannelException, CardTerminalException {
        List<CommandAPDU> readLength = this.createFileTemplate(FilePurpose.READ, Phase.PREPARE_OPERATION, null, null);
        List<ResponseAPDU> readLengthResponse = null;
        try {
            readLengthResponse = this.executeTemplate(readLength, ResponseAPDU.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        byte[] responseData = readLengthResponse.get(0).data();
        if (responseData == null || responseData.length < 5) {
            throw new IllegalArgumentException(RESOURCES.getString("insufficient_data") + HexUtil.hexify(responseData));
        }
        int fileSize = 0;
        if (responseData[0] != -1 && (responseData[1] & 0xFFFFFF80) == -128) {
            int length = responseData[1] & 0x7F;
            length = Math.min(length, 2);
            log.debug((Object)("fst 10 bytes: " + HexUtil.hexify(responseData)));
            for (int j = 0; j < length; ++j) {
                fileSize <<= 8;
                fileSize += responseData[2 + j] & 0xFF;
            }
            fileSize += 2 + length;
        }
        if (fileSize == 0) {
            return null;
        }
        log.debug((Object)("cert size: " + fileSize));
        boolean readFully = _length == 2048;
        int bytesToRead = readFully ? fileSize : _length;
        Integer[] parameters = new Integer[]{_offset, bytesToRead};
        List<CommandAPDU> read = this.createFileTemplate(FilePurpose.READ, Phase.EXECUTE_OPERATION, null, (Object)parameters);
        List<ResponseAPDU> readResponseList = null;
        try {
            readResponseList = this.executeTemplate(read, ResponseAPDU.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        byte[] fileBytes = new byte[]{};
        for (ResponseAPDU r : readResponseList) {
            fileBytes = ByteUtil.combine(fileBytes, r.data());
        }
        GovCS.ResultObject ro = new GovCS.ResultObject();
        ro.setResultCode(readResponseList.get(readResponseList.size() - 1).sw());
        ro.setResultData(fileBytes);
        String hashString = "- no hash generated -";
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1", "BC");
            hashString = HexUtil.hexify(md.digest(fileBytes));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        log.debug((Object)("cert size: " + fileSize));
        log.debug((Object)("read bytes length: " + fileBytes.length));
        log.debug((Object)("sha1 of read bytes: " + hashString));
        return ro;
    }

    @Override
    protected final GovCS.ResultObject signHash(CardChannel _channel, OCFCertificateInfo _info, byte[] _hashValue, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, CardTerminalException, ResponseCodeException, OperationCancelledException {
        log.debug((Object)("usesASN1HeaderWithSignHash=" + this.usesASN1HeaderWithSignHash()));
        if (_hashValue != null && this.usesASN1HeaderWithSignHash()) {
            try {
                _hashValue = new DigestInfo(HashAlgorithm.Algorithm.getAlgorithmByName(_hashAlgorithm), _hashValue).getEncoded();
                log.debug((Object)("pkcs#1=" + HexString.hexify(_hashValue)));
            }
            catch (Exception ex) {
                log.error((Object)"", (Throwable)ex);
            }
        }
        List<CommandAPDU> signCommands = this.createKeyTemplate(KeyPurpose.SIGNATURE, Phase.EXECUTE_OPERATION, (DIDInfoType)_info.getKey().getCifNode(), (Object)_hashValue);
        List<ResponseAPDU> responseList = null;
        try {
            responseList = this.executeTemplate(signCommands, ResponseAPDU.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ResponseAPDU finalResponse = responseList.get(responseList.size() - 1);
        GovCS.ResultObject ro = new GovCS.ResultObject();
        ro.setResultCode(finalResponse.sw());
        ro.setResultData(finalResponse.data());
        return ro;
    }

    @Override
    public int getPasswordBlockLength(OCFCertificateInfo _info) {
        PasswordAttributesType pa = CIFCard.findInElements(((DIDInfoType)_info.getPin().getCifNode()).getDifferentialIdentity().getDIDMarker().getPinCompareMarker().getAny(), PasswordAttributesType.class);
        if (pa != null) {
            return pa.getStoredLength().intValue();
        }
        return super.getPasswordBlockLength(_info);
    }

    @Override
    public int getMaxPINLength(OCFCertificateInfo _info) {
        PasswordAttributesType pa = CIFCard.findInElements(((DIDInfoType)_info.getPin().getCifNode()).getDifferentialIdentity().getDIDMarker().getPinCompareMarker().getAny(), PasswordAttributesType.class);
        if (pa != null && pa.getMaxLength() != null) {
            return pa.getMaxLength().intValue();
        }
        return super.getMaxPINLength(_info);
    }

    @Override
    public int getMinPINLength(OCFCertificateInfo _info) {
        PasswordAttributesType pa = CIFCard.findInElements(((DIDInfoType)_info.getPin().getCifNode()).getDifferentialIdentity().getDIDMarker().getPinCompareMarker().getAny(), PasswordAttributesType.class);
        if (pa != null) {
            return pa.getMinLength().intValue();
        }
        return super.getMinPINLength(_info);
    }

    @Override
    public byte getPasswordBlockFiller(OCFCertificateInfo _info) {
        PasswordAttributesType pa = CIFCard.findInElements(((DIDInfoType)_info.getPin().getCifNode()).getDifferentialIdentity().getDIDMarker().getPinCompareMarker().getAny(), PasswordAttributesType.class);
        if (pa != null && pa.getPadChar() != null) {
            return pa.getPadChar()[0];
        }
        return super.getPasswordBlockFiller(_info);
    }

    @Override
    public PinEncoder getPinEncoder(OCFCertificateInfo _info) {
        PasswordTypeType pwdType;
        PinEncoder encoder;
        PasswordAttributesType pa = CIFCard.findInElements(((DIDInfoType)_info.getPin().getCifNode()).getDifferentialIdentity().getDIDMarker().getPinCompareMarker().getAny(), PasswordAttributesType.class);
        if (pa != null && (encoder = CIFCard.getEncoderFromPasswordType(pwdType = pa.getPwdType())) != null) {
            return encoder;
        }
        return super.getPinEncoder(_info);
    }

    @Override
    protected boolean usesASN1HeaderWithSignHash() {
        return false;
    }

    @Override
    protected CommandAPDU createVerifyPasswordCommand(OCFCertificateInfo _info, char[] _pin) {
        List<CommandAPDU> verifyCommand = this.createPinTemplate(PinPurpose.VERIFY, Phase.EXECUTE_OPERATION, (DIDInfoType)_info.getPin().getCifNode(), (Object)_pin);
        if (verifyCommand != null && verifyCommand.size() == 1) {
            return verifyCommand.get(0);
        }
        return super.createVerifyPasswordCommand(_info, _pin);
    }

    public static boolean unsafeCommand(byte[] commandBytes) throws IllegalArgumentException {
        AssertUtil.notNull(commandBytes, "command bytes");
        if (commandBytes.length < 4) {
            throw new IllegalArgumentException("command bytes too short");
        }
        return (commandBytes[1] == 32 || commandBytes[1] == 33 || commandBytes[1] == 34 || commandBytes[1] == 36 || commandBytes[1] == 44) && (commandBytes[0] & 0xE0) == 0;
    }

    public static boolean matchResponse(ResponseAPDU actual, ResponseAPDUType target) throws IllegalArgumentException {
        AssertUtil.notNull(actual, "response APDU");
        AssertUtil.notNull(target, "expected response");
        byte[] cifResponseCode = target.getTrailer();
        if (cifResponseCode.length != 2) {
            throw new IllegalArgumentException("required data not present");
        }
        if (cifResponseCode[0] != actual.sw1() || cifResponseCode[1] != actual.sw2()) {
            return false;
        }
        DataMaskType cifBody = target.getBody();
        if (cifBody == null) {
            return true;
        }
        if (actual.data() == null) {
            return false;
        }
        try {
            return CIFCard.checkDataMaskType(actual.data(), cifBody);
        }
        catch (IOException e) {
            return false;
        }
    }

    private static boolean checkDataMaskType(byte[] cardBytes, DataMaskType cifDataMask) throws IOException {
        byte[] tag = cifDataMask.getTag();
        if (tag != null) {
            ASN1 data = new ASN1(48, cardBytes);
            ASN1[] children = data.getChildElementsByDTagBytes(tag);
            if (children == null || children.length == 0) {
                return false;
            }
            cardBytes = children[0].getValue();
        }
        if (cifDataMask.getMatchingData() != null) {
            return CIFCard.checkMatchingDataType(cardBytes, cifDataMask.getMatchingData());
        }
        return CIFCard.checkDataMaskType(cardBytes, cifDataMask.getDataObject());
    }

    private static boolean checkMatchingDataType(byte[] cardBytes, MatchingDataType cifMatchingData) {
        MatchingRuleType mrt;
        if (cifMatchingData.getOffset() != null) {
            cardBytes = ByteUtil.subbytes(cardBytes, new BigInteger(cifMatchingData.getOffset()).intValue());
        }
        if (cifMatchingData.getLength() != null) {
            cardBytes = ByteUtil.subbytes(cardBytes, 0, new BigInteger(cifMatchingData.getLength()).intValue());
        }
        if (cifMatchingData.getMask() != null) {
            ByteUtil.and(cardBytes, cifMatchingData.getMask());
        }
        if ((mrt = cifMatchingData.getMatchingRule()) == null) {
            mrt = MatchingRuleType.EQUALS;
        }
        byte[] targetValue = cifMatchingData.getMatchingValue();
        if (mrt == MatchingRuleType.EQUALS && ByteUtil.equals(cardBytes, targetValue)) {
            return true;
        }
        return mrt == MatchingRuleType.CONTAINS && ArrayUtil.contains(cardBytes, targetValue);
    }

    public static <T> T findInElements(List<Element> elements, Class<T> clazz) throws IllegalArgumentException {
        AssertUtil.notNullOrEmpty(elements, "element list");
        AssertUtil.notNull(clazz, "class");
        T ret = null;
        for (int i = 0; i < elements.size(); ++i) {
            Object found = ((JAXBWrapperElement)elements.get(i)).getInnerParsedType();
            if (found.getClass() != clazz) continue;
            ret = clazz.cast(found);
            break;
        }
        return ret;
    }

    public static PinEncoder getEncoderFromPasswordType(PasswordTypeType pwdType) {
        if (pwdType == PasswordTypeType.ISO_9564_1) {
            return PinEncoder.ENCODER_FORMAT_2_PIN_BLOCK;
        }
        if (pwdType == PasswordTypeType.ASCII_NUMERIC) {
            return PinEncoder.ENCODER_T50;
        }
        if (pwdType == PasswordTypeType.BCD) {
            return PinEncoder.ENCODER_BCD;
        }
        return null;
    }
}

