/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.channel.util;

import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.ByteUtil;
import de.bos_bremen.common.constants.Constants;
import de.bos_bremen.gov2.jca_provider.ocf.channel.util.SSCIvParameterSpec;
import java.math.BigInteger;
import javax.crypto.spec.IvParameterSpec;

public class SSCIvParameterSpecImpl
extends IvParameterSpec
implements SSCIvParameterSpec {
    public static final BigInteger DEFAULT_INCREMENT = BigInteger.valueOf(1L);
    public static final boolean DEFAULT_INITIAL_INCREASE = true;
    public static final BigInteger DEFAULT_BATCH_INCREMENT = BigInteger.valueOf(2L);
    private BigInteger increment = DEFAULT_INCREMENT;
    private int ivLength = -1;
    private BigInteger ssc = null;
    private BigInteger base = null;
    private BigInteger overflow = null;
    private BigInteger marker = null;
    private boolean firstUse = true;
    private byte[] iv = null;

    public SSCIvParameterSpecImpl(byte[] ssc) throws IllegalArgumentException {
        this(ssc, true, null);
    }

    public SSCIvParameterSpecImpl(byte[] ssc, boolean initialIncrease) throws IllegalArgumentException {
        this(ssc, initialIncrease, null);
    }

    public SSCIvParameterSpecImpl(byte[] ssc, boolean initialIncrease, BigInteger increment) throws IllegalArgumentException {
        super(Constants.EMPTY_PRIMITIVE_BYTE_ARRAY);
        AssertUtil.notNullOrEmpty(ssc, "SSC");
        this.ssc = new BigInteger(1, ssc);
        this.base = BigInteger.valueOf(2L).pow(8 * ssc.length).multiply(BigInteger.valueOf(2L)).negate();
        this.overflow = BigInteger.valueOf(2L).pow(8 * ssc.length);
        if (increment != null && increment.compareTo(BigInteger.valueOf(1L)) == -1) {
            throw new IllegalArgumentException("increment expected greater equals than 1");
        }
        BigInteger bigInteger = this.increment = increment != null ? increment : DEFAULT_INCREMENT;
        if (initialIncrease) {
            this.increaseSSC();
        } else {
            this.createIV();
        }
        this.ivLength = ssc.length;
    }

    @Override
    public synchronized byte[] getIV() {
        return this.iv;
    }

    @Override
    public synchronized void increaseSSC() {
        if (this.firstUse) {
            this.ssc = this.ssc.add(DEFAULT_INCREMENT);
            this.firstUse = false;
        } else {
            this.ssc = this.ssc.add(this.increment);
        }
        int comparison = this.overflow.compareTo(this.ssc);
        if (comparison < 1) {
            this.ssc = this.ssc.subtract(this.overflow);
        }
        this.createIV();
    }

    private void createIV() {
        this.iv = this.base.add(this.ssc).toByteArray();
        this.iv = ByteUtil.subbytes(this.iv, 1);
    }

    @Override
    public final int getLength() {
        return this.ivLength;
    }

    @Override
    public void mark() {
        this.marker = this.ssc;
        this.firstUse = true;
    }

    @Override
    public void reset() {
        this.ssc = this.marker;
        this.createIV();
    }
}

