/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.channel.util;

import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.ByteUtil;
import java.util.Arrays;

public final class SMUtil {
    private SMUtil() {
    }

    public static final byte[] pad(byte[] bytes, byte leadingPadByte, byte padByte, int blocksize) throws IllegalArgumentException {
        AssertUtil.notNullOrEmpty(bytes, "bytes");
        int l = bytes.length % blocksize;
        l = l == 0 ? blocksize : blocksize - l;
        byte[] padding = new byte[l];
        Arrays.fill(padding, padByte);
        padding[0] = leadingPadByte;
        return ByteUtil.combine(bytes, padding);
    }

    public static final byte[] padISO(byte[] bytes, int blocksize) throws IllegalArgumentException {
        return SMUtil.pad(bytes, (byte)-128, (byte)0, blocksize);
    }

    public static final byte[] unpad(byte[] paddedBytes, byte leadingPadByte, byte padByte, int blocksize) throws IllegalArgumentException {
        AssertUtil.notNullOrEmpty(paddedBytes, "padded bytes");
        int l = paddedBytes.length % blocksize;
        if (l != 0) {
            throw new IllegalArgumentException("bytes can not be unpadded, bytes does not match block size");
        }
        l = ByteUtil.lastIndexOf(paddedBytes, new byte[]{leadingPadByte});
        if (l <= 0) {
            throw new IllegalArgumentException("bytes can not be unpadded, padding not found");
        }
        if (paddedBytes.length - l > blocksize) {
            throw new IllegalArgumentException("bytes can not be unpadded, too much padding bytes");
        }
        byte[] paddingEnd = new byte[paddedBytes.length - l - 1];
        Arrays.fill(paddingEnd, padByte);
        if (!Arrays.equals(paddingEnd, ByteUtil.subbytes(paddedBytes, l + 1))) {
            throw new IllegalArgumentException("bytes can not be unpadded, bytes not padded correctly");
        }
        return ByteUtil.subbytes(paddedBytes, 0, l);
    }

    public static final byte[] unpadISO(byte[] paddedBytes, int blocksize) throws IllegalArgumentException {
        return SMUtil.unpad(paddedBytes, (byte)-128, (byte)0, blocksize);
    }

    public static final byte[] padToBlocksize(byte[] bytes, byte padByte, int blocksize) {
        AssertUtil.notNullOrEmpty(bytes, "bytes");
        int l = bytes.length % blocksize;
        if (l == 0) {
            return bytes;
        }
        l = blocksize - l;
        byte[] padding = new byte[l];
        Arrays.fill(padding, padByte);
        return ByteUtil.combine(bytes, padding);
    }
}

