/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.channel.util;

import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.ByteUtil;
import de.bos_bremen.common.ObjectUtil;
import de.bos_bremen.common.StringUtil;
import de.bos_bremen.gov2.jca_provider.ocf.channel.util.MacPadding;
import de.bos_bremen.gov2.jca_provider.ocf.channel.util.SSCIvParameterSpec;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.AESFastEngine;
import org.bouncycastle.crypto.macs.CMac;
import org.bouncycastle.crypto.params.KeyParameter;

public final class CipherUtil {
    public static final String ALGORITHM_3DES = "DESede";
    public static final String ALGORITHM_DES = "DES";
    public static final String ALGORITHM_AES = "AES";
    public static final int DES_KEY_LENGTH = 8;
    public static final int DES_IV_LENGTH = 8;
    public static final int TRIPLE_DES_IV_LENGTH = 8;
    public static final int AES_IV_LENGTH = 16;
    public static final int AES_CMAC_MINIMUM_LENGTH = 1;
    public static final int AES_CMAC_MAXIMUM_LENGTH = 16;
    public static final int TRIPLE_DES_KEY_LENGTH_SHORT = 16;
    public static final int TRIPLE_DES_KEY_LENGTH_DEFAULT = 24;
    public static final int BEGININDEX_DES_KEY_A = 0;
    public static final int ENDINDEX_DES_KEY_A = 8;
    public static final int BEGININDEX_DES_KEY_B = 8;
    public static final int ENDINDEX_DES_KEY_B = 16;
    public static final int BEGININDEX_DES_KEY_C = 16;
    public static final int ENDINDEX_DES_KEY_C = 24;
    public static final int IDX_DES_KEY_A = 0;
    public static final int IDX_DES_KEY_B = 1;
    public static final int IDX_DES_KEY_C = 2;
    private static final List<Integer> KEY_SIZES_LIST_DES = Collections.unmodifiableList(Arrays.asList(8));
    private static final List<Integer> KEY_SIZES_LIST_3DES = Collections.unmodifiableList(Arrays.asList(24));
    private static final List<Integer> KEY_SIZES_LIST_AES = Collections.unmodifiableList(Arrays.asList(16, 24, 32));
    public static final String TRANSFORMATION_SEPARATOR = "/";
    public static final String SIGNATURE_TRANSFORMATION_SEPARATOR = "with";
    public static final int IDX_TRANSFORMATION_ALGORITHM_NAME = 0;
    public static final int IDX_SIGNATURE_TRANSFORMATION_HASH_ALGORITHM_NAME = 0;
    public static final int IDX_SIGNATURE_TRANSFORMATION_CRYPTO_ALGORITHM_NAME = 1;
    public static final int IDX_TRANSFORMATION_BLOCKMODE = 1;
    public static final int IDX_TRANSFORMATION_PADDING = 2;
    public static final String BLOCK_MODE_CBC = "CBC";
    public static final String BLOCK_MODE_ECB = "ECB";
    public static final String PADDING_NO_PADDING = "NoPadding";
    public static final IvParameterSpec DEFAULT_DES_IV;
    public static final IvParameterSpec DEFAULT_AES_IV;
    public static final String RETAIL_MAC_ALGORITHM = "DES/CBC/NoPadding";

    private CipherUtil() {
    }

    public static SecretKey[] getDESKeys(byte[] tripleDESKeyBytes) throws IllegalArgumentException {
        SecretKey des3key = CipherUtil.get3DESKey(tripleDESKeyBytes);
        return CipherUtil.getDESKeys(des3key);
    }

    public static SecretKey[] getDESKeys(SecretKey tripleDESKey) throws IllegalArgumentException {
        AssertUtil.notNull(tripleDESKey, "key");
        if (!ALGORITHM_3DES.equals(tripleDESKey.getAlgorithm())) {
            throw new IllegalArgumentException("only DES3 key permitted");
        }
        SecretKey[] result = new SecretKey[3];
        byte[] bytes = tripleDESKey.getEncoded();
        result[0] = CipherUtil.getSecretKey(ALGORITHM_DES, ByteUtil.subbytes(bytes, 0, 8));
        result[1] = CipherUtil.getSecretKey(ALGORITHM_DES, ByteUtil.subbytes(bytes, 8, 16));
        result[2] = CipherUtil.getSecretKey(ALGORITHM_DES, ByteUtil.subbytes(bytes, 16, 24));
        return result;
    }

    public static SecretKey get3DESKey(byte[] bytes) throws IllegalArgumentException {
        AssertUtil.notNullOrEmpty(bytes, "bytes of key");
        if (bytes.length == 16) {
            bytes = ByteUtil.combine(bytes, ByteUtil.subbytes(bytes, 0, 8));
        }
        if (bytes.length < 24) {
            throw new IllegalArgumentException("not enough bytes for key available");
        }
        if (bytes.length > 24) {
            throw new IllegalArgumentException("too much bytes for key available");
        }
        return CipherUtil.getSecretKey(ALGORITHM_3DES, bytes);
    }

    public static SecretKey getSecretKey(String algorithm, byte[] bytes) throws IllegalArgumentException {
        AssertUtil.notNullOrEmpty(algorithm, "key algorithm");
        AssertUtil.notNullOrEmpty(bytes, "bytes of key");
        SecretKeySpec sks = new SecretKeySpec(bytes, algorithm);
        try {
            if (ALGORITHM_AES.equals(algorithm)) {
                return sks;
            }
            SecretKeyFactory skf = SecretKeyFactory.getInstance(algorithm);
            SecretKey result = skf.translateKey(sks);
            if (result.getEncoded().length != bytes.length) {
                throw new IllegalArgumentException("too much bytes provided");
            }
            return result;
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("illegal secret key: " + e.getMessage(), e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("algorithm not supported: " + algorithm, e);
        }
    }

    public static Cipher getCipher(String algorithm, SecretKey key, int mode, byte[] iv, String provider) throws IllegalArgumentException {
        AssertUtil.notNullOrEmpty(iv, "array with bytes of initialization vector");
        return CipherUtil.getCipher(algorithm, key, mode, new IvParameterSpec(iv), provider);
    }

    public static Cipher getCipher(String algorithm, SecretKey key, int mode, IvParameterSpec iv, String provider) throws IllegalArgumentException {
        String keyAlgorithm;
        AssertUtil.notNullOrEmpty(algorithm, "algorithm");
        AssertUtil.notNull(key, "key");
        String[] transformationParts = CipherUtil.getTransformationParts(algorithm);
        boolean ivRequired = true;
        if (transformationParts.length >= 1 && BLOCK_MODE_ECB.equals(transformationParts[1])) {
            ivRequired = false;
        }
        if (ivRequired) {
            AssertUtil.notNull(iv, "Initialization Vector");
            AssertUtil.notNullOrEmpty(iv.getIV(), "Initialiation Vector Bytes");
        }
        if (ALGORITHM_DES.equals(keyAlgorithm = transformationParts[0])) {
            if (ivRequired && iv.getIV().length != 8) {
                throw new IllegalArgumentException("key and initialization vector length does not match");
            }
        } else if (ALGORITHM_AES.equals(keyAlgorithm)) {
            if (ivRequired && 16 != iv.getIV().length) {
                throw new IllegalArgumentException("initialization vector length does not match AES expected length: 16");
            }
        } else if (ALGORITHM_3DES.equals(keyAlgorithm) && ivRequired && iv.getIV().length != 8) {
            throw new IllegalArgumentException("initialization vector length does not match 3DES expected length: 8");
        }
        if (mode != 1 && mode != 2 && mode != 3 && mode != 4) {
            throw new IllegalArgumentException("illegal mode: " + mode + ", Cipher.ENCRYPT_MODE, Cipher.DECRYPT_MODE, Cipher.WRAP_MODE or Cipher.UNWRAP_MODE only permitted");
        }
        if (!algorithm.startsWith(key.getAlgorithm())) {
            throw new IllegalArgumentException("algorithm and algorithm of key does not match: " + algorithm + ", " + key.getAlgorithm());
        }
        Cipher c = null;
        try {
            c = provider == null ? Cipher.getInstance(algorithm, "BC") : Cipher.getInstance(algorithm, provider);
        }
        catch (NoSuchProviderException e) {
            throw new IllegalArgumentException("no provider available: " + provider, e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("no algorithm available: " + algorithm, e);
        }
        catch (NoSuchPaddingException e) {
            throw new IllegalArgumentException("illegal padding: " + algorithm, e);
        }
        try {
            c.init(mode, (Key)key, iv);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("invalid key: " + key + ", message: " + e.getMessage(), e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new IllegalArgumentException("invalid algorithm parameters: " + iv + ", message: " + e.getMessage(), e);
        }
        return c;
    }

    public static byte[] encipherDES(String algorithm, SecretKey key, IvParameterSpec iv, byte[] data, String provider) throws IllegalArgumentException, IllegalBlockSizeException, BadPaddingException {
        return CipherUtil.cipherDES(algorithm, key, 1, iv, data, provider);
    }

    public static byte[] decipherDES(String algorithm, SecretKey key, IvParameterSpec iv, byte[] data, String provider) throws IllegalArgumentException, IllegalBlockSizeException, BadPaddingException {
        return CipherUtil.cipherDES(algorithm, key, 2, iv, data, provider);
    }

    public static byte[] cipherDES(String algorithm, SecretKey key, int mode, IvParameterSpec iv, byte[] data, String provider) throws IllegalArgumentException, IllegalBlockSizeException, BadPaddingException {
        CipherUtil.checkCipherKey(key, ALGORITHM_DES, KEY_SIZES_LIST_DES);
        CipherUtil.checkCipherMode(mode);
        CipherUtil.checkCipherData(data, ALGORITHM_DES, 8);
        Cipher cipher = CipherUtil.getCipher(algorithm, key, mode, iv, provider);
        return cipher.doFinal(data);
    }

    private static void checkCipherKey(SecretKey key, String algorithm, List<Integer> keySizeList) throws IllegalArgumentException {
        AssertUtil.notNull(key, "key");
        if (!algorithm.equals(key.getAlgorithm())) {
            throw new IllegalArgumentException("illegal algorithm, key for " + algorithm + " permitted only");
        }
        if (keySizeList != null && !keySizeList.contains(key.getEncoded().length)) {
            throw new IllegalArgumentException("illegal size of, key of size " + keySizeList + " permitted only");
        }
    }

    private static void checkCipherMode(int mode) {
        if (mode != 1 && mode != 2) {
            throw new IllegalArgumentException("illegal mode: " + mode + ", Cipher.ENCRYPT_MODE or Cipher.DECRYPT_MODE only permitted");
        }
    }

    private static void checkCipherData(byte[] data, String algorithm, int keyLength) throws IllegalArgumentException {
        AssertUtil.notNullOrEmpty(data, "data");
        if (data.length % keyLength != 0) {
            throw new IllegalArgumentException("only padded data to multiple of " + algorithm + " key size " + keyLength + " permitted, length of data: " + data.length);
        }
    }

    public static String[] getTransformationParts(String transformation) throws IllegalArgumentException {
        AssertUtil.notNullOrEmpty(transformation, "transformation");
        String[] tmp = transformation.split(TRANSFORMATION_SEPARATOR);
        String[] result = new String[3];
        if (tmp.length > 3) {
            throw new IllegalArgumentException("transformation contains more parts as expected, maximum of parts is3");
        }
        System.arraycopy(tmp, 0, result, 0, tmp.length);
        for (int i = 0; i < result.length; ++i) {
            if (!StringUtil.isNullOrEmpty(result[i])) continue;
            result[i] = null;
        }
        return result;
    }

    public static String[] getSignatureTransformationParts(String signatureTransformation) throws IllegalArgumentException {
        AssertUtil.notNullOrEmpty(signatureTransformation, "signatureTransformation");
        String[] tmp = signatureTransformation.split(SIGNATURE_TRANSFORMATION_SEPARATOR);
        String[] result = new String[2];
        if (tmp.length != result.length) {
            throw new IllegalArgumentException("signature transformation does not consist out of 2");
        }
        System.arraycopy(tmp, 0, result, 0, tmp.length);
        return result;
    }

    public static byte[] encipher3DES(String algorithm, SecretKey key, IvParameterSpec iv, byte[] data, String provider) throws IllegalArgumentException, IllegalBlockSizeException, BadPaddingException {
        return CipherUtil.cipher3DES(algorithm, key, 1, iv, data, provider);
    }

    public static byte[] decipher3DES(String algorithm, SecretKey key, IvParameterSpec iv, byte[] data, String provider) throws IllegalArgumentException, IllegalBlockSizeException, BadPaddingException {
        return CipherUtil.cipher3DES(algorithm, key, 2, iv, data, provider);
    }

    public static byte[] encipherAES(String algorithm, SecretKey key, IvParameterSpec iv, byte[] data, String provider) throws IllegalArgumentException, IllegalBlockSizeException, BadPaddingException {
        return CipherUtil.cipherAES(algorithm, key, 1, iv, data, provider);
    }

    public static byte[] decipherAES(String algorithm, SecretKey key, IvParameterSpec iv, byte[] data, String provider) throws IllegalArgumentException, IllegalBlockSizeException, BadPaddingException {
        return CipherUtil.cipherAES(algorithm, key, 2, iv, data, provider);
    }

    public static byte[] cipher3DES(String algorithm, SecretKey key, int mode, IvParameterSpec iv, byte[] data, String provider) throws IllegalArgumentException, IllegalBlockSizeException, BadPaddingException {
        CipherUtil.checkCipherKey(key, ALGORITHM_3DES, KEY_SIZES_LIST_3DES);
        CipherUtil.checkCipherMode(mode);
        CipherUtil.checkCipherData(data, algorithm, 8);
        Cipher cipher = CipherUtil.getCipher(algorithm, key, mode, iv, provider);
        return cipher.doFinal(data);
    }

    public static byte[] cipherAES(String algorithm, SecretKey key, int mode, IvParameterSpec iv, byte[] data, String provider) throws IllegalArgumentException, IllegalBlockSizeException, BadPaddingException {
        CipherUtil.checkCipherKey(key, ALGORITHM_AES, KEY_SIZES_LIST_AES);
        CipherUtil.checkCipherMode(mode);
        Cipher cipher = CipherUtil.getCipher(algorithm, key, mode, iv, provider);
        return cipher.doFinal(data);
    }

    public static KeyPair getKeyPair(String algorithm, int keysize, String provider) throws IllegalArgumentException {
        KeyPair keyPair = null;
        try {
            KeyPairGenerator keyPairGenerator = null;
            keyPairGenerator = provider == null ? KeyPairGenerator.getInstance(algorithm) : KeyPairGenerator.getInstance(algorithm, provider);
            keyPairGenerator.initialize(keysize);
            keyPair = keyPairGenerator.generateKeyPair();
        }
        catch (NoSuchProviderException e) {
            throw new IllegalArgumentException("no provider available: " + provider, e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("no algorithm available: " + algorithm, e);
        }
        return keyPair;
    }

    public static byte[] retailMAC(byte[] bytes, SecretKey des3Key, IvParameterSpec iv, MacPadding padding) {
        SecretKey[] desKeys = CipherUtil.getDESKeys(des3Key);
        return CipherUtil.retailMAC(bytes, desKeys[0], desKeys[1], iv, padding);
    }

    public static byte[] cMAC(byte[] bytes, SecretKey macKey, IvParameterSpec iv, Integer outputLength) throws IllegalArgumentException {
        AssertUtil.notNull(bytes, "data");
        AssertUtil.notNull(macKey, "key");
        AssertUtil.notNull(iv, "initialization vector");
        if (!ALGORITHM_AES.equals(macKey.getAlgorithm())) {
            throw new IllegalArgumentException("only AES key permitted for MAC calculation");
        }
        if (SSCIvParameterSpec.class.isInstance(iv)) {
            ((SSCIvParameterSpec)((Object)iv)).increaseSSC();
        }
        byte[] ivBytes = iv.getIV();
        AssertUtil.notNullOrEmpty(ivBytes, "initialization vector bytes");
        if (ivBytes.length != 16) {
            throw new IllegalArgumentException("initialization vector length not as expected: 16, length found is " + ivBytes.length);
        }
        byte[] macData = ByteUtil.combine(new byte[][]{ivBytes, bytes});
        return CipherUtil.cMAC(macData, macKey, outputLength);
    }

    public static byte[] cMAC(byte[] bytes, SecretKey macKey, Integer outputLength) throws IllegalArgumentException {
        AssertUtil.notNull(bytes, "data");
        AssertUtil.notNull(bytes, "data");
        AssertUtil.notNull(macKey, "key");
        if (!ALGORITHM_AES.equals(macKey.getAlgorithm())) {
            throw new IllegalArgumentException("only AES key permitted for MAC calculation");
        }
        AESFastEngine bc = new AESFastEngine();
        if (ObjectUtil.isNull(outputLength)) {
            outputLength = 16;
        } else {
            if (outputLength < 1) {
                throw new IllegalArgumentException("output length exceeds minimum of 1 bytes");
            }
            if (outputLength > 16) {
                throw new IllegalArgumentException("output length exceeds maximum of 16 bytes");
            }
        }
        CMac cmac = new CMac((BlockCipher)bc, outputLength * 8);
        cmac.init((CipherParameters)new KeyParameter(macKey.getEncoded()));
        cmac.update(bytes, 0, bytes.length);
        byte[] result = new byte[outputLength.intValue()];
        cmac.doFinal(result, 0);
        return result;
    }

    public static byte[] retailMAC(byte[] bytes, SecretKey keyA, SecretKey keyB, IvParameterSpec iv, MacPadding padding) throws IllegalArgumentException, RuntimeException {
        AssertUtil.notNullOrEmpty(bytes, "data");
        AssertUtil.notNull(iv, "initialization vector");
        try {
            byte[][] blocks;
            byte[] paddedData = bytes;
            if (bytes.length % 8 != 0 && padding == null) {
                throw new IllegalArgumentException("data not multiple of DES blocksize so padding not permitted as null");
            }
            if (padding != null) {
                paddedData = padding.pad(bytes);
            }
            if (paddedData.length % 8 != 0) {
                throw new IllegalArgumentException("padded data not multiple of DES blocksize");
            }
            if (SSCIvParameterSpec.class.isInstance(iv)) {
                ((SSCIvParameterSpec)((Object)iv)).increaseSSC();
            }
            byte[] ivBytes = iv.getIV();
            AssertUtil.notNullOrEmpty(ivBytes, "initialization vector bytes");
            if (ivBytes.length != 8) {
                throw new IllegalArgumentException("initialization vector length not as expected: 8, length found is " + ivBytes.length);
            }
            byte[] lastCryptedBlock = CipherUtil.encipherDES(RETAIL_MAC_ALGORITHM, keyA, DEFAULT_DES_IV, ivBytes, null);
            for (byte[] block : blocks = ByteUtil.split(paddedData, 8)) {
                block = ByteUtil.xorBits(block, lastCryptedBlock);
                lastCryptedBlock = CipherUtil.encipherDES(RETAIL_MAC_ALGORITHM, keyA, DEFAULT_DES_IV, block, null);
            }
            lastCryptedBlock = CipherUtil.decipherDES(RETAIL_MAC_ALGORITHM, keyB, DEFAULT_DES_IV, lastCryptedBlock, null);
            lastCryptedBlock = CipherUtil.encipherDES(RETAIL_MAC_ALGORITHM, keyA, DEFAULT_DES_IV, lastCryptedBlock, null);
            return lastCryptedBlock;
        }
        catch (BadPaddingException e) {
            throw new RuntimeException("implementation fault, check tests, etc.: BadPaddingException occured", e);
        }
        catch (IllegalBlockSizeException e) {
            throw new RuntimeException("implementation fault, check tests, etc.: IllegalBlockSizeException occured", e);
        }
    }

    static {
        byte[] tmpIVBytes = new byte[8];
        Arrays.fill(tmpIVBytes, (byte)0);
        DEFAULT_DES_IV = new IvParameterSpec(tmpIVBytes);
        tmpIVBytes = new byte[16];
        Arrays.fill(tmpIVBytes, (byte)0);
        DEFAULT_AES_IV = new IvParameterSpec(tmpIVBytes);
    }
}

