/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.channel.util;

import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.ByteUtil;
import de.bos_bremen.gov2.jca_provider.ocf.channel.util.CipherUtil;
import de.bos_bremen.gov2.jca_provider.ocf.channel.util.EncryptedSSCIvParameterSpec;
import de.bos_bremen.gov2.jca_provider.ocf.channel.util.SSCIvParameterSpec;
import de.bos_bremen.gov2.jca_provider.ocf.channel.util.SSCIvParameterSpecImpl;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class AESEncSSCIvParameterSpecImpl
extends SSCIvParameterSpecImpl
implements EncryptedSSCIvParameterSpec,
SSCIvParameterSpec {
    private SecretKey keyEnc = null;

    public AESEncSSCIvParameterSpecImpl(byte[] ssc, SecretKey keyEnc) throws IllegalArgumentException {
        super(ssc, true, DEFAULT_BATCH_INCREMENT);
        this.init(keyEnc);
    }

    public AESEncSSCIvParameterSpecImpl(byte[] ssc, boolean initialIncrease, SecretKey keyEnc) throws IllegalArgumentException {
        super(ssc, initialIncrease, DEFAULT_BATCH_INCREMENT);
        this.init(keyEnc);
    }

    private void init(SecretKey keyEnc) throws IllegalArgumentException {
        AssertUtil.notNull(keyEnc, "encryption key");
        if (!"AES".equals(keyEnc.getAlgorithm())) {
            throw new IllegalArgumentException("only AESkey permitted, but key with algorithm " + keyEnc.getAlgorithm() + " used");
        }
        this.keyEnc = keyEnc;
    }

    @Override
    public byte[] getIV() {
        return super.getIV();
    }

    private IvParameterSpec updateEncryptedIV(byte[] iv) {
        byte[] result = ByteUtil.copy(iv);
        try {
            result = CipherUtil.encipherAES("AES/ECB/NoPadding", this.keyEnc, null, result, null);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new RuntimeException("generation of IV failed by encrypting SSC with key", e);
        }
        catch (IllegalBlockSizeException e) {
            throw new RuntimeException("generation of IV failed by encrypting SSC with key", e);
        }
        catch (BadPaddingException e) {
            throw new RuntimeException("generation of IV failed by encrypting SSC with key", e);
        }
        return new IvParameterSpec(result);
    }

    @Override
    public synchronized IvParameterSpec getEncryptedIV() {
        IvParameterSpec spec = this.updateEncryptedIV(super.getIV());
        return spec;
    }
}

