/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.channel.iso7816;

import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.gov2.jca_provider.ocf.channel.SMKeyMaterial;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class TripleDESKeyMaterialImpl
implements SMKeyMaterial {
    private IvParameterSpec ivParameterSpecSSC = null;
    private SecretKey des3EncKey = null;
    private SecretKey des3MacKey = null;

    public <T extends IvParameterSpec> TripleDESKeyMaterialImpl(SecretKey des3EncKey, SecretKey des3MacKey, T ivParameterSpecSSC) throws IllegalArgumentException {
        AssertUtil.notNull(des3EncKey, "encryption key");
        AssertUtil.notNull(des3MacKey, "Mac key");
        AssertUtil.notNull(ivParameterSpecSSC, "IVParameterSpec of SSC");
        if (!"DESede".equals(des3EncKey.getAlgorithm())) {
            throw new IllegalArgumentException("only triple DES key permitted for encryption");
        }
        if (!"DESede".equals(des3MacKey.getAlgorithm())) {
            throw new IllegalArgumentException("only triple DES key permitted for mac calculation");
        }
        if (8 != ivParameterSpecSSC.getIV().length) {
            throw new IllegalArgumentException("only IvParameterSpec with 8 bytes permitted");
        }
        this.des3EncKey = des3EncKey;
        this.des3MacKey = des3MacKey;
        this.ivParameterSpecSSC = ivParameterSpecSSC;
    }

    public IvParameterSpec getIvParameterSpec() {
        return this.ivParameterSpecSSC;
    }

    public SecretKey getDes3EncKey() {
        return this.des3EncKey;
    }

    public SecretKey getDes3MacKey() {
        return this.des3MacKey;
    }
}

