/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.channel.iso7816;

import de.bos_bremen.common.ArrayUtil;
import de.bos_bremen.common.ByteUtil;
import de.bos_bremen.common.asn1.ASN1;
import de.bos_bremen.gov2.jca_provider.ocf.apdu.GISOCommandAPDU;
import de.bos_bremen.gov2.jca_provider.ocf.apdu.GISOCommandAPDUUtil;
import de.bos_bremen.gov2.jca_provider.ocf.apdu.GISOCommandConstants;
import de.bos_bremen.gov2.jca_provider.ocf.channel.CardCommunication;
import de.bos_bremen.gov2.jca_provider.ocf.channel.iso7816.AbstractSecureMessagingImpl;
import de.bos_bremen.gov2.jca_provider.ocf.channel.iso7816.SMSettingsImpl;
import de.bos_bremen.gov2.jca_provider.ocf.channel.iso7816.TripleDESKeyMaterialImpl;
import de.bos_bremen.gov2.jca_provider.ocf.channel.util.CipherUtil;
import de.bos_bremen.gov2.jca_provider.ocf.channel.util.MacPadding;
import de.bos_bremen.gov2.jca_provider.ocf.channel.util.SMUtil;
import de.bos_bremen.gov2.jca_provider.ocf.channel.util.TCOS30MacPadding;
import java.util.ArrayList;
import java.util.Arrays;
import opencard.core.service.CHVDialog;
import opencard.core.terminal.CHVControl;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;

public final class TCOS30SecureMessagingImpl
extends AbstractSecureMessagingImpl<TripleDESKeyMaterialImpl> {
    private static final String CIPHER_ALGORITHM = "DESede/CBC/NoPadding";
    private static final MacPadding PADDING = new TCOS30MacPadding();
    private static final MacPadding ISO7816_PADDING = new MacPadding(){

        @Override
        public byte[] pad(byte[] data) throws IllegalArgumentException {
            return SMUtil.padISO(data, 8);
        }
    };

    public TCOS30SecureMessagingImpl(TripleDESKeyMaterialImpl keyMaterial) throws IllegalArgumentException {
        super(keyMaterial, SMSettingsImpl.SMEnum.FIRST_INTERINDUSTRY_SM_HEADER_AUTHENTICATED);
    }

    @Override
    protected void fromCardInt(CardCommunication cardCommunication) {
        ResponseAPDU response = cardCommunication.getResponse();
        try {
            ResponseAPDU decryptedResponse = this.processSingleResponse(response);
            cardCommunication.setResponse(decryptedResponse);
        }
        catch (Exception e) {
            cardCommunication.setThrowable(e);
        }
        cardCommunication.setPhase(1);
        cardCommunication.setFinished(true);
    }

    @Override
    protected void toCardInt(CardCommunication cardCommunication) {
        Exception throwable = null;
        ArrayList<CommandAPDU> encryptedCommandList = new ArrayList<CommandAPDU>();
        for (CommandAPDU command : cardCommunication.getCommands()) {
            try {
                encryptedCommandList.add(this.processSingleCommand(command));
            }
            catch (Exception e) {
                throwable = e;
                break;
            }
        }
        if (throwable != null) {
            cardCommunication.setThrowable(throwable);
        } else {
            cardCommunication.setCommands(encryptedCommandList.toArray(new CommandAPDU[0]));
        }
        cardCommunication.setPhase(1);
        cardCommunication.setFinished(true);
    }

    @Override
    protected void toCardVerifiedInt(CardCommunication cardCommunication, CHVControl control, CHVDialog dialog) {
        this.toCardInt(cardCommunication);
    }

    private CommandAPDU processSingleCommand(CommandAPDU command) throws Exception {
        GISOCommandAPDU isoCmd = new GISOCommandAPDU(command.getBytes());
        GISOCommandConstants.CommandCaseEnum commandCase = isoCmd.getCommandCase();
        boolean extended = isoCmd.isExtended() && commandCase.isLEPresent();
        byte[] header = this.getHeader(command);
        byte[] le = this.getLe(command, commandCase);
        byte[] secureHeaderBytes = this.createSecureHeader(header);
        byte[] secureHeaderPaddedBytes = ISO7816_PADDING.pad(secureHeaderBytes);
        byte[] cryptogramDOBytes = this.createCryptogramDO(command, commandCase);
        byte[] neDOBytes = this.createNeDO(le);
        byte[] macDOBytes = this.createMacDO(secureHeaderPaddedBytes, cryptogramDOBytes, neDOBytes);
        byte[] dataFieldBytes = ByteUtil.combine(new byte[][]{cryptogramDOBytes, neDOBytes, macDOBytes});
        return new GISOCommandAPDU(extended, secureHeaderBytes, dataFieldBytes, 0);
    }

    private ResponseAPDU processSingleResponse(ResponseAPDU response) throws Exception {
        byte[] retailMac;
        byte[] responseBytes = response.getBytes();
        if (responseBytes.length == 2) {
            return response;
        }
        byte[] responseData = response.data();
        if (ArrayUtil.isNullOrEmpty(responseData)) {
            return response;
        }
        ASN1 asn1data = new ASN1(48, responseData);
        ASN1[] childs = asn1data.getChildElements();
        byte[] encDataDOBytes = null;
        byte[] processDOBytes = null;
        byte[] macDOBytes = null;
        byte[] macData = null;
        for (int i = 0; i < childs.length; ++i) {
            int tag = (int)childs[i].getDTag().longValue();
            if (super.getSettings().getByteSettings().getTagByteDOCryptogram() == tag) {
                if (encDataDOBytes == null) {
                    macData = ByteUtil.combine(macData, childs[i].getEncoded());
                    encDataDOBytes = childs[i].getValue();
                    continue;
                }
                throw new RuntimeException("response contain more than one cryptogram");
            }
            if (super.getSettings().getByteSettings().getTagByteDOProcessingStatus() == tag) {
                if (processDOBytes == null) {
                    macData = ByteUtil.combine(macData, childs[i].getEncoded());
                    processDOBytes = childs[i].getValue();
                    continue;
                }
                throw new RuntimeException("response contain more than one le");
            }
            if (super.getSettings().getByteSettings().getTagByteDOCryptoGraphicChecksum() == tag) {
                if (macDOBytes == null) {
                    macDOBytes = childs[i].getValue();
                    continue;
                }
                throw new RuntimeException("response contain more than one cryptogram checksum");
            }
            throw new RuntimeException("unrecognized DO at response");
        }
        if (!ArrayUtil.isNullOrEmpty(macDOBytes) && !Arrays.equals(retailMac = this.retailMac(macData, ISO7816_PADDING), macDOBytes)) {
            throw new IllegalArgumentException("response of card not verified successfully, another checksum expected as found at response");
        }
        byte[] dataBytes = null;
        if (!ArrayUtil.isNullOrEmpty(encDataDOBytes)) {
            dataBytes = CipherUtil.decipher3DES(CIPHER_ALGORITHM, ((TripleDESKeyMaterialImpl)super.getLayerData()).getDes3EncKey(), CipherUtil.DEFAULT_DES_IV, ByteUtil.subbytes(encDataDOBytes, 1), null);
            dataBytes = SMUtil.unpadISO(dataBytes, 8);
        }
        byte[] result = ByteUtil.combine(new byte[][]{dataBytes, processDOBytes != null ? processDOBytes : ByteUtil.subbytes(responseBytes, responseBytes.length - 2)});
        return new ResponseAPDU(result);
    }

    private byte[] createMacDO(byte[] secureHeaderBytes, byte[] cryptogramDOBytes, byte[] neDOBytes) {
        byte[] macData = ByteUtil.combine(new byte[][]{secureHeaderBytes, cryptogramDOBytes, neDOBytes});
        byte[] retailMac = this.retailMac(macData, cryptogramDOBytes != null || neDOBytes != null ? ISO7816_PADDING : null);
        ASN1 result = new ASN1(super.getSettings().getByteSettings().getTagByteDOCryptoGraphicChecksum(), retailMac);
        return result.getEncoded();
    }

    private byte[] retailMac(byte[] macData, MacPadding padding) {
        byte[] retailMac = CipherUtil.retailMAC(macData, ((TripleDESKeyMaterialImpl)this.layerData).getDes3MacKey(), ((TripleDESKeyMaterialImpl)this.layerData).getIvParameterSpec(), padding);
        return retailMac;
    }

    private byte[] createNeDO(byte[] le) {
        if (ArrayUtil.isNullOrEmpty(le)) {
            return null;
        }
        byte[] leTmp = le;
        if (le.length == 3) {
            leTmp = ByteUtil.subbytes(le, 1, 3);
        }
        return new ASN1(super.getSettings().getByteSettings().getTagByteDONe(), leTmp).getEncoded();
    }

    private byte[] createCryptogramDO(CommandAPDU command, GISOCommandConstants.CommandCaseEnum commandCase) throws Exception {
        byte[] data = this.getData(command, commandCase);
        if (ArrayUtil.isNullOrEmpty(data)) {
            return null;
        }
        byte[] paddedData = ISO7816_PADDING.pad(data);
        byte[] cryptogram = CipherUtil.encipher3DES(CIPHER_ALGORITHM, ((TripleDESKeyMaterialImpl)super.getLayerData()).getDes3EncKey(), CipherUtil.DEFAULT_DES_IV, paddedData, null);
        byte[] paddedCryptogram = ByteUtil.combine(new byte[]{super.getSettings().getByteSettings().getPaddingIndicatorByte()}, cryptogram);
        ASN1 result = new ASN1(super.getSettings().getByteSettings().getTagByteDOCryptogram(), paddedCryptogram);
        return result.getEncoded();
    }

    private byte[] getData(CommandAPDU command, GISOCommandConstants.CommandCaseEnum commandCase) {
        return GISOCommandAPDUUtil.getData(command, commandCase);
    }

    private byte[] getLe(CommandAPDU command, GISOCommandConstants.CommandCaseEnum commandCase) {
        return GISOCommandAPDUUtil.getLEBytes(command, commandCase);
    }

    private byte[] createSecureHeader(byte[] header) {
        byte[] result = header;
        ByteUtil.setBits(result, 0, super.getSettings().getSMEnum().getClaMask());
        return result;
    }

    private byte[] getHeader(CommandAPDU command) {
        byte[] header = GISOCommandAPDUUtil.getHeader(command);
        return header;
    }
}

