/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.channel.iso7816;

import de.bos_bremen.gov2.jca_provider.ocf.channel.SMSettings;
import de.bos_bremen.gov2.jca_provider.ocf.channel.iso7816.ClaEncodingEnum;
import de.bos_bremen.gov2.jca_provider.ocf.channel.iso7816.SMByteSettingsImpl;

public class SMSettingsImpl
implements SMSettings<SMByteSettingsImpl> {
    private SMByteSettingsImpl byteSettings = null;
    private SMEnum smKind = null;

    public SMSettingsImpl(SMEnum smKind) {
        this(SMByteSettingsImpl.DEFAULT_BYTE_SETTINGS, smKind);
    }

    public SMSettingsImpl(SMByteSettingsImpl byteSettings, SMEnum smKind) throws IllegalArgumentException {
        if (byteSettings == null) {
            throw new IllegalArgumentException("byte settings not permitted as null");
        }
        if (smKind == null) {
            throw new IllegalArgumentException("kind of secure messaging not permitted as null");
        }
        this.byteSettings = byteSettings;
        this.smKind = smKind;
    }

    @Override
    public SMByteSettingsImpl getByteSettings() {
        return this.byteSettings;
    }

    public SMEnum getSMEnum() {
        return this.smKind;
    }

    static enum SMEnum {
        FIRST_INTERINDUSTRY_SM_NONE(ClaEncodingEnum.FIRST_INTERINDUSTRY, false, SMHeaderAuthenticationEnum.NOT_PROCESSED, false, 0),
        FIRST_INTERINDUSTRY_SM_PROPRIETARY(ClaEncodingEnum.FIRST_INTERINDUSTRY, true, SMHeaderAuthenticationEnum.UNKNOWN, true, 4),
        FIRST_INTERINDUSTRY_SM_HEADER_NOT_PROCESSED(ClaEncodingEnum.FIRST_INTERINDUSTRY, true, SMHeaderAuthenticationEnum.NOT_PROCESSED, false, 8),
        FIRST_INTERINDUSTRY_SM_HEADER_AUTHENTICATED(ClaEncodingEnum.FIRST_INTERINDUSTRY, true, SMHeaderAuthenticationEnum.AUTHENTICATED, false, 12),
        FURTHER_INTERINDUSTRY_SM_NONE(ClaEncodingEnum.FURTHER_INTERINDUSTRY, false, SMHeaderAuthenticationEnum.NOT_PROCESSED, false, 64),
        FURTHER_INTERINDUSTRY_SM_HEADER_NOT_PROCESSED(ClaEncodingEnum.FURTHER_INTERINDUSTRY, true, SMHeaderAuthenticationEnum.NOT_PROCESSED, false, 96);

        private ClaEncodingEnum encoding = null;
        private boolean secure = false;
        private SMHeaderAuthenticationEnum headerAuthenticated = null;
        private boolean proprietary = false;
        private byte claMask = 0;

        private SMEnum(ClaEncodingEnum encoding, boolean secure, SMHeaderAuthenticationEnum headerAuthenticated, boolean proprietary, byte claMask) {
            this.encoding = encoding;
            this.secure = secure;
            this.headerAuthenticated = headerAuthenticated;
            this.proprietary = proprietary;
            this.claMask = claMask;
        }

        public ClaEncodingEnum getEncoding() {
            return this.encoding;
        }

        public SMHeaderAuthenticationEnum getHeaderAuthenticated() {
            return this.headerAuthenticated;
        }

        public boolean isProprietary() {
            return this.proprietary;
        }

        public boolean isSecure() {
            return this.secure;
        }

        public boolean isUnsecure() {
            return !this.secure;
        }

        public byte getClaMask() {
            return this.claMask;
        }
    }

    static enum SMHeaderAuthenticationEnum {
        UNKNOWN,
        AUTHENTICATED,
        NOT_PROCESSED;

    }
}

