/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.channel.iso7816;

import de.bos_bremen.common.ByteUtil;
import de.bos_bremen.gov2.jca_provider.ocf.apdu.GISOCommandAPDUUtil;
import de.bos_bremen.gov2.jca_provider.ocf.apdu.GISOCommandConstants;
import de.bos_bremen.gov2.jca_provider.ocf.channel.CardCommunication;
import de.bos_bremen.gov2.jca_provider.ocf.channel.ExtendedLengthLayer;
import de.bos_bremen.gov2.jca_provider.ocf.channel.ExtendedLengthState;
import de.bos_bremen.gov2.jca_provider.ocf.channel.impl.AbstractCardChannelLayer;
import opencard.core.service.CHVDialog;
import opencard.core.terminal.CHVControl;
import opencard.core.terminal.CommandAPDU;

public class ExtendedLengthLayerImpl
extends AbstractCardChannelLayer<ExtendedLengthState>
implements ExtendedLengthLayer {
    public ExtendedLengthLayerImpl(ExtendedLengthState layerData) {
        super(layerData);
    }

    @Override
    public void checkLayerDataValid(ExtendedLengthState layerData) throws IllegalArgumentException {
        if (layerData.isSupported(65536, 1) || layerData.isSupported(1, 65537)) {
            throw new IllegalArgumentException("cannot support length > MAX_EXTENDED_LENGTH");
        }
        if (layerData.isSupported(-1, 1) || layerData.isSupported(1, -1) || layerData.isSupported(-1, -1)) {
            throw new IllegalArgumentException("cannot support negative length");
        }
    }

    @Override
    protected void fromCardInt(CardCommunication cardCommunication) {
    }

    @Override
    protected void toCardInt(CardCommunication cardCommunication) {
        CommandAPDU[] apduArray = cardCommunication.getCommands();
        CommandAPDU[] modifiedArray = new CommandAPDU[apduArray.length];
        for (int n = 0; n < apduArray.length; ++n) {
            byte[] header;
            CommandAPDU apdu = apduArray[n];
            Integer le = GISOCommandAPDUUtil.getLE(apdu);
            Integer lc = GISOCommandAPDUUtil.getLC(apdu);
            int apduLength = apdu.getLength();
            if (GISOCommandAPDUUtil.isExtended(apdu)) {
                if ((le == GISOCommandConstants.NO_LE || le < 256 && le > 0) && (lc == GISOCommandConstants.NO_LC || lc < 256)) {
                    header = GISOCommandAPDUUtil.getHeader(apdu);
                    if (lc != GISOCommandConstants.NO_LC) {
                        header = ByteUtil.combine(ByteUtil.combine(header, ByteUtil.subbytes(GISOCommandAPDUUtil.getLCBytes(apdu), 2)), GISOCommandAPDUUtil.getData(apdu));
                    }
                    if (le != GISOCommandConstants.NO_LE && lc == GISOCommandConstants.NO_LC) {
                        header = ByteUtil.combine(header, ByteUtil.subbytes(GISOCommandAPDUUtil.getLEBytes(apdu), 2));
                    } else if (le != GISOCommandConstants.NO_LE) {
                        header = ByteUtil.combine(header, ByteUtil.subbytes(GISOCommandAPDUUtil.getLEBytes(apdu), 1));
                    }
                    apdu = new CommandAPDU(header);
                    apduLength = apdu.getLength();
                }
                if (((ExtendedLengthState)this.layerData).isSupported(apduLength, le)) {
                    cardCommunication.setFinished(true);
                    cardCommunication.setPhase(1);
                } else if (((ExtendedLengthState)this.layerData).isSupported(0, le)) {
                    cardCommunication.setFinished(false);
                    cardCommunication.setPhase(0);
                } else {
                    cardCommunication.setFinished(true);
                    cardCommunication.setPhase(1);
                    cardCommunication.setThrowable(new IllegalArgumentException("value of le not accepted"));
                }
            } else if (le == 0 && ((ExtendedLengthState)this.layerData).isSupported(apduLength + 4, le)) {
                header = ByteUtil.combine(GISOCommandAPDUUtil.getHeader(apdu), new byte[]{0});
                if (lc != GISOCommandConstants.NO_LC) {
                    header = ByteUtil.combine(ByteUtil.combine(header, ByteUtil.combine(new byte[]{0}, GISOCommandAPDUUtil.getLCBytes(apdu))), GISOCommandAPDUUtil.getData(apdu));
                }
                header = ByteUtil.combine(header, new byte[]{0, 0});
                apdu = new CommandAPDU(header);
                apduLength = apdu.getLength();
                cardCommunication.setFinished(true);
                cardCommunication.setPhase(1);
            } else if (((ExtendedLengthState)this.layerData).isSupported(apduLength, le)) {
                cardCommunication.setFinished(true);
                cardCommunication.setPhase(1);
            } else if (((ExtendedLengthState)this.layerData).isSupported(0, le)) {
                cardCommunication.setFinished(false);
                cardCommunication.setPhase(0);
            } else {
                cardCommunication.setFinished(true);
                cardCommunication.setPhase(1);
                cardCommunication.setThrowable(new IllegalArgumentException("value of le not accepted"));
            }
            modifiedArray[n] = apdu;
        }
        cardCommunication.setCommands(modifiedArray);
    }

    @Override
    protected void toCardVerifiedInt(CardCommunication cardCommunication, CHVControl control, CHVDialog dialog) {
        this.toCard(cardCommunication);
    }
}

