/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.channel.iso7816;

import de.bos_bremen.common.ByteUtil;
import de.bos_bremen.gov2.jca_provider.ocf.apdu.GISOCommandAPDU;
import de.bos_bremen.gov2.jca_provider.ocf.apdu.GISOCommandAPDUUtil;
import de.bos_bremen.gov2.jca_provider.ocf.apdu.GISOCommandConstants;
import de.bos_bremen.gov2.jca_provider.ocf.channel.CardCommunication;
import de.bos_bremen.gov2.jca_provider.ocf.channel.CommandChainingLayer;
import de.bos_bremen.gov2.jca_provider.ocf.channel.CommandChainingState;
import de.bos_bremen.gov2.jca_provider.ocf.channel.impl.AbstractCardChannelLayer;
import java.util.ArrayList;
import opencard.core.service.CHVDialog;
import opencard.core.terminal.CHVControl;
import opencard.core.terminal.CommandAPDU;

public class CommandChainingLayerImpl
extends AbstractCardChannelLayer<CommandChainingState>
implements CommandChainingLayer {
    public CommandChainingLayerImpl() {
        super(true);
    }

    public CommandChainingLayerImpl(CommandChainingState layerData) throws IllegalArgumentException {
        super(layerData);
    }

    @Override
    public void checkLayerDataValid(CommandChainingState layerData) throws IllegalArgumentException {
        if (layerData.getMaximumCommandLength() < 127 || layerData.getMaximumCommandLength() > 261) {
            throw new IllegalArgumentException("maximum command length not between 127 and 261, maximum command length not accepted");
        }
        if (layerData.getBufferSize() < 127 || layerData.getBufferSize() > 1020) {
            throw new IllegalArgumentException("buffer size not between 127 and 1020, maximum command length not accepted");
        }
    }

    @Override
    protected void fromCardInt(CardCommunication cardCommunication) {
    }

    @Override
    protected void toCardInt(CardCommunication cardCommunication) {
        ArrayList<GISOCommandAPDU> commandList;
        cardCommunication.setPhase(1);
        cardCommunication.setFinished(true);
        CommandAPDU[] commands = cardCommunication.getCommands();
        if (commands.length > 1) {
            cardCommunication.setThrowable(new IllegalArgumentException("command chaining not possible for more than one command"));
            return;
        }
        GISOCommandConstants.CommandCaseEnum commandCase = GISOCommandAPDUUtil.getCommandCase(commands[0]);
        if (commandCase.isShort() && ((CommandChainingState)this.layerData).getMaximumCommandLength() > commands[0].getLength()) {
            return;
        }
        Integer le = GISOCommandAPDUUtil.getLE(commands[0], commandCase);
        Integer lc = GISOCommandAPDUUtil.getLC(commands[0], commandCase);
        if (commandCase.isExtended() && le != null && le == 0 || le != null && le > 256) {
            cardCommunication.setThrowable(new IllegalArgumentException("not splittable extended length command"));
            return;
        }
        if (!(!commandCase.isExtended() || le != null && le > 256 || lc != null && lc > 255)) {
            CommandAPDU cmd = commands[0];
            if (!GISOCommandAPDU.class.isInstance(cmd)) {
                cmd = new GISOCommandAPDU(cmd.getBytes());
            }
            GISOCommandConstants.CommandCaseEnum shortCommandCase = null;
            switch (commandCase.getISOCase()) {
                case 2: {
                    shortCommandCase = GISOCommandConstants.CommandCaseEnum.CASE2_SHORT;
                    break;
                }
                case 3: {
                    shortCommandCase = GISOCommandConstants.CommandCaseEnum.CASE3_SHORT;
                    break;
                }
                case 4: {
                    shortCommandCase = GISOCommandConstants.CommandCaseEnum.CASE4_SHORT;
                }
            }
            ((GISOCommandAPDU)cmd).setCommandCase(shortCommandCase);
            if (cmd != commands[0]) {
                cardCommunication.setCommand(cmd);
            }
            if (cmd.getLength() < ((CommandChainingState)this.layerData).getMaximumCommandLength()) {
                return;
            }
        }
        if (((CommandChainingState)this.layerData).isSupported(commands[0], commands[0].getLength())) {
            int maxCommandLength = ((CommandChainingState)this.layerData).getMaximumCommandLength();
            int maxDataLength = maxCommandLength - 4 - 1 - (le != null ? 1 : 0);
            byte[] header = GISOCommandAPDUUtil.getHeader(commands[0]);
            byte[] chaChainHeader = ByteUtil.copy(header);
            ByteUtil.setBit(chaChainHeader, 0, 4);
            byte[] data = GISOCommandAPDUUtil.getData(commands[0]);
            int lastDataBlockLength = data.length % maxDataLength;
            byte[][] dataParts = ByteUtil.splitAt(data, data.length - lastDataBlockLength);
            byte[] lastData = dataParts[1];
            dataParts = ByteUtil.split(dataParts[0], maxDataLength);
            ArrayList<byte[]> dataPartsList = new ArrayList<byte[]>();
            for (int i = 0; i < dataParts.length; ++i) {
                dataPartsList.add(dataParts[i]);
            }
            if (lastData != null && lastData.length > 0) {
                dataPartsList.add(lastData);
            }
            commandList = new ArrayList<GISOCommandAPDU>();
            for (int i = 0; i < dataPartsList.size(); ++i) {
                if (i != dataPartsList.size() - 1) {
                    commandList.add(new GISOCommandAPDU(ByteUtil.combine(new byte[][]{chaChainHeader, GISOCommandAPDUUtil.createLCBytes(false, maxDataLength), (byte[])dataPartsList.get(i)})));
                    continue;
                }
                commandList.add(new GISOCommandAPDU(ByteUtil.combine(new byte[][]{header, GISOCommandAPDUUtil.createLCBytes(false, lastDataBlockLength), (byte[])dataPartsList.get(i), le != null ? GISOCommandAPDUUtil.createLEBytes(false, le, GISOCommandConstants.CommandCaseEnum.CASE4_SHORT) : null})));
            }
        } else {
            cardCommunication.setThrowable(new IllegalArgumentException("command chaining impossible"));
            return;
        }
        cardCommunication.setCommands(commandList.toArray(new CommandAPDU[0]));
    }

    @Override
    protected void toCardVerifiedInt(CardCommunication cardCommunication, CHVControl control, CHVDialog dialog) {
        this.toCardInt(cardCommunication);
    }
}

