/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.channel.iso7816;

import de.bos_bremen.common.HexUtil;
import de.bos_bremen.gov2.jca_provider.ocf.channel.iso7816.ClaEncodingConstants;

public enum ClaEncodingEnum implements ClaEncodingConstants
{
    FIRST_INTERINDUSTRY("First Interindustry", 0, -32),
    FURTHER_INTERINDUSTRY("Further Interindustry", 64, -64);

    private String name = null;
    private byte encodingValue = (byte)-1;
    private byte encodingMask = (byte)-1;

    private ClaEncodingEnum(String name, byte encodingValue, byte encodingMask) {
        this.name = name;
        this.encodingValue = encodingValue;
        this.encodingMask = encodingMask;
    }

    public String getName() {
        return this.name;
    }

    public byte getEncodingValue() {
        return this.encodingValue;
    }

    public byte getEncodingMask() {
        return this.encodingMask;
    }

    public static ClaEncodingEnum getEncoding(byte cla) {
        for (ClaEncodingEnum encoding : ClaEncodingEnum.values()) {
            if ((cla & encoding.getEncodingMask()) != encoding.getEncodingValue()) continue;
            return encoding;
        }
        return null;
    }

    public String toString() {
        return super.toString() + "(Name: " + this.name + ", mask for encoding: " + HexUtil.hexify(this.encodingMask) + ", encoding value: " + HexUtil.hexify(this.encodingValue) + ")";
    }
}

