/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.channel.iso7816;

import de.bos_bremen.gov2.jca_provider.ocf.channel.CardCommunication;
import de.bos_bremen.gov2.jca_provider.ocf.channel.ChannelIDLayer;
import de.bos_bremen.gov2.jca_provider.ocf.channel.impl.AbstractCardChannelLayer;
import de.bos_bremen.gov2.jca_provider.ocf.channel.iso7816.ChannelIDEncodingEnum;
import java.util.Arrays;
import opencard.core.service.CHVDialog;
import opencard.core.terminal.CHVControl;
import opencard.core.terminal.CommandAPDU;

public class ChannelIDLayerImpl
extends AbstractCardChannelLayer<Integer>
implements ChannelIDLayer {
    private ChannelIDEncodingEnum channelIDEncoding = null;
    private byte claMask = 0;

    public ChannelIDLayerImpl() {
        super(true);
    }

    public ChannelIDLayerImpl(Integer layerData) {
        super(layerData);
        int channelID = layerData;
        this.update(channelID);
    }

    private void update(int channelID) throws IllegalArgumentException {
        ChannelIDEncodingEnum channelIDEncoding = ChannelIDEncodingEnum.getEncoding(channelID);
        if (channelIDEncoding == null) {
            throw new IllegalArgumentException("channel ID " + channelID + " must be encodable with known in range " + Arrays.asList(ChannelIDEncodingEnum.values()));
        }
        byte claMask = channelIDEncoding.getClaByte(channelID);
        this.channelIDEncoding = channelIDEncoding;
        this.claMask = claMask;
    }

    @Override
    protected void toCardInt(CardCommunication cardCommunication) {
        CommandAPDU[] apduArray = cardCommunication.getCommands();
        if (apduArray.length == 0) {
            return;
        }
        if ((Integer)this.layerData != 0) {
            for (CommandAPDU apdu : apduArray) {
                int claByte = apdu.getByte(0);
                int id = -1;
                try {
                    id = ChannelIDEncodingEnum.getChannelID((byte)claByte);
                }
                catch (IllegalArgumentException e) {
                    cardCommunication.setFinished(true);
                    cardCommunication.setPhase(1);
                    cardCommunication.setThrowable(e);
                    return;
                }
                if (id != 0) {
                    cardCommunication.setFinished(true);
                    cardCommunication.setPhase(1);
                    cardCommunication.setThrowable(new IllegalArgumentException("channel already set, not accepting"));
                    return;
                }
                apdu.setByte(0, claByte |= this.claMask);
            }
            cardCommunication.setCommands(apduArray);
        }
    }

    @Override
    protected void toCardVerifiedInt(CardCommunication cardCommunication, CHVControl control, CHVDialog dialog) {
        this.toCardInt(cardCommunication);
    }

    @Override
    protected void checkLayerDataValid(Integer layerData) throws IllegalArgumentException {
        this.update(layerData);
    }

    @Override
    protected void fromCardInt(CardCommunication cardCommunication) {
    }
}

