/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.channel.iso7816;

import de.bos_bremen.common.HexUtil;
import de.bos_bremen.gov2.jca_provider.ocf.channel.iso7816.ChannelIDEncodingConstants;
import de.bos_bremen.gov2.jca_provider.ocf.channel.iso7816.ClaEncodingEnum;

public enum ChannelIDEncodingEnum implements ChannelIDEncodingConstants
{
    FIRST_INTERINDUSTRY(ClaEncodingEnum.FIRST_INTERINDUSTRY, 0, 3, 3, -4),
    FURTHER_INTERINDUSTRY(ClaEncodingEnum.FURTHER_INTERINDUSTRY, 4, 19, 15, -16);

    private ClaEncodingEnum claEncoding = null;
    private int minimum = -1;
    private int maximum = -1;
    private byte idMask = (byte)-1;
    private byte idMaskComplement = (byte)-1;

    private ChannelIDEncodingEnum(ClaEncodingEnum claEncoding, int minimum, int maximum, byte idMask, byte idMaskComplement) {
        this.claEncoding = claEncoding;
        this.maximum = maximum;
        this.minimum = minimum;
        this.idMask = idMask;
        this.idMaskComplement = idMaskComplement;
    }

    public int getMinimum() {
        return this.minimum;
    }

    public int getMaximum() {
        return this.maximum;
    }

    public byte getIdMask() {
        return this.idMask;
    }

    public byte getIdMaskComplement() {
        return this.idMaskComplement;
    }

    public static ChannelIDEncodingEnum getEncoding(int id) {
        for (ChannelIDEncodingEnum encoding : ChannelIDEncodingEnum.values()) {
            if (encoding.getMinimum() > id || id > encoding.getMaximum()) continue;
            return encoding;
        }
        return null;
    }

    public static ChannelIDEncodingEnum getEncoding(byte cla) {
        ClaEncodingEnum claEncoding = ClaEncodingEnum.getEncoding(cla);
        if (claEncoding == null) {
            return null;
        }
        ChannelIDEncodingEnum result = null;
        for (ChannelIDEncodingEnum encoding : ChannelIDEncodingEnum.values()) {
            if (encoding.getClaEncoding() != claEncoding) continue;
            result = encoding;
            break;
        }
        return result;
    }

    public byte getClaByte(int channelID) throws IllegalArgumentException {
        if (ChannelIDEncodingEnum.getEncoding(channelID) != this) {
            throw new IllegalArgumentException("channel ID can not be used with this encoding");
        }
        byte claMask = (byte)(this.getClaEncoding().getEncodingValue() | (channelID -= this.getMinimum()));
        return claMask;
    }

    public static int getChannelID(byte cla) throws IllegalArgumentException {
        ChannelIDEncodingEnum encoding = ChannelIDEncodingEnum.getEncoding(cla);
        if (encoding == null) {
            throw new IllegalArgumentException("no encoding available that supports given CLA byte: " + cla);
        }
        int id = (cla & encoding.idMask) + encoding.minimum;
        return id;
    }

    public String toString() {
        return super.toString() + "(ClaEncoding: " + this.claEncoding + ", mask for ID: " + HexUtil.hexify(this.idMask) + ", complement mask: " + HexUtil.hexify(this.idMaskComplement) + ", Minimum: " + this.minimum + ", Maximum: " + this.maximum + ")";
    }

    public ClaEncodingEnum getClaEncoding() {
        return this.claEncoding;
    }
}

