/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.channel.iso7816;

import de.bos_bremen.common.ArrayUtil;
import de.bos_bremen.common.ByteUtil;
import de.bos_bremen.common.asn1.ASN1;
import de.bos_bremen.gov2.jca_provider.ocf.apdu.GISOCommandAPDU;
import de.bos_bremen.gov2.jca_provider.ocf.apdu.GISOCommandAPDUUtil;
import de.bos_bremen.gov2.jca_provider.ocf.apdu.GISOCommandConstants;
import de.bos_bremen.gov2.jca_provider.ocf.channel.CardCommunication;
import de.bos_bremen.gov2.jca_provider.ocf.channel.iso7816.AESKeyMaterialImpl;
import de.bos_bremen.gov2.jca_provider.ocf.channel.iso7816.AbstractSecureMessagingImpl;
import de.bos_bremen.gov2.jca_provider.ocf.channel.iso7816.SMSettingsImpl;
import de.bos_bremen.gov2.jca_provider.ocf.channel.util.CipherUtil;
import de.bos_bremen.gov2.jca_provider.ocf.channel.util.EncryptedSSCIvParameterSpec;
import de.bos_bremen.gov2.jca_provider.ocf.channel.util.MacPadding;
import de.bos_bremen.gov2.jca_provider.ocf.channel.util.SMUtil;
import de.bos_bremen.gov2.jca_provider.ocf.channel.util.SSCIvParameterSpec;
import java.util.ArrayList;
import java.util.Arrays;
import javax.crypto.spec.IvParameterSpec;
import opencard.core.service.CHVDialog;
import opencard.core.terminal.CHVControl;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;

public final class AESSecureMessagingImpl
extends AbstractSecureMessagingImpl<AESKeyMaterialImpl> {
    private static final String CIPHER_ALGORITHM = "AES/CBC/NoPadding";
    private static final MacPadding ISO7816_PADDING = new MacPadding(){

        @Override
        public byte[] pad(byte[] data) throws IllegalArgumentException {
            return SMUtil.padISO(data, 16);
        }
    };
    private MacPadding macPadding = ISO7816_PADDING;

    public AESSecureMessagingImpl(AESKeyMaterialImpl keyMaterial) throws IllegalArgumentException {
        super(keyMaterial, SMSettingsImpl.SMEnum.FIRST_INTERINDUSTRY_SM_HEADER_AUTHENTICATED);
    }

    @Override
    protected void fromCardInt(CardCommunication cardCommunication) {
        Exception throwable = null;
        SSCIvParameterSpec paramSpec = null;
        IvParameterSpec iv = ((AESKeyMaterialImpl)super.getLayerData()).getIvParameterSpec();
        if (SSCIvParameterSpec.class.isInstance(iv)) {
            paramSpec = (SSCIvParameterSpec)((Object)iv);
        }
        ResponseAPDU[] encryptedResponses = cardCommunication.getResponses();
        ArrayList<ResponseAPDU> decryptedResponses = new ArrayList<ResponseAPDU>();
        for (ResponseAPDU response : encryptedResponses) {
            try {
                ResponseAPDU decryptedResponse = this.processSingleResponse(response);
                decryptedResponses.add(decryptedResponse);
            }
            catch (Exception e) {
                throwable = e;
                break;
            }
        }
        if (throwable != null) {
            cardCommunication.setThrowable(throwable);
        } else {
            cardCommunication.setResponses(decryptedResponses.toArray(new ResponseAPDU[0]));
        }
        cardCommunication.setPhase(1);
        cardCommunication.setFinished(true);
    }

    @Override
    protected void toCardInt(CardCommunication cardCommunication) {
        Exception throwable = null;
        ArrayList<CommandAPDU> encryptedCommandList = new ArrayList<CommandAPDU>();
        SSCIvParameterSpec paramSpec = null;
        IvParameterSpec iv = ((AESKeyMaterialImpl)super.getLayerData()).getIvParameterSpec();
        if (iv instanceof SSCIvParameterSpec) {
            paramSpec = (SSCIvParameterSpec)((Object)iv);
            paramSpec.mark();
        }
        for (CommandAPDU command : cardCommunication.getCommands()) {
            try {
                encryptedCommandList.add(this.processSingleCommand(command));
            }
            catch (Exception e) {
                throwable = e;
                break;
            }
        }
        if (throwable != null) {
            cardCommunication.setThrowable(throwable);
        } else {
            cardCommunication.setCommands(encryptedCommandList.toArray(new CommandAPDU[0]));
        }
        cardCommunication.setPhase(1);
        cardCommunication.setFinished(true);
        if (paramSpec != null) {
            paramSpec.reset();
        }
    }

    @Override
    protected void toCardVerifiedInt(CardCommunication cardCommunication, CHVControl control, CHVDialog dialog) {
        this.toCardInt(cardCommunication);
    }

    private CommandAPDU processSingleCommand(CommandAPDU command) throws Exception {
        IvParameterSpec iv = ((AESKeyMaterialImpl)super.getLayerData()).getIvParameterSpec();
        if (iv instanceof SSCIvParameterSpec) {
            ((SSCIvParameterSpec)((Object)iv)).increaseSSC();
        }
        GISOCommandAPDU isoCmd = new GISOCommandAPDU(command.getBytes());
        GISOCommandConstants.CommandCaseEnum commandCase = isoCmd.getCommandCase();
        boolean extended = isoCmd.isExtended() && commandCase.isLEPresent();
        byte[] header = this.getHeader(command);
        byte[] le = this.getLe(command, commandCase);
        byte[] secureHeaderBytes = this.createSecureHeader(header);
        byte[] secureHeaderPaddedBytes = this.macPadding.pad(secureHeaderBytes);
        byte[] cryptogramDOBytes = this.createCryptogramDO(command, commandCase);
        byte[] neDOBytes = this.createNeDO(le);
        byte[] macDOBytes = this.createMacDO(secureHeaderPaddedBytes, cryptogramDOBytes, neDOBytes);
        byte[] dataFieldBytes = ByteUtil.combine(new byte[][]{cryptogramDOBytes, neDOBytes, macDOBytes});
        return new GISOCommandAPDU(extended, secureHeaderBytes, dataFieldBytes, 0);
    }

    private ResponseAPDU processSingleResponse(ResponseAPDU response) throws Exception {
        byte[] cMac;
        byte[] responseBytes;
        IvParameterSpec iv = ((AESKeyMaterialImpl)super.getLayerData()).getIvParameterSpec();
        if (iv instanceof SSCIvParameterSpec) {
            ((SSCIvParameterSpec)((Object)iv)).increaseSSC();
        }
        if ((responseBytes = response.getBytes()).length == 2) {
            return response;
        }
        byte[] responseData = response.data();
        if (ArrayUtil.isNullOrEmpty(responseData)) {
            return response;
        }
        ASN1 asn1data = new ASN1(48, responseData);
        ASN1[] childs = asn1data.getChildElements();
        byte[] encDataDOBytes = null;
        byte[] processDOBytes = null;
        byte[] macDOBytes = null;
        byte[] macData = null;
        for (int i = 0; i < childs.length; ++i) {
            int tag = (int)childs[i].getDTag().longValue();
            if (super.getSettings().getByteSettings().getTagByteDOCryptogram() == tag) {
                if (encDataDOBytes == null) {
                    macData = ByteUtil.combine(macData, childs[i].getEncoded());
                    encDataDOBytes = childs[i].getValue();
                    continue;
                }
                throw new RuntimeException("response contain more than one cryptogram");
            }
            if (super.getSettings().getByteSettings().getTagByteDOProcessingStatus() == tag) {
                if (processDOBytes == null) {
                    macData = ByteUtil.combine(macData, childs[i].getEncoded());
                    processDOBytes = childs[i].getValue();
                    continue;
                }
                throw new RuntimeException("response contain more than one le");
            }
            if (super.getSettings().getByteSettings().getTagByteDOCryptoGraphicChecksum() == tag) {
                if (macDOBytes == null) {
                    macDOBytes = childs[i].getValue();
                    continue;
                }
                throw new RuntimeException("response contain more than one cryptogram checksum");
            }
            throw new RuntimeException("unrecognized DO at response");
        }
        if (!ArrayUtil.isNullOrEmpty(macDOBytes) && !Arrays.equals(cMac = this.cMac(macData = this.macPadding.pad(macData)), macDOBytes)) {
            throw new IllegalArgumentException("response of card not verified successfully, another checksum expected as found at response");
        }
        byte[] dataBytes = null;
        if (!ArrayUtil.isNullOrEmpty(encDataDOBytes)) {
            dataBytes = CipherUtil.decipherAES(CIPHER_ALGORITHM, ((AESKeyMaterialImpl)super.getLayerData()).getAESEncKey(), ((EncryptedSSCIvParameterSpec)((Object)((AESKeyMaterialImpl)super.getLayerData()).getIvParameterSpec())).getEncryptedIV(), ByteUtil.subbytes(encDataDOBytes, 1), null);
            dataBytes = SMUtil.unpadISO(dataBytes, 16);
        }
        byte[] result = ByteUtil.combine(new byte[][]{dataBytes, processDOBytes != null ? processDOBytes : ByteUtil.subbytes(responseBytes, responseBytes.length - 2)});
        return new ResponseAPDU(result);
    }

    private byte[] createMacDO(byte[] secureHeaderBytes, byte[] cryptogramDOBytes, byte[] neDOBytes) {
        byte[] macData = ByteUtil.combine(new byte[][]{secureHeaderBytes, cryptogramDOBytes, neDOBytes});
        if (!ArrayUtil.isNullOrEmpty(cryptogramDOBytes) || !ArrayUtil.isNullOrEmpty(neDOBytes)) {
            macData = this.macPadding.pad(macData);
        }
        byte[] cMac = this.cMac(macData);
        ASN1 result = new ASN1(super.getSettings().getByteSettings().getTagByteDOCryptoGraphicChecksum(), cMac);
        return result.getEncoded();
    }

    private byte[] cMac(byte[] macData) {
        IvParameterSpec ivSpec = new IvParameterSpec(((AESKeyMaterialImpl)this.layerData).getIvParameterSpec().getIV());
        return CipherUtil.cMAC(macData, ((AESKeyMaterialImpl)this.layerData).getAESMacKey(), ivSpec, 8);
    }

    private byte[] createNeDO(byte[] le) {
        if (ArrayUtil.isNullOrEmpty(le)) {
            return null;
        }
        byte[] leTmp = le;
        if (le.length == 3) {
            leTmp = ByteUtil.subbytes(le, 1, 3);
        }
        return new ASN1(super.getSettings().getByteSettings().getTagByteDONe(), leTmp).getEncoded();
    }

    private byte[] createCryptogramDO(CommandAPDU command, GISOCommandConstants.CommandCaseEnum commandCase) throws Exception {
        byte[] data = this.getData(command, commandCase);
        if (ArrayUtil.isNullOrEmpty(data)) {
            return null;
        }
        byte[] paddedData = this.macPadding.pad(data);
        IvParameterSpec encIv = ((EncryptedSSCIvParameterSpec)((Object)((AESKeyMaterialImpl)super.getLayerData()).getIvParameterSpec())).getEncryptedIV();
        byte[] cryptogram = CipherUtil.encipherAES(CIPHER_ALGORITHM, ((AESKeyMaterialImpl)super.getLayerData()).getAESEncKey(), encIv, paddedData, null);
        byte[] paddedCryptogram = ByteUtil.combine(new byte[]{super.getSettings().getByteSettings().getPaddingIndicatorByte()}, cryptogram);
        ASN1 result = new ASN1(super.getSettings().getByteSettings().getTagByteDOCryptogram(), paddedCryptogram);
        return result.getEncoded();
    }

    private byte[] getData(CommandAPDU command, GISOCommandConstants.CommandCaseEnum commandCase) {
        return GISOCommandAPDUUtil.getData(command, commandCase);
    }

    private byte[] getLe(CommandAPDU command, GISOCommandConstants.CommandCaseEnum commandCase) {
        return GISOCommandAPDUUtil.getLEBytes(command, commandCase);
    }

    private byte[] createSecureHeader(byte[] header) {
        byte[] result = header;
        ByteUtil.setBits(result, 0, super.getSettings().getSMEnum().getClaMask());
        return result;
    }

    private byte[] getHeader(CommandAPDU command) {
        return GISOCommandAPDUUtil.getHeader(command);
    }
}

