/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.channel.iso7816;

import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.gov2.jca_provider.ocf.channel.SMKeyMaterial;
import de.bos_bremen.gov2.jca_provider.ocf.channel.util.SSCIvParameterSpec;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class AESKeyMaterialImpl
implements SMKeyMaterial {
    private IvParameterSpec ivParameterSpecSSC = null;
    private SecretKey aes3EncKey = null;
    private SecretKey aes3MacKey = null;

    public <T extends IvParameterSpec> AESKeyMaterialImpl(SecretKey aesEncKey, SecretKey aesMacKey, T ivParameterSpecSSC) throws IllegalArgumentException {
        AssertUtil.notNull(aesEncKey, "encryption key");
        AssertUtil.notNull(aesMacKey, "Mac key");
        AssertUtil.notNull(ivParameterSpecSSC, "IVParameterSpec of SSC");
        if (!"AES".equals(aesEncKey.getAlgorithm())) {
            throw new IllegalArgumentException("only AES key permitted for encryption");
        }
        if (!"AES".equals(aesMacKey.getAlgorithm())) {
            throw new IllegalArgumentException("only AES key permitted for MAC calculation");
        }
        if (aesEncKey.getEncoded().length != aesMacKey.getEncoded().length) {
            throw new IllegalArgumentException("AES keys for encryption and mac calculation not consistent, different strength");
        }
        if (16 != ((SSCIvParameterSpec)((Object)ivParameterSpecSSC)).getLength()) {
            throw new IllegalArgumentException("only IvParameterSpec with 16 bytes permitted currently");
        }
        this.aes3EncKey = aesEncKey;
        this.aes3MacKey = aesMacKey;
        this.ivParameterSpecSSC = ivParameterSpecSSC;
    }

    public IvParameterSpec getIvParameterSpec() {
        return this.ivParameterSpecSSC;
    }

    public SecretKey getAESEncKey() {
        return this.aes3EncKey;
    }

    public SecretKey getAESMacKey() {
        return this.aes3MacKey;
    }
}

