/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.channel.impl;

import de.bos_bremen.gov2.jca_provider.ocf.channel.CardCommunication;
import java.io.Serializable;
import java.util.Arrays;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;

public class CardCommunicationImpl
implements CardCommunication {
    private CommandAPDU[] commands = null;
    private boolean finished = false;
    private int phase = 0;
    private ResponseAPDU[] responses = null;
    private Throwable throwable = null;

    public CardCommunicationImpl(CommandAPDU[] commands) {
        this.setCommands(commands);
    }

    public CardCommunicationImpl(CommandAPDU command) {
        this(new CommandAPDU[]{command});
    }

    public CardCommunicationImpl(ResponseAPDU response) {
        this(new ResponseAPDU[]{response});
    }

    public CardCommunicationImpl(ResponseAPDU[] responses) {
        this.setResponses(responses);
    }

    @Override
    public CommandAPDU[] getCommands() {
        return this.commands;
    }

    @Override
    public int getPhase() {
        return this.phase;
    }

    @Override
    public ResponseAPDU[] getResponses() {
        return this.responses;
    }

    @Override
    public ResponseAPDU getResponse() {
        return this.responses != null && this.responses.length >= 1 ? this.responses[0] : null;
    }

    @Override
    public Throwable getThrowable() {
        return this.throwable;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void setCommand(CommandAPDU command) {
        if (command == null) {
            throw new IllegalArgumentException("command not permitted as null");
        }
        this.setCommands(new CommandAPDU[]{command});
    }

    @Override
    public void setCommands(CommandAPDU[] commands) {
        if (commands == null) {
            throw new IllegalArgumentException("command array not permitted as null");
        }
        if (commands.length < 1) {
            throw new IllegalArgumentException("empty command-array not permitted");
        }
        for (int i = 0; i < commands.length; ++i) {
            if (commands[i] == null) {
                throw new IllegalArgumentException("command of array not permitted as null");
            }
            if (commands[i].getLength() >= 4) continue;
            throw new IllegalArgumentException("command of array not permitted as incomplete command, at least 4 bytes required");
        }
        this.commands = commands;
    }

    @Override
    public void setFinished(boolean finished) {
        this.finished = finished;
    }

    @Override
    public void setPhase(int phase) throws IllegalArgumentException, IllegalStateException {
        if (phase != 1 && phase != 0) {
            throw new IllegalArgumentException("illegal phase");
        }
        if (this.phase == 1 && phase == 0) {
            throw new IllegalStateException("change from post to prepare phase not permitted");
        }
        this.phase = phase;
    }

    @Override
    public void setResponse(ResponseAPDU response) {
        if (response == null) {
            throw new IllegalArgumentException("response not permitted as null");
        }
        this.setResponses(new ResponseAPDU[]{response});
    }

    @Override
    public void setResponses(ResponseAPDU[] responses) {
        if (responses != null) {
            for (ResponseAPDU r : responses) {
                if (r == null) {
                    throw new IllegalArgumentException("response not permitted as null");
                }
                if (r.getLength() >= 2) continue;
                throw new IllegalArgumentException("illegal response, response expected to possess at least 2 bytes");
            }
        }
        this.responses = responses;
    }

    @Override
    public void setThrowable(Throwable throwable) {
        this.throwable = throwable;
    }

    public String toString() {
        return super.toString() + "\n  Finished: " + this.finished + "\n  Phase: " + (this.phase == 0 ? "PREPARE" : "POST") + "\n  Commands: " + (this.commands != null ? Arrays.asList(this.commands) : null) + "\n  Responses: " + (this.responses != null ? Arrays.asList(this.responses) : null) + "  Throwable: " + (Serializable)(this.throwable != null ? this.throwable.getClass().getName() + " / " + this.throwable.getMessage() : this.throwable);
    }
}

