/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.channel.impl;

import de.bos_bremen.gov2.jca_provider.ocf.channel.CardChannelLayer;
import de.bos_bremen.gov2.jca_provider.ocf.channel.CardCommunication;
import opencard.core.service.CHVDialog;
import opencard.core.terminal.CHVControl;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;

public abstract class AbstractCardChannelLayer<T>
implements CardChannelLayer<T> {
    protected T layerData = null;
    protected boolean layerDataRequired = false;

    protected AbstractCardChannelLayer(boolean layerDataRequired) {
        this.layerDataRequired = layerDataRequired;
    }

    public AbstractCardChannelLayer(T layerData) throws IllegalArgumentException {
        this.layerDataRequired = true;
        this.setLayerData(layerData);
    }

    private boolean checkCardCommunication(CardCommunication cardCommunication, Boolean finished, int phase) {
        if (cardCommunication == null) {
            throw new IllegalArgumentException("card communication not permitted as null");
        }
        if (this.layerDataRequired && this.layerData == null) {
            return this.endWithError(cardCommunication, new IllegalStateException("layer in illegal state, required layer data not present"));
        }
        if (cardCommunication.getPhase() != phase) {
            return this.endWithError(cardCommunication, new IllegalArgumentException("card communication not in expected phase"));
        }
        if (finished != null && cardCommunication.isFinished() != finished.booleanValue()) {
            return this.endWithError(cardCommunication, new IllegalArgumentException("card communication not at expected finished state"));
        }
        if (phase == 0) {
            return this.checkCardCommunicationPreparePhase(cardCommunication);
        }
        return this.checkCardCommunicationPostPhase(cardCommunication);
    }

    private boolean endWithError(CardCommunication cardCommunication, Throwable throwable) {
        cardCommunication.setThrowable(throwable);
        cardCommunication.setFinished(true);
        cardCommunication.setPhase(1);
        return true;
    }

    private boolean checkCardCommunicationPostPhase(CardCommunication cardCommunication) {
        ResponseAPDU response = cardCommunication.getResponse();
        Throwable throwable = cardCommunication.getThrowable();
        if (response == null && throwable == null) {
            return this.endWithError(cardCommunication, new IllegalArgumentException("response and throwable cannot be both null at post phase"));
        }
        return this.checkCardCommunicationPreparePhase(cardCommunication);
    }

    private boolean checkCardCommunicationPreparePhase(CardCommunication cardCommunication) {
        CommandAPDU[] commands = cardCommunication.getCommands();
        if (commands == null) {
            return this.endWithError(cardCommunication, new IllegalArgumentException("commands of card communication not permitted as null"));
        }
        if (commands.length < 1) {
            return this.endWithError(cardCommunication, new IllegalArgumentException("commands of card communication not permitted as empty array"));
        }
        for (int i = 0; i < commands.length; ++i) {
            if (commands[i] == null) {
                return this.endWithError(cardCommunication, new IllegalArgumentException("commands of card communication not permitted as null"));
            }
            if (commands[i].getLength() >= 4) continue;
            return this.endWithError(cardCommunication, new IllegalArgumentException("commands of card communication not permitted as incomplete commands, at least 4 byte commands expected"));
        }
        return false;
    }

    protected abstract void checkLayerDataValid(T var1) throws IllegalArgumentException;

    protected abstract void fromCardInt(CardCommunication var1);

    protected abstract void toCardInt(CardCommunication var1);

    protected abstract void toCardVerifiedInt(CardCommunication var1, CHVControl var2, CHVDialog var3);

    @Override
    public final void fromCard(CardCommunication cardCommunication) throws IllegalArgumentException {
        if (this.checkCardCommunication(cardCommunication, false, 1)) {
            return;
        }
        try {
            this.fromCardInt(cardCommunication);
        }
        catch (Throwable t) {
            cardCommunication.setFinished(true);
            cardCommunication.setThrowable(t);
            cardCommunication.setPhase(1);
        }
    }

    @Override
    public T getLayerData() {
        return this.layerData;
    }

    @Override
    public final synchronized void setLayerData(T layerData) throws IllegalArgumentException, IllegalStateException {
        if (layerData == null) {
            throw new IllegalArgumentException("layer data not permitted as null");
        }
        if (this.layerData != null) {
            throw new IllegalStateException("layer data already set");
        }
        this.checkLayerDataValid(layerData);
        this.layerData = layerData;
    }

    @Override
    public final void toCard(CardCommunication cardCommunication) throws IllegalArgumentException {
        if (this.checkCardCommunication(cardCommunication, false, 0)) {
            return;
        }
        try {
            this.toCardInt(cardCommunication);
        }
        catch (Throwable t) {
            cardCommunication.setFinished(true);
            cardCommunication.setThrowable(t);
            cardCommunication.setPhase(1);
        }
    }

    @Override
    public final void toCardVerified(CardCommunication cardCommunication, CHVControl control, CHVDialog dialog) throws IllegalArgumentException {
        if (this.checkCardCommunication(cardCommunication, false, 0)) {
            return;
        }
        try {
            this.toCardVerifiedInt(cardCommunication, control, dialog);
        }
        catch (Throwable t) {
            cardCommunication.setFinished(true);
            cardCommunication.setThrowable(t);
            cardCommunication.setPhase(1);
        }
    }

    public final String toString() {
        return super.toString() + "(LayerDataRequired: " + this.layerDataRequired + ", LayerData: " + this.layerData + ")";
    }

    @Override
    public boolean isLayerDataRequired() {
        return this.layerDataRequired;
    }
}

