/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.channel;

import de.bos_bremen.gov2.jca_provider.ocf.channel.CardChannelLayer;
import de.bos_bremen.gov2.jca_provider.ocf.channel.CardCommunication;
import de.bos_bremen.gov2.jca_provider.ocf.channel.impl.CardCommunicationImpl;
import java.util.List;
import java.util.Vector;
import opencard.core.service.CHVDialog;
import opencard.core.service.CardChannel;
import opencard.core.service.CardServiceInvalidCredentialException;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.terminal.CHVControl;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;

public class ChannelCommunicationModifier {
    private CardChannel channel = null;
    private List<CardChannelLayer<?>> layerList = new Vector();

    public ResponseAPDU sendCommandAPDU(CommandAPDU cmdAPDU) throws InvalidCardChannelException, CardTerminalException {
        CardCommunicationImpl cc = new CardCommunicationImpl(cmdAPDU);
        int i = 0;
        for (i = 0; !cc.isFinished() && cc.getPhase() == 0 && i < this.layerList.size(); ++i) {
            this.layerList.get(i).toCard(cc);
        }
        if (cc.getPhase() == 0) {
            CommandAPDU[] commands = cc.getCommands();
            for (int j = 0; j < commands.length; ++j) {
                try {
                    ResponseAPDU response = this.channel.sendCommandAPDU(commands[j]);
                    cc.setResponse(response);
                    continue;
                }
                catch (Throwable t) {
                    cc.setThrowable(t);
                    break;
                }
            }
            cc.setFinished(false);
            cc.setPhase(1);
        }
        if (!(cc.isFinished() || cc.getResponse() == null && cc.getThrowable() == null)) {
            for (int j = i; !cc.isFinished() && j >= 0; --j) {
                this.layerList.get(j).fromCard(cc);
            }
        } else {
            throw new CardTerminalException("communication failed - unknown internal implementation error, communication finished and result is null");
        }
        if (cc.getThrowable() != null) {
            Throwable t = cc.getThrowable();
            if (InvalidCardChannelException.class.isInstance(t)) {
                throw (InvalidCardChannelException)t;
            }
            if (CardTerminalException.class.isInstance(t)) {
                throw (CardTerminalException)t;
            }
            CardTerminalException cte = new CardTerminalException("communication failed");
            cte.initCause(t);
            throw cte;
        }
        return cc.getResponse();
    }

    public final ResponseAPDU sendVerifiedAPDU(CommandAPDU command, CHVControl control, CHVDialog dialog) throws InvalidCardChannelException, CardTerminalException, CardServiceInvalidCredentialException {
        CardCommunication cc = null;
        int i = 0;
        for (i = 0; !cc.isFinished() && cc.getPhase() == 0 && i < this.layerList.size(); ++i) {
            this.layerList.get(i).toCardVerified(cc, control, dialog);
        }
        if (cc.getPhase() == 0) {
            CommandAPDU[] commands = cc.getCommands();
            for (int j = 0; j < commands.length; ++j) {
                try {
                    ResponseAPDU response = this.channel.sendVerifiedAPDU(command, control, dialog);
                    cc.setResponse(response);
                    continue;
                }
                catch (Throwable t) {
                    cc.setThrowable(t);
                    break;
                }
            }
            cc.setFinished(false);
            cc.setPhase(1);
        }
        if (!(cc.isFinished() || cc.getResponse() == null && cc.getThrowable() == null)) {
            for (int j = i; !cc.isFinished() && j >= 0; --j) {
                this.layerList.get(j).fromCard(cc);
            }
        } else {
            throw new CardTerminalException("communication failed - unknown internal implementation error, communication finished and result is null");
        }
        if (cc.getThrowable() != null) {
            Throwable t = cc.getThrowable();
            if (InvalidCardChannelException.class.isInstance(t)) {
                throw (InvalidCardChannelException)t;
            }
            if (CardTerminalException.class.isInstance(t)) {
                throw (CardTerminalException)t;
            }
            CardTerminalException cte = new CardTerminalException("communication failed");
            cte.initCause(t);
            throw cte;
        }
        return cc.getResponse();
    }

    public boolean add(CardChannelLayer<?> layer) throws IllegalArgumentException {
        if (layer == null) {
            throw new IllegalArgumentException("null not permitted");
        }
        return this.layerList.add(layer);
    }

    public void add(int index, CardChannelLayer<?> layer) throws IllegalArgumentException {
        if (layer == null) {
            throw new IllegalArgumentException("null not permitted");
        }
        if (index < 0) {
            throw new IllegalArgumentException("illegal index - index greater equals 0 permitted only");
        }
        if (index > this.layerList.size()) {
            throw new IllegalArgumentException("illegal index - index exceeds count of present layers");
        }
        this.layerList.add(index, layer);
    }

    public void clearLayer() {
        this.layerList.clear();
    }

    public boolean hasLayer() {
        return !this.layerList.isEmpty();
    }

    public boolean remove(CardChannelLayer<?> layer) {
        return this.layerList.remove(layer);
    }

    public CardChannelLayer<?> set(int index, CardChannelLayer<?> layer) throws IllegalArgumentException {
        if (index < 0) {
            throw new IllegalArgumentException("illegal index - index greater equals 0 permitted only");
        }
        if (index >= this.layerList.size()) {
            throw new IllegalArgumentException("illegal index - index exceeds count of present layers");
        }
        return this.layerList.set(index, layer);
    }

    public int getLayerCount() {
        return this.layerList.size();
    }
}

