/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.util;

import de.bos_bremen.common.asn1.OID;
import de.bos_bremen.common.constants.OIDConstants;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Signature;

public class SignatureHandler
implements OIDConstants {
    private SignatureHandler() {
    }

    public static Signature createSignature(OID oid) throws IllegalArgumentException, NoSuchAlgorithmException, NoSuchProviderException {
        Signature sig = null;
        if (oid == null) {
            throw new IllegalArgumentException("null not permitted");
        }
        if (oid.equals(OID_TA_ECDSA_SHA_1)) {
            sig = Signature.getInstance("SHA1withCVC-ECDSA", "BC");
        } else if (oid.equals(OID_TA_ECDSA_SHA_224)) {
            sig = Signature.getInstance("SHA224withCVC-ECDSA", "BC");
        } else if (oid.equals(OID_TA_ECDSA_SHA_256)) {
            sig = Signature.getInstance("SHA256withCVC-ECDSA", "BC");
        } else if (oid.equals(OID_TA_RSA_PSS_SHA_1)) {
            sig = Signature.getInstance("SHA1withRSA/PSS", "BC");
        } else if (oid.equals(OID_TA_RSA_PSS_SHA_256)) {
            sig = Signature.getInstance("SHA256withRSA/PSS", "BC");
        } else if (oid.equals(OID_TA_RSA_v1_5_SHA_1)) {
            sig = Signature.getInstance("SHA1withRSA", "BC");
        } else if (oid.equals(OID_TA_RSA_v1_5_SHA_256)) {
            sig = Signature.getInstance("SHA256withRSA", "BC");
        } else {
            throw new IllegalArgumentException("unknown OID");
        }
        return sig;
    }
}

