/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.util;

import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.ByteUtil;
import de.bos_bremen.common.asn1.DigestInfo;
import de.bos_bremen.common.asn1.HashAlgorithm;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;

public final class RSAPadding {
    private RSAPadding() {
    }

    public static byte[] padPKCS1PSS(PublicKey publicKey, String hashAlgorithm, byte[] hashValue) throws IllegalArgumentException {
        return RSAPadding.padPKCS1V15(publicKey, hashAlgorithm, hashValue);
    }

    public static byte[] padPKCS1V15(PublicKey publicKey, String hashAlgorithm, byte[] hashValue) throws IllegalArgumentException {
        if (RSAPublicKey.class.isInstance(publicKey)) {
            HashAlgorithm.Algorithm algorithm = HashAlgorithm.Algorithm.getAlgorithmByName(hashAlgorithm);
            AssertUtil.equals(algorithm.getHashLength(), hashValue.length, "hash length");
            byte[] digestInfo = new DigestInfo(algorithm, hashValue).getEncoded();
            int l = ((RSAPublicKey)RSAPublicKey.class.cast(publicKey)).getModulus().bitLength() / 8 - digestInfo.length;
            byte[] padding = new byte[l];
            Arrays.fill(padding, (byte)-1);
            padding[0] = 0;
            padding[1] = 1;
            padding[l - 1] = 0;
            return ByteUtil.combine(padding, digestInfo);
        }
        throw new IllegalArgumentException("only RSAPublicKey's are supported");
    }
}

