/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.util;

import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.ByteUtil;
import de.bos_bremen.common.HexUtil;
import de.bos_bremen.common.asn1.ASN1;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.cards.APDUCommands;
import de.bos_bremen.gov2.jca_provider.ocf.cards.CardChannelManager;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import java.io.IOException;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import opencard.core.service.CardChannel;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PKCS15PinDataUtil {
    private static final Log LOG = LogFactory.getLog(PKCS15PinDataUtil.class);
    private Map<BigInteger, ASN1> pinInfoMap = new HashMap<BigInteger, ASN1>();
    private GovCS cardService = null;

    public PKCS15PinDataUtil(GovCS cs) throws IllegalArgumentException {
        AssertUtil.notNull(cs, "card service");
        this.cardService = cs;
    }

    private void storePinData(ASN1 authObject) throws IOException, IllegalArgumentException {
        AssertUtil.notNull(authObject, "ASN.1 of Authentication Object");
        ASN1 pinAttrib = null;
        byte[] completePinPath = null;
        byte[] pinPath = null;
        try {
            pinAttrib = new ASN1(authObject.getChildElementsByDTagBytes(new byte[]{-95})[0].getValue());
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IOException("pin path could not be determined");
        }
        try {
            ASN1 seq = pinAttrib.getChildElementsByTag((short)48)[0];
            pinPath = seq.getChildElements()[0].getValue();
            if (pinPath[0] == 63 && pinPath[1] == 0) {
                pinPath = ByteUtil.subbytes(pinPath, 2);
            }
        }
        catch (ArrayIndexOutOfBoundsException seq) {
            // empty catch block
        }
        try {
            byte[] pinRefBytes = pinAttrib.getChildElementsByDTagBytes(new byte[]{-128})[0].getValue();
            byte pinID = pinRefBytes[pinRefBytes.length - 1];
            completePinPath = ByteUtil.combine(pinPath, new byte[]{pinID});
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IOException("pin path could not be determined");
        }
        this.pinInfoMap.put(new BigInteger(completePinPath), authObject);
    }

    private static int extractMinPinLengthInt(ASN1 authObject) throws IOException, IllegalArgumentException {
        AssertUtil.notNull(authObject, "pin data object");
        try {
            ASN1 pinAttrib = new ASN1(authObject.getChildElementsByDTagBytes(new byte[]{-95})[0].getValue());
            return new BigInteger(pinAttrib.getChildElementsByTag((short)2)[0].getValue()).intValue();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IOException("data not available", e);
        }
        catch (NumberFormatException e) {
            throw new IOException("data not available", e);
        }
    }

    private static int extractMaxPinLengthInt(ASN1 authObject) throws IOException, IllegalArgumentException {
        AssertUtil.notNull(authObject, "pin data object");
        try {
            ASN1 pinAttrib = new ASN1(authObject.getChildElementsByDTagBytes(new byte[]{-95})[0].getValue());
            ASN1[] integerChildren = pinAttrib.getChildElementsByTag((short)2);
            ASN1 maxLengthChild = integerChildren[1];
            if (integerChildren.length > 2) {
                maxLengthChild = integerChildren[2];
            }
            return new BigInteger(maxLengthChild.getValue()).intValue();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IOException("data not available", e);
        }
        catch (NumberFormatException e) {
            throw new IOException("data not available", e);
        }
    }

    private ASN1 searchPinData(OCFCertificateInfo info) throws IllegalArgumentException {
        AssertUtil.notNull(info, "certificate info");
        AssertUtil.notNull(info.getPin(), "pin of certificate info");
        byte[] pinID = new byte[]{info.getPin().getPinID()};
        byte[] directory = null;
        try {
            directory = info.getPin().getParentApplication().getFileEntry().getDirectory().reference;
            if (directory[0] == 63 && directory[1] == 0) {
                directory = ByteUtil.subbytes(directory, 2);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        byte[] completePinPath = ByteUtil.combine(directory, pinID);
        ASN1 pinData = this.pinInfoMap.get(new BigInteger(completePinPath));
        if (pinData == null) {
            pinData = this.pinInfoMap.get(new BigInteger(pinID));
        }
        return pinData;
    }

    public Integer getMinPINLength(OCFCertificateInfo info) throws IllegalArgumentException {
        AssertUtil.notNull(info, "certificate info");
        ASN1 pinData = this.searchPinData(info);
        if (pinData != null) {
            try {
                return PKCS15PinDataUtil.extractMinPinLengthInt(pinData);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public Integer getMaxPINLength(OCFCertificateInfo info) throws IllegalArgumentException {
        AssertUtil.notNull(info, "certificate info");
        ASN1 pinData = this.searchPinData(info);
        if (pinData != null) {
            try {
                return PKCS15PinDataUtil.extractMaxPinLengthInt(pinData);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readPKCS15PinData() {
        CardChannelManager cardChannelManager = new CardChannelManager();
        try {
            CommandAPDU cmd = null;
            ResponseAPDU res = null;
            CardChannel cc = cardChannelManager.init(this.cardService);
            cmd = new CommandAPDU(HexUtil.parse("00 a4 04 0c 0c a0 00 00 00 63 50 4b 43 53 2d 31 35"));
            LOG.debug((Object)("CMD : " + HexUtil.hexify(cmd.getBuffer())));
            res = cc.sendCommandAPDU(cmd);
            LOG.debug((Object)("RES : " + HexUtil.hexify(res.getBuffer())));
            cmd = new CommandAPDU(HexUtil.parse("00 a4 02 0c 02 50 31"));
            LOG.debug((Object)("CMD : " + HexUtil.hexify(cmd.getBuffer())));
            res = cc.sendCommandAPDU(cmd);
            LOG.debug((Object)("RES : " + HexUtil.hexify(res.getBuffer())));
            cmd = APDUCommands.createReadBinaryCommand(0, 0);
            LOG.debug((Object)("CMD : " + HexUtil.hexify(cmd.getBuffer())));
            res = cc.sendCommandAPDU(cmd);
            LOG.debug((Object)("RES : " + HexUtil.hexify(res.getBuffer())));
            ASN1 seq = new ASN1(48, res.data());
            ASN1 innerSeq = new ASN1(seq.getChildElementsByDTagBytes(new byte[]{-88})[0].getValue());
            byte[] pathBytes = innerSeq.getChildElements()[0].getValue();
            cmd = new CommandAPDU(ByteUtil.combine(HexUtil.parse("00 a4 08 0c"), ByteUtil.combine(new byte[]{(byte)pathBytes.length}, pathBytes)));
            LOG.debug((Object)("CMD : " + HexUtil.hexify(cmd.getBuffer())));
            res = cc.sendCommandAPDU(cmd);
            LOG.debug((Object)("RES : " + HexUtil.hexify(res.getBuffer())));
            if (res.sw() != 36864) {
                cmd = new CommandAPDU(ByteUtil.combine(HexUtil.parse("00 a4 09 0c"), ByteUtil.combine(new byte[]{(byte)pathBytes.length}, pathBytes)));
                LOG.debug((Object)("CMD : " + HexUtil.hexify(cmd.getBuffer())));
                res = cc.sendCommandAPDU(cmd);
                LOG.debug((Object)("RES : " + HexUtil.hexify(res.getBuffer())));
            }
            cmd = APDUCommands.createReadBinaryCommand(0, 0);
            LOG.debug((Object)("CMD : " + HexUtil.hexify(cmd.getBuffer())));
            res = cc.sendCommandAPDU(cmd);
            LOG.debug((Object)("RES : " + HexUtil.hexify(res.getBuffer())));
            if (res.sw() == 36864) {
                ASN1 completeSeq = new ASN1(48, res.data());
                for (ASN1 authObject : completeSeq.getChildElementsByTag((short)48)) {
                    ASN1 commonAttrib = authObject.getChildElementsByTag((short)48)[0];
                    String pinName = new String(commonAttrib.getChildElements()[0].getValue());
                    if (!pinName.contains("PIN")) continue;
                    this.storePinData(authObject);
                }
            } else {
                int i = 0;
                while (i != -1) {
                    cmd = new CommandAPDU(HexUtil.parse("00 b2 " + HexUtil.hexify(++i) + " 00 00"));
                    LOG.debug((Object)("CMD : " + HexUtil.hexify(cmd.getBuffer())));
                    res = cc.sendCommandAPDU(cmd);
                    LOG.debug((Object)("RES : " + HexUtil.hexify(res.getBuffer())));
                    if (res.sw() != 36864) {
                        i = -1;
                        continue;
                    }
                    ASN1 authObject = new ASN1(new ASN1(res.data()).getValue());
                    ASN1 commonAttrib = authObject.getChildElementsByTag((short)48)[0];
                    String pinName = new String(commonAttrib.getChildElements()[0].getValue());
                    if (!pinName.contains("PIN")) continue;
                    this.storePinData(authObject);
                }
            }
            cmd = new CommandAPDU(HexUtil.parse("00 a4 00 0c"));
            LOG.debug((Object)("CMD : " + HexUtil.hexify(cmd.getBuffer())));
            res = cc.sendCommandAPDU(cmd);
            LOG.debug((Object)("RES : " + HexUtil.hexify(res.getBuffer())));
        }
        catch (Throwable t) {
            LOG.error((Object)"", t);
        }
        finally {
            cardChannelManager.destroy();
        }
    }
}

