/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.util;

import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.gov2.jca_provider.CipherNotYetInitializedException;
import de.bos_bremen.gov2.jca_provider.CipherOperationCancelledException;
import de.bos_bremen.gov2.jca_provider.CipherPINInputCancelledException;
import de.bos_bremen.gov2.jca_provider.CipherPINInputTimeoutException;
import de.bos_bremen.gov2.jca_provider.CipherPINInputTooLongException;
import de.bos_bremen.gov2.jca_provider.CipherPINInputTooShortException;
import de.bos_bremen.gov2.jca_provider.CipherPinRelatedException;
import de.bos_bremen.gov2.jca_provider.CipherRetryCounterExpiredException;
import de.bos_bremen.gov2.jca_provider.CipherWrongPINException;
import de.bos_bremen.gov2.jca_provider.KeyAgreementPinRelatedException;
import de.bos_bremen.gov2.jca_provider.SignatureNotYetInitializedException;
import de.bos_bremen.gov2.jca_provider.SignatureOperationCancelledException;
import de.bos_bremen.gov2.jca_provider.SignaturePINInputCancelledException;
import de.bos_bremen.gov2.jca_provider.SignaturePINInputTimeoutException;
import de.bos_bremen.gov2.jca_provider.SignaturePINInputTooLongException;
import de.bos_bremen.gov2.jca_provider.SignaturePINInputTooShortException;
import de.bos_bremen.gov2.jca_provider.SignaturePinRelatedException;
import de.bos_bremen.gov2.jca_provider.SignatureRetryCounterExpiredException;
import de.bos_bremen.gov2.jca_provider.SignatureWrongPINException;
import de.bos_bremen.gov2.jca_provider.VerifyNotYetInitializedException;
import de.bos_bremen.gov2.jca_provider.VerifyOperationCancelledException;
import de.bos_bremen.gov2.jca_provider.VerifyPINInputCancelledException;
import de.bos_bremen.gov2.jca_provider.VerifyPINInputTimeoutException;
import de.bos_bremen.gov2.jca_provider.VerifyPINInputTooLongException;
import de.bos_bremen.gov2.jca_provider.VerifyPINInputTooShortException;
import de.bos_bremen.gov2.jca_provider.VerifyPinRelatedException;
import de.bos_bremen.gov2.jca_provider.VerifyRetryCounterExpiredException;
import de.bos_bremen.gov2.jca_provider.VerifyWrongPINException;
import de.bos_bremen.gov2.jca_provider.ocf.NotYetInitializedException;
import de.bos_bremen.gov2.jca_provider.ocf.OCFPinRelatedException;
import de.bos_bremen.gov2.jca_provider.ocf.OperationCancelledException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputCancelledException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputTimeoutException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputTooLongException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputTooShortException;
import de.bos_bremen.gov2.jca_provider.ocf.RetryCounterExpiredException;
import de.bos_bremen.gov2.jca_provider.ocf.WrongPinException;

public class CardErrorUtil {
    public static final int ISO7816_4_PIN_BLOCKED = 27011;
    public static final int ISO7816_4_RETRIES_DELIVERED = 25536;
    public static final int ISO7816_4_RETRIES_DELIVERED_MASK = 65520;
    public static final int ISO7816_4_RETRIES_MASK = 15;
    public static final int NO_RETRIES_LEFT = 0;
    public static final int RETRIES_NOT_DELIVERED = 25344;
    public static final int UNKNOWN_RETRIES = -1;

    public static int getErrorCodeForRetries(int retries) {
        if (retries == -1) {
            return 25344;
        }
        if (retries < 0) {
            throw new IllegalArgumentException("retries expected as integer greater equals 0");
        }
        if (retries > 15) {
            throw new IllegalArgumentException("retries expected as integer less equals 15");
        }
        return 0x63C0 | retries;
    }

    public static int getRetries(CipherNotYetInitializedException e) throws IllegalArgumentException {
        AssertUtil.notNull(e, "exception");
        return -1;
    }

    public static int getRetries(CipherOperationCancelledException e) throws IllegalArgumentException {
        AssertUtil.notNull(e, "exception");
        return -1;
    }

    public static int getRetries(CipherPINInputCancelledException e) throws IllegalArgumentException {
        AssertUtil.notNull(e, "exception");
        return -1;
    }

    public static int getRetries(CipherPINInputTimeoutException e) throws IllegalArgumentException {
        AssertUtil.notNull(e, "exception");
        return -1;
    }

    public static int getRetries(CipherPINInputTooLongException e) throws IllegalArgumentException {
        AssertUtil.notNull(e, "exception");
        return -1;
    }

    public static int getRetries(CipherPINInputTooShortException e) throws IllegalArgumentException {
        AssertUtil.notNull(e, "exception");
        return -1;
    }

    public static int getRetries(CipherPinRelatedException e) throws IllegalArgumentException {
        AssertUtil.notNull(e, "exception");
        return CardErrorUtil.getRetries(e.getErrorCode());
    }

    public static int getRetries(CipherRetryCounterExpiredException e) throws IllegalArgumentException {
        AssertUtil.notNull(e, "exception");
        return 0;
    }

    public static int getRetries(CipherWrongPINException e) throws IllegalArgumentException {
        AssertUtil.notNull(e, "exception");
        return CardErrorUtil.getRetries(e.getErrorCode());
    }

    public static int getRetries(KeyAgreementPinRelatedException e) throws IllegalArgumentException {
        AssertUtil.notNull(e, "exception");
        return CardErrorUtil.getRetries(e.getErrorCode());
    }

    public static int getRetries(int errorCode) {
        if (errorCode == 25344) {
            return -1;
        }
        if ((errorCode & 0xFFF0) == 25536) {
            return errorCode & 0xF;
        }
        if (errorCode == 27011) {
            return 0;
        }
        return -1;
    }

    public static int getRetries(NotYetInitializedException e) throws IllegalArgumentException {
        AssertUtil.notNull(e, "exception");
        return CardErrorUtil.getRetries(e.getErrorCode());
    }

    public static int getRetries(OCFPinRelatedException e) throws IllegalArgumentException {
        AssertUtil.notNull(e, "exception");
        return CardErrorUtil.getRetries(e.getErrorCode());
    }

    public static int getRetries(OperationCancelledException e) throws IllegalArgumentException {
        AssertUtil.notNull(e, "exception");
        return -1;
    }

    public static int getRetries(PinInputCancelledException e) throws IllegalArgumentException {
        AssertUtil.notNull(e, "exception");
        return -1;
    }

    public static int getRetries(PinInputTimeoutException e) throws IllegalArgumentException {
        AssertUtil.notNull(e, "exception");
        return -1;
    }

    public static int getRetries(PinInputTooLongException e) throws IllegalArgumentException {
        AssertUtil.notNull(e, "exception");
        return -1;
    }

    public static int getRetries(PinInputTooShortException e) throws IllegalArgumentException {
        AssertUtil.notNull(e, "exception");
        return -1;
    }

    public static int getRetries(RetryCounterExpiredException e) throws IllegalArgumentException {
        AssertUtil.notNull(e, "exception");
        return 0;
    }

    public static int getRetries(SignatureNotYetInitializedException e) throws IllegalArgumentException {
        AssertUtil.notNull(e, "exception");
        return -1;
    }

    public static int getRetries(SignatureOperationCancelledException e) throws IllegalArgumentException {
        AssertUtil.notNull(e, "exception");
        return -1;
    }

    public static int getRetries(SignaturePINInputCancelledException e) throws IllegalArgumentException {
        AssertUtil.notNull(e, "exception");
        return -1;
    }

    public static int getRetries(SignaturePINInputTimeoutException e) throws IllegalArgumentException {
        AssertUtil.notNull(e, "exception");
        return -1;
    }

    public static int getRetries(SignaturePINInputTooLongException e) throws IllegalArgumentException {
        AssertUtil.notNull(e, "exception");
        return -1;
    }

    public static int getRetries(SignaturePINInputTooShortException e) throws IllegalArgumentException {
        AssertUtil.notNull(e, "exception");
        return -1;
    }

    public static int getRetries(SignaturePinRelatedException e) throws IllegalArgumentException {
        AssertUtil.notNull(e, "exception");
        return CardErrorUtil.getRetries(e.getErrorCode());
    }

    public static int getRetries(SignatureRetryCounterExpiredException e) throws IllegalArgumentException {
        AssertUtil.notNull(e, "exception");
        return 0;
    }

    public static int getRetries(VerifyWrongPINException e) throws IllegalArgumentException {
        AssertUtil.notNull(e, "exception");
        return CardErrorUtil.getRetries(e.getErrorCode());
    }

    public static int getRetries(VerifyNotYetInitializedException e) throws IllegalArgumentException {
        AssertUtil.notNull(e, "exception");
        return -1;
    }

    public static int getRetries(VerifyOperationCancelledException e) throws IllegalArgumentException {
        AssertUtil.notNull(e, "exception");
        return -1;
    }

    public static int getRetries(VerifyPINInputCancelledException e) throws IllegalArgumentException {
        AssertUtil.notNull(e, "exception");
        return -1;
    }

    public static int getRetries(VerifyPINInputTimeoutException e) throws IllegalArgumentException {
        AssertUtil.notNull(e, "exception");
        return -1;
    }

    public static int getRetries(VerifyPINInputTooLongException e) throws IllegalArgumentException {
        AssertUtil.notNull(e, "exception");
        return -1;
    }

    public static int getRetries(VerifyPINInputTooShortException e) throws IllegalArgumentException {
        AssertUtil.notNull(e, "exception");
        return -1;
    }

    public static int getRetries(VerifyPinRelatedException e) throws IllegalArgumentException {
        AssertUtil.notNull(e, "exception");
        return CardErrorUtil.getRetries(e.getErrorCode());
    }

    public static int getRetries(VerifyRetryCounterExpiredException e) throws IllegalArgumentException {
        AssertUtil.notNull(e, "exception");
        return 0;
    }

    public static int getRetries(SignatureWrongPINException e) throws IllegalArgumentException {
        AssertUtil.notNull(e, "exception");
        return CardErrorUtil.getRetries(e.getErrorCode());
    }

    public static int getRetries(WrongPinException e) throws IllegalArgumentException {
        AssertUtil.notNull(e, "exception");
        return CardErrorUtil.getRetries(e.getErrorCode());
    }

    private CardErrorUtil() {
    }
}

