/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.util;

import de.bos_bremen.common.ByteUtil;
import java.util.Arrays;

public class ByteMatcher {
    private byte[][] matches = null;
    private byte[] significantBitsMask = null;
    private int length = 0;

    public ByteMatcher(byte[] matches) throws IllegalArgumentException {
        this(new byte[][]{matches}, null);
    }

    public ByteMatcher(byte[][] matches) throws IllegalArgumentException {
        this(matches, null);
    }

    public ByteMatcher(byte[] matches, byte[] significantBitsMask) throws IllegalArgumentException {
        this(new byte[][]{matches}, significantBitsMask);
    }

    public ByteMatcher(byte[][] matches, byte[] significantBitsMask) throws IllegalArgumentException {
        int i;
        if (matches == null) {
            throw new IllegalArgumentException("matches not permitted as null");
        }
        if (matches.length == 0) {
            throw new IllegalArgumentException("matches not permitted as empty array");
        }
        if (significantBitsMask != null && significantBitsMask.length == 0) {
            throw new IllegalArgumentException("when specified empty mask for significant bits not permitted as empty array");
        }
        this.length = 0;
        for (i = 0; i < matches.length; ++i) {
            if (matches[i] == null) {
                throw new IllegalArgumentException("null entry in matches not permitted");
            }
            if (matches[i].length == 0) {
                throw new IllegalArgumentException("empty entry in matches not permitted");
            }
            if (this.length == 0) {
                this.length = matches[i].length;
            }
            if (this.length == matches[i].length) continue;
            throw new IllegalArgumentException("entries with different length in matches not permitted");
        }
        this.matches = matches;
        if (significantBitsMask != null && significantBitsMask.length != this.length) {
            throw new IllegalArgumentException("significant bit mask with different length as entries of  matches not permitted");
        }
        if (significantBitsMask != null) {
            for (i = 0; i < matches.length; ++i) {
                ByteUtil.and(matches[i], significantBitsMask);
            }
        }
        this.significantBitsMask = significantBitsMask;
    }

    public boolean match(byte[] bytes) {
        boolean result = false;
        if (bytes != null && this.length == bytes.length) {
            byte[] search = bytes;
            if (this.significantBitsMask != null) {
                ByteUtil.and(bytes, this.significantBitsMask);
            }
            for (int i = 0; i < this.matches.length; ++i) {
                if (!Arrays.equals(search, this.matches[i])) continue;
                result = true;
                break;
            }
        }
        return result;
    }
}

