/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.util;

import de.bos_bremen.basecard.common.pin.PinModifyParameters;
import de.bos_bremen.basecard.common.pin.PinVerifyParameters;
import de.bos_bremen.basecard.common.pin.coding.PinEncoder;
import de.bos_bremen.common.system.LanguageEnum;
import de.bos_bremen.common.system.LanguageUtil;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.cards.PinInformationProvider;

public class BaseCardUtil {
    private static final int DEFAULT_FIRST_TIMEOUT = 30;
    private static final int DEFAULT_SECOND_TIMEOUT = 10;

    public static PinVerifyParameters createVerifyParameters(OCFCertificateInfo info, PinInformationProvider pip, boolean usesCCID, int maxL) {
        PinEncoder encoder = pip.getPinEncoder(info);
        if (PinEncoder.ENCODER_FORMAT_2_PIN_BLOCK == encoder) {
            maxL = 12;
        }
        LanguageEnum lang = LanguageUtil.getCurrentLanguage();
        PinVerifyParameters pvp = new PinVerifyParameters(info.getPinID(), encoder, (Integer)pip.getPasswordBlockLength(info), (Byte)pip.getPasswordBlockFiller(info), encoder == PinEncoder.ENCODER_FORMAT_1_PIN_BLOCK || encoder == PinEncoder.ENCODER_FORMAT_2_PIN_BLOCK, Math.max(pip.getMinPINLength(info), 4), maxL, 30, 10, lang, usesCCID);
        return pvp;
    }

    public static PinModifyParameters createPinModifyParameters(OCFCertificateInfo info, PinInformationProvider pip, byte[] firstPin, boolean usesCCID, int min, int max) {
        PinEncoder encoder = pip.getPinEncoder(info);
        LanguageEnum lang = LanguageUtil.getCurrentLanguage();
        PinModifyParameters pmp = new PinModifyParameters(info.getPinID(), encoder, (Integer)pip.getPasswordBlockLength(info), (Byte)pip.getPasswordBlockFiller(info), encoder == PinEncoder.ENCODER_FORMAT_1_PIN_BLOCK || encoder == PinEncoder.ENCODER_FORMAT_2_PIN_BLOCK, min, max, 30, 10, lang, usesCCID, firstPin);
        return pmp;
    }
}

