/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.tcos;

import de.bos_bremen.gov2.jca_provider.ocf.FileEntry;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.cards.FileReference;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.KeyID;
import de.bos_bremen.gov2.jca_provider.ocf.cards.tcos.TCOSv2r3;
import de.bos_bremen.gov2.jca_provider.ocf.model.Card;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardApplication;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardFile;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardKey;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardObjectManager;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardPin;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardRegistry;
import de.bos_bremen.gov2.jca_provider.ocf.model.Disposeable;
import de.bos_bremen.gov2.jca_provider.ocf.model.Terminal;
import de.bos_bremen.gov2.jca_provider.ocf.model.Type;
import de.bos_bremen.gov2.jca_provider.ocf.model.TypedType;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardApplicationImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardFileImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardKeyImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectManagerImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectRegistryImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardPinImpl;
import opencard.core.util.HexString;

public class TCOSv2r3_SignTrust_PKS
extends TCOSv2r3 {
    static final String EF_GDO_ISSUER_CONSTANT = "5a 0a 89 49 01 72 00";
    private static final byte[] HISTORICALS = HexString.parseHexString("00 64 05 60 02 03 31 80 90 00");

    @Override
    protected byte[] getHistoricals() {
        return HISTORICALS;
    }

    @Override
    protected String getIssuerConstant() {
        return EF_GDO_ISSUER_CONSTANT;
    }

    @Override
    protected boolean usesASN1HeaderWithAuthentify() {
        return true;
    }

    @Override
    public String getDisplayName() {
        return "SignTrust PKS (11, 11A, 12A) " + super.getDisplayName();
    }

    @Override
    protected Card createCardInt(Terminal terminal, int slotID) {
        long idOfCard = CARD_OBJECT_REGISTRY.createNewCardID();
        long idOfPinCH = -1L;
        long idOfMFApplication = 1000000L;
        CardApplication application01 = this.createSignApp(terminal, slotID, idOfCard, idOfMFApplication, idOfPinCH);
        CardApplication application02 = this.createAutApp(terminal, slotID, idOfCard, idOfMFApplication, idOfPinCH);
        CardApplication application03 = this.createEncApp(terminal, slotID, idOfCard, idOfMFApplication, idOfPinCH);
        FileReference dirRefMF = new FileReference(0, "3f00");
        FileEntry fileEntryMF = new FileEntry(dirRefMF, dirRefMF);
        CardObjectManagerImpl mfManager = new CardObjectManagerImpl(idOfMFApplication);
        mfManager.putApplication(application01);
        mfManager.putApplication(application02);
        mfManager.putApplication(application03);
        CardApplicationImpl mfApplication = new CardApplicationImpl("MF", idOfMFApplication, CardApplication.CardApplicationTypeEnum.UNKNOWN.getType(), fileEntryMF, (CardObjectManager)mfManager, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        CardImpl card = new CardImpl(this.getDisplayName() + "-" + String.valueOf(idOfCard), idOfCard, Card.CardTypeEnum.SIGNTRUST_DP_MEDIZON_10.getType(), super.getCard(), mfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance());
        return card;
    }

    private CardApplication createSignApp(Terminal terminal, int slotID, long idOfCard, long idOfMFApplication, long idOfPinCH) {
        long idOfApplication = 1000001L;
        long idOfPin01 = 2000001L;
        long idOfFile01 = 3000001L;
        long idOfFile02 = 3000002L;
        long idOfKey01 = 4000001L;
        KeyID k01 = new KeyID("81");
        byte pinID01 = -127;
        FileReference dirRefQSIGN = new FileReference(4, "d27600006601");
        FileReference cerRef01 = new FileReference(2, "c000");
        FileEntry fileEntry01 = new FileEntry(dirRefQSIGN, cerRef01);
        FileReference fileRef02 = new FileReference(2, "c00E");
        FileEntry fileEntry02 = new FileEntry(dirRefQSIGN, fileRef02);
        OCFCertificateInfo info01 = new OCFCertificateInfo(idOfCard, idOfPin01, idOfFile01, idOfKey01, OCFCertificateInfo.ChainEntry.USER, null, null);
        OCFCertificateInfo info02 = new OCFCertificateInfo(idOfCard, -1L, idOfFile02, -1L, OCFCertificateInfo.ChainEntry.ROOT, null, null);
        CardPinImpl pin01 = new CardPinImpl(Disposeable.NO_LOCK, "Signatur-PIN", idOfPin01, CardPin.CardPinTypeEnum.PIN.getType(), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID01, idOfKey01);
        CardFileImpl file01 = new CardFileImpl(Disposeable.NO_LOCK, "cerSig", idOfFile01, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey01);
        CardFileImpl file02 = new CardFileImpl(Disposeable.NO_LOCK, "cerCARoot", idOfFile02, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry02, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L, info02);
        CardKeyImpl key01 = new CardKeyImpl(Disposeable.NO_LOCK, "SignatureKey", idOfKey01, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.EUROPEAN_QUALIFIED_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.QUALIFIED_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.ACCREDITED_SIGNATURE_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.SIGNATURE.getType()}), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info01, idOfFile01, idOfPin01, k01);
        CardObjectManagerImpl manager = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl application = new CardApplicationImpl("d27600006601", idOfApplication, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.SIGNATURE.getType()}), fileEntry01, (CardObjectManager)manager, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        application.putPin(pin01);
        application.putFile(file01);
        application.putFile(file02);
        application.putKey(key01);
        return application;
    }

    private CardApplication createAutApp(Terminal terminal, int slotID, long idOfCard, long idOfMFApplication, long idOfPinCH) {
        long idOfApplication = 1000002L;
        long idOfPin01 = 2000002L;
        long idOfFile01 = 3000003L;
        long idOfKey01 = 4000002L;
        KeyID k01 = new KeyID("80");
        byte pinID01 = -127;
        FileReference dirRef = new FileReference(4, "df03");
        FileReference fileRef01 = new FileReference(2, "8320");
        FileEntry fileEntry01 = new FileEntry(dirRef, fileRef01);
        OCFCertificateInfo info01 = new OCFCertificateInfo(idOfCard, idOfPin01, idOfFile01, idOfKey01, OCFCertificateInfo.ChainEntry.USER, null, null);
        CardPinImpl pin01 = new CardPinImpl(Disposeable.NO_LOCK, "Authentisierungs-PIN", idOfPin01, CardPin.CardPinTypeEnum.PIN.getType(), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID01, idOfKey01);
        CardFileImpl file01 = new CardFileImpl(Disposeable.NO_LOCK, "cerAut", idOfFile01, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey01);
        CardKeyImpl key01 = new CardKeyImpl(Disposeable.NO_LOCK, "AuthenticationKey", idOfKey01, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_AUTHENTICATION.getType(), CardKey.CardKeyTypeEnum.AUTHENTICATION.getType(), CardKey.CardKeyTypeEnum.AUTHENTICATION_BY_ENCRYPTION.getType()}), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info01, idOfFile01, idOfPinCH, k01);
        CardObjectManagerImpl manager = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl application = new CardApplicationImpl("df03", idOfApplication, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.AUTHENTICATION.getType()}), fileEntry01, (CardObjectManager)manager, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        application.putPin(pin01);
        application.putFile(file01);
        application.putKey(key01);
        return application;
    }

    private CardApplication createEncApp(Terminal terminal, int slotID, long idOfCard, long idOfMFApplication, long idOfPinCH) {
        long idOfApplication = 1000003L;
        long idOfPin01 = 2000003L;
        long idOfFile01 = 3000004L;
        long idOfKey01 = 4000003L;
        KeyID k01 = new KeyID("80");
        byte pinID01 = -127;
        FileReference dirRefESIGN = new FileReference(4, "df02");
        FileReference cerRef01 = new FileReference(2, "8220");
        FileEntry fileEntry01 = new FileEntry(dirRefESIGN, cerRef01);
        OCFCertificateInfo info01 = new OCFCertificateInfo(idOfCard, idOfPin01, idOfFile01, idOfKey01, OCFCertificateInfo.ChainEntry.USER, null, null);
        CardPinImpl pin01 = new CardPinImpl(Disposeable.NO_LOCK, "Verschl\u00fcsselungs-PIN", idOfPin01, CardPin.CardPinTypeEnum.PIN.getType(), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID01, idOfKey01);
        CardFileImpl file01 = new CardFileImpl(Disposeable.NO_LOCK, "cerEncDec", idOfFile01, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey01);
        CardKeyImpl key01 = new CardKeyImpl(Disposeable.NO_LOCK, "DecryptionKey/EncryptionKey", idOfKey01, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_DECRYPTION.getType(), CardKey.CardKeyTypeEnum.DEFAULT_ENCRYPTION.getType(), CardKey.CardKeyTypeEnum.DECRYPTION.getType(), CardKey.CardKeyTypeEnum.ENCRYPTION.getType()}), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info01, idOfFile01, idOfPinCH, k01);
        CardObjectManagerImpl manager = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl application = new CardApplicationImpl("df02", idOfApplication, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.AUTHENTICATION.getType()}), fileEntry01, (CardObjectManager)manager, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        application.putPin(pin01);
        application.putFile(file01);
        application.putKey(key01);
        return application;
    }

    @Override
    public OCFCertificateInfo[] createCertificateInfos() {
        return new OCFCertificateInfo[]{new OCFCertificateInfo(new FileReference(4, "d27600006601"), new FileReference(2, "c000"), new KeyID("81"), -127, OCFCertificateInfo.ChainEntry.USER), new OCFCertificateInfo(new FileReference(4, "df03"), new FileReference(2, "8320"), new KeyID("80"), -127, OCFCertificateInfo.ChainEntry.USER), new OCFCertificateInfo(new FileReference(4, "df02"), new FileReference(2, "8220"), new KeyID("80"), -127, OCFCertificateInfo.ChainEntry.USER), new OCFCertificateInfo(new FileReference(4, "d27600006601"), new FileReference(2, "c00e"), null, 0, OCFCertificateInfo.ChainEntry.ROOT)};
    }
}

