/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.tcos;

import de.bos_bremen.gov2.jca_provider.ocf.FileEntry;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.cards.FileReference;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.KeyID;
import de.bos_bremen.gov2.jca_provider.ocf.cards.tcos.TCOSv2r3;
import de.bos_bremen.gov2.jca_provider.ocf.model.Card;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardApplication;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardFile;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardKey;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardObjectManager;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardPin;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardRegistry;
import de.bos_bremen.gov2.jca_provider.ocf.model.Disposeable;
import de.bos_bremen.gov2.jca_provider.ocf.model.Terminal;
import de.bos_bremen.gov2.jca_provider.ocf.model.Type;
import de.bos_bremen.gov2.jca_provider.ocf.model.TypedType;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardApplicationImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardFileImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardKeyImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectManagerImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectRegistryImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardPinImpl;
import opencard.core.util.HexString;

public class TCOSv2r3_Datev_PKS
extends TCOSv2r3 {
    static final String EF_GDO_ISSUER_CONSTANT = "5a 0a 89 49 01 72 90";
    private static final byte[][] HISTORICALS = new byte[][]{HexString.parseHexString("00 64 05 60 02 03 31 80 90 00")};
    private int historicalsIndex = -5;

    @Override
    protected String getIssuerConstant() {
        return EF_GDO_ISSUER_CONSTANT;
    }

    @Override
    protected byte[] getHistoricals() {
        return HISTORICALS[this.historicalsIndex];
    }

    @Override
    protected boolean usesASN1HeaderWithAuthentify() {
        return true;
    }

    @Override
    public String getDisplayName() {
        return "Datev PKS (8, 9) " + super.getDisplayName();
    }

    @Override
    protected Card createCardInt(Terminal terminal, int slotID) {
        long idOfCard = CARD_OBJECT_REGISTRY.createNewCardID();
        long idOfPinCH = 2000001L;
        long idOfMFApplication = 1000000L;
        CardApplication applicationQSIGN = this.createQSignApp(terminal, slotID, idOfCard, idOfMFApplication, idOfPinCH);
        CardApplication applicationESIGN = this.createEncAutApp(terminal, slotID, idOfCard, idOfMFApplication, idOfPinCH);
        byte pinID01 = 1;
        FileReference dirRefMF = new FileReference(0, "3f00");
        FileEntry fileEntryMF = new FileEntry(dirRefMF, dirRefMF);
        CardPinImpl pinCH = new CardPinImpl(Disposeable.NO_LOCK, "Authentisierungs-/Verschl\u00fcsselungs-PIN", idOfPinCH, CardPin.CardPinTypeEnum.PIN.getType(), fileEntryMF, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID01, new long[]{4000001L, 4000002L});
        CardObjectManagerImpl mfManager = new CardObjectManagerImpl(idOfMFApplication);
        mfManager.putApplication(applicationQSIGN);
        mfManager.putApplication(applicationESIGN);
        mfManager.putPin(pinCH);
        CardApplicationImpl mfApplication = new CardApplicationImpl("MF", idOfMFApplication, CardApplication.CardApplicationTypeEnum.UNKNOWN.getType(), fileEntryMF, (CardObjectManager)mfManager, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        CardImpl card = new CardImpl(this.getDisplayName() + "-" + String.valueOf(idOfCard), idOfCard, Card.CardTypeEnum.DATEV_10.getType(), super.getCard(), mfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance());
        return card;
    }

    private CardApplication createQSignApp(Terminal terminal, int slotID, long idOfCard, long idOfMFApplication, long idOfPinCH) {
        long idOfApplicationQSIGN = 1000003L;
        long idOfPin01 = 2000002L;
        long idOfFile01 = 3000001L;
        long idOfFile02 = 3000002L;
        long idOfFile03 = 3000003L;
        long idOfKey01 = 4000001L;
        KeyID k01 = new KeyID("00");
        byte pinID01 = -127;
        FileReference dirRefQSIGN = new FileReference(4, "d27600006601");
        FileReference cerRef01 = new FileReference(2, "c000");
        FileEntry fileEntry01 = new FileEntry(dirRefQSIGN, cerRef01);
        FileReference fileRef01 = new FileReference(2, "c008");
        FileEntry fileEntry02 = new FileEntry(dirRefQSIGN, fileRef01);
        FileReference fileRef03 = new FileReference(2, "b000");
        FileEntry fileEntry03 = new FileEntry(dirRefQSIGN, fileRef03);
        OCFCertificateInfo info01 = new OCFCertificateInfo(idOfCard, idOfPin01, idOfFile01, idOfKey01, OCFCertificateInfo.ChainEntry.USER, null, null);
        OCFCertificateInfo info02 = new OCFCertificateInfo(idOfCard, -1L, idOfFile02, -1L, OCFCertificateInfo.ChainEntry.CA, null, null);
        OCFCertificateInfo info03 = new OCFCertificateInfo(idOfCard, -1L, idOfFile03, -1L, OCFCertificateInfo.ChainEntry.ROOT, null, null);
        CardFileImpl file01 = new CardFileImpl(Disposeable.NO_LOCK, "cerSig", idOfFile01, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry01, idOfCard, idOfApplicationQSIGN, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey01);
        CardFileImpl file02 = new CardFileImpl(Disposeable.NO_LOCK, "cerCA", idOfFile02, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry02, idOfCard, idOfApplicationQSIGN, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L, info02);
        CardFileImpl file03 = new CardFileImpl(Disposeable.NO_LOCK, "cerCARoot", idOfFile03, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry03, idOfCard, idOfApplicationQSIGN, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L, info03);
        CardPinImpl pin01 = new CardPinImpl(Disposeable.NO_LOCK, "Signatur-PIN", idOfPin01, CardPin.CardPinTypeEnum.PIN.getType(), fileEntry01, idOfCard, idOfApplicationQSIGN, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID01, idOfKey01);
        CardKeyImpl key01 = new CardKeyImpl(Disposeable.NO_LOCK, "SignatureKey", idOfKey01, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.EUROPEAN_QUALIFIED_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.QUALIFIED_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.ACCREDITED_SIGNATURE_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.SIGNATURE.getType()}), fileEntry01, idOfCard, idOfApplicationQSIGN, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info01, idOfFile01, idOfPin01, k01);
        CardObjectManagerImpl managerQSIGN = new CardObjectManagerImpl(idOfApplicationQSIGN);
        CardApplicationImpl applicationQSIGN = new CardApplicationImpl("d27600006601", idOfApplicationQSIGN, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.SIGNATURE.getType()}), fileEntry01, (CardObjectManager)managerQSIGN, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        applicationQSIGN.putPin(pin01);
        applicationQSIGN.putFile(file01);
        applicationQSIGN.putFile(file02);
        applicationQSIGN.putFile(file03);
        applicationQSIGN.putKey(key01);
        return applicationQSIGN;
    }

    private CardApplication createEncAutApp(Terminal terminal, int slotID, long idOfCard, long idOfMFApplication, long idOfPinCH) {
        long idOfApplicationESIGN = 1000001L;
        long idOfFile01 = 3000004L;
        long idOfFile02 = 3000005L;
        long idOfKey01 = 4000002L;
        long idOfKey02 = 4000003L;
        KeyID k01 = new KeyID("81");
        KeyID k02 = new KeyID("82");
        FileReference dirRefESIGN = new FileReference(1, "df02");
        FileReference cerRef01 = new FileReference(2, "c200");
        FileEntry fileEntry01 = new FileEntry(dirRefESIGN, cerRef01);
        FileReference cerRef02 = new FileReference(2, "c500");
        FileEntry fileEntry02 = new FileEntry(dirRefESIGN, cerRef02);
        OCFCertificateInfo info01 = new OCFCertificateInfo(idOfCard, idOfPinCH, idOfFile01, idOfKey01, OCFCertificateInfo.ChainEntry.USER, null, null);
        OCFCertificateInfo info02 = new OCFCertificateInfo(idOfCard, idOfPinCH, idOfFile02, idOfKey02, OCFCertificateInfo.ChainEntry.USER, null, null);
        CardFileImpl file01 = new CardFileImpl(Disposeable.NO_LOCK, "cerEncDec", idOfFile01, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry01, idOfCard, idOfApplicationESIGN, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey01);
        CardKeyImpl key01 = new CardKeyImpl(Disposeable.NO_LOCK, "EncryptionKey/DecryptionKey", idOfKey01, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_DECRYPTION.getType(), CardKey.CardKeyTypeEnum.DEFAULT_ENCRYPTION.getType(), CardKey.CardKeyTypeEnum.DECRYPTION.getType(), CardKey.CardKeyTypeEnum.ENCRYPTION.getType()}), fileEntry01, idOfCard, idOfApplicationESIGN, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info01, idOfFile01, idOfPinCH, k01);
        CardFileImpl file02 = new CardFileImpl(Disposeable.NO_LOCK, "cerAut", idOfFile02, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry02, idOfCard, idOfApplicationESIGN, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey02);
        CardKeyImpl key02 = new CardKeyImpl(Disposeable.NO_LOCK, "AuthenticationKey", idOfKey02, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_AUTHENTICATION.getType(), CardKey.CardKeyTypeEnum.AUTHENTICATION.getType(), CardKey.CardKeyTypeEnum.AUTHENTICATION_BY_ENCRYPTION.getType()}), fileEntry02, idOfCard, idOfApplicationESIGN, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info02, idOfFile02, idOfPinCH, k02);
        CardObjectManagerImpl managerESIGN = new CardObjectManagerImpl(idOfApplicationESIGN);
        CardApplicationImpl applicationESIGN = new CardApplicationImpl("df02", idOfApplicationESIGN, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.DECRYPTION.getType(), CardApplication.CardApplicationTypeEnum.AUTHENTICATION.getType(), CardApplication.CardApplicationTypeEnum.ENCRYPTION.getType()}), fileEntry01, (CardObjectManager)managerESIGN, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        applicationESIGN.putFile(file01);
        applicationESIGN.putFile(file02);
        applicationESIGN.putKey(key01);
        applicationESIGN.putKey(key02);
        return applicationESIGN;
    }

    @Override
    public OCFCertificateInfo[] createCertificateInfos() {
        return new OCFCertificateInfo[]{new OCFCertificateInfo(new FileReference(4, "d27600006601"), new FileReference(2, "c000"), new KeyID("00"), -127, OCFCertificateInfo.ChainEntry.USER), new OCFCertificateInfo(new FileReference(1, "df02"), new FileReference(2, "c200"), new KeyID("81"), 1, OCFCertificateInfo.ChainEntry.USER), new OCFCertificateInfo(new FileReference(1, "df02"), new FileReference(2, "c500"), new KeyID("82"), 1, OCFCertificateInfo.ChainEntry.USER), new OCFCertificateInfo(new FileReference(4, "d27600006601"), new FileReference(2, "c008"), null, 0, OCFCertificateInfo.ChainEntry.CA), new OCFCertificateInfo(new FileReference(4, "d27600006601"), new FileReference(2, "b000"), null, 0, OCFCertificateInfo.ChainEntry.ROOT)};
    }
}

