/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.tcos;

import de.bos_bremen.gov2.jca_provider.ocf.FileEntry;
import de.bos_bremen.gov2.jca_provider.ocf.NotYetInitializedException;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.PinDeactivatedException;
import de.bos_bremen.gov2.jca_provider.ocf.ResponseCodeException;
import de.bos_bremen.gov2.jca_provider.ocf.RetryCounterExpiredException;
import de.bos_bremen.gov2.jca_provider.ocf.cards.APDUCommands;
import de.bos_bremen.gov2.jca_provider.ocf.cards.CardChannelManager;
import de.bos_bremen.gov2.jca_provider.ocf.cards.FileReference;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.KeyID;
import de.bos_bremen.gov2.jca_provider.ocf.model.Card;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardApplication;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardFile;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardKey;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardObjectManager;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardPin;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardRegistry;
import de.bos_bremen.gov2.jca_provider.ocf.model.Disposeable;
import de.bos_bremen.gov2.jca_provider.ocf.model.Terminal;
import de.bos_bremen.gov2.jca_provider.ocf.model.Type;
import de.bos_bremen.gov2.jca_provider.ocf.model.TypedType;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardApplicationImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardFileImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardKeyImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectManagerImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectRegistryImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardPinImpl;
import java.security.AlgorithmParameters;
import java.util.ArrayList;
import java.util.List;
import opencard.core.service.CardChannel;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.util.HexString;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class TCOSv2r3
extends GovCS {
    private static final Log log = LogFactory.getLog(TCOSv2r3.class);
    private static final byte[] HISTORICALS = HexString.parseHexString("00 64 05 60 02 03 31 80 90 00");
    private String releaseNumber = "?";

    TCOSv2r3() {
    }

    @Override
    public boolean isPinpadUsableInitCaseForT50PinOfVariableLength() {
        if (super.isCyberJack()) {
            return true;
        }
        return super.isPinpadUsableInitCaseForT50PinOfVariableLength();
    }

    @Override
    public boolean isPinpadUsableChangeCaseForT50PinOfVariableLength() {
        if (super.isCyberJack()) {
            return true;
        }
        return super.isPinpadUsableChangeCaseForT50PinOfVariableLength();
    }

    @Override
    public int getMaxPINLength(OCFCertificateInfo _info) {
        try {
            this.getRetryCount(_info);
        }
        catch (NotYetInitializedException e) {
            return 6;
        }
        catch (RetryCounterExpiredException retryCounterExpiredException) {
        }
        catch (PinDeactivatedException pinDeactivatedException) {
            // empty catch block
        }
        return 12;
    }

    protected Card.CardTypeEnum getCardTypeEnum() {
        return Card.CardTypeEnum.TELESEC_PKS;
    }

    @Override
    protected byte[] getHistoricals() {
        return HISTORICALS;
    }

    @Override
    protected boolean historicalsEquals(byte[] _historicals) {
        if (!super.historicalsEquals(_historicals)) {
            return false;
        }
        if (_historicals[5] != 2 && _historicals[5] != 3) {
            return false;
        }
        this.releaseNumber = Byte.toString(_historicals[5]);
        return true;
    }

    @Override
    public String getOSName() {
        return "(TCOS v.2 r." + this.releaseNumber + ")";
    }

    @Override
    protected boolean usesNullPIN() {
        return true;
    }

    @Override
    protected Card createCardInt(Terminal terminal, int slotID) {
        long idOfCard = CARD_OBJECT_REGISTRY.createNewCardID();
        long idOfPinCH = -1L;
        long idOfMFApplication = 1000000L;
        CardApplication application01 = this.createApp(terminal, slotID, idOfCard, idOfMFApplication, idOfPinCH);
        FileReference dirRefMF = new FileReference(0, "3f00");
        FileEntry fileEntryMF = new FileEntry(dirRefMF, dirRefMF);
        CardObjectManagerImpl mfManager = new CardObjectManagerImpl(idOfMFApplication);
        mfManager.putApplication(application01);
        CardApplicationImpl mfApplication = new CardApplicationImpl("MF", idOfMFApplication, CardApplication.CardApplicationTypeEnum.UNKNOWN.getType(), fileEntryMF, (CardObjectManager)mfManager, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        CardImpl card = new CardImpl(this.getDisplayName() + "-" + String.valueOf(idOfCard), idOfCard, this.getCardTypeEnum().getType(), super.getCard(), mfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance());
        return card;
    }

    private CardApplication createApp(Terminal terminal, int slotID, long idOfCard, long idOfMFApplication, long idOfPinCH) {
        long idOfApplication = 1000001L;
        long idOfPin01 = 2000001L;
        long idOfFile01 = 3000001L;
        long idOfFile02 = 3000002L;
        long idOfKey01 = 4000001L;
        long idOfKey02 = 4000002L;
        KeyID k01 = new KeyID("81");
        KeyID k02 = new KeyID("81");
        byte pinID01 = -127;
        FileReference dirRef = new FileReference(4, "d27600006601");
        FileReference cerRef01 = new FileReference(2, "c000");
        FileEntry fileEntry01 = new FileEntry(dirRef, cerRef01);
        FileReference fileRef02 = new FileReference(2, "c200");
        FileEntry fileEntry02 = new FileEntry(dirRef, fileRef02);
        OCFCertificateInfo info01 = new OCFCertificateInfo(idOfCard, idOfPin01, idOfFile01, idOfKey01, OCFCertificateInfo.ChainEntry.USER, null, null);
        OCFCertificateInfo info02 = new OCFCertificateInfo(idOfCard, idOfPin01, idOfFile02, idOfKey02, OCFCertificateInfo.ChainEntry.USER, null, null);
        CardPinImpl pin01 = new CardPinImpl(Disposeable.NO_LOCK, "PIN.SIG.ENC", idOfPin01, CardPin.CardPinTypeEnum.PIN.getType(), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID01, idOfKey01);
        CardFileImpl file01 = new CardFileImpl(Disposeable.NO_LOCK, "cerSig", idOfFile01, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey01);
        CardFileImpl file02 = new CardFileImpl(Disposeable.NO_LOCK, "cerDecEnc", idOfFile02, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry02, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey02);
        CardKeyImpl key01 = new CardKeyImpl(Disposeable.NO_LOCK, "SignatureKey", idOfKey01, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.EUROPEAN_QUALIFIED_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.QUALIFIED_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.ACCREDITED_SIGNATURE_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.SIGNATURE.getType()}), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info01, idOfFile01, idOfPin01, k01);
        CardKeyImpl key02 = new CardKeyImpl(Disposeable.NO_LOCK, "EncrytpionKey/DecryptionKey", idOfKey02, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_ENCRYPTION.getType(), CardKey.CardKeyTypeEnum.DEFAULT_DECRYPTION.getType(), CardKey.CardKeyTypeEnum.DEFAULT_AUTHENTICATION.getType(), CardKey.CardKeyTypeEnum.ENCRYPTION.getType(), CardKey.CardKeyTypeEnum.DECRYPTION.getType(), CardKey.CardKeyTypeEnum.AUTHENTICATION.getType(), CardKey.CardKeyTypeEnum.AUTHENTICATION_BY_ENCRYPTION.getType()}), fileEntry02, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info02, idOfFile02, idOfPin01, k02);
        CardObjectManagerImpl manager = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl application = new CardApplicationImpl("d27600006601", idOfApplication, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.SIGNATURE.getType()}), fileEntry01, (CardObjectManager)manager, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        application.putPin(pin01);
        application.putFile(file01);
        application.putFile(file02);
        application.putKey(key01);
        application.putKey(key02);
        return application;
    }

    @Override
    protected OCFCertificateInfo[] createCertificateInfos() {
        return new OCFCertificateInfo[]{new OCFCertificateInfo(new FileReference(4, "d27600006601"), new FileReference(2, "c000"), new KeyID("81"), -127, OCFCertificateInfo.ChainEntry.USER), new OCFCertificateInfo(new FileReference(4, "d27600006601"), new FileReference(2, "c200"), new KeyID("81"), -127, OCFCertificateInfo.ChainEntry.USER)};
    }

    @Override
    protected int getRetryCount(CardChannel _channel, OCFCertificateInfo _info) throws RetryCounterExpiredException, NotYetInitializedException, InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        return this.getRetryCount(TCOSv2r3.getPinNameForInfo(_info), _channel, _info.getPinID());
    }

    protected int getRetryCount(String pinName, CardChannel _channel, byte pinID) throws RetryCounterExpiredException, NotYetInitializedException, InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        int errorCode;
        CommandAPDU cmd = APDUCommands.createGetRetryCounterCommand(pinID);
        log.debug((Object)("RC CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        ResponseAPDU res = _channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        log.debug((Object)("RC RESULT : " + HexString.hexify(res.getBuffer(), false)));
        String message = APDUCommands.getVerifyErrorMsg(res.sw());
        if ((res.sw() & 0xFFF0) != 25536) {
            log.debug((Object)("RC RESULT : " + message));
        }
        if ((errorCode = res.sw()) == 27013) {
            throw new NotYetInitializedException(pinName, errorCode, message);
        }
        if (errorCode == 27011) {
            throw new RetryCounterExpiredException(pinName, errorCode, message);
        }
        if (errorCode != 36864 && (errorCode & 0xFFF0) == 25536) {
            int retryCounter = errorCode - 25536;
            if (retryCounter == 0) {
                throw new RetryCounterExpiredException(pinName, errorCode, message);
            }
            return retryCounter;
        }
        return -1;
    }

    @Override
    protected CommandAPDU createMSECommand(CardChannel _channel, OCFCertificateInfo _info, int _type, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        switch (_type) {
            case 1: 
            case 2: {
                return APDUCommands.createMSEforDecryption(_info.getKeyID().getID());
            }
        }
        return null;
    }

    @Override
    public List<String> getAvailableHashAlgorithmNames(OCFCertificateInfo _info) {
        ArrayList<String> c = new ArrayList<String>();
        if (_info.getUsage() != OCFCertificateInfo.Usage.ENC) {
            c.add("SHA1");
        }
        return c;
    }

    @Override
    public void reset() {
        if (!super.isCardPresent()) {
            return;
        }
        CardChannelManager cardChannelManager = new CardChannelManager();
        try {
            CardChannel cardChannel = cardChannelManager.init(this);
            this.resetInt(cardChannel);
        }
        finally {
            cardChannelManager.destroy();
        }
    }

    private void resetInt(CardChannel channel) {
        super.resetChannelState(channel);
        try {
            this.selectMasterFile(channel);
        }
        catch (Exception e) {
            log.debug((Object)"selecting master file failed", (Throwable)e);
        }
    }
}

