/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.tcos;

import de.bos_bremen.common.HexUtil;
import de.bos_bremen.gov2.jca_provider.ocf.NotYetInitializedException;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.OperationCancelledException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputCancelledException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputTimeoutException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputTooLongException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputTooShortException;
import de.bos_bremen.gov2.jca_provider.ocf.ProgressSession;
import de.bos_bremen.gov2.jca_provider.ocf.ResponseCodeException;
import de.bos_bremen.gov2.jca_provider.ocf.RetryCounterExpiredException;
import de.bos_bremen.gov2.jca_provider.ocf.WrongPinException;
import de.bos_bremen.gov2.jca_provider.ocf.cards.APDUCommands;
import de.bos_bremen.gov2.jca_provider.ocf.cards.CardChannelManager;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.MaxSignatureCountReachedException;
import de.bos_bremen.gov2.jca_provider.ocf.cards.tcos.TCOS30SC20;
import de.bos_bremen.gov2.jca_provider.ocf.model.Card;
import java.security.AlgorithmParameters;
import opencard.core.service.CardChannel;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TCOS30SC20M
extends TCOS30SC20 {
    private static final Log LOG = LogFactory.getLog(TCOS30SC20M.class);
    private static final String MULTICARD = "-multicard";
    protected static final String TELESEC_TCOS_30_SC_20_M = "TCOS 3.0 SC 2.0 M";

    @Override
    public String getDisplayName() {
        return TELESEC_TCOS_30_SC_20_M;
    }

    @Override
    protected String getIssuerConstant() {
        return super.getIssuerConstant() + MULTICARD;
    }

    @Override
    protected Card.CardTypeEnum getCardTypeEnum() {
        return Card.CardTypeEnum.TCOS30_SC20M;
    }

    @Override
    protected String readIssuerFromATR(CardChannel _channel, int bytes) {
        try {
            CommandAPDU cmd = APDUCommands.createSelectCommand(2, 12, HexUtil.parse("2f00"), 1024);
            ResponseAPDU res = _channel.sendCommandAPDU(cmd);
            if (res.sw() != 36864) {
                return null;
            }
            cmd = APDUCommands.createReadBinaryCommand(0, 0);
            res = _channel.sendCommandAPDU(cmd);
            if (res.sw() != 36864) {
                return null;
            }
            byte[] data = res.data();
            if (data != null && data.length == 44 && data[22] == 77) {
                return super.getIssuerConstant() + MULTICARD;
            }
        }
        catch (CardTerminalException cardTerminalException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public boolean isMultiSign() {
        return true;
    }

    @Override
    public boolean isStapleSign() {
        return GovCS.isStapleSign(this);
    }

    @Override
    public Integer getStapleSignCounter() {
        return this.isStapleSign() ? MAXIMUM_COUNT_OF_STAPLE_SIGNATURES : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final GovCS.ResultObject signHashServer(OCFCertificateInfo _info, byte[] _hashValue, char[] _pin, String _hashAlgorithm, ProgressSession session, GovCS.ResultObject ro, AlgorithmParameters algorithmParameters) throws WrongPinException, RetryCounterExpiredException, NotYetInitializedException, ResponseCodeException, PinInputCancelledException, PinInputTooShortException, PinInputTooLongException, PinInputTimeoutException, OperationCancelledException {
        CardChannelManager cardChannelManager = new CardChannelManager();
        CardChannel channel = null;
        try {
            this.fireProgressEvent(session, "get connection to the device");
            channel = cardChannelManager.init(this);
            this.fireProgressEvent(session, "select application on card");
            if (!this.checkChannelState(channel, _info)) {
                this.selectFile(channel, _info, false);
            }
            boolean loop = true;
            while (loop) {
                this.fireProgressEvent(session, "sign the given hash value");
                ro = this.signHash(channel, _info, _hashValue, _hashAlgorithm, algorithmParameters);
                if (ro.getResultCode() == 27010 || ro.getResultCode() == 27272) {
                    this.resetChannelState(channel);
                    try {
                        this.checkSignCounter(channel, false);
                    }
                    catch (MaxSignatureCountReachedException e) {
                        LOG.debug((Object)"maximum count of signatures reached");
                    }
                    this.selectFile(channel, _info, false);
                    this.fireProgressEvent(session, "verify the corresponding password");
                    ro.setResultCode(this.verifyPassword(channel, _info, _pin));
                    if (ro.getResultCode() != 36864) {
                        LOG.debug((Object)APDUCommands.getVerifyErrorMsg(ro.getResultCode()));
                        GovCS.ResultObject resultObject = ro;
                        return resultObject;
                    }
                    loop = true;
                    continue;
                }
                this.fireProgressEvent(session, "operation finished!");
                loop = false;
            }
            GovCS.ResultObject resultObject = ro;
            return resultObject;
        }
        catch (WrongPinException e) {
            throw e;
        }
        catch (RetryCounterExpiredException e) {
            throw e;
        }
        catch (NotYetInitializedException e) {
            throw e;
        }
        catch (PinInputTooShortException e) {
            throw e;
        }
        catch (PinInputTooLongException e) {
            throw e;
        }
        catch (PinInputTimeoutException e) {
            throw e;
        }
        catch (PinInputCancelledException e) {
            throw e;
        }
        catch (OperationCancelledException e) {
            throw e;
        }
        catch (ResponseCodeException e) {
            throw e;
        }
        catch (CardTerminalException ex) {
            LOG.debug((Object)"", (Throwable)ex);
            ro.setResultCode(0);
            GovCS.ResultObject resultObject = ro;
            return resultObject;
        }
        catch (Throwable ex) {
            LOG.debug((Object)"", ex);
            ro.setResultCode(0);
            GovCS.ResultObject resultObject = ro;
            return resultObject;
        }
        finally {
            cardChannelManager.destroy();
            if (this.progressSessionListener != null) {
                while (session.getCurrentStep() != session.getStepCount()) {
                    session.increaseCurrentStep();
                }
                session.setProgressMessage("done!");
                this.progressSessionListener.progressSessionWillStop(session);
                this.progressSessionListener.progressSessionStopped(session);
            }
        }
    }
}

