/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.tcos;

import de.bos_bremen.basecard.common.dialog.BDialogMode;
import de.bos_bremen.basecard.terminal.pcsc.PaceConstants;
import de.bos_bremen.basecard.terminal.pcsc.impl.PaceInputData;
import de.bos_bremen.common.ArrayUtil;
import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.ByteUtil;
import de.bos_bremen.common.HexUtil;
import de.bos_bremen.common.asn1.ASN1;
import de.bos_bremen.common.asn1.OID;
import de.bos_bremen.gov2.jca_provider.ocf.FileEntry;
import de.bos_bremen.gov2.jca_provider.ocf.NotYetInitializedException;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.OCFException;
import de.bos_bremen.gov2.jca_provider.ocf.OCFPinRelatedException;
import de.bos_bremen.gov2.jca_provider.ocf.OperationCancelledException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputCancelledException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputTimeoutException;
import de.bos_bremen.gov2.jca_provider.ocf.ResponseCodeException;
import de.bos_bremen.gov2.jca_provider.ocf.RetryCounterExpiredException;
import de.bos_bremen.gov2.jca_provider.ocf.SecureCard;
import de.bos_bremen.gov2.jca_provider.ocf.WrongPinException;
import de.bos_bremen.gov2.jca_provider.ocf.asn1.epa.SecurityInfos;
import de.bos_bremen.gov2.jca_provider.ocf.cards.APDUCommands;
import de.bos_bremen.gov2.jca_provider.ocf.cards.CanPukRequestDialog;
import de.bos_bremen.gov2.jca_provider.ocf.cards.FileReference;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCHVConfiguration;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCHVDialog;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.KeyID;
import de.bos_bremen.gov2.jca_provider.ocf.cards.SMGovCS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.EPA;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.pace.impl.PACE;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.pace.impl.PaceInputParameters;
import de.bos_bremen.gov2.jca_provider.ocf.channel.iso7816.AESKeyMaterialImpl;
import de.bos_bremen.gov2.jca_provider.ocf.channel.iso7816.AESSecureMessagingImpl;
import de.bos_bremen.gov2.jca_provider.ocf.channel.util.AESEncSSCIvParameterSpecImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.Card;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardApplication;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardFile;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardKey;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardObjectManager;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardPin;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardRegistry;
import de.bos_bremen.gov2.jca_provider.ocf.model.Disposeable;
import de.bos_bremen.gov2.jca_provider.ocf.model.Terminal;
import de.bos_bremen.gov2.jca_provider.ocf.model.Type;
import de.bos_bremen.gov2.jca_provider.ocf.model.TypedType;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardApplicationImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardFileImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardKeyImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectManagerImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectRegistryImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardPinImpl;
import de.bos_bremen.opencard.terminal.pcsc.PCSCCardTerminal;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import opencard.core.service.CardChannel;
import opencard.core.service.CardServiceException;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TCOS30SC20
extends SMGovCS
implements SecureCard {
    private static final Log LOG = LogFactory.getLog(TCOS30SC20.class);
    private static final byte[] HISTORICALS = HexUtil.parse("00 64 05 a0 03 04 31 c0 73 f7 01 d0 00 90 00");
    private static final String TELESEC_TCOS_30_SC_20 = "TCOS 3.0 SC 2.0";
    private static final String EF_GDO_ISSUER_CONSTANT = "5a 0a 89 49 01 79 91";
    private SecurityInfos cardAccess = null;
    private boolean paceReaderChecked = false;
    PCSCCardTerminal paceReader = null;
    private SecureCard.SecurityProtocol establishedProtocol = null;
    private final List<SecureCard.SecurityProtocol> supportedProtocols = Arrays.asList(SecureCard.SecurityProtocol.EAC2_PACE);

    @Override
    protected byte[] getHistoricals() {
        return HISTORICALS;
    }

    @Override
    protected boolean historicalsEquals(byte[] historicals) {
        return historicals != null && Arrays.equals(HISTORICALS, historicals);
    }

    @Override
    public String getDisplayName() {
        return TELESEC_TCOS_30_SC_20;
    }

    @Override
    protected String getIssuerConstant() {
        return EF_GDO_ISSUER_CONSTANT;
    }

    @Override
    protected Card createCardInt(Terminal terminal, int _slotID) {
        try {
            long idOfCard = CARD_OBJECT_REGISTRY.createNewCardID();
            long idOfPinCard1 = 2000001L;
            long idOfMFApplication = 1000000L;
            CardApplication applicationNetkey = this.createNetkeyApp(terminal, _slotID, idOfCard, idOfMFApplication, idOfPinCard1);
            CardApplication applicationESign = this.createESignApp(terminal, _slotID, idOfCard, idOfMFApplication);
            FileReference dirRefMF = new FileReference(0, "3f00");
            FileEntry fileEntryMF = new FileEntry(dirRefMF, dirRefMF);
            byte pinID01 = 3;
            CardPinImpl pin01 = new CardPinImpl(Disposeable.NO_LOCK, "CardPIN 1", idOfPinCard1, CardPin.CardPinTypeEnum.PIN.getType(), fileEntryMF, idOfCard, idOfMFApplication, terminal.getID(), _slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID01, new long[]{4000001L, 4000002L, 4000003L, 4000004L});
            CardObjectManagerImpl mfManager = new CardObjectManagerImpl(idOfMFApplication);
            if (applicationNetkey != null) {
                mfManager.putApplication(applicationNetkey);
            }
            if (applicationESign != null) {
                mfManager.putApplication(applicationESign);
            }
            mfManager.putPin(pin01);
            CardApplicationImpl mfApplication = new CardApplicationImpl("MF", idOfMFApplication, CardApplication.CardApplicationTypeEnum.UNKNOWN.getType(), fileEntryMF, (CardObjectManager)mfManager, idOfCard, idOfMFApplication, terminal.getID(), _slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
            CardImpl card = new CardImpl(this.getDisplayName() + "-" + String.valueOf(idOfCard), idOfCard, this.getCardTypeEnum().getType(), super.getCard(), mfApplication, terminal.getID(), _slotID, this, CardObjectRegistryImpl.getInstance());
            return card;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
            return null;
        }
    }

    protected Card.CardTypeEnum getCardTypeEnum() {
        return Card.CardTypeEnum.TCOS30_SC20;
    }

    private CardApplication createNetkeyApp(Terminal terminal, int _slotID, long idOfCard, long idOfMFApplication, long idOfPinCH) {
        long idOfApplication = 1000001L;
        long idOfFile01 = 3000001L;
        long idOfFile02 = 3000002L;
        long idOfFile03 = 3000003L;
        long idOfFile04 = 3000004L;
        long idOfKey01 = 4000001L;
        long idOfKey02 = 4000002L;
        long idOfKey03 = 4000003L;
        long idOfKey04 = 4000004L;
        FileReference dirRef = new FileReference(4, "d2760000030102");
        FileEntry fileEntryNetkeyApp = new FileEntry(dirRef, dirRef);
        CardObjectManagerImpl manager = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl application = new CardApplicationImpl("Netkey", idOfApplication, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.ENCRYPTION.getType(), CardApplication.CardApplicationTypeEnum.DECRYPTION.getType(), CardApplication.CardApplicationTypeEnum.AUTHENTICATION.getType(), CardApplication.CardApplicationTypeEnum.SIGNATURE.getType()}), fileEntryNetkeyApp, (CardObjectManager)manager, idOfCard, idOfMFApplication, terminal.getID(), _slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        KeyID k01 = new KeyID("80");
        FileReference fileRef01 = new FileReference(2, "c000");
        FileEntry fileEntry01 = new FileEntry(dirRef, fileRef01);
        OCFCertificateInfo info01 = new OCFCertificateInfo(idOfCard, idOfPinCH, idOfFile01, idOfKey01, OCFCertificateInfo.ChainEntry.USER, null, null);
        CardFileImpl file01 = new CardFileImpl(Disposeable.NO_LOCK, "cerSig", idOfFile01, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry01, idOfCard, idOfApplication, terminal.getID(), _slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey01);
        CardKeyImpl key01 = new CardKeyImpl(Disposeable.NO_LOCK, "AdvancedSignatureKey", idOfKey01, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.ADVANCED_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.SIGNATURE.getType()}), fileEntry01, idOfCard, idOfApplication, terminal.getID(), _slotID, this, CardObjectRegistryImpl.getInstance(), info01, idOfFile01, idOfPinCH, k01);
        application.putFile(file01);
        application.putKey(key01);
        KeyID k02 = new KeyID("81");
        FileReference fileRef02 = new FileReference(2, "c200");
        FileEntry fileEntry02 = new FileEntry(dirRef, fileRef02);
        OCFCertificateInfo info02 = new OCFCertificateInfo(idOfCard, idOfPinCH, idOfFile02, idOfKey02, OCFCertificateInfo.ChainEntry.USER, null, null);
        CardFileImpl file02 = new CardFileImpl(Disposeable.NO_LOCK, "cerEnc1", idOfFile02, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry02, idOfCard, idOfApplication, terminal.getID(), _slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey02);
        CardKeyImpl key02 = new CardKeyImpl(Disposeable.NO_LOCK, "EncryptionKey/DecryptionKey 1", idOfKey02, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_DECRYPTION.getType(), CardKey.CardKeyTypeEnum.DEFAULT_ENCRYPTION.getType(), CardKey.CardKeyTypeEnum.ENCRYPTION.getType(), CardKey.CardKeyTypeEnum.DECRYPTION.getType()}), fileEntry01, idOfCard, idOfApplication, terminal.getID(), _slotID, this, CardObjectRegistryImpl.getInstance(), info02, idOfFile02, idOfPinCH, k02);
        application.putFile(file02);
        application.putKey(key02);
        KeyID k03 = new KeyID("82");
        FileReference fileRef03 = new FileReference(2, "c500");
        FileEntry fileEntry03 = new FileEntry(dirRef, fileRef03);
        OCFCertificateInfo info03 = new OCFCertificateInfo(idOfCard, idOfPinCH, idOfFile03, idOfKey03, OCFCertificateInfo.ChainEntry.USER, null, null);
        CardFileImpl file03 = new CardFileImpl(Disposeable.NO_LOCK, "cerAut", idOfFile03, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry03, idOfCard, idOfApplication, terminal.getID(), _slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey03);
        CardKeyImpl key03 = new CardKeyImpl(Disposeable.NO_LOCK, "AuthenticationKey", idOfKey03, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_AUTHENTICATION.getType(), CardKey.CardKeyTypeEnum.AUTHENTICATION.getType(), CardKey.CardKeyTypeEnum.AUTHENTICATION_BY_ENCRYPTION.getType()}), fileEntry03, idOfCard, idOfApplication, terminal.getID(), _slotID, this, CardObjectRegistryImpl.getInstance(), info03, idOfFile03, idOfPinCH, k03);
        application.putFile(file03);
        application.putKey(key03);
        KeyID k04 = new KeyID("85");
        FileReference fileRef04 = new FileReference(2, "c201");
        FileEntry fileEntry04 = new FileEntry(dirRef, fileRef04);
        OCFCertificateInfo info04 = new OCFCertificateInfo(idOfCard, idOfPinCH, idOfFile04, idOfKey04, OCFCertificateInfo.ChainEntry.USER, null, null);
        CardFileImpl file04 = new CardFileImpl(Disposeable.NO_LOCK, "cerEnc2", idOfFile04, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry04, idOfCard, idOfApplication, terminal.getID(), _slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey04);
        CardKeyImpl key04 = new CardKeyImpl(Disposeable.NO_LOCK, "EncryptionKey/DecryptionKey 2", idOfKey04, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.ENCRYPTION.getType(), CardKey.CardKeyTypeEnum.DECRYPTION.getType()}), fileEntry04, idOfCard, idOfApplication, terminal.getID(), _slotID, this, CardObjectRegistryImpl.getInstance(), info04, idOfFile04, idOfPinCH, k04);
        application.putFile(file04);
        application.putKey(key04);
        return application;
    }

    private CardApplication createESignApp(Terminal terminal, int _slotID, long idOfCard, long idOfMFApplication) {
        long idOfApplicationESIGN = 1000003L;
        long idOfFile01 = 3000005L;
        long idOfKey01 = 4000005L;
        KeyID k01 = new KeyID("84");
        long idOfPin01 = 2000002L;
        byte pinID01 = -127;
        FileReference dirRefESIGN = new FileReference(4, "a000000167455349474e");
        FileEntry fileEntryESIGN = new FileEntry(dirRefESIGN, dirRefESIGN);
        FileReference cerRef01 = new FileReference(2, "c001");
        FileEntry fileEntry01 = new FileEntry(dirRefESIGN, cerRef01);
        OCFCertificateInfo info01 = new OCFCertificateInfo(idOfCard, idOfPin01, idOfFile01, idOfKey01, OCFCertificateInfo.ChainEntry.USER, OCFCertificateInfo.Usage.SIG, null);
        CardFileImpl file01 = new CardFileImpl(Disposeable.NO_LOCK, "cerQES", idOfFile01, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry01, idOfCard, idOfApplicationESIGN, terminal.getID(), _slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey01);
        CardKeyImpl key01 = new CardKeyImpl(Disposeable.NO_LOCK, "QualifiedSignatureKey", idOfKey01, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.EUROPEAN_QUALIFIED_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.QUALIFIED_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.SIGNATURE.getType()}), fileEntry01, idOfCard, idOfApplicationESIGN, terminal.getID(), _slotID, this, CardObjectRegistryImpl.getInstance(), info01, idOfFile01, idOfPin01, k01);
        CardPinImpl pin01 = new CardPinImpl(Disposeable.NO_LOCK, "ESign-PIN 1", idOfPin01, CardPin.CardPinTypeEnum.PIN.getType(), fileEntryESIGN, idOfCard, idOfApplicationESIGN, terminal.getID(), _slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID01, new long[]{idOfKey01});
        CardObjectManagerImpl managerESIGN = new CardObjectManagerImpl(idOfApplicationESIGN);
        CardApplicationImpl applicationESIGN = new CardApplicationImpl("ESign", idOfApplicationESIGN, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.QUALIFIED_SIGNATURE.getType()}), fileEntryESIGN, (CardObjectManager)managerESIGN, idOfCard, idOfMFApplication, terminal.getID(), _slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        applicationESIGN.putFile(file01);
        applicationESIGN.putKey(key01);
        applicationESIGN.putPin(pin01);
        return applicationESIGN;
    }

    @Override
    protected boolean usesNullPIN() {
        return false;
    }

    @Override
    public OCFCertificateInfo[] createCertificateInfos() {
        return new OCFCertificateInfo[0];
    }

    @Override
    protected final char[] getInitPIN() {
        return "00000".toCharArray();
    }

    @Override
    public final boolean usesNullPin(OCFCertificateInfo _info) {
        return true;
    }

    @Override
    protected int getRetryCount(CardChannel _channel, OCFCertificateInfo _info) throws RetryCounterExpiredException, NotYetInitializedException, InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        return this.getRetryCount(TCOS30SC20.getPinNameForInfo(_info), _channel, _info.getPinID());
    }

    protected int getRetryCount(String pinName, CardChannel _channel, byte pinID) throws RetryCounterExpiredException, NotYetInitializedException, InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        int errorCode;
        CommandAPDU cmd = APDUCommands.createGetRetryCounterCommand(pinID);
        LOG.debug((Object)("RC CMD : " + HexUtil.hexify(cmd.getBuffer())));
        ResponseAPDU res = this.sendCommandAPDU(_channel, cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        LOG.debug((Object)("RC RESULT : " + HexUtil.hexify(res.getBuffer())));
        String message = APDUCommands.getVerifyErrorMsg(res.sw());
        if ((res.sw() & 0xFFF0) != 25536) {
            LOG.debug((Object)("RC RESULT : " + message));
        }
        if ((errorCode = res.sw()) == 27013) {
            throw new NotYetInitializedException(pinName, errorCode, message);
        }
        if (errorCode == 27011) {
            throw new RetryCounterExpiredException(pinName, errorCode, message);
        }
        if (errorCode != 36864 && (errorCode & 0xFFF0) == 25536) {
            int retryCounter = errorCode - 25536;
            if (retryCounter == 0) {
                throw new RetryCounterExpiredException(pinName, errorCode, message);
            }
            return retryCounter;
        }
        return -1;
    }

    @Override
    protected final CommandAPDU createMSECommand(CardChannel _channel, OCFCertificateInfo _info, int _type, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        switch (_type) {
            case 1: {
                byte[] keyID = _info.getKeyID().getID();
                byte[] data = new byte[2 + keyID.length];
                data[0] = -124;
                data[1] = (byte)keyID.length;
                System.arraycopy(keyID, 0, data, 2, keyID.length);
                return APDUCommands.createManageSecurityEnvironmentCommand((byte)65, (byte)-72, data);
            }
        }
        byte[] keyID = _info.getKeyID().getID();
        byte[] data = new byte[2 + keyID.length];
        data[0] = -124;
        data[1] = (byte)keyID.length;
        System.arraycopy(keyID, 0, data, 2, keyID.length);
        return APDUCommands.createManageSecurityEnvironmentCommand((byte)65, (byte)-74, data);
    }

    @Override
    protected final CommandAPDU createAuthentifyCommand(byte[] _hashValue, AlgorithmParameters algorithmParameters) {
        byte[] store = new byte[6 + _hashValue.length];
        store[0] = 0;
        store[1] = 42;
        store[2] = -98;
        store[3] = -102;
        store[4] = (byte)_hashValue.length;
        System.arraycopy(_hashValue, 0, store, 5, _hashValue.length);
        store[store.length - 1] = 0;
        return new CommandAPDU(store);
    }

    @Override
    public void authentifyAdjust(GovCS.ResultObject ro, AlgorithmParameters algorithmParameters) {
    }

    @Override
    protected byte getPaddingIndicator() {
        return 0;
    }

    @Override
    public List<String> getAvailableHashAlgorithmNames(OCFCertificateInfo _info) {
        ArrayList<String> c = new ArrayList<String>();
        c.add("SHA256");
        return c;
    }

    @Override
    protected boolean usesASN1HeaderWithSignHash() {
        return false;
    }

    @Override
    protected String readIssuerFromATR(CardChannel _channel, int bytes) {
        try {
            CommandAPDU cmd = APDUCommands.createSelectCommand(2, 12, HexUtil.parse("2f00"), 1024);
            ResponseAPDU res = this.sendCommandAPDU(_channel, cmd);
            if (res.sw() != 36864) {
                return null;
            }
            cmd = APDUCommands.createReadBinaryCommand(0, 0);
            res = this.sendCommandAPDU(_channel, cmd);
            if (res.sw() != 36864) {
                return null;
            }
            byte[] data = res.data();
            if (data != null && data.length == 42 && data[22] != 77) {
                return EF_GDO_ISSUER_CONSTANT;
            }
        }
        catch (CardTerminalException cardTerminalException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public int getMinPINLength(OCFCertificateInfo _info) {
        if (_info == null) {
            return 6;
        }
        return 6;
    }

    @Override
    public int getMaxPINLength(OCFCertificateInfo _info) {
        if (_info == null) {
            return 6;
        }
        return 12;
    }

    @Override
    public Integer getMinPINLengthInit(OCFCertificateInfo _info) {
        return 5;
    }

    @Override
    public Integer getMaxPINLengthInit(OCFCertificateInfo _info) {
        return 5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized SecureCard.SecurityProtocolResult<? extends Object> allocateSecureContext(SecureCard.SecurityProtocol securityProtocol, SecureCard.SecurityProtocolParameter securityProtocolParameter) throws IllegalArgumentException, CardServiceException, CardTerminalException {
        block22: {
            if (this.establishedProtocol != null && this.isSecure()) {
                throw new IllegalStateException("SM already established");
            }
            if (securityProtocol != SecureCard.SecurityProtocol.EAC2_PACE) {
                throw new IllegalArgumentException("unsupported protocol requested");
            }
            char[] canChar = null;
            if (securityProtocolParameter != null) {
                if (!(securityProtocolParameter instanceof PaceInputParameters)) {
                    throw new IllegalArgumentException("unsupported protocol parameters given");
                }
                PaceInputParameters pip = (PaceInputParameters)securityProtocolParameter;
                if (pip.getSecretChoice() != null && !pip.getSecretChoice().equals(PACE.USE_CAN_KEY)) {
                    throw new IllegalArgumentException("currently only PACE with CAN supported");
                }
                canChar = pip.getSecretValue();
            }
            if (!this.paceReaderChecked) {
                this.paceReader = super.getReader(PaceConstants.PaceCapabilityEnum.PACE);
                this.paceReaderChecked = true;
            }
            try {
                String can;
                SecurityInfos.GeneralDomainParameterInfo domParamInfo;
                this.sendCommandAPDU(this.createSelectMasterFile());
                if (this.paceReader != null) {
                    Object monitor;
                    block21: {
                        GovCHVDialog chvDialog = (GovCHVDialog)this.chvDialogClass.newInstance();
                        chvDialog.setParentWindow(this.parentWindow);
                        PaceInputData pid = new PaceInputData(2, null, ByteUtil.convert(canChar), null);
                        monitor = null;
                        try {
                            OCFCertificateInfo ocfCertInfo = new OCFCertificateInfo(this.getCardObject(), OCFCertificateInfo.Usage.RFID, OCFCertificateInfo.ChainEntry.UNKNOWN);
                            GovCHVConfiguration config = new GovCHVConfiguration(0, BDialogMode.RFID_CAN, this.getMinPINLength(null), this.getMaxPINLength(null), ocfCertInfo, this.createTerminalString(null), null, null, null, this.getClass());
                            config.setShowPseudoDisplay(false);
                            chvDialog.setConfiguration(config);
                            monitor = chvDialog.showReaderMessage();
                            byte[] result = this.paceReader.sendTerminalCommand(this.paceReader.getPcsc20Features().getExecutePACE().valueAsNumber(), pid.getEncoded());
                            TCOS30SC20.checkTerminalCode("CAN", result);
                            this.establishedProtocol = securityProtocol;
                            if (monitor == null) break block21;
                        }
                        catch (Throwable throwable) {
                            if (monitor != null) {
                                chvDialog.hideReaderMessage(monitor);
                            }
                            monitor = null;
                            throw throwable;
                        }
                        chvDialog.hideReaderMessage(monitor);
                    }
                    monitor = null;
                    break block22;
                }
                if (this.cardAccess == null) {
                    this.readEFCardAccess();
                }
                List<SecurityInfos.PACEInfo> infoList = this.cardAccess.getPACEInfo();
                List<SecurityInfos.PACEDomainParameterInfo> domainParameterInfoList = this.cardAccess.getPACEDomainParameterInfo();
                if (infoList == null || infoList.size() == 0) {
                    throw new IllegalStateException("Required data for PACE not available in EF.CardAccess");
                }
                boolean success = false;
                SecurityInfos.PACEInfo info = EPA.selectPACE(infoList);
                if (info == null) {
                    throw new IllegalStateException("Required data for PACE not available in EF.CardAccess");
                }
                ASN1 pID = info.getParameterID();
                Integer id = null;
                if (pID != null) {
                    id = new BigInteger(pID.getValue()).intValue();
                }
                if ((domParamInfo = EPA.selectPACEDomainParameterInfo(domainParameterInfoList, id)) == null) {
                    throw new IllegalStateException("Required data for PACE not available in EF.CardAccess");
                }
                OID protocolOID = new OID(info.getProtocol().getEncoded());
                int paceVersion = new BigInteger(info.getVersion().getValue()).intValue();
                PACE pace = new PACE(this, domParamInfo, protocolOID, paceVersion, id);
                if (canChar == null) {
                    canChar = CanPukRequestDialog.requestUserAuthenticationCode(OCFCertificateInfo.Usage.RFID, BDialogMode.RFID_CAN, this.getCardTerminal().getName(), 6);
                }
                if (success = pace.executePACE(PACE.USE_CAN_KEY, can = new String(canChar), null)) {
                    AESEncSSCIvParameterSpecImpl ssc = new AESEncSSCIvParameterSpecImpl(new byte[16], false, pace.getEncKey());
                    AESKeyMaterialImpl smKeyMaterial = new AESKeyMaterialImpl(pace.getEncKey(), pace.getMacKey(), ssc);
                    AESSecureMessagingImpl sm = new AESSecureMessagingImpl(smKeyMaterial);
                    super.setSM(sm);
                    this.establishedProtocol = securityProtocol;
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (OCFPinRelatedException e) {
                return new SecureCard.SimpleSecurityProtocolResult(e);
            }
            catch (Exception e) {
                throw new CardServiceException("establishing SM failed");
            }
        }
        return new SecureCard.SimpleSecurityProtocolResult(this.establishedProtocol != null);
    }

    @Override
    public boolean releaseSecureContext() throws CardServiceException, CardTerminalException {
        return false;
    }

    @Override
    public boolean prepareSignatureTerminal(boolean initMode) throws IllegalStateException, OperationCancelledException, WrongPinException {
        throw new UnsupportedOperationException("signature terminal not required for signing with this card");
    }

    @Override
    public synchronized boolean isSecure() {
        this.checkSMStillActive();
        return super.isSMEstablished() || this.paceReader != null && this.establishedProtocol != null;
    }

    @Override
    public synchronized SecureCard.SecurityProtocol getSecurityProtocol() {
        this.checkSMStillActive();
        return this.establishedProtocol;
    }

    private void checkSMStillActive() {
        if (this.paceReader == null && !super.isSMEstablished()) {
            this.establishedProtocol = null;
        }
    }

    @Override
    public List<SecureCard.SecurityProtocol> getSupportedSecurityProtocols() {
        return this.supportedProtocols;
    }

    private void readEFCardAccess() throws InternalError {
        if (this.cardAccess == null) {
            try {
                byte[] fileBytes = this.readFileRaw("011c", "EF.CardAccess");
                SecurityInfos result = new SecurityInfos(fileBytes);
                this.cardAccess = (SecurityInfos)result.decode(result);
            }
            catch (Exception e) {
                throw new InternalError("Unable to read EF.CardAccess");
            }
        }
    }

    public static void checkTerminalCode(String pinName, byte[] terminalResult) throws CardTerminalException, WrongPinException, PinInputCancelledException, PinInputTimeoutException, OCFException {
        AssertUtil.notNullOrEmpty(terminalResult, "result from terminal");
        if (ArrayUtil.isNullOrEmpty(terminalResult) || terminalResult.length < 4) {
            throw new CardTerminalException("protocol failed at terminal - no response received (at least 4 bytes required containing execution result code");
        }
        byte[] code = ByteUtil.flip(ByteUtil.subbytes(terminalResult, 0, 4));
        if (!ByteUtil.equals(code, HexUtil.parse("00000000"))) {
            TCOS30SC20.checkFXXXS152(pinName, code);
            TCOS30SC20.checkF010000X(code);
            TCOS30SC20.checkF020000X(pinName, code);
            TCOS30SC20.checkD000000X(code);
            TCOS30SC20.checkE000000X(code);
            throw new CardTerminalException("protocol failed at terminal, unknown error: " + HexUtil.hexify(code));
        }
    }

    private static void checkE000000X(byte[] code) throws CardTerminalException {
        if (code[0] == -32 && code[1] == 0 && code[2] == 0 && (code[3] >= 1 && code[3] <= 3 || code[3] >= 6 && code[3] <= 10)) {
            throw new CardTerminalException("protocol failed at terminal, error in execution: " + HexUtil.hexify(code));
        }
    }

    private static void checkD000000X(byte[] code) throws CardTerminalException {
        if (code[0] == -48 && code[1] == 0 && code[2] == 0 && code[3] >= 1 && code[3] <= 3) {
            throw new CardTerminalException("protocol failed at terminal, data input error: " + HexUtil.hexify(code));
        }
    }

    private static void checkF020000X(String pinName, byte[] code) throws PinInputCancelledException, PinInputTimeoutException {
        if (code[0] == -16 && code[1] == 32 && code[2] == 0) {
            if (code[3] == 1) {
                throw new PinInputCancelledException(pinName, 25601, "input cancelled");
            }
            if (code[3] == 2) {
                throw new PinInputTimeoutException(pinName, 25600, "timeout");
            }
        }
    }

    private static void checkF010000X(byte[] code) throws CardTerminalException {
        if (code[0] == -16 && code[1] == 16 && code[2] == 0 && code[3] >= 1 && code[3] <= 2) {
            throw new CardTerminalException("protocol failed at terminal, card communication error: " + HexUtil.hexify(code));
        }
    }

    private static void checkFXXXS152(String pinName, byte[] code) throws WrongPinException, OCFException {
        if (code[0] == -16 && code[1] >= 0 && code[1] <= 6 || code[0] == -8 && code[1] >= 0 && code[1] <= 12) {
            int sw = (code[2] + 256) % 256 * 256 + (code[3] + 256) % 256;
            if (code[2] == 99 && (code[3] & 0xFFFFFFF0) == -64) {
                throw new WrongPinException(pinName, sw, "wrong password entered");
            }
            throw new OCFException(new BigInteger(code).intValue(), "card returned error code");
        }
    }
}

