/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.tcos;

import de.bos_bremen.common.HexUtil;
import de.bos_bremen.gov2.jca_provider.ocf.FileEntry;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.ResponseCodeException;
import de.bos_bremen.gov2.jca_provider.ocf.cards.APDUCommands;
import de.bos_bremen.gov2.jca_provider.ocf.cards.CardPerformanceSettings;
import de.bos_bremen.gov2.jca_provider.ocf.cards.FileReference;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.KeyID;
import de.bos_bremen.gov2.jca_provider.ocf.cards.tcos.NetKey30;
import de.bos_bremen.gov2.jca_provider.ocf.model.Card;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardApplication;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardFile;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardKey;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardObjectManager;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardPin;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardRegistry;
import de.bos_bremen.gov2.jca_provider.ocf.model.Disposeable;
import de.bos_bremen.gov2.jca_provider.ocf.model.Terminal;
import de.bos_bremen.gov2.jca_provider.ocf.model.Type;
import de.bos_bremen.gov2.jca_provider.ocf.model.TypedType;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardApplicationImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardFileImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardKeyImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectManagerImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectRegistryImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardPinImpl;
import java.security.AlgorithmParameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import opencard.core.service.CardChannel;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.util.HexString;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NiedersachsenDOINetKey30
extends NetKey30 {
    protected static final String TELESEC_NDSDOI_NETKEY_30 = "Niedersachsen/DOI ";
    private static final Log LOG = LogFactory.getLog(NiedersachsenDOINetKey30.class);
    static final String EF_GDO_ISSUER_CONSTANT = "5a 0a 89 49 01 73 30";
    private static final byte GLOBAL_PINID = 0;
    private static final long GLOBAL_PIN_ID = 2000001L;

    @Override
    public String getDisplayName() {
        return TELESEC_NDSDOI_NETKEY_30 + super.getDisplayName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String readIssuerFromATR(CardChannel _channel) {
        String issuer = super.simpleReadIssuerFromATR(_channel);
        try {
            try {
                CommandAPDU cmd = APDUCommands.createSelectCommand(4, 12, HexUtil.parse("d2760001050002"), 1024);
                LOG.debug((Object)("SELECT AID CMD : " + HexString.hexify(cmd.getBuffer(), false)));
                ResponseAPDU res = _channel.sendCommandAPDU(cmd);
                LOG.debug((Object)("SELECT AID RESP : " + HexString.hexify(res.getBuffer(), false)));
                if (res.sw() == 36864) {
                    throw new CardTerminalException("no Niedersachsen/DOI");
                }
                cmd = APDUCommands.createSelectCommand(4, 12, HexUtil.parse("d2760001050001"), 1024);
                LOG.debug((Object)("SELECT AID CMD : " + HexString.hexify(cmd.getBuffer(), false)));
                res = _channel.sendCommandAPDU(cmd);
                LOG.debug((Object)("SELECT AID RESP : " + HexString.hexify(res.getBuffer(), false)));
                if (res.sw() == 36864) {
                    throw new CardTerminalException("no Niedersachsen/DOI");
                }
                cmd = APDUCommands.createSelectCommand(4, 12, HexUtil.parse("d2760000030102"), 1024);
                LOG.debug((Object)("SELECT AID CMD : " + HexString.hexify(cmd.getBuffer(), false)));
                res = _channel.sendCommandAPDU(cmd);
                LOG.debug((Object)("SELECT AID RESP : " + HexString.hexify(res.getBuffer(), false)));
                if (res.sw() != 36864) {
                    throw new CardTerminalException("no Niedersachsen/DOI");
                }
                cmd = APDUCommands.createSelectCommand(2, 12, HexUtil.parse("4331"), 1024);
                LOG.debug((Object)("SELECT CER CMD : " + HexString.hexify(cmd.getBuffer(), false)));
                res = _channel.sendCommandAPDU(cmd);
                LOG.debug((Object)("SELECT CER RESP : " + HexString.hexify(res.getBuffer(), false)));
                if (res.sw() != 36864) {
                    throw new CardTerminalException("no Niedersachsen/DOI");
                }
            }
            catch (CardTerminalException e) {
                throw e;
            }
            catch (Exception e) {
                // empty catch block
            }
            super.selectFile(_channel, new FileReference(4, "d27600006601"));
            super.selectFile(_channel, new FileReference(2, "5349"));
            ResponseAPDU response = super.readRecord(_channel, 1);
            byte[] data = response.data();
            if (response.sw() == 36864 || data == null || data.length >= 14) {
                byte[] tail = new byte[14];
                System.arraycopy(data, data.length - 14, tail, 0, 14);
                byte[] compare = new byte[14];
                issuer = !Arrays.equals(tail, compare) ? EF_GDO_ISSUER_CONSTANT : null;
            } else {
                issuer = null;
            }
        }
        catch (Exception e) {
            issuer = null;
        }
        finally {
            try {
                super.selectMasterFile(_channel);
            }
            catch (Exception exception) {}
        }
        return issuer;
    }

    @Override
    protected Card createCardInt(Terminal terminal, int slotID) {
        long idOfCard = CARD_OBJECT_REGISTRY.createNewCardID();
        long idOfPin01 = 2000001L;
        long idOfMFApplication = 1000000L;
        CardApplication application01 = this.createSignApp(terminal, slotID, idOfCard, idOfMFApplication, idOfPin01);
        CardApplication application02 = this.createEncDecAutApp(terminal, slotID, idOfCard, idOfMFApplication, idOfPin01);
        FileReference dirRefMF = new FileReference(0, "3f00");
        FileEntry fileEntryMF = new FileEntry(dirRefMF, dirRefMF);
        byte pinID01 = 0;
        CardPinImpl pin01 = new CardPinImpl(Disposeable.NO_LOCK, "Globale PIN", idOfPin01, CardPin.CardPinTypeEnum.PIN.getType(), fileEntryMF, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID01, new long[]{4000002L, 4000003L, 4000004L, 4000005L, 4000006L});
        CardObjectManagerImpl mfManager = new CardObjectManagerImpl(idOfMFApplication);
        if (application01 != null) {
            mfManager.putApplication(application01);
        }
        if (application02 != null) {
            mfManager.putApplication(application02);
        }
        mfManager.putPin(pin01);
        CardApplicationImpl mfApplication = new CardApplicationImpl("MF", idOfMFApplication, CardApplication.CardApplicationTypeEnum.UNKNOWN.getType(), fileEntryMF, (CardObjectManager)mfManager, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        CardImpl card = new CardImpl(this.getDisplayName() + "-" + String.valueOf(idOfCard), idOfCard, this.getCardTypeEnum().getType(), super.getCard(), mfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance());
        return card;
    }

    @Override
    protected Card.CardTypeEnum getCardTypeEnum() {
        return Card.CardTypeEnum.DOI;
    }

    private CardApplication createSignApp(Terminal terminal, int slotID, long idOfCard, long idOfMFApplication, long idOfPinCH) {
        if (!CardPerformanceSettings.getInstance().getBooleanProperty("TeleSecNetKey30SignatureKey")) {
            return null;
        }
        long idOfApplication = 1000001L;
        long idOfPin01 = 2000002L;
        long idOfFile01 = 3000001L;
        long idOfKey01 = 4000001L;
        KeyID k01 = new KeyID("84");
        byte pinID01 = -127;
        FileReference dirRefQSIGN = new FileReference(4, "d27600006601");
        FileReference cerRef01 = new FileReference(2, "c000");
        FileEntry fileEntry01 = new FileEntry(dirRefQSIGN, cerRef01);
        OCFCertificateInfo info01 = new OCFCertificateInfo(idOfCard, idOfPin01, idOfFile01, idOfKey01, OCFCertificateInfo.ChainEntry.USER, null, null);
        CardPinImpl pin01 = new CardPinImpl(Disposeable.NO_LOCK, "Signatur-PIN", idOfPin01, CardPin.CardPinTypeEnum.PIN.getType(), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID01, idOfKey01);
        CardFileImpl file01 = new CardFileImpl(Disposeable.NO_LOCK, "cerSig", idOfFile01, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey01);
        CardKeyImpl key01 = new CardKeyImpl(Disposeable.NO_LOCK, "SignatureKey", idOfKey01, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.EUROPEAN_QUALIFIED_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.QUALIFIED_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.ACCREDITED_SIGNATURE_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.SIGNATURE.getType()}), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info01, idOfFile01, idOfPin01, k01);
        CardObjectManagerImpl manager = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl application = new CardApplicationImpl("d27600006601", idOfApplication, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.SIGNATURE.getType()}), fileEntry01, (CardObjectManager)manager, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        application.putPin(pin01);
        application.putFile(file01);
        application.putKey(key01);
        return application;
    }

    private CardApplication createEncDecAutApp(Terminal terminal, int slotID, long idOfCard, long idOfMFApplication, long idOfPinCH) {
        CardKeyImpl key03;
        long idOfApplication = 1000002L;
        long idOfFile01 = 3000002L;
        long idOfFile02 = 3000003L;
        long idOfFile03 = 3000004L;
        long idOfFile04 = 3000005L;
        long idOfFile05 = 3000006L;
        long idOfKey01 = 4000002L;
        long idOfKey02 = 4000003L;
        long idOfKey03 = 4000004L;
        long idOfKey04 = 4000005L;
        long idOfKey05 = 4000006L;
        if (!(CardPerformanceSettings.getInstance().getBooleanProperty("TeleSecNetKey30AdvancedSignatureKey") || CardPerformanceSettings.getInstance().getBooleanProperty("TeleSecNetKey30EncryptionKeyE4DecryptionKey") || CardPerformanceSettings.getInstance().getBooleanProperty("TeleSecNetKey30AuthenticationKey") || CardPerformanceSettings.getInstance().getBooleanProperty("TeleSecNetKey30SignatureKeyE4EncryptionKeyE4DecryptionKeyE4AuthenticationKey") || CardPerformanceSettings.getInstance().getBooleanProperty("TeleSecNetKey30HessenPKISignatureKey"))) {
            return null;
        }
        FileReference dirRef = new FileReference(4, "d2760000030102");
        FileReference fileRef01 = new FileReference(2, "c000");
        FileEntry fileEntry01 = new FileEntry(dirRef, fileRef01);
        CardObjectManagerImpl manager = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl application = new CardApplicationImpl("d2760000030102", idOfApplication, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.ENCRYPTION.getType(), CardApplication.CardApplicationTypeEnum.DECRYPTION.getType(), CardApplication.CardApplicationTypeEnum.AUTHENTICATION.getType(), CardApplication.CardApplicationTypeEnum.SIGNATURE.getType()}), fileEntry01, (CardObjectManager)manager, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        if (CardPerformanceSettings.getInstance().getBooleanProperty("TeleSecNetKey30AdvancedSignatureKey")) {
            KeyID k01 = new KeyID("80");
            OCFCertificateInfo info01 = new OCFCertificateInfo(idOfCard, idOfPinCH, idOfFile01, idOfKey01, OCFCertificateInfo.ChainEntry.USER, null, null);
            CardFileImpl file01 = new CardFileImpl(Disposeable.NO_LOCK, "cerSig", idOfFile01, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey01);
            CardKeyImpl cardKeyImpl = new CardKeyImpl(Disposeable.NO_LOCK, "AdvancedSignatureKey", idOfKey01, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.ADVANCED_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.SIGNATURE.getType()}), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info01, idOfFile01, idOfPinCH, k01);
        }
        if (CardPerformanceSettings.getInstance().getBooleanProperty("TeleSecNetKey30EncryptionKeyE4DecryptionKey")) {
            KeyID k02 = new KeyID("81");
            FileReference fileRef02 = new FileReference(2, "c200");
            FileEntry fileEntry02 = new FileEntry(dirRef, fileRef02);
            OCFCertificateInfo info02 = new OCFCertificateInfo(idOfCard, idOfPinCH, idOfFile02, idOfKey02, OCFCertificateInfo.ChainEntry.USER, null, null);
            CardFileImpl file02 = new CardFileImpl(Disposeable.NO_LOCK, "cerEnc", idOfFile02, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry02, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey02);
            CardKeyImpl key02 = new CardKeyImpl(Disposeable.NO_LOCK, "EncryptionKey/E4DecryptionKey", idOfKey02, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_DECRYPTION.getType(), CardKey.CardKeyTypeEnum.DEFAULT_ENCRYPTION.getType(), CardKey.CardKeyTypeEnum.ENCRYPTION.getType(), CardKey.CardKeyTypeEnum.DECRYPTION.getType()}), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info02, idOfFile02, idOfPinCH, k02);
            application.putFile(file02);
            application.putKey(key02);
        }
        if (CardPerformanceSettings.getInstance().getBooleanProperty("TeleSecNetKey30AuthenticationKey")) {
            KeyID k03 = new KeyID("82");
            FileReference fileRef03 = new FileReference(2, "c500");
            FileEntry fileEntry03 = new FileEntry(dirRef, fileRef03);
            OCFCertificateInfo info03 = new OCFCertificateInfo(idOfCard, idOfPinCH, idOfFile03, idOfKey03, OCFCertificateInfo.ChainEntry.USER, null, null);
            CardFileImpl file03 = new CardFileImpl(Disposeable.NO_LOCK, "cerAut", idOfFile03, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry03, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey03);
            key03 = new CardKeyImpl(Disposeable.NO_LOCK, "AuthenticationKey", idOfKey03, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_AUTHENTICATION.getType(), CardKey.CardKeyTypeEnum.AUTHENTICATION.getType(), CardKey.CardKeyTypeEnum.AUTHENTICATION_BY_ENCRYPTION.getType()}), fileEntry03, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info03, idOfFile03, idOfPinCH, k03);
            application.putFile(file03);
            application.putKey(key03);
        }
        if (CardPerformanceSettings.getInstance().getBooleanProperty("TeleSecNetKey30SignatureKeyE4EncryptionKeyE4DecryptionKeyE4AuthenticationKey")) {
            KeyID k04 = new KeyID("82");
            FileReference fileRef04 = new FileReference(2, "c201");
            FileEntry fileEntry04 = new FileEntry(dirRef, fileRef04);
            OCFCertificateInfo info04 = new OCFCertificateInfo(idOfCard, idOfPinCH, idOfFile04, idOfKey04, OCFCertificateInfo.ChainEntry.USER, null, null);
            CardFileImpl file04 = new CardFileImpl(Disposeable.NO_LOCK, "cerEncSigAut", idOfFile04, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry04, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey04);
            key03 = new CardKeyImpl(Disposeable.NO_LOCK, "SignatureKey/E4EncryptionKey/E4DecryptionKey/E4AuthenticationKey", idOfKey04, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.SIGNATURE.getType(), CardKey.CardKeyTypeEnum.ADVANCED_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.ENCRYPTION.getType(), CardKey.CardKeyTypeEnum.DECRYPTION.getType(), CardKey.CardKeyTypeEnum.AUTHENTICATION.getType(), CardKey.CardKeyTypeEnum.AUTHENTICATION_BY_ENCRYPTION.getType()}), fileEntry04, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info04, idOfFile04, idOfPinCH, k04);
        }
        if (CardPerformanceSettings.getInstance().getBooleanProperty("TeleSecNetKey30HessenPKISignatureKey")) {
            KeyID k05 = new KeyID("00");
            FileReference fileRef05 = new FileReference(2, "4331");
            FileEntry fileEntry05 = new FileEntry(dirRef, fileRef05);
            OCFCertificateInfo info05 = new OCFCertificateInfo(idOfCard, idOfPinCH, idOfFile05, idOfKey05, OCFCertificateInfo.ChainEntry.USER, null, null);
            CardFileImpl file05 = new CardFileImpl(Disposeable.NO_LOCK, "cerSigHessenPKI", idOfFile05, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry05, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey05);
            CardKeyImpl key05 = new CardKeyImpl(Disposeable.NO_LOCK, "HessenPKISignatureKey", idOfKey05, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.SIGNATURE.getType(), CardKey.CardKeyTypeEnum.QUALIFIED_SIGNATURE.getType()}), fileEntry05, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info05, idOfFile05, idOfPinCH, k05);
            application.putFile(file05);
            application.putKey(key05);
        }
        return application;
    }

    @Override
    public OCFCertificateInfo[] createCertificateInfos() {
        return new OCFCertificateInfo[0];
    }

    @Override
    protected final CommandAPDU createMSECommand(CardChannel _channel, OCFCertificateInfo _info, int _type, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        switch (_type) {
            case 1: {
                return null;
            }
            case 2: {
                CommandAPDU cmd = null;
                ResponseAPDU res = null;
                cmd = new CommandAPDU(HexString.parseHexString("0022f301"));
                LOG.debug((Object)("RESET MSE CMD : " + HexString.hexify(cmd.getBuffer(), false)));
                res = _channel.sendCommandAPDU(cmd);
                if (res == null) {
                    throw new ResponseCodeException(RESOURCES.getString("no_response"));
                }
                LOG.debug((Object)("RESET MSE RES : " + HexString.hexify(res.getBuffer(), false)));
                byte[] keyID = _info.getKeyID().getID();
                byte[] data = new byte[5 + keyID.length];
                int index = 0;
                data[index++] = -124;
                data[index++] = (byte)keyID.length;
                System.arraycopy(keyID, 0, data, 2, keyID.length);
                index += keyID.length;
                data[index++] = -128;
                data[index++] = 1;
                data[index++] = 10;
                return APDUCommands.createManageSecurityEnvironmentCommand((byte)65, (byte)-72, data);
            }
        }
        if (!Arrays.equals(_info.getKeyID().id, HexString.parseHexString("84"))) {
            return null;
        }
        CommandAPDU cmd = null;
        ResponseAPDU res = null;
        cmd = new CommandAPDU(HexString.parseHexString("0022f301"));
        LOG.debug((Object)("RESET MSE CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        res = _channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        LOG.debug((Object)("RESET MSE RES : " + HexString.hexify(res.getBuffer(), false)));
        byte[] keyID = _info.getKeyID().getID();
        byte[] data = new byte[5 + keyID.length];
        int index = 0;
        data[index++] = -124;
        data[index++] = (byte)keyID.length;
        System.arraycopy(keyID, 0, data, 2, keyID.length);
        index += keyID.length;
        data[index++] = -128;
        data[index++] = 1;
        data[index++] = 2;
        return APDUCommands.createManageSecurityEnvironmentCommand((byte)65, (byte)-74, data);
    }

    @Override
    public List<String> getAvailableHashAlgorithmNames(OCFCertificateInfo _info) {
        ArrayList<String> c = new ArrayList<String>();
        if ("81".equals(HexString.hexify(_info.getKeyID().id))) {
            return c;
        }
        if (this.isSignatureRelatedKey(_info)) {
            c.add("SHA1");
            c.add("RIPEMD160");
            c.add("SHA224");
            c.add("SHA384");
            c.add("SHA512");
            c.add("SHA256");
        }
        return c;
    }

    public boolean isSignatureRelatedKey(OCFCertificateInfo _info) {
        if (!"84".equals(HexString.hexify(_info.getKeyID().id))) {
            return true;
        }
        return !(_info.getX509Certificate() == null || _info.getX509Certificate().getKeyUsage() == null || !_info.getX509Certificate().getKeyUsage()[0] && !_info.getX509Certificate().getKeyUsage()[1] || _info.getUsage() != OCFCertificateInfo.Usage.SIG && _info.getUsage() != OCFCertificateInfo.Usage.AUT && _info.getUsage() != OCFCertificateInfo.Usage.AEN && _info.getUsage() != OCFCertificateInfo.Usage.ASC);
    }
}

