/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.tcos;

import de.bos_bremen.gov2.jca_provider.ocf.cards.FileReference;
import de.bos_bremen.gov2.jca_provider.ocf.cards.tcos.NetKey30;
import de.bos_bremen.gov2.jca_provider.ocf.model.Card;
import java.util.Arrays;
import opencard.core.service.CardChannel;
import opencard.core.terminal.ResponseAPDU;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NetKey30M
extends NetKey30 {
    private static final String MULTICARD = "-multicard";
    private static final String TELESEC_NETKEY_30M = "TeleSec NetKey 3.0M ";
    private static final Log LOG = LogFactory.getLog(NetKey30M.class);

    @Override
    public String getDisplayName() {
        return TELESEC_NETKEY_30M + super.getDisplayName().substring("TeleSec NetKey 3.0 ".length());
    }

    @Override
    public boolean isMultiSign() {
        return true;
    }

    @Override
    protected String getIssuerConstant() {
        return super.getIssuerConstant() + MULTICARD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String readIssuerFromATR(CardChannel _channel) {
        Object issuer = super.simpleReadIssuerFromATR(_channel);
        try {
            super.selectFile(_channel, new FileReference(4, "d27600006601"));
            super.selectFile(_channel, new FileReference(2, "5349"));
            ResponseAPDU response = super.readRecord(_channel, 1);
            byte[] data = response.data();
            if (response.sw() == 36864 || data == null || data.length >= 14) {
                byte[] tail = new byte[14];
                System.arraycopy(data, data.length - 14, tail, 0, 14);
                byte[] compare = new byte[14];
                issuer = Arrays.equals(tail, compare) ? super.getIssuerConstant() + MULTICARD : null;
            } else {
                issuer = null;
            }
        }
        catch (Exception e) {
            issuer = null;
        }
        finally {
            try {
                super.selectMasterFile(_channel);
            }
            catch (Exception exception) {}
        }
        return issuer;
    }

    @Override
    protected Card.CardTypeEnum getCardTypeEnum() {
        return Card.CardTypeEnum.TELESEC_NETKEY30M;
    }

    @Override
    public boolean isStapleSign() {
        return NetKey30.isStapleSign(this);
    }

    @Override
    public Integer getStapleSignCounter() {
        return this.isStapleSign() ? MAXIMUM_COUNT_OF_STAPLE_SIGNATURES : null;
    }
}

