/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.tcos;

import de.bos_bremen.common.ByteUtil;
import de.bos_bremen.common.HexUtil;
import de.bos_bremen.common.asn1.ASN1;
import de.bos_bremen.common.asn1.DigestInfo;
import de.bos_bremen.common.asn1.HashAlgorithm;
import de.bos_bremen.gov2.jca_provider.OCFProvider;
import de.bos_bremen.gov2.jca_provider.ocf.FileEntry;
import de.bos_bremen.gov2.jca_provider.ocf.NotYetInitializedException;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.OperationCancelledException;
import de.bos_bremen.gov2.jca_provider.ocf.PinDeactivatedException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputCancelledException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputTimeoutException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputTooLongException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputTooShortException;
import de.bos_bremen.gov2.jca_provider.ocf.ProgressSession;
import de.bos_bremen.gov2.jca_provider.ocf.ResponseCodeException;
import de.bos_bremen.gov2.jca_provider.ocf.RetryCounterExpiredException;
import de.bos_bremen.gov2.jca_provider.ocf.WrongPinException;
import de.bos_bremen.gov2.jca_provider.ocf.cards.APDUCommands;
import de.bos_bremen.gov2.jca_provider.ocf.cards.CardChannelManager;
import de.bos_bremen.gov2.jca_provider.ocf.cards.CardPerformanceSettings;
import de.bos_bremen.gov2.jca_provider.ocf.cards.ChannelState;
import de.bos_bremen.gov2.jca_provider.ocf.cards.FileReference;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.KeyID;
import de.bos_bremen.gov2.jca_provider.ocf.cards.MaxSignatureCountReachedException;
import de.bos_bremen.gov2.jca_provider.ocf.cards.tcos.TCOSv2r3;
import de.bos_bremen.gov2.jca_provider.ocf.channel.util.SSCIvParameterSpec;
import de.bos_bremen.gov2.jca_provider.ocf.channel.util.SSCIvParameterSpecImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.Card;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardApplication;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardFile;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardKey;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardObjectManager;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardPin;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardRegistry;
import de.bos_bremen.gov2.jca_provider.ocf.model.Disposeable;
import de.bos_bremen.gov2.jca_provider.ocf.model.Terminal;
import de.bos_bremen.gov2.jca_provider.ocf.model.Type;
import de.bos_bremen.gov2.jca_provider.ocf.model.TypedType;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardApplicationImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardFileImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardKeyImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectManagerImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectRegistryImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardPinImpl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import opencard.core.service.CardChannel;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.util.HexString;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.asn1.x509.RSAPublicKeyStructure;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.DESEngine;
import org.bouncycastle.crypto.engines.RSAEngine;
import org.bouncycastle.crypto.params.DESParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;

public class NetKey30
extends TCOSv2r3 {
    protected static final String TELESEC_NETKEY_30 = "TeleSec NetKey 3.0 ";
    private static final Log LOG = LogFactory.getLog(NetKey30.class);
    private static final byte[] HISTORICALS = HexString.parseHexString("00 64 04 11 03 01 31 c0 73 f7 01 d0 00 90 00");
    static final String EF_GDO_ISSUER_CONSTANT = "5a 0a 89 49 01 73 30";
    private static final byte GLOBAL_PINID = 0;
    private static final long GLOBAL_PIN_ID = 2000001L;
    private static boolean detailLog = false;

    @Override
    protected byte[] getHistoricals() {
        return HISTORICALS;
    }

    @Override
    protected boolean historicalsEquals(byte[] _historicals) {
        return Arrays.equals(this.getHistoricals(), _historicals);
    }

    @Override
    protected String getIssuerConstant() {
        return EF_GDO_ISSUER_CONSTANT;
    }

    @Override
    public String getDisplayName() {
        return TELESEC_NETKEY_30 + super.getDisplayName();
    }

    protected String simpleReadIssuerFromATR(CardChannel _channel) {
        return super.readIssuerFromATR(_channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String readIssuerFromATR(CardChannel _channel) {
        String issuer = this.simpleReadIssuerFromATR(_channel);
        try {
            try {
                CommandAPDU cmd = APDUCommands.createSelectCommand(4, 12, HexUtil.parse("d2760001050002"), 1024);
                LOG.debug((Object)("SELECT AID CMD : " + HexString.hexify(cmd.getBuffer(), false)));
                ResponseAPDU res = _channel.sendCommandAPDU(cmd);
                LOG.debug((Object)("SELECT AID RESP : " + HexString.hexify(res.getBuffer(), false)));
                if (res.sw() == 36864) {
                    throw new CardTerminalException("new default NetKey 3.0");
                }
                cmd = APDUCommands.createSelectCommand(4, 12, HexUtil.parse("d2760001050001"), 1024);
                LOG.debug((Object)("SELECT AID CMD : " + HexString.hexify(cmd.getBuffer(), false)));
                res = _channel.sendCommandAPDU(cmd);
                LOG.debug((Object)("SELECT AID RESP : " + HexString.hexify(res.getBuffer(), false)));
                if (res.sw() == 36864) {
                    throw new CardTerminalException("new default NetKey 3.0");
                }
                cmd = APDUCommands.createSelectCommand(4, 12, HexUtil.parse("d2760000030102"), 1024);
                LOG.debug((Object)("SELECT AID CMD : " + HexString.hexify(cmd.getBuffer(), false)));
                res = _channel.sendCommandAPDU(cmd);
                LOG.debug((Object)("SELECT AID RESP : " + HexString.hexify(res.getBuffer(), false)));
                if (res.sw() != 36864) {
                    throw new CardTerminalException("new default NetKey 3.0");
                }
                cmd = APDUCommands.createSelectCommand(2, 12, HexUtil.parse("4331"), 1024);
                LOG.debug((Object)("SELECT CER CMD : " + HexString.hexify(cmd.getBuffer(), false)));
                res = _channel.sendCommandAPDU(cmd);
                LOG.debug((Object)("SELECT CER RESP : " + HexString.hexify(res.getBuffer(), false)));
                if (res.sw() == 36864) {
                    throw new CardTerminalException("new default NetKey 3.0");
                }
            }
            catch (CardTerminalException e) {
                throw e;
            }
            catch (Exception e) {
                // empty catch block
            }
            super.selectFile(_channel, new FileReference(4, "d27600006601"));
            super.selectFile(_channel, new FileReference(2, "5349"));
            ResponseAPDU response = super.readRecord(_channel, 1);
            byte[] data = response.data();
            if (response.sw() == 36864 || data == null || data.length >= 14) {
                byte[] tail = new byte[14];
                System.arraycopy(data, data.length - 14, tail, 0, 14);
                byte[] compare = new byte[14];
                issuer = !Arrays.equals(tail, compare) ? EF_GDO_ISSUER_CONSTANT : null;
            } else {
                issuer = null;
            }
        }
        catch (Exception e) {
            issuer = null;
        }
        finally {
            try {
                super.selectMasterFile(_channel);
            }
            catch (Exception exception) {}
        }
        return issuer;
    }

    @Override
    protected Card createCardInt(Terminal terminal, int slotID) {
        try {
            long idOfCard = CARD_OBJECT_REGISTRY.createNewCardID();
            long idOfPin01 = 2000001L;
            long idOfMFApplication = 1000000L;
            CardApplication application01 = this.createSignApp(terminal, slotID, idOfCard, idOfMFApplication, idOfPin01);
            CardApplication application02 = this.createEncDecAutApp(terminal, slotID, idOfCard, idOfMFApplication, idOfPin01);
            FileReference dirRefMF = new FileReference(0, "3f00");
            FileEntry fileEntryMF = new FileEntry(dirRefMF, dirRefMF);
            byte pinID01 = 0;
            CardPinImpl pin01 = new CardPinImpl(Disposeable.NO_LOCK, "Globale PIN", idOfPin01, CardPin.CardPinTypeEnum.PIN.getType(), fileEntryMF, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID01, new long[]{4000002L, 4000003L, 4000004L, 4000005L, 4000006L});
            CardObjectManagerImpl mfManager = new CardObjectManagerImpl(idOfMFApplication);
            if (application01 != null) {
                mfManager.putApplication(application01);
            }
            if (application02 != null) {
                mfManager.putApplication(application02);
            }
            mfManager.putPin(pin01);
            CardApplicationImpl mfApplication = new CardApplicationImpl("MF", idOfMFApplication, CardApplication.CardApplicationTypeEnum.UNKNOWN.getType(), fileEntryMF, (CardObjectManager)mfManager, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
            CardImpl card = new CardImpl(this.getDisplayName() + "-" + String.valueOf(idOfCard), idOfCard, this.getCardTypeEnum().getType(), super.getCard(), mfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance());
            return card;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
            return null;
        }
    }

    @Override
    protected Card.CardTypeEnum getCardTypeEnum() {
        return Card.CardTypeEnum.TELESEC_NETKEY30;
    }

    private CardApplication createSignApp(Terminal terminal, int slotID, long idOfCard, long idOfMFApplication, long idOfPinCH) {
        if (!CardPerformanceSettings.getInstance().getBooleanProperty("TeleSecNetKey30SignatureKey")) {
            return null;
        }
        long idOfApplication = 1000001L;
        long idOfPin01 = 2000002L;
        long idOfFile01 = 3000001L;
        long idOfKey01 = 4000001L;
        KeyID k01 = new KeyID("84");
        byte pinID01 = -127;
        FileReference dirRefQSIGN = new FileReference(4, "d27600006601");
        FileReference cerRef01 = new FileReference(2, "c000");
        FileEntry fileEntry01 = new FileEntry(dirRefQSIGN, cerRef01);
        OCFCertificateInfo info01 = new OCFCertificateInfo(idOfCard, idOfPin01, idOfFile01, idOfKey01, OCFCertificateInfo.ChainEntry.USER, null, null);
        CardPinImpl pin01 = new CardPinImpl(Disposeable.NO_LOCK, "Signatur-PIN", idOfPin01, CardPin.CardPinTypeEnum.PIN.getType(), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID01, idOfKey01);
        CardFileImpl file01 = new CardFileImpl(Disposeable.NO_LOCK, "cerSig", idOfFile01, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey01);
        CardKeyImpl key01 = new CardKeyImpl(Disposeable.NO_LOCK, "SignatureKey", idOfKey01, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.EUROPEAN_QUALIFIED_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.QUALIFIED_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.ACCREDITED_SIGNATURE_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.SIGNATURE.getType()}), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info01, idOfFile01, idOfPin01, k01);
        CardObjectManagerImpl manager = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl application = new CardApplicationImpl("d27600006601", idOfApplication, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.SIGNATURE.getType()}), fileEntry01, (CardObjectManager)manager, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        application.putPin(pin01);
        application.putFile(file01);
        application.putKey(key01);
        return application;
    }

    private CardApplication createEncDecAutApp(Terminal terminal, int slotID, long idOfCard, long idOfMFApplication, long idOfPinCH) {
        long idOfApplication = 1000002L;
        long idOfFile01 = 3000002L;
        long idOfFile02 = 3000003L;
        long idOfFile03 = 3000004L;
        long idOfFile04 = 3000005L;
        long idOfKey01 = 4000002L;
        long idOfKey02 = 4000003L;
        long idOfKey03 = 4000004L;
        long idOfKey04 = 4000005L;
        if (!(CardPerformanceSettings.getInstance().getBooleanProperty("TeleSecNetKey30AdvancedSignatureKey") || CardPerformanceSettings.getInstance().getBooleanProperty("TeleSecNetKey30EncryptionKeyE4DecryptionKey") || CardPerformanceSettings.getInstance().getBooleanProperty("TeleSecNetKey30AuthenticationKey") || CardPerformanceSettings.getInstance().getBooleanProperty("TeleSecNetKey30SignatureKeyE4EncryptionKeyE4DecryptionKeyE4AuthenticationKey"))) {
            return null;
        }
        FileReference dirRef = new FileReference(4, "d2760000030102");
        FileReference fileRef01 = new FileReference(2, "c000");
        FileEntry fileEntry01 = new FileEntry(dirRef, fileRef01);
        CardObjectManagerImpl manager = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl application = new CardApplicationImpl("d2760000030102", idOfApplication, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.ENCRYPTION.getType(), CardApplication.CardApplicationTypeEnum.DECRYPTION.getType(), CardApplication.CardApplicationTypeEnum.AUTHENTICATION.getType(), CardApplication.CardApplicationTypeEnum.SIGNATURE.getType()}), fileEntry01, (CardObjectManager)manager, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        if (CardPerformanceSettings.getInstance().getBooleanProperty("TeleSecNetKey30AdvancedSignatureKey")) {
            KeyID k01 = new KeyID("80");
            OCFCertificateInfo info01 = new OCFCertificateInfo(idOfCard, idOfPinCH, idOfFile01, idOfKey01, OCFCertificateInfo.ChainEntry.USER, null, null);
            CardFileImpl file01 = new CardFileImpl(Disposeable.NO_LOCK, "cerSig", idOfFile01, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey01);
            CardKeyImpl cardKeyImpl = new CardKeyImpl(Disposeable.NO_LOCK, "AdvancedSignatureKey", idOfKey01, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.ADVANCED_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.SIGNATURE.getType()}), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info01, idOfFile01, idOfPinCH, k01);
        }
        if (CardPerformanceSettings.getInstance().getBooleanProperty("TeleSecNetKey30EncryptionKeyE4DecryptionKey")) {
            KeyID k02 = new KeyID("81");
            FileReference fileRef02 = new FileReference(2, "c200");
            FileEntry fileEntry02 = new FileEntry(dirRef, fileRef02);
            OCFCertificateInfo info02 = new OCFCertificateInfo(idOfCard, idOfPinCH, idOfFile02, idOfKey02, OCFCertificateInfo.ChainEntry.USER, null, null);
            CardFileImpl file02 = new CardFileImpl(Disposeable.NO_LOCK, "cerEnc", idOfFile02, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry02, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey02);
            CardKeyImpl key02 = new CardKeyImpl(Disposeable.NO_LOCK, "EncryptionKey/E4DecryptionKey", idOfKey02, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_DECRYPTION.getType(), CardKey.CardKeyTypeEnum.DEFAULT_ENCRYPTION.getType(), CardKey.CardKeyTypeEnum.ENCRYPTION.getType(), CardKey.CardKeyTypeEnum.DECRYPTION.getType()}), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info02, idOfFile02, idOfPinCH, k02);
            application.putFile(file02);
            application.putKey(key02);
        }
        if (CardPerformanceSettings.getInstance().getBooleanProperty("TeleSecNetKey30AuthenticationKey")) {
            KeyID k03 = new KeyID("82");
            FileReference fileRef03 = new FileReference(2, "c500");
            FileEntry fileEntry03 = new FileEntry(dirRef, fileRef03);
            OCFCertificateInfo info03 = new OCFCertificateInfo(idOfCard, idOfPinCH, idOfFile03, idOfKey03, OCFCertificateInfo.ChainEntry.USER, null, null);
            CardFileImpl file03 = new CardFileImpl(Disposeable.NO_LOCK, "cerAut", idOfFile03, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry03, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey03);
            CardKeyImpl key03 = new CardKeyImpl(Disposeable.NO_LOCK, "AuthenticationKey", idOfKey03, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_AUTHENTICATION.getType(), CardKey.CardKeyTypeEnum.AUTHENTICATION.getType(), CardKey.CardKeyTypeEnum.AUTHENTICATION_BY_ENCRYPTION.getType()}), fileEntry03, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info03, idOfFile03, idOfPinCH, k03);
            application.putFile(file03);
            application.putKey(key03);
        }
        if (CardPerformanceSettings.getInstance().getBooleanProperty("TeleSecNetKey30SignatureKeyE4EncryptionKeyE4DecryptionKeyE4AuthenticationKey")) {
            KeyID k04 = new KeyID("82");
            FileReference fileRef04 = new FileReference(2, "c201");
            FileEntry fileEntry04 = new FileEntry(dirRef, fileRef04);
            OCFCertificateInfo info04 = new OCFCertificateInfo(idOfCard, idOfPinCH, idOfFile04, idOfKey04, OCFCertificateInfo.ChainEntry.USER, null, null);
            CardFileImpl file04 = new CardFileImpl(Disposeable.NO_LOCK, "cerEncSigAut", idOfFile04, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry04, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey04);
            CardKeyImpl cardKeyImpl = new CardKeyImpl(Disposeable.NO_LOCK, "SignatureKey/E4EncryptionKey/E4DecryptionKey/E4AuthenticationKey", idOfKey04, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.SIGNATURE.getType(), CardKey.CardKeyTypeEnum.ADVANCED_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.ENCRYPTION.getType(), CardKey.CardKeyTypeEnum.DECRYPTION.getType(), CardKey.CardKeyTypeEnum.AUTHENTICATION.getType(), CardKey.CardKeyTypeEnum.AUTHENTICATION_BY_ENCRYPTION.getType()}), fileEntry04, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info04, idOfFile04, idOfPinCH, k04);
        }
        return application;
    }

    @Override
    public OCFCertificateInfo[] createCertificateInfos() {
        return new OCFCertificateInfo[0];
    }

    @Override
    protected void adjustForPaddingByte(GovCS.ResultObject _ro) {
    }

    @Override
    protected CommandAPDU createMSECommand(CardChannel _channel, OCFCertificateInfo _info, int _type, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        switch (_type) {
            case 1: {
                return null;
            }
            case 2: {
                CommandAPDU cmd = null;
                ResponseAPDU res = null;
                cmd = new CommandAPDU(HexString.parseHexString("0022f301"));
                LOG.debug((Object)("RESET MSE CMD : " + HexString.hexify(cmd.getBuffer(), false)));
                res = _channel.sendCommandAPDU(cmd);
                if (res == null) {
                    throw new ResponseCodeException(RESOURCES.getString("no_response"));
                }
                LOG.debug((Object)("RESET MSE RES : " + HexString.hexify(res.getBuffer(), false)));
                byte[] keyID = _info.getKeyID().getID();
                byte[] data = new byte[5 + keyID.length];
                int index = 0;
                data[index++] = -124;
                data[index++] = (byte)keyID.length;
                System.arraycopy(keyID, 0, data, 2, keyID.length);
                index += keyID.length;
                data[index++] = -128;
                data[index++] = 1;
                data[index++] = 10;
                return APDUCommands.createManageSecurityEnvironmentCommand((byte)65, (byte)-72, data);
            }
        }
        if (!Arrays.equals(_info.getKeyID().id, HexString.parseHexString("84"))) {
            return null;
        }
        CommandAPDU cmd = null;
        ResponseAPDU res = null;
        cmd = new CommandAPDU(HexString.parseHexString("0022f301"));
        LOG.debug((Object)("RESET MSE CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        res = _channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        LOG.debug((Object)("RESET MSE RES : " + HexString.hexify(res.getBuffer(), false)));
        byte[] keyID = _info.getKeyID().getID();
        byte[] data = new byte[5 + keyID.length];
        int index = 0;
        data[index++] = -124;
        data[index++] = (byte)keyID.length;
        System.arraycopy(keyID, 0, data, 2, keyID.length);
        index += keyID.length;
        data[index++] = -128;
        data[index++] = 1;
        data[index++] = 2;
        return APDUCommands.createManageSecurityEnvironmentCommand((byte)65, (byte)-74, data);
    }

    @Override
    protected final CommandAPDU createDecryptCommand(byte[] _encryptedBytes, byte _paddingIndicator, AlgorithmParameters algorithmParameters) {
        if (_encryptedBytes != null && _encryptedBytes.length < 256) {
            return super.createDecryptCommand(_encryptedBytes, _paddingIndicator, algorithmParameters);
        }
        ByteArray ba = new ByteArray("00 2a 80 86");
        ba = ba.append(new ByteArray(_encryptedBytes.length + 1, 3));
        ba = ba.append(new ByteArray(new byte[]{_paddingIndicator}));
        ba = ba.append(new ByteArray(_encryptedBytes));
        ba = ba.append(new ByteArray("01 00"));
        return new CommandAPDU(ba.getData());
    }

    @Override
    public synchronized GovCS.ResultObject decrypt(OCFCertificateInfo _info, byte[] _encryptedBytes, char[] _pin, AlgorithmParameters algorithmParameters) throws ResponseCodeException, WrongPinException, RetryCounterExpiredException, NotYetInitializedException, PinInputCancelledException, PinInputTooShortException, PinInputTooLongException, PinInputTimeoutException, OperationCancelledException {
        return super.decrypt(_info, _encryptedBytes, _pin, algorithmParameters);
    }

    @Override
    protected GovCS.ResultObject decrypt(CardChannel _channel, OCFCertificateInfo _info, byte[] _encryptedBytes, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, ResponseCodeException, CardTerminalException, ResponseCodeException, OperationCancelledException {
        int i;
        GovCS.ResultObject ro = super.decrypt(_channel, _info, _encryptedBytes, algorithmParameters);
        byte[] b = (byte[])ro.getResultData();
        if (b == null || b.length < 3) {
            return ro;
        }
        if (b[0] != 0 || b[1] != 2) {
            return ro;
        }
        int count = b.length;
        for (i = 2; i < count && b[i] != 0; ++i) {
        }
        byte[] bb = new byte[b.length - i - 1];
        System.arraycopy(b, i + 1, bb, 0, bb.length);
        ro.setResultData(bb);
        return ro;
    }

    @Override
    protected boolean usesASN1HeaderWithAuthentify() {
        return true;
    }

    @Override
    protected final CommandAPDU createAuthentifyCommand(byte[] _hashValue, AlgorithmParameters algorithmParameters) {
        int blockSize = 257;
        byte[] store = new byte[7 + blockSize + 2];
        Arrays.fill(store, (byte)-1);
        int i = 0;
        store[i++] = 0;
        store[i++] = 42;
        store[i++] = -128;
        store[i++] = -122;
        store[i++] = 0;
        store[i++] = (byte)(blockSize >> 8 & 0xFF);
        store[i++] = (byte)(blockSize >> 0 & 0xFF);
        store[i++] = this.getPaddingIndicator();
        store[i++] = 0;
        store[i++] = 1;
        i += blockSize - 3 - _hashValue.length - 1;
        store[i++] = 0;
        System.arraycopy(_hashValue, 0, store, i, _hashValue.length);
        i += _hashValue.length;
        int resultLength = 256;
        store[i++] = (byte)(resultLength >> 8 & 0xFF);
        store[i++] = (byte)(resultLength >> 0 & 0xFF);
        return new CommandAPDU(store);
    }

    @Override
    public List<String> getAvailableHashAlgorithmNames(OCFCertificateInfo _info) {
        ArrayList<String> c = new ArrayList<String>();
        if (!"81".equals(HexString.hexify(_info.getKeyID().id))) {
            c.add("SHA1");
            c.add("RIPEMD160");
            c.add("SHA224");
            c.add("SHA384");
            c.add("SHA512");
            c.add("SHA256");
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized GovCS.ResultObject signHash(OCFCertificateInfo _info, byte[] _hashValue, char[] _pin, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws WrongPinException, RetryCounterExpiredException, NotYetInitializedException, ResponseCodeException, CardTerminalException, OperationCancelledException {
        if (!Arrays.equals(_info.getKeyID().id, HexString.parseHexString("84"))) {
            return super.signHash(_info, _hashValue, _pin, _hashAlgorithm, algorithmParameters);
        }
        LOG.debug((Object)("usesASN1HeaderWithSignHash=" + this.usesASN1HeaderWithSignHash()));
        if (_hashValue != null && this.usesASN1HeaderWithSignHash()) {
            try {
                _hashValue = new DigestInfo(HashAlgorithm.Algorithm.getAlgorithmByName(_hashAlgorithm), _hashValue).getEncoded();
                LOG.debug((Object)("pkcs#1=" + HexString.hexify(_hashValue)));
            }
            catch (Exception ex) {
                LOG.error((Object)"", (Throwable)ex);
            }
        }
        CardChannelManager cardChannelManager = new CardChannelManager();
        ProgressSession session = new ProgressSession(2);
        session.setStepCount(6);
        session.setProgressMessage("init sign hash operation");
        if (this.progressSessionListener != null) {
            this.progressSessionListener.progressSessionWillStart(session);
            this.progressSessionListener.progressSessionStarted(session);
        }
        GovCS.ResultObject ro = new GovCS.ResultObject();
        try {
            ResponseAPDU res;
            CommandAPDU cmd;
            CardChannel channel = cardChannelManager.init(this);
            boolean localTransaction = cardChannelManager.isTransactionLocallyStarted();
            try {
                this.checkSignCounter(null, localTransaction);
            }
            catch (MaxSignatureCountReachedException e) {
                cardChannelManager.allocate();
                this.resetCard(cardChannelManager.getCardChannel());
                throw e;
            }
            int retryCount = this.getRetryCount(_info);
            SMMaterial material = this.getSMMaterial(_info, _pin, channel, session, retryCount);
            if (super.getChannelState(channel).getInfo() != _info) {
                cmd = NetKey30.generateSecureMessagingCommand((byte)0, (byte)-92, (byte)4, (byte)12, HexString.parseHexString("d2 76 00 00 66 01"), null, material.smKeyEnc, material.smKeyMAC, new ByteArray(new byte[8]), material.ssc, material.sscOld);
                LOG.debug((Object)("CMD : " + HexString.hexify(cmd.getBuffer())));
                res = channel.sendCommandAPDU(cmd);
                LOG.debug((Object)("RES : " + HexString.hexify(res.getBuffer())));
                this.assertEquals(res.sw(), 36864);
                res = this.getResponseFromSecureMessage(res, material);
                this.assertEquals(res.sw(), 36864);
                super.setChannelState(channel, _info);
            }
            this.fireProgressEvent(session, "sign the given hash value");
            cmd = NetKey30.generateSecureMessagingCommand((byte)0, (byte)42, (byte)-98, (byte)-102, _hashValue, new ByteArray("00 00"), material.smKeyEnc, material.smKeyMAC, new ByteArray(new byte[8]), material.ssc, material.sscOld);
            LOG.debug((Object)("CMD : " + HexString.hexify(cmd.getBuffer())));
            res = channel.sendCommandAPDU(cmd);
            LOG.debug((Object)("RES : " + HexString.hexify(res.getBuffer())));
            this.assertEquals(res.sw(), 36864);
            res = this.getResponseFromSecureMessage(res, material);
            this.assertEquals(res.sw(), 36864);
            byte[] signature = res.data();
            ro.setResultData(signature);
            ro.setResultCode(res.sw());
            if (ro.getResultCode() == 36864) {
                this.fireProgressEvent(session, "operation finished!");
                try {
                    this.increaseAndCheckSignCounter(null, localTransaction);
                }
                catch (MaxSignatureCountReachedException e) {
                    this.resetCard(channel);
                }
            }
            GovCS.ResultObject resultObject = ro;
            return resultObject;
        }
        catch (OperationCancelledException e) {
            throw e;
        }
        catch (WrongPinException e) {
            throw e;
        }
        catch (RetryCounterExpiredException e) {
            throw e;
        }
        catch (NotYetInitializedException e) {
            throw e;
        }
        catch (ResponseCodeException e) {
            throw e;
        }
        catch (CardTerminalException e) {
            LOG.debug((Object)"", (Throwable)e);
            throw e;
        }
        catch (Throwable ex) {
            LOG.debug((Object)"", ex);
            ro.setResultCode(0);
            GovCS.ResultObject resultObject = ro;
            return resultObject;
        }
        finally {
            cardChannelManager.destroy();
            if (this.progressSessionListener != null) {
                while (session.getCurrentStep() != session.getStepCount()) {
                    session.increaseCurrentStep();
                }
                session.setProgressMessage("done!");
                this.progressSessionListener.progressSessionWillStop(session);
                this.progressSessionListener.progressSessionStopped(session);
            }
        }
    }

    private SMMaterial getSMMaterial(OCFCertificateInfo _info, char[] _pin, CardChannel _channel, ProgressSession session, int retryCount) throws NotYetInitializedException, RetryCounterExpiredException, CardTerminalException, ResponseCodeException, NoSuchAlgorithmException, NoSuchProviderException, WrongPinException, InvalidKeyException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, SignatureException, KeyStoreException, CertificateException, IOException, ClassNotFoundException, InvalidCardChannelException, OperationCancelledException, PinDeactivatedException {
        this.fireProgressEvent(session, "get connection to the device");
        SMMaterial material = this.getSMMaterial(_channel, session, retryCount, null, _info, null);
        if (material.hasData()) {
            return material;
        }
        this.installSMCommunication(_channel, _info, _pin, material, session);
        material.xorKey = new ByteArray(material.ifdK2).xor(new ByteArray(material.iccK)).getData();
        material.smKeyEnc = new byte[16];
        MessageDigest md = MessageDigest.getInstance("SHA-1", "BC");
        md.update(material.xorKey);
        md.update(HexString.parseHexString("00000001"));
        byte[] digest = md.digest();
        System.arraycopy(digest, 0, material.smKeyEnc, 0, material.smKeyEnc.length);
        material.smKeyMAC = new byte[16];
        md = MessageDigest.getInstance("SHA-1", "BC");
        md.update(material.xorKey);
        md.update(HexString.parseHexString("00000002"));
        digest = md.digest();
        System.arraycopy(digest, 0, material.smKeyMAC, 0, material.smKeyMAC.length);
        material.ssc = new SSCIvParameterSpecImpl(new ByteArray((byte[])material.iccRND, (int)4, (int)4).append((ByteArray)new ByteArray((byte[])material.ifdPRND, (int)4, (int)4)).data, false);
        material.sscOld = new ByteArray(material.iccRND, 4, 4).append(new ByteArray(material.ifdPRND, 4, 4));
        super.setChannelState(_channel, material);
        return material;
    }

    private SMMaterial getSMMaterial(CardChannel channel, ProgressSession session, Integer retryCount, Byte pinID, OCFCertificateInfo info, CardPin cardPin) throws CardTerminalException, ResponseCodeException, InvalidCardChannelException, RetryCounterExpiredException, NotYetInitializedException {
        ChannelState channelState;
        Object extra;
        String pinName = NetKey30.getPinNameForInfo(info);
        SMMaterial material = new SMMaterial();
        if ((OCFProvider.Settings.getInstance().isServerEnvironmentActive() || OCFProvider.Settings.getInstance().isClientEnvironmentActive() && this.isStapleSign()) && SMMaterial.class.isInstance(extra = (channelState = this.getChannelState(channel)).getExtra())) {
            material = (SMMaterial)extra;
            return material;
        }
        material.retryCount = -1;
        if (retryCount != null) {
            material.retryCount = retryCount;
        } else if (pinID != null) {
            retryCount = this.getRetryCount(pinName, channel, pinID);
        } else if (info != null) {
            retryCount = this.getRetryCount(pinName, channel, info.getPinID());
        } else if (cardPin != null) {
            retryCount = this.getRetryCount(pinName, channel, cardPin.getPinID());
        }
        if (session != null) {
            this.fireProgressEvent(session, "select application on card");
        }
        CommandAPDU cmd = new CommandAPDU(HexString.parseHexString("00 a4 00 0c"));
        LOG.debug((Object)("CMD : " + HexString.hexify(cmd.getBuffer())));
        ResponseAPDU res = channel.sendCommandAPDU(cmd);
        LOG.debug((Object)("RES : " + HexString.hexify(res.getBuffer())));
        this.assertEquals(res.sw(), 36864);
        cmd = new CommandAPDU(HexString.parseHexString("00 a4 02 0c 02 2f 02"));
        LOG.debug((Object)("CMD : " + HexString.hexify(cmd.getBuffer())));
        res = channel.sendCommandAPDU(cmd);
        LOG.debug((Object)("RES : " + HexString.hexify(res.getBuffer())));
        this.assertEquals(res.sw(), 36864);
        cmd = new CommandAPDU(HexString.parseHexString("00 b0 00 00 00"));
        LOG.debug((Object)("CMD : " + HexString.hexify(cmd.getBuffer())));
        res = channel.sendCommandAPDU(cmd);
        LOG.debug((Object)("RES : " + HexString.hexify(res.getBuffer())));
        this.assertEquals(res.sw(), 36864);
        byte[] b = res.data();
        material.iccID = new byte[8];
        System.arraycopy(b, b.length - 8, material.iccID, 0, 8);
        return material;
    }

    private ResponseAPDU getResponseFromSecureMessage(ResponseAPDU _res, SMMaterial _material) {
        byte[] data = _res.data();
        TLV sw = new TLV();
        TLV mac = new TLV();
        TLV cryptogram = new TLV();
        INT index = new INT();
        while (index.i < data.length) {
            int tag = data[index.i] & 0xFF;
            if (tag == 153) {
                sw = new TLV(data, index.i);
                index.i += sw.length();
                continue;
            }
            if (tag == 142) {
                mac = new TLV(data, index.i);
                index.i += mac.length();
                continue;
            }
            if (tag == 135) {
                cryptogram = new TLV(data, index.i);
                index.i += cryptogram.length();
                continue;
            }
            ++index.i;
            index.i += INT.readLength(data, index);
        }
        LOG.debug((Object)("        sw tag : " + sw.bytes()));
        LOG.debug((Object)("       mac tag : " + mac.bytes()));
        LOG.debug((Object)("cryptogram tag : " + cryptogram.bytes()));
        _material.ssc.increaseSSC();
        byte[] byArray = _material.sscOld.getData();
        int n = _material.sscOld.getLength() - 1;
        byArray[n] = (byte)(byArray[n] + 1);
        if (detailLog) {
            LOG.debug((Object)("SSC : " + HexUtil.hexify(_material.ssc.getIV())));
            LOG.debug((Object)("SSC (old): " + _material.sscOld));
        }
        if (mac.dataLength() > 0 && cryptogram.dataLength() > 0) {
            ByteArray toVerify = cryptogram.bytes().append(sw.bytes());
            toVerify = CryptoHelper.padISO7816_4(toVerify);
            LOG.debug((Object)("padded cryptogram to verify : " + toVerify));
            ByteArray retailMAC = CryptoHelper.retailMAC(toVerify, new ByteArray(_material.smKeyMAC, 0, 8), new ByteArray(_material.smKeyMAC, 8, 8), new ByteArray(_material.ssc.getIV()));
            boolean b = Arrays.equals(mac.dataBytes(), retailMAC.getData());
            LOG.debug((Object)("verification " + (b ? "successful" : "failed")));
            if (!b) {
                throw new RuntimeException("seems to be corrupted");
            }
        }
        if (cryptogram.dataLength() > 0 && _material.smKeyEnc != null) {
            ByteArray a = new ByteArray(cryptogram.dataBytes());
            a = a.subArray(1, a.getLength() - 1);
            ByteArray plaintext = CryptoHelper.decryptCBCTripleDes(a, new ByteArray(_material.smKeyEnc, 0, 8), new ByteArray(_material.smKeyEnc, 8, 8), new ByteArray("00 00 00 00 00 00 00 00"));
            return new ResponseAPDU(plaintext.append(new ByteArray(sw.dataBytes())).getData());
        }
        ByteArray swResult = sw.bytes();
        if (swResult.getLength() == 4) {
            swResult = swResult.subArray(2, 2);
        }
        return new ResponseAPDU(cryptogram.bytes().append(swResult).getData());
    }

    private void installSMCommunication(CardChannel channel, OCFCertificateInfo _info, char[] _pin, SMMaterial material, ProgressSession session) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidCardChannelException, ResponseCodeException, WrongPinException, RetryCounterExpiredException, NotYetInitializedException, InvalidKeyException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, SignatureException, KeyStoreException, CertificateException, IOException, ClassNotFoundException, OperationCancelledException, PinDeactivatedException {
        CommandAPDU cmd = null;
        ResponseAPDU res = null;
        KeyPair ifdKeyPair = this.getRSAKey();
        material.ifdPubKey = (RSAPublicKey)ifdKeyPair.getPublic();
        material.ifdPriKey = (RSAPrivateKey)ifdKeyPair.getPrivate();
        if (this.mustImportIntoCard(channel, material)) {
            this.updateApplicationKeyForSM(channel, _info, null, material, null);
        }
        cmd = new CommandAPDU(HexString.parseHexString("00 a4 02 0c 02 45 70"));
        LOG.debug((Object)("CMD : " + HexString.hexify(cmd.getBuffer())));
        res = channel.sendCommandAPDU(cmd);
        LOG.debug((Object)("RES : " + HexString.hexify(res.getBuffer())));
        this.assertEquals(res.sw(), 36864);
        cmd = new CommandAPDU(HexString.parseHexString("00 b2 01 04 00"));
        LOG.debug((Object)("CMD : " + HexString.hexify(cmd.getBuffer())));
        res = channel.sendCommandAPDU(cmd);
        LOG.debug((Object)("RES : " + HexString.hexify(res.getBuffer())));
        this.assertEquals(res.sw(), 36864);
        byte[] modulus = res.data();
        LOG.debug((Object)("icc pub key modulus  (" + modulus.length + ") : " + HexString.hexify(modulus)));
        cmd = new CommandAPDU(HexString.parseHexString("00 b2 02 04 00"));
        LOG.debug((Object)("CMD : " + HexString.hexify(cmd.getBuffer())));
        res = channel.sendCommandAPDU(cmd);
        LOG.debug((Object)("RES : " + HexString.hexify(res.getBuffer())));
        this.assertEquals(res.sw(), 36864);
        byte[] exponent = res.data();
        LOG.debug((Object)("icc pub key exponent (" + exponent.length + ") : " + HexString.hexify(exponent)));
        material.iccPubKey = new MyRSAPublicKey(new BigInteger(1, modulus), new BigInteger(exponent));
        cmd = new CommandAPDU(HexString.parseHexString("00 a4 04 0c 06 d2 76 00 00 66 01"));
        LOG.debug((Object)("CMD : " + HexString.hexify(cmd.getBuffer())));
        res = channel.sendCommandAPDU(cmd);
        LOG.debug((Object)("RES : " + HexString.hexify(res.getBuffer())));
        this.assertEquals(res.sw(), 36864);
        this.fireProgressEvent(session, "verify the corresponding password");
        super.verifyPassword(channel, _info, _pin, material.retryCount);
        LOG.debug((Object)"internal authenticate");
        material.ifdPRND = new byte[8];
        material.ifdID = new byte[8];
        material.ifdPRND = new byte[8];
        new SecureRandom().nextBytes(material.ifdPRND);
        String _ifdPRND = HexString.hexify(material.ifdPRND);
        material.ifdID = new byte[8];
        new SecureRandom().nextBytes(material.ifdID);
        String _ifdID = HexString.hexify(material.ifdID);
        cmd = new CommandAPDU(HexString.parseHexString("00 88 00 00 10 " + _ifdPRND + " " + _ifdID + " 80"));
        res = channel.sendCommandAPDU(cmd);
        this.assertEquals(res.sw(), 36864);
        material.ifdPRND = HexString.parseHexString(_ifdPRND);
        material.ifdID = HexString.parseHexString(_ifdID);
        byte[] cryptogram = res.data();
        LOG.debug((Object)("cryptogram from card : (" + cryptogram.length + ") " + HexString.hexify(cryptogram)));
        byte[] signature2 = this.interpretCryptogram(cryptogram, material.ifdPubKey, material.ifdPriKey, material.iccPubKey);
        LOG.debug((Object)("signed (" + signature2.length + ") " + HexString.hexify(signature2)));
        material.iccPRND = new byte[74];
        System.arraycopy(signature2, 1, material.iccPRND, 0, material.iccPRND.length);
        material.iccK = new byte[32];
        System.arraycopy(signature2, 75, material.iccK, 0, material.iccK.length);
        byte[] h = new byte[20];
        System.arraycopy(signature2, 107, h, 0, h.length);
        MessageDigest md = MessageDigest.getInstance("SHA-1", "BC");
        md.update(material.iccPRND);
        md.update(material.iccK);
        md.update(material.ifdPRND);
        md.update(material.ifdID);
        this.assertTrue(Arrays.equals(h, md.digest()));
        LOG.debug((Object)"get challenge");
        cmd = new CommandAPDU(HexString.parseHexString("00 84 00 00 08"));
        res = channel.sendCommandAPDU(cmd);
        this.assertEquals(res.sw(), 36864);
        material.iccRND = res.data();
        LOG.debug((Object)"external authenticate");
        material.ifdPRND2 = new byte[74];
        new SecureRandom().nextBytes(material.ifdPRND2);
        material.ifdK2 = new byte[32];
        new SecureRandom().nextBytes(material.ifdK2);
        byte[] m = this.createCryptogram(material);
        byte[] bytes = new byte[5 + m.length];
        int i = 0;
        bytes[i++] = 0;
        bytes[i++] = -126;
        bytes[i++] = 0;
        bytes[i++] = 0;
        bytes[i++] = (byte)m.length;
        System.arraycopy(m, 0, bytes, i, m.length);
        cmd = new CommandAPDU(bytes);
        LOG.debug((Object)("CMD : " + HexString.hexify(cmd.getBuffer())));
        res = channel.sendCommandAPDU(cmd);
        LOG.debug((Object)("RES : " + HexString.hexify(res.getBuffer())));
        this.assertEquals(res.sw(), 36864);
    }

    private void updateApplicationKeyForSM(CardChannel channel, OCFCertificateInfo _info, FileEntry fileEntry, SMMaterial material, char[] pin) throws ResponseCodeException, WrongPinException, RetryCounterExpiredException, NotYetInitializedException, CardTerminalException, OperationCancelledException, PinDeactivatedException {
        OCFCertificateInfo global = new OCFCertificateInfo(super.getCardObject().getCardID(), 2000001L, -1L, -1L, OCFCertificateInfo.ChainEntry.USER, OCFCertificateInfo.Usage.GLO, null);
        global.init();
        this.verifyPassword(channel, global, pin);
        byte[] modulus = material.ifdPriKey.getModulus().toByteArray();
        byte[] exponent = material.ifdPriKey.getPrivateExponent().toByteArray();
        modulus = material.ifdPubKey.getModulus().toByteArray();
        exponent = material.ifdPubKey.getPublicExponent().toByteArray();
        LOG.debug((Object)("ifd pub key modulus (" + modulus.length + ") : " + HexString.hexify(modulus)));
        LOG.debug((Object)("ifd pub key exponent (" + exponent.length + ") : " + HexString.hexify(exponent)));
        byte[] dataField = null;
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            os.write(129);
            os.write(129);
            os.write(modulus.length - 1);
            os.write(modulus, 1, modulus.length - 1);
            os.write(130);
            os.write(exponent.length);
            os.write(exponent);
            dataField = os.toByteArray();
            os = new ByteArrayOutputStream();
            os.write(131);
            os.write(1);
            os.write(119);
            os.write(127);
            os.write(73);
            os.write(129);
            os.write(dataField.length);
            os.write(dataField);
            dataField = os.toByteArray();
        }
        catch (Exception ex) {
            LOG.error((Object)"", (Throwable)ex);
        }
        byte[] bytes = new byte[5 + dataField.length];
        int i = 0;
        bytes[i++] = 0;
        bytes[i++] = 34;
        bytes[i++] = -127;
        bytes[i++] = -92;
        bytes[i++] = (byte)dataField.length;
        System.arraycopy(dataField, 0, bytes, i, dataField.length);
        CommandAPDU cmd = new CommandAPDU(bytes);
        LOG.debug((Object)("CMD : " + HexString.hexify(cmd.getBuffer())));
        ResponseAPDU res = channel.sendCommandAPDU(cmd);
        LOG.debug((Object)("RES : " + HexString.hexify(res.getBuffer())));
        this.assertEquals(res.sw(), 36864);
    }

    private boolean mustImportIntoCard(CardChannel channel, SMMaterial material) throws InvalidCardChannelException, CardTerminalException {
        CommandAPDU cmd = new CommandAPDU(HexString.parseHexString("00 a4 02 0c 02 45 00"));
        LOG.debug((Object)("CMD : " + HexString.hexify(cmd.getBuffer())));
        ResponseAPDU res = channel.sendCommandAPDU(cmd);
        LOG.debug((Object)("RES : " + HexString.hexify(res.getBuffer())));
        if (res.sw() != 36864) {
            return true;
        }
        cmd = new CommandAPDU(HexString.parseHexString("00 b2 05 04 00"));
        res = channel.sendCommandAPDU(cmd);
        if (res.sw() != 36864) {
            return true;
        }
        BigInteger modulus = new BigInteger(1, res.data());
        if (!modulus.equals(material.ifdPubKey.getModulus())) {
            return true;
        }
        cmd = new CommandAPDU(HexString.parseHexString("00 b2 06 04 00"));
        LOG.debug((Object)("CMD : " + HexString.hexify(cmd.getBuffer())));
        res = channel.sendCommandAPDU(cmd);
        LOG.debug((Object)("RES : " + HexString.hexify(res.getBuffer())));
        if (res.sw() != 36864) {
            return true;
        }
        BigInteger exponent = new BigInteger(1, res.data());
        return !exponent.equals(material.ifdPubKey.getPublicExponent());
    }

    private KeyPair getRSAKey() throws NoSuchAlgorithmException, NoSuchProviderException, KeyStoreException, CertificateException, IOException, ClassNotFoundException {
        byte[] mod = HexString.parseHexString("88 09 5f 18 43 6f da 69 f7 a0 78 e0 65 85 ab 15 df b0 e6 8f 7a da 20 f6 d0 ef e7 5c 15 52 59 42 2b 32 72 e8 a6 11 0b 63 87 ea c5 3e b9 ba 01 fb 9d e2 75 e5 cd 60 be 80 63 9c 3c cb 02 d0 28 3d 1f e4 c0 28 54 a7 1d 48 25 d0 a2 f4 f9 9a e6 1d 0c 75 86 9e dc 11 2f 80 2c 87 d0 16 55 f7 79 99 5c c0 c4 d3 54 91 64 5b 0a 1d 30 0a 6d 1e 0e 4a 63 87 a5 0f 3f 59 10 2d f9 4d a0 3f 2a 36 2a dd");
        byte[] priE = HexString.parseHexString("61 b1 19 31 7b 7c 60 05 a9 66 fc 67 69 80 cc 94 30 c8 01 4b 18 96 7d 05 c2 96 06 38 02 b7 d8 91 c4 23 be 91 84 70 c9 14 f9 0e 88 07 bb a8 f0 b3 99 76 7f e4 3f d1 31 fd 51 8b 69 bd 00 90 2b d4 65 72 b6 3c a6 2f 36 9e 74 1d 4f 0d 22 fc cd 2a 9f a0 7c 27 ec 9c 9f eb 00 02 c3 db f9 7e fd b8 8f 77 fe 7f 61 75 a5 f5 6a a9 42 67 c8 76 9f b3 f9 24 49 18 a3 e0 cb a9 e6 d2 41 37 72 f7 5b a1");
        byte[] pubE = HexString.parseHexString("01 00 01");
        final BigInteger modI = new BigInteger(1, mod);
        BigInteger pubI = new BigInteger(1, pubE);
        RSAPublicKey pubK = this.createRSAPublicKey(mod, pubE);
        final BigInteger priI = new BigInteger(1, priE);
        RSAPrivateKey priK = new RSAPrivateKey(){
            private static final long serialVersionUID = 1L;

            @Override
            public BigInteger getPrivateExponent() {
                return priI;
            }

            @Override
            public String getAlgorithm() {
                return "RSA";
            }

            @Override
            public byte[] getEncoded() {
                return null;
            }

            @Override
            public String getFormat() {
                return null;
            }

            @Override
            public BigInteger getModulus() {
                return modI;
            }
        };
        KeyPair kk = new KeyPair(pubK, priK);
        return kk;
    }

    private RSAPublicKey createRSAPublicKey(byte[] mod, byte[] pubE) {
        final BigInteger modI = new BigInteger(1, mod);
        final BigInteger pubI = new BigInteger(1, pubE);
        RSAPublicKey pubK = new RSAPublicKey(){
            private static final long serialVersionUID = 1L;

            @Override
            public String getAlgorithm() {
                return "RSA";
            }

            @Override
            public byte[] getEncoded() {
                return null;
            }

            @Override
            public String getFormat() {
                return null;
            }

            @Override
            public BigInteger getPublicExponent() {
                return pubI;
            }

            @Override
            public BigInteger getModulus() {
                return modI;
            }
        };
        return pubK;
    }

    private void assertTrue(boolean _equals) throws ResponseCodeException {
        if (!_equals) {
            throw new ResponseCodeException(0, APDUCommands.getSelectErrorMsg(0));
        }
    }

    private void assertEquals(int _sw, int _noError) throws ResponseCodeException {
        if (_sw != _noError) {
            throw new ResponseCodeException(_sw, APDUCommands.getSelectErrorMsg(_sw));
        }
    }

    private byte[] interpretCryptogram(byte[] _cryptogram, RSAPublicKey ifdPubKey, RSAPrivateKey ifdPriKey, RSAPublicKey iccPubKey) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        RSAKeyParameters pubParam;
        RSAEngine eng;
        byte[] signature = _cryptogram;
        if (ifdPriKey != null) {
            eng = new RSAEngine();
            pubParam = new RSAKeyParameters(true, ifdPriKey.getModulus(), ifdPriKey.getPrivateExponent());
            eng.init(false, (CipherParameters)pubParam);
            signature = eng.processBlock(signature, 0, signature.length);
            LOG.debug((Object)("deciphered (" + signature.length + ") " + HexString.hexify(signature)));
        }
        eng = new RSAEngine();
        pubParam = new RSAKeyParameters(true, iccPubKey.getModulus(), iccPubKey.getPublicExponent());
        eng.init(true, (CipherParameters)pubParam);
        signature = eng.processBlock(signature, 0, signature.length);
        if (signature[0] != 106 || signature[signature.length - 1] != -68) {
            BigInteger n = iccPubKey.getModulus();
            BigInteger s = new BigInteger(1, signature);
            LOG.debug((Object)("s=" + s));
            LOG.debug((Object)("s=" + HexString.hexify(s.toByteArray())));
            BigInteger s1 = n.subtract(s);
            LOG.debug((Object)("s'=" + s1));
            LOG.debug((Object)("s'=" + HexString.hexify(s1.toByteArray())));
            signature = s1.toByteArray();
        }
        return signature;
    }

    private static byte[] rsaEncryptSunJCE(byte[] data, final RSAPublicKey pubkey, final RSAPrivateKey prikey) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, NoSuchProviderException {
        return NetKey30.rsaEncryptSunJCE(data, new RSAPublicKey(){
            private static final long serialVersionUID = 1L;

            @Override
            public BigInteger getPublicExponent() {
                return prikey.getPrivateExponent();
            }

            @Override
            public String getAlgorithm() {
                return pubkey.getAlgorithm();
            }

            @Override
            public byte[] getEncoded() {
                return pubkey.getEncoded();
            }

            @Override
            public String getFormat() {
                return pubkey.getFormat();
            }

            @Override
            public BigInteger getModulus() {
                return pubkey.getModulus();
            }
        });
    }

    private static byte[] rsaEncryptSunJCE(byte[] data, RSAPublicKey pubkey) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, NoSuchProviderException {
        Cipher c = Cipher.getInstance("RSA/ECB/NoPadding", "SunJCE");
        c.init(1, pubkey);
        byte[] sunSign = c.doFinal(data);
        return sunSign;
    }

    private byte[] createCryptogram(SMMaterial result) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException {
        byte[] buf;
        byte[] doFinal;
        byte[] signstring = null;
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            os.write(106);
            os.write(result.ifdPRND2);
            os.write(result.ifdK2);
            MessageDigest md = MessageDigest.getInstance("SHA1", "BC");
            md.update(result.ifdPRND2);
            md.update(result.ifdK2);
            md.update(result.iccRND);
            md.update(result.iccID);
            os.write(md.digest());
            os.write(188);
            signstring = os.toByteArray();
        }
        catch (Exception ex) {
            LOG.error((Object)"", (Throwable)ex);
        }
        LOG.debug((Object)("signature string : (" + signstring.length + ") " + HexString.hexify(signstring, false, false)));
        byte[] sign = NetKey30.rsaEncryptSunJCE(signstring, result.ifdPubKey, result.ifdPriKey);
        LOG.debug((Object)("signed : (" + sign.length + ") " + HexString.hexify(sign, false, false)));
        BigInteger s = new BigInteger(1, sign);
        BigInteger n = result.ifdPubKey.getModulus();
        BigInteger n2 = n.shiftRight(1);
        if (s.compareTo(n2) == 1) {
            s = n.subtract(s);
            byte[] ss = s.toByteArray();
            LOG.debug((Object)("modulus(PK(ifd))-signed applied : (" + ss.length + ") " + HexString.hexify(ss)));
        }
        if ((doFinal = NetKey30.rsaEncryptSunJCE(buf = s.toByteArray(), result.iccPubKey)).length % 2 == 1) {
            doFinal = new BigInteger(1, doFinal).toByteArray();
        }
        LOG.debug((Object)("ciphered : (" + doFinal.length + ") " + HexString.hexify(doFinal)));
        return doFinal;
    }

    public static CommandAPDU generateSecureMessagingCommand(byte _cla, byte _ins, byte _p1, byte _p2, byte[] _apduData, ByteArray _apduLE, byte[] _smKeyEnc, byte[] _smKeyMAC, ByteArray _icv, SSCIvParameterSpec ssc, ByteArray sscOld) {
        ByteArray apduDataPadded;
        _cla = (byte)(_cla | 0xC);
        ByteArray apduHeader = new ByteArray(new byte[]{_cla, _ins, _p1, _p2});
        ByteArray leTag = null;
        if (_apduLE != null && _apduLE.getLength() > 0) {
            if (_apduLE.getLength() == 3) {
                _apduLE = _apduLE.subArray(1, 2);
            }
            leTag = NetKey30.createLEObj(_apduLE);
            LOG.debug((Object)("le TAG : (" + leTag.getLength() + ") " + leTag));
        } else {
            leTag = new ByteArray(new byte[0]);
            LOG.debug((Object)"le TAG : skipped, le not present, empty created");
        }
        ByteArray dataTag = null;
        if (_apduData != null && _apduData.length > 0) {
            dataTag = NetKey30.createDataTag(_smKeyEnc == null ? null : new ByteArray(_smKeyEnc), new ByteArray(_apduData), _icv);
            LOG.debug((Object)("data TAG : (" + dataTag.getLength() + ") " + dataTag));
        } else {
            dataTag = new ByteArray(new byte[0]);
            LOG.debug((Object)"data TAG : skipped, data not present, empty created");
        }
        ByteArray apduHeaderPadded = CryptoHelper.padISO7816_4(apduHeader);
        if (detailLog) {
            LOG.debug((Object)("apduHeaderPadded : (" + apduHeaderPadded.getLength() + ") " + apduHeaderPadded));
        }
        if ((apduDataPadded = dataTag.append(leTag)).getLength() > 0) {
            apduDataPadded = CryptoHelper.padISO7816_4(apduDataPadded);
            LOG.debug((Object)("apduDataPadded : (" + apduDataPadded.getLength() + ") " + apduDataPadded));
        } else {
            apduDataPadded = new ByteArray(new byte[0]);
            LOG.debug((Object)"apduDataPadded : skipped, data and le not present, empty created");
        }
        byte[] byArray = sscOld.getData();
        int n = sscOld.getLength() - 1;
        byArray[n] = (byte)(byArray[n] + 1);
        ssc.increaseSSC();
        if (detailLog) {
            LOG.debug((Object)("SSC : " + HexUtil.hexify(ssc.getIV())));
            LOG.debug((Object)("SSC (old): " + HexUtil.hexify(sscOld.data)));
        }
        ByteArray dataMAC = apduHeaderPadded.append(apduDataPadded);
        if (detailLog) {
            LOG.debug((Object)("dataMAC : (" + dataMAC.getLength() + ") " + dataMAC));
        }
        dataMAC = CryptoHelper.retailMAC(dataMAC, new ByteArray(_smKeyMAC, 0, 8), new ByteArray(_smKeyMAC, 8, 8), new ByteArray(ssc.getIV()));
        if (detailLog) {
            LOG.debug((Object)("dataMAC : (" + dataMAC.getLength() + ") " + dataMAC));
        }
        ByteArray Mac_Obj = new ByteArray("8E").append(new ByteArray(dataMAC.getLength(), 1)).append(dataMAC);
        if (detailLog) {
            LOG.debug((Object)("Mac_Obj : (" + Mac_Obj.getLength() + ") " + Mac_Obj));
        }
        ByteArray APDU_Data = dataTag.append(leTag).append(Mac_Obj);
        if (detailLog) {
            LOG.debug((Object)("APDU_Data : (" + APDU_Data.getLength() + ") " + APDU_Data));
        }
        ByteArray SM_APDU = apduHeader;
        _apduLE = _apduLE == null ? new ByteArray("00") : new ByteArray(new byte[_apduLE.getLength()]);
        if (APDU_Data.getLength() >= 256 && _apduLE.getLength() == 1) {
            _apduLE = _apduLE.append(new ByteArray("00"));
        }
        if (_apduLE.getLength() == 2) {
            SM_APDU = SM_APDU.append(new ByteArray("00"));
        }
        SM_APDU = SM_APDU.append(new ByteArray(APDU_Data.getLength(), _apduLE.getLength() == 2 ? 2 : 1));
        SM_APDU = SM_APDU.append(APDU_Data);
        SM_APDU = SM_APDU.append(_apduLE);
        return new CommandAPDU(SM_APDU.getData());
    }

    private static ByteArray createDataTag(ByteArray _smKeyEnc, ByteArray _apduData, ByteArray _icv) {
        LOG.debug((Object)("createDataTag_EncryptionKey: " + (_smKeyEnc != null ? "present" : "absent")));
        LOG.debug((Object)("createDataTag_Data: " + (_apduData != null ? "present" : "absent")));
        if (_apduData != null && _smKeyEnc != null) {
            LOG.debug((Object)("icv : (" + _icv.getLength() + ") " + _icv));
            LOG.debug((Object)("des key : (" + _smKeyEnc.getLength() + ") " + _smKeyEnc));
            assert (_smKeyEnc.getLength() == 16) : "wrong key length: " + _smKeyEnc.getLength();
            ByteArray apduDataEnc = CryptoHelper.encryptCBCTripleDes(_apduData, _smKeyEnc.subArray(0, 8), _smKeyEnc.subArray(8, 8), _icv);
            apduDataEnc = new ByteArray(ByteUtil.combine(new byte[]{1}, apduDataEnc.getData()));
            ByteArray dataTag = new ByteArray(new ASN1(-121, apduDataEnc.getData()).getEncoded());
            return dataTag;
        }
        ByteArray dataTag = new ByteArray("81").append(new ByteArray(_apduData.getLength(), 1)).append(_apduData);
        return dataTag;
    }

    private static ByteArray createLEObj(ByteArray _apduLE) {
        if (_apduLE != null) {
            ByteArray leTag = new ByteArray("97 01");
            leTag.getData()[1] = (byte)_apduLE.getLength();
            leTag = leTag.append(_apduLE);
            return leTag;
        }
        return new ByteArray("");
    }

    @Override
    protected synchronized boolean isIssuerReadRequired() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resetApplicationKey(char[] globalPin) throws WrongPinException, RetryCounterExpiredException, NotYetInitializedException, InvalidCardChannelException, ResponseCodeException, NoSuchAlgorithmException, NoSuchProviderException, KeyStoreException, CertificateException, IOException, ClassNotFoundException, OperationCancelledException, PinDeactivatedException {
        CardChannelManager cardChannelManager = new CardChannelManager();
        try {
            CardChannel channel = cardChannelManager.init(this);
            SMMaterial material = this.getSMMaterial(channel, null, null, (byte)0, null, null);
            KeyPair ifdKeyPair = this.getRSAKey();
            material.ifdPubKey = (RSAPublicKey)ifdKeyPair.getPublic();
            material.ifdPriKey = (RSAPrivateKey)ifdKeyPair.getPrivate();
            boolean importKey = this.mustImportIntoCard(channel, material);
            if (importKey) {
                boolean bl = false;
                return bl;
            }
            FileReference dirRefMF = new FileReference(0, "3f00");
            FileEntry fileEntryMF = new FileEntry(dirRefMF, dirRefMF);
            byte[] mod = HexString.parseHexString("88 09 5f 18 43 6f da 69 f7 a0 78 e0 65 85 ab 15 df b0 e6 8f 7a da 20 f6 d0 ef e7 5c 15 52 59 42 2b 32 72 e8 a6 11 0b 63 87 ea c5 3e b9 ba 01 fb 9d e2 75 e5 cd 60 be 80 63 9c 3c cb 02 d0 28 3d 1f e4 c0 28 54 a7 1d 48 25 d0 a2 f4 f9 9a e6 1d 0c 75 86 9e dc 11 2f 80 2c 87 d0 16 55 f7 79 99 5c c0 c4 d3 54 91 64 5b 0a 1d 30 0a 6d 1e 0e 4a 63 87 a5 0f 3f 59 10 2d f9 4d a0 3f 2a 36 2a dd");
            byte[] pubE = HexString.parseHexString("01 00 01");
            ByteUtil.fill(mod, (byte)0);
            ByteUtil.fill(pubE, (byte)0);
            material.ifdPubKey = this.createRSAPublicKey(mod, pubE);
            this.updateApplicationKeyForSM(channel, null, fileEntryMF, material, globalPin);
        }
        finally {
            cardChannelManager.destroy();
        }
        return true;
    }

    public static class CryptoHelper {
        public static ByteArray padISO7816_4(ByteArray data) {
            StringBuffer buf = new StringBuffer("80");
            for (int i = 7; i > data.getLength() % 8; --i) {
                buf.append("00");
            }
            return data.append(new ByteArray(buf.toString()));
        }

        public static ByteArray removePaddingISO7816_4(ByteArray data) {
            for (int i = data.getLength() - 1; i > 0; --i) {
                if ((0xFF & data.getData()[i]) != 128) continue;
                return data.subArray(0, i);
            }
            return data;
        }

        public static ByteArray padSymmetric(ByteArray data) {
            if (data.getLength() % 8 == 0) {
                return data;
            }
            return data.append(new ByteArray(new byte[8 - data.getLength() % 8]));
        }

        private static ByteArray applyDES(ByteArray data, ByteArray key, boolean encrypt) {
            DESEngine engine = new DESEngine();
            engine.init(encrypt, (CipherParameters)new DESParameters(key.getData()));
            ByteArray result = (ByteArray)data.clone();
            engine.processBlock(data.getData(), 0, result.getData(), 0);
            return result;
        }

        public static ByteArray encryptBlockDES(ByteArray data, ByteArray key) {
            return CryptoHelper.applyDES(data, key, true);
        }

        public static ByteArray decryptBlockDES(ByteArray data, ByteArray key) {
            return CryptoHelper.applyDES(data, key, false);
        }

        public static ByteArray encryptBlockTripleDES(ByteArray data, ByteArray keyA, ByteArray keyB) {
            return CryptoHelper.encryptBlockDES(CryptoHelper.decryptBlockDES(CryptoHelper.encryptBlockDES(data, keyA), keyB), keyA);
        }

        public static ByteArray decryptBlockTripleDES(ByteArray data, ByteArray keyA, ByteArray keyB) {
            return CryptoHelper.decryptBlockDES(CryptoHelper.encryptBlockDES(CryptoHelper.decryptBlockDES(data, keyA), keyB), keyA);
        }

        public static ByteArray encryptCBCTripleDes(ByteArray data, ByteArray keyA, ByteArray keyB, ByteArray icv) {
            int BLOCK_LENGTH = 8;
            ByteArray paddedData = CryptoHelper.padISO7816_4(data);
            LOG.debug((Object)("apdu data : (" + paddedData.getLength() + ") " + paddedData));
            ByteArray lastCryptedBlock = icv;
            ByteArray result = new ByteArray(new byte[0]);
            for (int blockStartPos = 0; blockStartPos < paddedData.getLength(); blockStartPos += BLOCK_LENGTH) {
                ByteArray block = paddedData.subArray(blockStartPos, BLOCK_LENGTH);
                block = block.xor(lastCryptedBlock);
                lastCryptedBlock = CryptoHelper.encryptBlockTripleDES(block, keyA, keyB);
                result = result.append(lastCryptedBlock);
            }
            return result;
        }

        public static ByteArray decryptCBCTripleDes(ByteArray data, ByteArray keyA, ByteArray keyB, ByteArray ivc) {
            int BLOCK_LENGTH = 8;
            ByteArray lastBlock = ivc;
            ByteArray result = new ByteArray(new byte[0]);
            for (int blockStartPos = 0; blockStartPos < data.getLength(); blockStartPos += BLOCK_LENGTH) {
                ByteArray block = data.subArray(blockStartPos, BLOCK_LENGTH);
                ByteArray decryptedBlock = CryptoHelper.decryptBlockTripleDES(block, keyA, keyB);
                result = result.append(decryptedBlock.xor(lastBlock));
                lastBlock = block;
            }
            result = CryptoHelper.removePaddingISO7816_4(result);
            return result;
        }

        public static ByteArray retailMAC(ByteArray data, ByteArray keyA, ByteArray keyB, ByteArray icv) {
            int BLOCK_LENGTH = 8;
            ByteArray paddedData = CryptoHelper.padSymmetric(data);
            ByteArray lastCryptedBlock = CryptoHelper.encryptBlockDES(icv, keyA);
            for (int blockStartPos = 0; blockStartPos < paddedData.getLength(); blockStartPos += BLOCK_LENGTH) {
                ByteArray block = paddedData.subArray(blockStartPos, BLOCK_LENGTH);
                block = block.xor(lastCryptedBlock);
                lastCryptedBlock = CryptoHelper.encryptBlockDES(block, keyA);
            }
            return CryptoHelper.encryptBlockDES(CryptoHelper.decryptBlockDES(lastCryptedBlock, keyB), keyA);
        }
    }

    public static class ByteArray {
        private byte[] data;

        public ByteArray(byte[] _data) {
            if (_data == null) {
                this.data = new byte[0];
            } else {
                this.data = new byte[_data.length];
                System.arraycopy(_data, 0, this.data, 0, _data.length);
            }
        }

        public ByteArray(String _content) {
            String content = _content.replaceAll(" ", "");
            this.data = new byte[content.length() / 2];
            for (int i = 0; i < content.length() / 2; ++i) {
                this.data[i] = (byte)Integer.parseInt(content.substring(2 * i, 2 * i + 2), 16);
            }
        }

        public int getLength() {
            return this.data.length;
        }

        public int getBitLength() {
            return 8 * this.data.length;
        }

        public byte[] getData() {
            return this.data;
        }

        public ByteArray(byte[] _data, int startPos, int length) {
            this.data = new byte[length];
            System.arraycopy(_data, startPos, this.data, 0, length);
        }

        public ByteArray subArray(int startPos, int length) {
            return new ByteArray(this.data, startPos, length);
        }

        private ByteArray() {
        }

        public ByteArray(long _value, int count) {
            this.data = new byte[count];
            for (int i = 0; i < count; ++i) {
                this.data[i] = (byte)(_value >> (count - 1 - i) * 8 & 0xFFL);
            }
        }

        public ByteArray append(ByteArray other) {
            byte[] newData = new byte[this.data.length + other.getLength()];
            System.arraycopy(this.data, 0, newData, 0, this.data.length);
            System.arraycopy(other.data, 0, newData, this.data.length, other.data.length);
            ByteArray result = new ByteArray();
            result.data = newData;
            return result;
        }

        public ByteArray xor(ByteArray other) {
            if (this.data.length != other.getLength()) {
                throw new IllegalArgumentException("cannot XOR arrays of different length " + this.data.length + " and " + other.getLength());
            }
            byte[] newData = new byte[this.data.length];
            for (int i = 0; i < this.data.length; ++i) {
                newData[i] = (byte)(this.data[i] ^ other.data[i]);
            }
            ByteArray result = new ByteArray();
            result.data = newData;
            return result;
        }

        public Object clone() {
            return new ByteArray(this.data);
        }

        public int hashCode() {
            int result = 1;
            for (int i = 0; i < this.data.length; ++i) {
                byte x = this.data[i];
                result = 31 * result + x;
            }
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ByteArray other = (ByteArray)obj;
            return Arrays.equals(this.data, other.data);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(" (" + this.data.length + ") [");
            for (int i = 0; i < this.data.length; ++i) {
                byte x = this.data[i];
                if ((x & 0xFF) < 16) {
                    buf.append("0");
                }
                buf.append(Integer.toString(x & 0xFF, 16));
                buf.append(" ");
            }
            buf.append("]");
            return buf.toString();
        }
    }

    public static class TLV {
        public final byte[] data;
        public final int offset;

        public TLV(byte[] _data, int _offset) {
            this.data = _data;
            this.offset = _offset;
        }

        public byte[] dataBytes() {
            if (this.data.length == 0) {
                return new byte[0];
            }
            INT i = new INT(this.offset + 1);
            int l = INT.readLength(this.data, i);
            return new ByteArray(this.data, i.i, l).getData();
        }

        public ByteArray bytes() {
            if (this.data.length == 0) {
                return new ByteArray("");
            }
            byte[] result = new byte[this.length()];
            System.arraycopy(this.data, this.offset, result, 0, result.length);
            return new ByteArray(result);
        }

        public int dataLength() {
            if (this.data.length == 0) {
                return 0;
            }
            INT i = new INT(this.offset + 1);
            return INT.readLength(this.data, i);
        }

        public int length() {
            INT i = new INT(this.offset + 1);
            int length = INT.readLength(this.data, i);
            i.i += length;
            return i.i - this.offset;
        }

        public TLV() {
            this.data = new byte[0];
            this.offset = -1;
        }
    }

    public static class INT {
        private int i;

        public INT() {
        }

        public INT(int _i) {
            this.i = _i;
        }

        public int hashCode() {
            return this.i;
        }

        public boolean equals(Object _o) {
            if (!(_o instanceof INT)) {
                return false;
            }
            if (_o == this) {
                return true;
            }
            return this.i != ((INT)_o).i;
        }

        public String toString() {
            return Integer.toString(this.i);
        }

        public static int readLength(byte[] bytes, INT index) {
            if (bytes[index.i] == 0) {
                ++index.i;
                return 0;
            }
            if (bytes[index.i] == -128) {
                ++index.i;
                return -1;
            }
            if ((bytes[index.i] & 0xFFFFFF80) != -128) {
                return bytes[index.i++] & 0xFF;
            }
            int count = bytes[index.i++] & 0xF;
            int result = 0;
            for (int i = 0; i < count; ++i) {
                result <<= 8;
                result += bytes[index.i++] & 0xFF;
            }
            return result;
        }

        public static byte[] readLength(InputStream _value) throws IOException {
            byte tag = (byte)(_value.read() & 0xFF);
            if ((tag & 0xFFFFFF80) != -128) {
                return new byte[]{tag};
            }
            int count = tag & 0xF;
            byte[] result = new byte[count + 1];
            result[0] = tag;
            for (int i = 0; i < count; ++i) {
                result[i + 1] = (byte)(_value.read() & 0xFF);
            }
            return result;
        }

        public static void writeLength(OutputStream os, int length) throws IOException {
            if (length < 0) {
                throw new IOException("negative length : " + length);
            }
            if (length <= 255) {
                if (length == 129) {
                    os.write(-127);
                }
                os.write((byte)length);
            } else {
                os.write(0x80 | length / 256);
                int l = length;
                int i = 4;
                while (--i <= 0) {
                    os.write(l >> i * 8 & 0xFF);
                }
            }
        }

        public static void writeLength(StringBuffer os, int length) {
            if (length < 0) {
                throw new IllegalArgumentException("negative length : " + length);
            }
            if (length <= 255) {
                if (length == 129) {
                    os.append(-127);
                }
                os.append((byte)length);
            } else {
                os.append(0x80 | length / 256);
                int l = length;
                int i = 4;
                while (--i <= 0) {
                    os.append(l >> i * 8 & 0xFF);
                }
            }
        }

        public static int lengthLength(int length) {
            int result = 0;
            if (length < 0) {
                return -1;
            }
            if (length <= 255) {
                if (length == 129) {
                    ++result;
                }
                ++result;
            } else {
                ++result;
                int i = 4;
                while (--i <= 0) {
                    ++result;
                }
            }
            return result;
        }
    }

    static class SMMaterial {
        private int retryCount;
        private MyRSAPublicKey iccPubKey;
        private RSAPrivateKey ifdPriKey;
        private RSAPublicKey ifdPubKey;
        private byte[] ifdPRND2;
        private byte[] ifdID;
        private byte[] iccPRND;
        private byte[] iccID;
        private SSCIvParameterSpec ssc;
        private ByteArray sscOld;
        private byte[] smKeyMAC;
        private byte[] smKeyEnc;
        private byte[] xorKey;
        private byte[] iccRND;
        private byte[] ifdPRND;
        private byte[] ifdK2;
        private byte[] iccK;

        SMMaterial() {
        }

        public boolean hasData() {
            return this.smKeyMAC != null;
        }

        public int getRetryCount() {
            return this.retryCount;
        }

        public void setRetryCount(int retryCount) {
            this.retryCount = retryCount;
        }

        public MyRSAPublicKey getIccPubKey() {
            return this.iccPubKey;
        }

        public void setIccPubKey(MyRSAPublicKey iccPubKey) {
            this.iccPubKey = iccPubKey;
        }

        public RSAPrivateKey getIfdPriKey() {
            return this.ifdPriKey;
        }

        public void setIfdPriKey(RSAPrivateKey ifdPriKey) {
            this.ifdPriKey = ifdPriKey;
        }

        public RSAPublicKey getIfdPubKey() {
            return this.ifdPubKey;
        }

        public void setIfdPubKey(RSAPublicKey ifdPubKey) {
            this.ifdPubKey = ifdPubKey;
        }

        public byte[] getIfdPRND2() {
            return this.ifdPRND2;
        }

        public void setIfdPRND2(byte[] ifdPRND2) {
            this.ifdPRND2 = ifdPRND2;
        }

        public byte[] getIfdID() {
            return this.ifdID;
        }

        public void setIfdID(byte[] ifdID) {
            this.ifdID = ifdID;
        }

        public byte[] getIccPRND() {
            return this.iccPRND;
        }

        public void setIccPRND(byte[] iccPRND) {
            this.iccPRND = iccPRND;
        }

        public byte[] getIccID() {
            return this.iccID;
        }

        public void setIccID(byte[] iccID) {
            this.iccID = iccID;
        }

        public SSCIvParameterSpec getSsc() {
            return this.ssc;
        }

        public void setSsc(SSCIvParameterSpec ssc) {
            this.ssc = ssc;
        }

        public ByteArray getSscOld() {
            return this.sscOld;
        }

        public void setSscOld(ByteArray sscOld) {
            this.sscOld = sscOld;
        }

        public byte[] getSmKeyMAC() {
            return this.smKeyMAC;
        }

        public void setSmKeyMAC(byte[] smKeyMAC) {
            this.smKeyMAC = smKeyMAC;
        }

        public byte[] getSmKeyEnc() {
            return this.smKeyEnc;
        }

        public void setSmKeyEnc(byte[] smKeyEnc) {
            this.smKeyEnc = smKeyEnc;
        }

        public byte[] getXorKey() {
            return this.xorKey;
        }

        public void setXorKey(byte[] xorKey) {
            this.xorKey = xorKey;
        }

        public byte[] getIccRND() {
            return this.iccRND;
        }

        public void setIccRND(byte[] iccRND) {
            this.iccRND = iccRND;
        }

        public byte[] getIfdPRND() {
            return this.ifdPRND;
        }

        public void setIfdPRND(byte[] ifdPRND) {
            this.ifdPRND = ifdPRND;
        }

        public byte[] getIfdK2() {
            return this.ifdK2;
        }

        public void setIfdK2(byte[] ifdK2) {
            this.ifdK2 = ifdK2;
        }

        public byte[] getIccK() {
            return this.iccK;
        }

        public void setIccK(byte[] iccK) {
            this.iccK = iccK;
        }
    }

    public static class MyRSAPublicKey
    implements RSAPublicKey {
        private static final long serialVersionUID = 1L;
        public final BigInteger modulus;
        private final BigInteger exponent;

        public MyRSAPublicKey(BigInteger _modulus, BigInteger _exponent) {
            this.modulus = _modulus;
            this.exponent = _exponent;
        }

        @Override
        public BigInteger getPublicExponent() {
            return this.exponent;
        }

        @Override
        public String getAlgorithm() {
            return "RSA";
        }

        @Override
        public byte[] getEncoded() {
            try {
                RSAPublicKeyStructure structure = new RSAPublicKeyStructure(this.modulus, this.exponent);
                return structure.getEncoded("DER");
            }
            catch (IOException iOException) {
                return null;
            }
        }

        @Override
        public String getFormat() {
            return "X.509";
        }

        @Override
        public BigInteger getModulus() {
            return this.modulus;
        }
    }
}

