/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.tcos;

import de.bos_bremen.common.HexUtil;
import de.bos_bremen.gov2.jca_provider.ocf.FileEntry;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.ResponseCodeException;
import de.bos_bremen.gov2.jca_provider.ocf.cards.APDUCommands;
import de.bos_bremen.gov2.jca_provider.ocf.cards.CardPerformanceSettings;
import de.bos_bremen.gov2.jca_provider.ocf.cards.FileReference;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.KeyID;
import de.bos_bremen.gov2.jca_provider.ocf.cards.tcos.NetKey30;
import de.bos_bremen.gov2.jca_provider.ocf.model.Card;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardApplication;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardFile;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardKey;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardObjectManager;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardPin;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardRegistry;
import de.bos_bremen.gov2.jca_provider.ocf.model.Disposeable;
import de.bos_bremen.gov2.jca_provider.ocf.model.Terminal;
import de.bos_bremen.gov2.jca_provider.ocf.model.Type;
import de.bos_bremen.gov2.jca_provider.ocf.model.TypedType;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardApplicationImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardFileImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardKeyImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectManagerImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectRegistryImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardPinImpl;
import java.security.AlgorithmParameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import opencard.core.service.CardChannel;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.util.HexString;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HessenPKI10NetKey30
extends NetKey30 {
    protected static final String TELESEC_HESSENPKI_NETKEY_30 = "HessenPKI (1.0) ";
    private static final Log LOG = LogFactory.getLog(HessenPKI10NetKey30.class);
    static final String EF_GDO_ISSUER_CONSTANT = "5a 0a 89 49 01 73 30";
    private static final byte GLOBAL_PINID = 0;
    private static final long GLOBAL_PIN_ID = 2000001L;
    private final String HESSEN_PKI_KEYID = "83";

    @Override
    public String getDisplayName() {
        return TELESEC_HESSENPKI_NETKEY_30 + super.getDisplayName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String readIssuerFromATR(CardChannel _channel) {
        String issuer = super.simpleReadIssuerFromATR(_channel);
        try {
            ResponseAPDU res;
            CommandAPDU cmd;
            try {
                cmd = APDUCommands.createSelectCommand(4, 12, HexUtil.parse("d2760001050001"), 1024);
                LOG.debug((Object)("SELECT AID CMD : " + HexString.hexify(cmd.getBuffer(), false)));
                res = _channel.sendCommandAPDU(cmd);
                LOG.debug((Object)("SELECT AID RESP : " + HexString.hexify(res.getBuffer(), false)));
                if (res.sw() != 36864) {
                    throw new CardTerminalException("no HessenPKI 1.0");
                }
            }
            catch (CardTerminalException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CardTerminalException("no HessenPKI 1.0");
            }
            try {
                cmd = APDUCommands.createSelectCommand(4, 12, HexUtil.parse("d2760001050002"), 1024);
                LOG.debug((Object)("SELECT AID CMD : " + HexString.hexify(cmd.getBuffer(), false)));
                res = _channel.sendCommandAPDU(cmd);
                LOG.debug((Object)("SELECT AID RESP : " + HexString.hexify(res.getBuffer(), false)));
                if (res.sw() != 36864) {
                    throw new CardTerminalException("no HessenPKI 1.0");
                }
                cmd = APDUCommands.createSelectCommand(2, 12, HexUtil.parse("4353"), 1024);
                LOG.debug((Object)("SELECT CER3 CMD : " + HexString.hexify(cmd.getBuffer(), false)));
                res = _channel.sendCommandAPDU(cmd);
                LOG.debug((Object)("SELECT CER3 RESP : " + HexString.hexify(res.getBuffer(), false)));
                if (res.sw() == 36864) {
                    throw new CardTerminalException("no HessenPKI 1.0");
                }
            }
            catch (CardTerminalException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CardTerminalException("no HessenPKI 1.0");
            }
            super.selectFile(_channel, new FileReference(4, "d27600006601"));
            super.selectFile(_channel, new FileReference(2, "5349"));
            ResponseAPDU response = super.readRecord(_channel, 1);
            byte[] data = response.data();
            if (response.sw() == 36864 || data == null || data.length >= 14) {
                byte[] tail = new byte[14];
                System.arraycopy(data, data.length - 14, tail, 0, 14);
                byte[] compare = new byte[14];
                issuer = !Arrays.equals(tail, compare) ? EF_GDO_ISSUER_CONSTANT : null;
            } else {
                issuer = null;
            }
        }
        catch (Exception e) {
            issuer = null;
        }
        finally {
            try {
                super.selectMasterFile(_channel);
            }
            catch (Exception exception) {}
        }
        return issuer;
    }

    @Override
    protected Card createCardInt(Terminal terminal, int slotID) {
        try {
            long idOfCard = CARD_OBJECT_REGISTRY.createNewCardID();
            long idOfPin01 = 2000001L;
            long idOfMFApplication = 1000000L;
            CardApplication application02 = this.createEncDecAutApp(terminal, slotID, idOfCard, idOfMFApplication, idOfPin01);
            CardApplication application03 = this.createHessenPKIEncDecApp02(terminal, slotID, idOfCard, idOfMFApplication, idOfPin01);
            CardApplication application04 = this.createHessenPKIEncDecApp01(terminal, slotID, idOfCard, idOfMFApplication, idOfPin01);
            FileReference dirRefMF = new FileReference(0, "3f00");
            FileEntry fileEntryMF = new FileEntry(dirRefMF, dirRefMF);
            byte pinID01 = 0;
            CardPinImpl pin01 = new CardPinImpl(Disposeable.NO_LOCK, "Globale PIN", idOfPin01, CardPin.CardPinTypeEnum.PIN.getType(), fileEntryMF, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID01, new long[]{4000002L, 4000003L, 4000004L, 4000005L, 4000006L});
            CardObjectManagerImpl mfManager = new CardObjectManagerImpl(idOfMFApplication);
            if (application02 != null) {
                mfManager.putApplication(application02);
            }
            if (application03 != null) {
                mfManager.putApplication(application03);
            }
            if (application04 != null) {
                mfManager.putApplication(application04);
            }
            mfManager.putPin(pin01);
            CardApplicationImpl mfApplication = new CardApplicationImpl("MF", idOfMFApplication, CardApplication.CardApplicationTypeEnum.UNKNOWN.getType(), fileEntryMF, (CardObjectManager)mfManager, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
            CardImpl card = new CardImpl(this.getDisplayName() + "-" + String.valueOf(idOfCard), idOfCard, this.getCardTypeEnum().getType(), super.getCard(), mfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance());
            return card;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
            return null;
        }
    }

    @Override
    protected Card.CardTypeEnum getCardTypeEnum() {
        return Card.CardTypeEnum.TELESEC_NETKEY30;
    }

    private CardApplication createEncDecAutApp(Terminal terminal, int slotID, long idOfCard, long idOfMFApplication, long idOfPinCH) {
        long idOfApplication = 1000002L;
        long idOfFile05 = 3000006L;
        long idOfFile06 = 3000007L;
        long idOfKey05 = 4000006L;
        long idOfKey06 = 4000007L;
        if (!CardPerformanceSettings.getInstance().getBooleanProperty("TeleSecNetKey30HessenPKISignatureKey")) {
            return null;
        }
        FileReference dirRef = new FileReference(4, "d2760000030102");
        FileReference fileRef01 = new FileReference(2, "c000");
        FileEntry fileEntry01 = new FileEntry(dirRef, fileRef01);
        CardObjectManagerImpl manager = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl application = new CardApplicationImpl("d2760000030102", idOfApplication, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.ENCRYPTION.getType(), CardApplication.CardApplicationTypeEnum.DECRYPTION.getType(), CardApplication.CardApplicationTypeEnum.AUTHENTICATION.getType(), CardApplication.CardApplicationTypeEnum.SIGNATURE.getType()}), fileEntry01, (CardObjectManager)manager, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        if (CardPerformanceSettings.getInstance().getBooleanProperty("TeleSecNetKey30HessenPKISignatureKey")) {
            KeyID k05 = new KeyID("00");
            FileReference fileRef05 = new FileReference(2, "4331");
            FileEntry fileEntry05 = new FileEntry(dirRef, fileRef05);
            OCFCertificateInfo info05 = new OCFCertificateInfo(idOfCard, idOfPinCH, idOfFile05, idOfKey05, OCFCertificateInfo.ChainEntry.USER, null, null);
            CardFileImpl file05 = new CardFileImpl(Disposeable.NO_LOCK, "HessenPKI-Signatur-Zertifikat", idOfFile05, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry05, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey05);
            CardKeyImpl key05 = new CardKeyImpl(Disposeable.NO_LOCK, "HessenPKISignatureKey", idOfKey05, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.SIGNATURE.getType(), CardKey.CardKeyTypeEnum.QUALIFIED_SIGNATURE.getType()}), fileEntry05, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info05, idOfFile05, idOfPinCH, k05);
            FileReference fileRef06 = new FileReference(2, "43b1");
            FileEntry fileEntry06 = new FileEntry(dirRef, fileRef06);
            OCFCertificateInfo info06 = new OCFCertificateInfo(idOfCard, idOfPinCH, idOfFile06, idOfKey06, OCFCertificateInfo.ChainEntry.USER, null, null);
            CardFileImpl file06 = new CardFileImpl(Disposeable.NO_LOCK, "HessenPKI-Authentisierungs-Zertifikat", idOfFile06, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry06, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey06);
            KeyID k06 = new KeyID("81");
            CardKeyImpl key06 = new CardKeyImpl(Disposeable.NO_LOCK, "HessenPKIAuthenticationKey", idOfKey06, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.AUTHENTICATION.getType()}), fileEntry06, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info06, idOfFile06, idOfPinCH, k06);
            application.putFile(file05);
            application.putFile(file06);
            application.putKey(key05);
            application.putKey(key06);
        }
        return application;
    }

    private CardApplication createHessenPKIEncDecApp02(Terminal terminal, int slotID, long idOfCard, long idOfMFApplication, long idOfPinCH) {
        long idOfApplication = 1000004L;
        long idOfFile08 = 3000008L;
        long idOfFile09 = 3000009L;
        long idOfKey08 = 4000008L;
        KeyID k09 = new KeyID("83");
        FileReference dirRef = new FileReference(4, "d2760001050002");
        FileReference fileRef08 = new FileReference(2, "4352");
        FileEntry fileEntry08 = new FileEntry(dirRef, fileRef08);
        CardObjectManagerImpl manager = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl application = new CardApplicationImpl("d2760001050002", idOfApplication, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.ENCRYPTION.getType(), CardApplication.CardApplicationTypeEnum.DECRYPTION.getType()}), fileEntry08, (CardObjectManager)manager, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        OCFCertificateInfo info08 = new OCFCertificateInfo(idOfCard, idOfPinCH, idOfFile08, idOfKey08, OCFCertificateInfo.ChainEntry.USER, null, null);
        CardFileImpl file08 = new CardFileImpl(Disposeable.NO_LOCK, "HessenPKI-Verschl\u00fcsselungs-Zertifikat2", idOfFile08, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry08, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey08);
        CardKeyImpl key08 = new CardKeyImpl(Disposeable.NO_LOCK, "HessenPKIDecrpytionKey2", idOfKey08, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DECRYPTION.getType(), CardKey.CardKeyTypeEnum.ENCRYPTION.getType()}), fileEntry08, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info08, idOfFile08, idOfPinCH, k09);
        application.putFile(file08);
        application.putKey(key08);
        return application;
    }

    private CardApplication createHessenPKIEncDecApp01(Terminal terminal, int slotID, long idOfCard, long idOfMFApplication, long idOfPinCH) {
        long idOfApplication = 1000005L;
        long idOfFile10 = 3000010L;
        long idOfKey10 = 4000010L;
        KeyID k10 = new KeyID("83");
        FileReference dirRef = new FileReference(4, "d2760001050001");
        FileReference fileRef10 = new FileReference(2, "4352");
        FileEntry fileEntry10 = new FileEntry(dirRef, fileRef10);
        CardObjectManagerImpl manager = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl application = new CardApplicationImpl("d2760001050001", idOfApplication, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.ENCRYPTION.getType(), CardApplication.CardApplicationTypeEnum.DECRYPTION.getType()}), fileEntry10, (CardObjectManager)manager, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        OCFCertificateInfo info10 = new OCFCertificateInfo(idOfCard, idOfPinCH, idOfFile10, idOfKey10, OCFCertificateInfo.ChainEntry.USER, null, null);
        CardFileImpl file10 = new CardFileImpl(Disposeable.NO_LOCK, "HessenPKI-Verschl\u00fcsselungs-Zertifikat1", idOfFile10, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry10, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey10);
        CardKeyImpl key10 = new CardKeyImpl(Disposeable.NO_LOCK, "HessenPKIDecrpytionKey1", idOfKey10, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DECRYPTION.getType(), CardKey.CardKeyTypeEnum.ENCRYPTION.getType()}), fileEntry10, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info10, idOfFile10, idOfPinCH, k10);
        application.putFile(file10);
        application.putKey(key10);
        return application;
    }

    @Override
    public OCFCertificateInfo[] createCertificateInfos() {
        return new OCFCertificateInfo[0];
    }

    public static CommandAPDU createMSEforDecryptionInt(byte[] _keyID) {
        int index = 0;
        byte[] data = new byte[5 + _keyID.length];
        data[index++] = -128;
        data[index++] = 1;
        data[index++] = 29;
        data[index++] = -124;
        data[index++] = (byte)_keyID.length;
        System.arraycopy(_keyID, 0, data, 5, _keyID.length);
        return APDUCommands.createManageSecurityEnvironmentCommand((byte)65, (byte)-72, data);
    }

    @Override
    protected final CommandAPDU createMSECommand(CardChannel _channel, OCFCertificateInfo _info, int _type, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        switch (_type) {
            case 1: {
                return HessenPKI10NetKey30.createMSEforDecryptionInt(_info.getKeyID().getID());
            }
            case 2: {
                CommandAPDU cmd = null;
                ResponseAPDU res = null;
                cmd = new CommandAPDU(HexString.parseHexString("0022f301"));
                LOG.debug((Object)("RESET MSE CMD : " + HexString.hexify(cmd.getBuffer(), false)));
                res = _channel.sendCommandAPDU(cmd);
                if (res == null) {
                    throw new ResponseCodeException(RESOURCES.getString("no_response"));
                }
                LOG.debug((Object)("RESET MSE RES : " + HexString.hexify(res.getBuffer(), false)));
                byte[] keyID = _info.getKeyID().getID();
                byte[] data = new byte[5 + keyID.length];
                int index = 0;
                data[index++] = -124;
                data[index++] = (byte)keyID.length;
                System.arraycopy(keyID, 0, data, 2, keyID.length);
                index += keyID.length;
                data[index++] = -128;
                data[index++] = 1;
                data[index++] = 10;
                return APDUCommands.createManageSecurityEnvironmentCommand((byte)65, (byte)-72, data);
            }
        }
        if (!Arrays.equals(_info.getKeyID().id, HexString.parseHexString("84"))) {
            return null;
        }
        CommandAPDU cmd = null;
        ResponseAPDU res = null;
        cmd = new CommandAPDU(HexString.parseHexString("0022f301"));
        LOG.debug((Object)("RESET MSE CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        res = _channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        LOG.debug((Object)("RESET MSE RES : " + HexString.hexify(res.getBuffer(), false)));
        byte[] keyID = _info.getKeyID().getID();
        byte[] data = new byte[5 + keyID.length];
        int index = 0;
        data[index++] = -124;
        data[index++] = (byte)keyID.length;
        System.arraycopy(keyID, 0, data, 2, keyID.length);
        index += keyID.length;
        data[index++] = -128;
        data[index++] = 1;
        data[index++] = 2;
        return APDUCommands.createManageSecurityEnvironmentCommand((byte)65, (byte)-74, data);
    }

    @Override
    public List<String> getAvailableHashAlgorithmNames(OCFCertificateInfo _info) {
        ArrayList<String> c = new ArrayList<String>();
        if ("83".equals(HexString.hexify(_info.getKeyID().id))) {
            return c;
        }
        c.add("SHA1");
        c.add("RIPEMD160");
        c.add("SHA224");
        c.add("SHA384");
        c.add("SHA512");
        c.add("SHA256");
        return c;
    }
}

