/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.starcos;

import de.bos_bremen.basecard.common.crypto.AlgorithmProvider;
import de.bos_bremen.basecard.common.crypto.UsageRelated;
import de.bos_bremen.basecard.common.pin.coding.PinEncoder;
import de.bos_bremen.common.HexUtil;
import de.bos_bremen.common.asn1.ASN1;
import de.bos_bremen.gov2.jca_provider.OCFPrivateKey;
import de.bos_bremen.gov2.jca_provider.ocf.FileEntry;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.cards.FileReference;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GDCardHelper;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.KeyID;
import de.bos_bremen.gov2.jca_provider.ocf.cards.starcos.StarCOS37;
import de.bos_bremen.gov2.jca_provider.ocf.model.Card;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardApplication;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardFile;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardKey;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardObjectManager;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardPin;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardRegistry;
import de.bos_bremen.gov2.jca_provider.ocf.model.Disposeable;
import de.bos_bremen.gov2.jca_provider.ocf.model.Terminal;
import de.bos_bremen.gov2.jca_provider.ocf.model.Type;
import de.bos_bremen.gov2.jca_provider.ocf.model.TypedType;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardApplicationImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardFileImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardKeyImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectManagerImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectRegistryImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardPinImpl;
import java.security.AlgorithmParameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import opencard.core.service.CardChannel;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceScheduler;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StarCOS37DGNService
extends StarCOS37 {
    private static final String IMAGE_ID_SINGLE = "0200000b";
    private static final String IMAGE_ID_SINGLE_TEST = "00c09b0b";
    private static final String IMAGE_ID_STAPLE = "0200000c";
    private static final String IMAGE_ID_STAPLE_TEST = "02800100";
    protected static final List<String> IMAGE_IDS_SINGLE = Collections.unmodifiableList(Arrays.asList("0200000b", "00c09b0b"));
    protected static final List<String> IMAGE_IDS_STAPLE = Collections.unmodifiableList(Arrays.asList("0200000c", "02800100"));
    public static final Map<String, String> MAP_IMAGE_ID;
    private static final byte PINID_CH = 1;
    private static final String NAME_QES_SIGNATURE_KEY_RSA = "QESRSASignatureKey";
    private static final String NAME_QES_SIGNATURE_KEY_EC = "QESECSignatureKey";
    private static final byte PINID_QES1_LOCAL = 1;
    private static final byte PINID_QES1 = -127;
    private static final String AID_EA = "a000000167455349474e";
    private static final Integer INIT_LENGTH;
    private static final Log LOG;
    protected String displayName;
    private final String issuerConstant;
    private final String tokenLabel;
    protected boolean stapleSign;
    protected boolean multiSign;
    private final boolean issuerReadRequired;
    protected static final String ISSUER_CONSTANT_W3 = "5a 0a 92 76 00 35 31";
    private static final List<String> SUPPORTED_EF_GDOS;
    private GDCardHelper.CheckAlgAnalyzer siggAlgAnalyzer;
    private GDCardHelper.CheckAlgAnalyzer esignAlgAnalyzer;
    private boolean rfidMode;
    protected Integer stapleSignCounter = 250;

    protected StarCOS37DGNService() {
        this("DGN", ISSUER_CONSTANT_W3, ISSUER_CONSTANT_W3, false, false, Card.CardTypeEnum.HPC_ZOD_DGN, true);
    }

    public StarCOS37DGNService(String displayName, String mainIssuerConstant, String cardIssuerConstant, boolean stapleSign, boolean multiSign, Card.CardTypeEnum cardType, boolean issuerReadRequired) {
        super(cardType, new String[]{"80 81 05"});
        this.issuerConstant = mainIssuerConstant == null || mainIssuerConstant.isEmpty() ? ISSUER_CONSTANT_W3 : mainIssuerConstant;
        this.displayName = displayName;
        this.tokenLabel = cardIssuerConstant;
        this.stapleSign = stapleSign;
        this.multiSign = multiSign;
        this.issuerReadRequired = issuerReadRequired;
    }

    @Override
    public final String getDisplayName() {
        return this.displayName;
    }

    @Override
    public final boolean isMultiSign() {
        return this.multiSign;
    }

    @Override
    public boolean isStapleSign() {
        return this.stapleSign || GovCS.isStapleSign(this);
    }

    @Override
    protected final boolean isIssuerReadRequired() {
        return this.issuerReadRequired;
    }

    @Override
    protected String getIssuerConstant() {
        return this.tokenLabel;
    }

    @Override
    protected void initialize(CardServiceScheduler scheduler, SmartCard smartcard, boolean blocking) throws CardServiceException {
        super.initialize(scheduler, smartcard, blocking);
        this.siggAlgAnalyzer = new GDCardHelper.CheckAlgAnalyzer(this, "D2 76 00 00 66 01", MAP_SIG_ALGORITHM_PKCS1V15, MAP_SIG_ALGORITHM_PKCS1PSS, MAP_SIG_ALGORITHM_DINSIG, MAP_SIG_ALGORITHM_ECDSA, MAP_AUT_ALGORITHM, null, ASYMMETRIC_KEY_IDENTIFIER);
        this.siggAlgAnalyzer.checkAlgSuppport((byte)3);
        this.siggAlgAnalyzer.checkAlgSuppport((byte)4);
        this.esignAlgAnalyzer = new GDCardHelper.CheckAlgAnalyzer(this, "A0 00 00 01 67 45 53 49 47 4e", MAP_SIG_ALGORITHM_PKCS1V15, MAP_SIG_ALGORITHM_PKCS1PSS, MAP_SIG_ALGORITHM_DINSIG, MAP_SIG_ALGORITHM_ECDSA, MAP_AUT_ALGORITHM, null, ASYMMETRIC_KEY_IDENTIFIER);
        this.esignAlgAnalyzer.checkAlgSuppport((byte)1);
        this.esignAlgAnalyzer.checkAlgSuppport((byte)2);
        this.esignAlgAnalyzer.checkAlgSuppport((byte)3);
        this.esignAlgAnalyzer.checkAlgSuppport((byte)5);
        StarCOS37DGNService.getImageID(this, MAP_IMAGE_ID);
        LOG.debug((Object)"signature key algorithms:");
        this.siggAlgAnalyzer.dumpAlgorithms();
        LOG.debug((Object)"authentication/decryption key algorithms:");
        this.esignAlgAnalyzer.dumpAlgorithms();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final String readIssuerFromATR(CardChannel channel) {
        Object readIssuerFromATR = super.readIssuerFromATR(channel);
        boolean supported = false;
        LOG.debug((Object)("EF.GDO: " + (String)readIssuerFromATR));
        String imageID = null;
        try {
            ResponseAPDU r = channel.sendCommandAPDU(new CommandAPDU(HexUtil.parse("a0 ca 9f 6b 08")));
            if (r.sw() != 36864) {
                return null;
            }
            LOG.debug((Object)("Chip: " + HexUtil.hexify(r.data())));
            LOG.debug((Object)("OS version: " + HexUtil.hexify(channel.sendCommandAPDU(new CommandAPDU(HexUtil.parse("a0 ca 9f 6a 05"))).data())));
            ResponseAPDU responseImageID = channel.sendCommandAPDU(new CommandAPDU(HexUtil.parse("a0 ca 9f 67 04")));
            LOG.debug((Object)("Image ID: " + HexUtil.hexify(responseImageID.data())));
            if (responseImageID.sw() == 36864 && responseImageID.data() != null && MAP_IMAGE_ID.containsKey(imageID = HexUtil.hexify(responseImageID.data()))) {
                LOG.debug((Object)"card identified by image id");
                supported = true;
            }
        }
        catch (Exception e) {
            LOG.debug((Object)("failed to read card informations: " + e.getMessage()), (Throwable)e);
        }
        if (supported |= SUPPORTED_EF_GDOS.contains(readIssuerFromATR)) {
            try {
                this.selectFile(channel, new FileReference(2, "0013"));
                ASN1 mfPinCHRecord = this.findEFKEYDRecord(channel, new StarCOS37.PwdRecordMatcher(1), null);
                StarCOS37DGNService.logLifeCycle("PIN.CH", "MF", mfPinCHRecord);
                this.selectSubDirectory(channel, new FileReference(4, "D2 76 00 00 66 01"));
                this.selectFile(channel, new FileReference(2, "0013"));
                ASN1 dfPinQESRecord1 = this.findEFKEYDRecord(channel, new StarCOS37.PwdRecordMatcher(1), null);
                if (dfPinQESRecord1 != null) {
                    ASN1[] ssecChilds = dfPinQESRecord1.getChildElementsByTag(SSEC_PATH[0][0]);
                    StarCOS37DGNService.logLifeCycle("PIN.QES1", "DF.EUserPKI", dfPinQESRecord1);
                    ASN1 ssec = null;
                    if (ssecChilds.length == 2) {
                        ssec = ssecChilds[0];
                        ssec = StarCOS37DGNService.getASN1Child(ssec, SSEC_CONTENT_PATH);
                    } else {
                        ssec = StarCOS37DGNService.getASN1Child(dfPinQESRecord1, SSEC_PATH);
                    }
                    if (ssec != null) {
                        LOG.debug((Object)("SSEC for password of QES1:\n" + HexUtil.dump(ssec.getEncoded())));
                        readIssuerFromATR = (String)readIssuerFromATR + " " + HexUtil.hexify(ssec.getValue());
                    } else if (IMAGE_IDS_SINGLE.equals(imageID)) {
                        LOG.debug((Object)"card personalization - expected SSEC value not set, using ImageID");
                        readIssuerFromATR = (String)readIssuerFromATR + " 01";
                    } else if (IMAGE_IDS_STAPLE.contains(imageID)) {
                        LOG.debug((Object)"card personalization - expected SSEC value not set, using ImageID");
                        readIssuerFromATR = (String)readIssuerFromATR + " fa";
                    } else {
                        LOG.debug((Object)"card personalization - expected SSEC value not set, ImageID unknown, using default: ff");
                        readIssuerFromATR = (String)readIssuerFromATR + " ff";
                    }
                } else if (this.rfidMode && dfPinQESRecord1 == null) {
                    String string = "5a 0a 92 76 00 35 31 fa";
                    return string;
                }
            }
            catch (Exception e) {
                LOG.debug((Object)("failed reading EF.KEYD of MF/DF.QES for PIN.CH, PIN.QES1 and PIN.QES2: " + e.getMessage()), (Throwable)e);
            }
            finally {
                try {
                    this.selectMasterFile(channel);
                }
                catch (Exception e) {
                    LOG.debug((Object)("select MF failed: " + e.getMessage()), (Throwable)e);
                }
            }
        }
        LOG.debug((Object)("card identification: " + (String)readIssuerFromATR));
        return readIssuerFromATR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final String readIssuerFromATR2(CardChannel _channel) {
        Object readIssuerFromATR = super.readIssuerFromATR(_channel);
        if (this.issuerConstant.equals(readIssuerFromATR)) {
            try {
                this.selectFile(_channel, new FileReference(2, "0013"));
                ASN1 mfPinCHRecord = this.findEFKEYDRecord(_channel, new StarCOS37.PwdRecordMatcher(1), null);
                StarCOS37DGNService.logLifeCycle("PIN.CH", "MF", mfPinCHRecord);
                this.selectSubDirectory(_channel, new FileReference(4, "D2 76 00 00 66 01"));
                this.selectFile(_channel, new FileReference(2, "0013"));
                ASN1 dfPinQESRecord = this.findEFKEYDRecord(_channel, new StarCOS37.PwdRecordMatcher(1), null);
                if (dfPinQESRecord != null) {
                    StarCOS37DGNService.logLifeCycle("PIN.CH", "DF.QES", dfPinQESRecord);
                    ASN1 ssec = StarCOS37DGNService.getASN1Child(dfPinQESRecord, SSEC_PATH);
                    if (ssec != null) {
                        LOG.debug((Object)("SSEC for password of QES:\n" + HexUtil.dump(ssec.getEncoded())));
                        readIssuerFromATR = (String)readIssuerFromATR + " " + HexUtil.hexify(ssec.getValue());
                    } else {
                        readIssuerFromATR = (String)readIssuerFromATR + " ff";
                    }
                }
            }
            catch (Exception e) {
                LOG.debug((Object)("failed reading EF.KEYD of MF/DF.QES for PIN.CH or PIN.QES: " + e.getMessage()), (Throwable)e);
            }
            finally {
                try {
                    this.selectMasterFile(_channel);
                }
                catch (Exception e) {
                    LOG.debug((Object)("select MF failed: " + e.getMessage()), (Throwable)e);
                }
            }
        }
        return readIssuerFromATR;
    }

    private static void logLifeCycle(String pinName, String dfName, ASN1 pwdRecord) {
        if (pwdRecord == null) {
            return;
        }
        LOG.debug((Object)("EF.KEYD of " + dfName + " for PINID of " + pinName + ":\n" + HexUtil.dump(pwdRecord.getEncoded())));
        ASN1 lifeCycle = StarCOS37DGNService.getASN1Child(pwdRecord, (byte)-118);
        if (lifeCycle != null) {
            byte[] lifeCycleValue = lifeCycle.getValue();
            LOG.debug((Object)("lifeCycle " + pinName + " (active: " + (5 == lifeCycleValue[0]) + "): " + HexUtil.hexify(lifeCycleValue)));
        }
    }

    @Override
    public final Integer getStapleSignCounter() {
        return this.stapleSign ? this.stapleSignCounter : (this.isStapleSign() ? MAXIMUM_COUNT_OF_STAPLE_SIGNATURES : null);
    }

    @Override
    protected final Card createCardInt(Terminal pTerminal, int pSlotID) {
        long idOfCard = CARD_OBJECT_REGISTRY.createNewCardID();
        long idOfMFApplication = 1000000L;
        long idOfPinCH = 2000001L;
        byte pinID = 1;
        FileReference dirRefMF = new FileReference(0, "3f00");
        FileEntry fileEntryMF = new FileEntry(dirRefMF, dirRefMF);
        CardPinImpl pinCH = new CardPinImpl(Disposeable.NO_LOCK, "PIN.CH", idOfPinCH, CardPin.CardPinTypeEnum.PIN.getType(), fileEntryMF, idOfCard, idOfMFApplication, pTerminal.getID(), pSlotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID, new long[]{4000001L});
        CardApplication applicationQES = this.createQESApp(pTerminal, pSlotID, idOfCard, idOfMFApplication);
        CardApplication applicationESIGN = this.createESignApp(pTerminal, pSlotID, idOfCard, idOfMFApplication, idOfPinCH);
        CardObjectManagerImpl mfManager = new CardObjectManagerImpl(idOfMFApplication);
        mfManager.putApplication(applicationQES);
        mfManager.putApplication(applicationESIGN);
        mfManager.putPin(pinCH);
        CardApplicationImpl mfApplication = new CardApplicationImpl("MF", idOfMFApplication, CardApplication.CardApplicationTypeEnum.MF.getType(), fileEntryMF, (CardObjectManager)mfManager, idOfCard, idOfMFApplication, pTerminal.getID(), pSlotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        CardImpl card = new CardImpl(this.getDisplayName() + "-" + String.valueOf(idOfCard), idOfCard, this.cardType.getType(), super.getCard(), mfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance());
        return card;
    }

    protected CardApplication createESignApp(Terminal pTerminal, int pSlotID, long idOfCard, long idOfMFApplication, long idOfPinCH) {
        String aid = AID_EA;
        long idOfApplication = 1000002L;
        long idOfFile01 = 3000003L;
        long idOfFile02 = 3000004L;
        long idOfFile03 = 3000005L;
        long idOfFile04 = 3000006L;
        long idOfKey01 = 4000003L;
        long idOfKey02 = 4000004L;
        long idOfKey03 = 4000005L;
        long idOfKey04 = 4000006L;
        KeyID k01 = new KeyID("82");
        KeyID k02 = new KeyID("83");
        KeyID k03 = new KeyID("86");
        KeyID k04 = new KeyID("85");
        FileReference dirRefApp = new FileReference(4, aid);
        FileReference cerRef01 = new FileReference(2, "c500");
        FileReference cerRef02 = new FileReference(2, "c200");
        FileReference cerRef03 = new FileReference(2, "c506");
        FileReference cerRef04 = new FileReference(2, "c205");
        FileEntry fileEntry01 = new FileEntry(dirRefApp, cerRef01);
        FileEntry fileEntry02 = new FileEntry(dirRefApp, cerRef02);
        FileEntry fileEntry03 = new FileEntry(dirRefApp, cerRef03);
        FileEntry fileEntry04 = new FileEntry(dirRefApp, cerRef04);
        OCFCertificateInfo info01 = new OCFCertificateInfo(idOfCard, idOfPinCH, idOfFile01, idOfKey01, OCFCertificateInfo.ChainEntry.USER, null, null);
        OCFCertificateInfo info02 = new OCFCertificateInfo(idOfCard, idOfPinCH, idOfFile02, idOfKey02, OCFCertificateInfo.ChainEntry.USER, null, null);
        OCFCertificateInfo info03 = new OCFCertificateInfo(idOfCard, idOfPinCH, idOfFile03, idOfKey03, OCFCertificateInfo.ChainEntry.USER, null, null);
        OCFCertificateInfo info04 = new OCFCertificateInfo(idOfCard, idOfPinCH, idOfFile04, idOfKey04, OCFCertificateInfo.ChainEntry.USER, null, null);
        CardFileImpl file01 = new CardFileImpl(Disposeable.NO_LOCK, "cerAutRSA", idOfFile01, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry01, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), idOfKey01);
        CardFileImpl file02 = new CardFileImpl(Disposeable.NO_LOCK, "cerEncRSA", idOfFile02, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry02, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), idOfKey02);
        CardFileImpl file03 = new CardFileImpl(Disposeable.NO_LOCK, "cerAutEC", idOfFile03, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry03, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), idOfKey03);
        CardFileImpl file04 = new CardFileImpl(Disposeable.NO_LOCK, "cerEncEC", idOfFile04, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry04, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), idOfKey04);
        CardKeyImpl key01 = new CardKeyImpl(Disposeable.NO_LOCK, "AuthenticationKeyRSA", idOfKey01, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.SIGNATURE.getType(), CardKey.CardKeyTypeEnum.ADVANCED_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.AUTHENTICATION.getType()}), fileEntry01, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), info01, idOfFile01, idOfPinCH, k01);
        CardKeyImpl key02 = new CardKeyImpl(Disposeable.NO_LOCK, "DecryptionKeyRSA", idOfKey02, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DECRYPTION.getType()}), fileEntry02, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), info02, idOfFile02, idOfPinCH, k02);
        CardKeyImpl key03 = new CardKeyImpl(Disposeable.NO_LOCK, "AuthenticationKeyEC", idOfKey03, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.SIGNATURE.getType(), CardKey.CardKeyTypeEnum.ADVANCED_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.DEFAULT_AUTHENTICATION.getType(), CardKey.CardKeyTypeEnum.AUTHENTICATION.getType()}), fileEntry03, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), info03, idOfFile03, idOfPinCH, k03);
        CardKeyImpl key04 = new CardKeyImpl(Disposeable.NO_LOCK, "DecryptionKeyEC", idOfKey04, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DECRYPTION.getType(), CardKey.CardKeyTypeEnum.DEFAULT_DECRYPTION.getType()}), fileEntry04, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), info04, idOfFile04, idOfPinCH, k04);
        AlgorithmProvider<OCFPrivateKey> algorithmProvider01 = this.createDefaultAlgorithmProviderSignatureAndOrAuthentication(Collections.singletonList(UsageRelated.Usage.AUTHENTICATION));
        key01.setAlgorithmProvider(algorithmProvider01);
        AlgorithmProvider<OCFPrivateKey> algorithmProvider02 = this.createDefaultAlgorithmProviderDecryption();
        key02.setAlgorithmProvider(algorithmProvider02);
        AlgorithmProvider<OCFPrivateKey> algorithmProvider03 = StarCOS37DGNService.createDefaultECAlgorithmProviderSignature(Collections.singletonList(UsageRelated.Usage.AUTHENTICATION));
        key03.setAlgorithmProvider(algorithmProvider03);
        AlgorithmProvider<OCFPrivateKey> algorithmProvider04 = this.createDefaultAlgorithmProviderDecryption();
        key04.setAlgorithmProvider(algorithmProvider04);
        CardObjectManagerImpl managerApp = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl applicationApp = new CardApplicationImpl(aid, idOfApplication, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.SIGNATURE.getType(), CardApplication.CardApplicationTypeEnum.AUTHENTICATION.getType(), CardApplication.CardApplicationTypeEnum.DECRYPTION.getType()}), fileEntry03, (CardObjectManager)managerApp, idOfCard, idOfMFApplication, pTerminal.getID(), pSlotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        applicationApp.putFile(file01);
        applicationApp.putFile(file02);
        applicationApp.putFile(file03);
        applicationApp.putFile(file04);
        applicationApp.putKey(key01);
        applicationApp.putKey(key02);
        applicationApp.putKey(key03);
        applicationApp.putKey(key04);
        return applicationApp;
    }

    private CardApplication createQESApp(Terminal pTerminal, int pSlotID, long idOfCard, long idOfMFApplication) {
        String aid = "d27600006601";
        long idOfApplication = 1000001L;
        long idOfPin01 = 2000002L;
        long idOfFile01 = 3000001L;
        long idOfFile02 = 3000002L;
        long idOfKey01 = 4000001L;
        long idOfKey02 = 4000002L;
        KeyID k01 = new KeyID("84");
        KeyID k02 = new KeyID("86");
        byte pinID01 = -127;
        FileReference dirRefApp = new FileReference(4, aid);
        FileReference cerRef01rsa = new FileReference(2, "c000");
        FileReference cerRef02ec = new FileReference(2, "c006");
        FileEntry fileEntry01 = new FileEntry(dirRefApp, cerRef01rsa);
        FileEntry fileEntry02 = new FileEntry(dirRefApp, cerRef02ec);
        OCFCertificateInfo info01 = new OCFCertificateInfo(idOfCard, idOfPin01, idOfFile01, idOfKey01, OCFCertificateInfo.ChainEntry.USER, OCFCertificateInfo.Usage.SIG, new long[0]);
        OCFCertificateInfo info02 = new OCFCertificateInfo(idOfCard, idOfPin01, idOfFile02, idOfKey02, OCFCertificateInfo.ChainEntry.USER, OCFCertificateInfo.Usage.SIG, new long[0]);
        CardPinImpl pin01 = new CardPinImpl(Disposeable.NO_LOCK, "Signatur-PIN", idOfPin01, CardPin.CardPinTypeEnum.PIN.getType(), fileEntry01, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID01, new long[]{idOfKey01, idOfKey02});
        CardFileImpl file01 = new CardFileImpl(Disposeable.NO_LOCK, "cerQESrsa", idOfFile01, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry01, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), idOfKey01);
        CardFileImpl file02 = new CardFileImpl(Disposeable.NO_LOCK, "cerQESec", idOfFile02, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry02, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), idOfKey02);
        CardKeyImpl key01 = new CardKeyImpl(Disposeable.NO_LOCK, NAME_QES_SIGNATURE_KEY_RSA, idOfKey01, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.SIGNATURE.getType(), CardKey.CardKeyTypeEnum.QUALIFIED_SIGNATURE.getType()}), fileEntry01, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), info01, new long[]{idOfFile01}, new long[0], new long[]{idOfPin01}, k01);
        CardKeyImpl key02 = new CardKeyImpl(Disposeable.NO_LOCK, NAME_QES_SIGNATURE_KEY_EC, idOfKey02, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.SIGNATURE.getType(), CardKey.CardKeyTypeEnum.QUALIFIED_SIGNATURE.getType()}), fileEntry02, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), info02, new long[]{idOfFile02}, new long[0], new long[]{idOfPin01}, k02);
        AlgorithmProvider<OCFPrivateKey> algorithmProvider01 = this.createDefaultAlgorithmProviderSignatureAndOrAuthentication(Collections.singletonList(UsageRelated.Usage.SIGNATURE));
        key01.setAlgorithmProvider(algorithmProvider01);
        AlgorithmProvider<OCFPrivateKey> algorithmProvider02 = StarCOS37DGNService.createDefaultECAlgorithmProviderSignature(Collections.singletonList(UsageRelated.Usage.SIGNATURE));
        key02.setAlgorithmProvider(algorithmProvider02);
        CardObjectManagerImpl managerApp = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl applicationApp = new CardApplicationImpl(aid, idOfApplication, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.SIGNATURE.getType()}), fileEntry01, (CardObjectManager)managerApp, idOfCard, idOfMFApplication, pTerminal.getID(), pSlotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        applicationApp.putPin(pin01);
        applicationApp.putFile(file01);
        applicationApp.putFile(file02);
        applicationApp.putKey(key01);
        applicationApp.putKey(key02);
        return applicationApp;
    }

    @Override
    public final Integer getMaxPINLengthInit(OCFCertificateInfo _info) {
        return INIT_LENGTH;
    }

    @Override
    public final Integer getMinPINLengthInit(OCFCertificateInfo _info) {
        return INIT_LENGTH;
    }

    @Override
    public final int getPasswordBlockLength(OCFCertificateInfo _info) {
        return 8;
    }

    @Override
    protected byte[] getPaddedPIN(OCFCertificateInfo _info, char[] _pin) {
        return this.getPinEncoder(_info).encode(_pin);
    }

    @Override
    public final PinEncoder getPinEncoder(OCFCertificateInfo _info) {
        return PinEncoder.ENCODER_FORMAT_2_PIN_BLOCK;
    }

    @Override
    public final byte getPasswordBlockFiller(OCFCertificateInfo _info) {
        return -1;
    }

    @Override
    public final int getMinPINLength(OCFCertificateInfo info) {
        return 6;
    }

    @Override
    public List<String> getAvailableHashAlgorithmNames(OCFCertificateInfo _info) {
        ArrayList<String> c = new ArrayList<String>();
        if (_info.getUsage() != OCFCertificateInfo.Usage.ENC) {
            c.add("SHA256");
        }
        return c;
    }

    @Override
    protected boolean usesASN1HeaderWithAuthentify() {
        return false;
    }

    @Override
    protected CommandAPDU createAuthentifyCommand(byte[] _hashValue, AlgorithmParameters algorithmParameters) {
        byte[] store = new byte[6 + _hashValue.length];
        store[0] = 0;
        store[1] = -120;
        store[2] = 0;
        store[3] = 0;
        store[4] = (byte)_hashValue.length;
        System.arraycopy(_hashValue, 0, store, 5, _hashValue.length);
        store[store.length - 1] = 0;
        return new CommandAPDU(store);
    }

    static {
        LinkedHashMap<String, String> tmp = new LinkedHashMap<String, String>();
        tmp.put(IMAGE_ID_STAPLE, "Version Release V Einzelsignatur");
        tmp.put(IMAGE_ID_STAPLE, "Version Release V Stapelsignatur");
        tmp.put(IMAGE_ID_SINGLE_TEST, "Version Testkarte Einzelsignatur");
        tmp.put(IMAGE_ID_STAPLE_TEST, "Version Testkarte Stapelsignatur");
        MAP_IMAGE_ID = Collections.unmodifiableMap(tmp);
        INIT_LENGTH = 5;
        LOG = LogFactory.getLog(StarCOS37DGNService.class);
        SUPPORTED_EF_GDOS = Collections.unmodifiableList(Arrays.asList(ISSUER_CONSTANT_W3));
    }
}

