/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.starcos;

import de.bos_bremen.basecard.common.crypto.Algorithm;
import de.bos_bremen.basecard.common.crypto.AlgorithmProvider;
import de.bos_bremen.basecard.common.crypto.CardExecutionDecryptRSAParameterSpec;
import de.bos_bremen.basecard.common.crypto.CardExecutionSignAuthenticateParameterSpec;
import de.bos_bremen.basecard.common.crypto.UsageRelated;
import de.bos_bremen.common.HexUtil;
import de.bos_bremen.common.asn1.ASN1;
import de.bos_bremen.common.crypto.AlgorithmIdentifierHelper;
import de.bos_bremen.gov2.jca_provider.OCFPrivateKey;
import de.bos_bremen.gov2.jca_provider.OCFProvider;
import de.bos_bremen.gov2.jca_provider.ocf.DefaultBaseAlgorithmProviderBuilder;
import de.bos_bremen.gov2.jca_provider.ocf.NotYetInitializedException;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.OCFDefaultAlgorithmFinder;
import de.bos_bremen.gov2.jca_provider.ocf.OperationCancelledException;
import de.bos_bremen.gov2.jca_provider.ocf.PinDeactivatedException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputCancelledException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputTimeoutException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputTooLongException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputTooShortException;
import de.bos_bremen.gov2.jca_provider.ocf.ProgressSession;
import de.bos_bremen.gov2.jca_provider.ocf.ResponseCodeException;
import de.bos_bremen.gov2.jca_provider.ocf.RetryCounterExpiredException;
import de.bos_bremen.gov2.jca_provider.ocf.WrongPinException;
import de.bos_bremen.gov2.jca_provider.ocf.cards.APDUCommands;
import de.bos_bremen.gov2.jca_provider.ocf.cards.CardChannelManager;
import de.bos_bremen.gov2.jca_provider.ocf.cards.FileReference;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GDCardHelper;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCHVDialog;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.MaxSignatureCountReachedException;
import de.bos_bremen.gov2.jca_provider.ocf.cards.base.HPCHBAG2Card;
import de.bos_bremen.gov2.jca_provider.ocf.cards.util.CardErrorUtil;
import de.bos_bremen.gov2.jca_provider.ocf.model.Card;
import de.bos_bremen.opencard.terminal.pcsc.PCSCCardTerminal;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidParameterSpecException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import opencard.core.service.CardChannel;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.util.HexString;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public abstract class StarCOS37
extends GovCS
implements HPCHBAG2Card {
    protected static final String HEX_CMD_GET_PROTOCOL_DATA_CHIP = "a0 ca 9f 6b 08";
    protected static final String HEX_CMD_GET_PROTOCOL_DATA_OS_VERSION = "a0 ca 9f 6a 05";
    protected static final String HEX_CMD_READ_IMAGE_ID = "a0 ca 9f 67 04";
    public static final Map<String, String> MAP_SIG_ALGORITHM_PKCS1V15;
    public static final Map<String, String> MAP_SIG_ALGORITHM_PKCS1PSS;
    public static final Map<String, String> MAP_SIG_ALGORITHM_DINSIG;
    public static final Map<String, String> MAP_SIG_ALGORITHM_ECDSA;
    public static final Map<String, String> MAP_AUT_ALGORITHM;
    public static final GDCardHelper.AsymmetricKeyIdentifier ASYMMETRIC_KEY_IDENTIFIER;
    protected static final byte[][] SSEC_PATH;
    protected static final byte[][] SSEC_CONTENT_PATH;
    public static final byte PWD_LIFECYCLE_TAG = -118;
    public static final int PWD_LIFECYLE_VALUE_ACTIVATED = 5;
    public static final byte PWDTYPE_EFKEYD_LOCAL = -104;
    public static final byte PWDTYPE_EFKEYD_GLOBAL = -120;
    public static final byte KEYTYPE_EFKEYD_LOCAL = -104;
    public static final byte KEYTYPE_EFKEYD_GLOBAL = -120;
    public static final String FID_EFKEYD = "0013";
    public static final String ALGORITHM_ID_CIPHER_RSA = "1130";
    public static final String ALGORITHM_ID_CIPHER_RSA_PKCS1_5 = "1131";
    public static final String ALGORITHM_ID_CIPHER_RSA_OAEP = "1132";
    public static final String ALGORITHM_ID_RSA_PKCS1_5 = "1323";
    public static final String ALGORITHM_ID_SHA256_RSA_PSS = "133330";
    public static final String ALGORITHM_ID_SHA224_RSA_PSS = "133360";
    public static final String ALGORITHM_ID_SHA384_RSA_PSS = "133340";
    public static final String ALGORITHM_ID_SHA512_RSA_PSS = "133350";
    public static final String ALGORITHM_ID_SHA1_RSA_PSS = "133310";
    public static final String AUT_ALGORITHM_ID_RSA_PKCS1_5 = "2353";
    public static final String AUT_ALGORITHM_ID_SHA256_RSA_PKCS_1_5 = "235330";
    public static final String AUT_ALGORITHM_ID_SHA224_RSA_PKCS_1_5 = "235360";
    public static final String AUT_ALGORITHM_ID_SHA384_RSA_PKCS_1_5 = "235340";
    public static final String AUT_ALGORITHM_ID_SHA512_RSA_PKCS_1_5 = "235350";
    public static final String AUT_ALGORITHM_ID_SHA1_RSA_PKCS_1_5 = "235310";
    public static final String ALGORITHM_ID_SHA256_ECDSA = "234153";
    private static final Log LOG;
    private final String[] historicals;
    protected int historicalsIndex = 0;
    protected Card.CardTypeEnum cardType;
    private final Map<String, Integer> cacheKeyNameEFKEYDRecordNo = new LinkedHashMap<String, Integer>();

    @Override
    public int getMaxPINLength(OCFCertificateInfo info) {
        if (info == null) {
            return 6;
        }
        return super.getMaxPINLength(info);
    }

    public Card.CardTypeEnum getCardType() {
        return this.cardType;
    }

    protected final ResponseAPDU getPinState(CardChannel cardChannel, OCFCertificateInfo info) throws ResponseCodeException, CardTerminalException {
        this.selectForPin(info, cardChannel);
        CommandAPDU cmd = APDUCommands.createGetRetryCounterCommand(info.getPinID());
        byte[] cb = cmd.getBytes();
        cb[0] = -128;
        cmd = new CommandAPDU(cb);
        LOG.debug((Object)("PS CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        ResponseAPDU res = this.sendCommandAPDU(cardChannel, cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        LOG.debug((Object)("PS RESULT : " + HexString.hexify(res.getBuffer(), false)));
        return res;
    }

    protected ResponseAPDU sendCommandAPDU(CardChannel cardChannel, CommandAPDU cmd) throws InvalidCardChannelException, CardTerminalException {
        return cardChannel.sendCommandAPDU(cmd);
    }

    protected final void selectForPin(OCFCertificateInfo _info, CardChannel cardChannel) throws ResponseCodeException, CardTerminalException {
        if (_info.getPinID() == -127) {
            this.selectSubDirectory(cardChannel, _info.getPin().getParentApplication().getFileEntry().getDirectory());
        } else {
            this.selectSubDirectory(cardChannel, _info.getKey().getParentApplication().getFileEntry().getDirectory());
        }
    }

    public StarCOS37(Card.CardTypeEnum cardType, String[] historicals) {
        this.historicals = historicals;
        this.cardType = cardType == null ? Card.CardTypeEnum.UNKNOWN_STARCOS35 : cardType;
    }

    @Override
    protected byte[] getHistoricals() {
        return HexUtil.parse(this.historicals[this.historicalsIndex]);
    }

    @Override
    protected boolean historicalsEquals(byte[] _historicals) {
        if (_historicals == null) {
            return true;
        }
        this.historicalsIndex = -1;
        for (int i = 0; i < this.historicals.length; ++i) {
            byte[] historicals = HexUtil.parse(this.historicals[i]);
            if (historicals.length != _historicals.length) continue;
            boolean diff = false;
            for (int j = 0; j < _historicals.length && !diff; ++j) {
                diff = historicals[j] != _historicals[j];
            }
            if (diff) continue;
            this.historicalsIndex = i;
            break;
        }
        return this.historicalsIndex >= 0 && this.historicalsIndex < this.historicals.length;
    }

    @Override
    protected final OCFCertificateInfo[] createCertificateInfos() {
        return new OCFCertificateInfo[0];
    }

    @Override
    protected final String getOSName() {
        return "StarCOS 3.7";
    }

    @Override
    protected final int getMaximumChunkSize() {
        return 240;
    }

    @Override
    protected final boolean usesASN1HeaderWithSignHash() {
        return false;
    }

    @Override
    protected final void adjustForPaddingByte(GovCS.ResultObject _ro) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final synchronized boolean isKeyInitialized(CardChannel _channel, OCFCertificateInfo _info) throws ResponseCodeException, CardTerminalException, InvalidCardChannelException {
        ResponseAPDU res = this.getPinState(_channel, _info);
        int errorCode = res.sw();
        if (errorCode == 25285) {
            return false;
        }
        if ((0x63C0 & errorCode) == 25536 && (0x63C0 & errorCode) > 0) {
            return true;
        }
        try {
            ASN1 lifeCycle;
            ASN1 passwordRecord = this.getPwdRecord(_channel, _info);
            if (passwordRecord != null && (lifeCycle = StarCOS37.getASN1Child(passwordRecord, (byte)-118)) != null) {
                byte[] lifeCycleValue = lifeCycle.getValue();
                LOG.debug((Object)("lifeCycle: " + HexUtil.hexify(lifeCycleValue)));
                if (lifeCycleValue != null && lifeCycleValue.length == 1) {
                    boolean bl = (lifeCycleValue[0] & 0xF) == 5;
                    return bl;
                }
            }
        }
        finally {
            if ((_info.getPinID() & 0xFFFFFFF0) == 0) {
                this.selectSubDirectory(_channel, _info.getDirectory());
            }
        }
        return true;
    }

    @Override
    protected final int getRetryCount(CardChannel _channel, OCFCertificateInfo _info) throws RetryCounterExpiredException, NotYetInitializedException, InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        int errorCode;
        String pinName = StarCOS37.getPinNameForInfo(_info);
        if (!this.isKeyInitialized(_info)) {
            throw new NotYetInitializedException(pinName, 27013, "password not initialized");
        }
        CommandAPDU cmd = APDUCommands.createGetRetryCounterCommand(_info.getPinID());
        LOG.debug((Object)("RC CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        ResponseAPDU res = this.sendCommandAPDU(_channel, cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        LOG.debug((Object)("RC RESULT : " + HexString.hexify(res.getBuffer(), false)));
        String message = APDUCommands.getVerifyErrorMsg(res.sw());
        if ((res.sw() & 0xFFF0) != 25536) {
            LOG.debug((Object)("RC RESULT : " + message));
        }
        if ((errorCode = res.sw()) == 27011) {
            throw new RetryCounterExpiredException(pinName, errorCode, message);
        }
        if (errorCode != 36864 && (errorCode & 0xFFF0) == 25536) {
            int retryCounter = errorCode - 25536;
            if (retryCounter == 0) {
                throw new RetryCounterExpiredException(pinName, errorCode, message);
            }
            return retryCounter;
        }
        return -1;
    }

    @Override
    protected CommandAPDU createMSECommand(CardChannel _channel, OCFCertificateInfo _info, int _type, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        switch (_type) {
            case 1: {
                try {
                    ByteArrayOutputStream data = new ByteArrayOutputStream();
                    data.write(-124);
                    data.write(_info.getKeyID().getID().length);
                    data.write(_info.getKeyID().getID());
                    byte[] algorithm = HexUtil.parse(ALGORITHM_ID_CIPHER_RSA_PKCS1_5);
                    try {
                        CardExecutionDecryptRSAParameterSpec parameterSpec = algorithmParameters.getParameterSpec(CardExecutionDecryptRSAParameterSpec.class);
                        algorithm = parameterSpec.getAlgorithmID();
                    }
                    catch (InvalidParameterSpecException e) {
                        LOG.debug((Object)e);
                    }
                    data.write(-119);
                    data.write(algorithm.length);
                    data.write(algorithm);
                    return APDUCommands.createManageSecurityEnvironmentCommand((byte)65, (byte)-72, data.toByteArray());
                }
                catch (IOException ex) {
                    LOG.debug((Object)ex);
                    throw new ResponseCodeException(27270, "MSE failed");
                }
            }
            case 0: 
            case 2: {
                try {
                    ByteArrayOutputStream data = new ByteArrayOutputStream();
                    data.write(-124);
                    data.write(_info.getKeyID().getID().length);
                    data.write(_info.getKeyID().getID());
                    if (algorithmParameters != null) {
                        byte[] algorithm = new byte[]{19, 51, 48};
                        try {
                            CardExecutionSignAuthenticateParameterSpec parameterSpec = algorithmParameters.getParameterSpec(CardExecutionSignAuthenticateParameterSpec.class);
                            algorithm = parameterSpec.getAlgorithmID();
                        }
                        catch (InvalidParameterSpecException e) {
                            LOG.debug((Object)e);
                        }
                        data.write(-119);
                        data.write(algorithm.length);
                        data.write(algorithm);
                    }
                    return APDUCommands.createManageSecurityEnvironmentCommand((byte)65, (byte)-74, data.toByteArray());
                }
                catch (IOException ex) {
                    LOG.debug((Object)ex);
                    throw new ResponseCodeException(27270, "MSE failed");
                }
            }
        }
        return null;
    }

    @Override
    protected final CommandAPDU createDecryptCommand(byte[] _encryptedBytes, byte _paddingIndicator, AlgorithmParameters algorithmParameters) {
        int blockSize = 257;
        byte[] store = new byte[7 + blockSize + 2];
        Arrays.fill(store, (byte)-1);
        int i = 0;
        store[i++] = 0;
        store[i++] = 42;
        store[i++] = -128;
        store[i++] = -122;
        store[i++] = 0;
        store[i++] = (byte)(blockSize >> 8 & 0xFF);
        store[i++] = (byte)(blockSize >> 0 & 0xFF);
        store[i++] = this.getPaddingIndicator();
        System.arraycopy(_encryptedBytes, 0, store, i, _encryptedBytes.length);
        i += _encryptedBytes.length;
        int resultLength = 256;
        store[i++] = (byte)(resultLength >> 8 & 0xFF);
        store[i++] = (byte)(resultLength >> 0 & 0xFF);
        return new CommandAPDU(store);
    }

    @Override
    protected byte getPaddingIndicator() {
        return 0;
    }

    @Override
    protected final GovCS.ResultObject decrypt(CardChannel channel, OCFCertificateInfo info, byte[] encryptedBytes, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, ResponseCodeException, CardTerminalException, ResponseCodeException {
        boolean ec = this.isECKey(info.getX509Certificate().getPublicKey().getAlgorithm());
        CommandAPDU cmd = null;
        ResponseAPDU res = null;
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            os.write(0);
            os.write(42);
            os.write(-128);
            os.write(-122);
            byte[] cryptogram = this.encodeCipherData(ec, encryptedBytes);
            int len = cryptogram.length;
            os.write(0);
            os.write((byte)(len >> 8 & 0xFF));
            os.write((byte)(len >> 0 & 0xFF));
            os.write(cryptogram);
            os.write(1);
            os.write(0);
            cmd = new CommandAPDU(os.toByteArray());
        }
        catch (IOException e) {
            throw new ResponseCodeException(26368, APDUCommands.getLocalizedErrorMessage(26368), e);
        }
        LOG.debug((Object)("DECRYPT CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        res = channel.sendCommandAPDU(cmd);
        if ((this.ctReference.getName().toLowerCase().contains("omnikey") || this.ctReference.getName().toLowerCase().contains("XX44")) && PCSCCardTerminal.class.isInstance(this.ctReference)) {
            try {
                ((PCSCCardTerminal)this.ctReference).resetSlot(0);
            }
            catch (CardTerminalException e) {
                LOG.debug((Object)("reset of slot failed: " + e.getMessage()));
            }
        }
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        LOG.debug((Object)("DECRYPT RESULT : " + HexString.hexify(res.getBuffer(), false)));
        if (res.sw() != 36864) {
            throw new ResponseCodeException(res.sw(), APDUCommands.getPerformSecurityOperationErrorMsg(res.sw()));
        }
        GovCS.ResultObject ro = new GovCS.ResultObject();
        ro.setResultCode(res.sw());
        ro.setResultData(res.data());
        byte[] b = (byte[])ro.getResultData();
        if (ec || b == null || b.length < 3) {
            return ro;
        }
        return this.handleRSAPKCS15(ro, b);
    }

    private GovCS.ResultObject handleRSAPKCS15(GovCS.ResultObject ro, byte[] b) {
        int i;
        if (b[0] != 0 || b[1] != 2) {
            return ro;
        }
        int count = b.length;
        for (i = 2; i < count && b[i] != 0; ++i) {
        }
        byte[] bb = new byte[b.length - i - 1];
        System.arraycopy(b, i + 1, bb, 0, bb.length);
        ro.setResultData(bb);
        return ro;
    }

    protected boolean isECKey(String keyAlgorithm) {
        return "EC".equals(keyAlgorithm) || "ECDSA".equals(keyAlgorithm);
    }

    private byte[] encodeCipherData(boolean isEC, byte[] encryptedBytes) throws ResponseCodeException {
        byte[] result = null;
        if (isEC) {
            result = encryptedBytes;
        } else {
            result = new byte[encryptedBytes.length + 1];
            result[0] = this.getPaddingIndicator();
            System.arraycopy(encryptedBytes, 0, result, 1, encryptedBytes.length);
        }
        if (result == null || result.length == 0) {
            throw new ResponseCodeException(26368, APDUCommands.getLocalizedErrorMessage(26368));
        }
        return result;
    }

    @Override
    protected CommandAPDU createAuthentifyCommand(byte[] _hashValue, AlgorithmParameters algorithmParameters) {
        byte[] store = new byte[6 + _hashValue.length];
        store[0] = 0;
        store[1] = 42;
        store[2] = -122;
        store[3] = -128;
        store[4] = (byte)_hashValue.length;
        System.arraycopy(_hashValue, 0, store, 5, _hashValue.length);
        store[store.length - 1] = 0;
        return new CommandAPDU(store);
    }

    @Override
    public final synchronized void reset() {
        if (!super.isCardPresent()) {
            return;
        }
        CardChannelManager cardChannelManager = new CardChannelManager();
        try {
            CardChannel channel = cardChannelManager.init(this);
            channel.sendCommandAPDU(new CommandAPDU(HexString.parseHexString("00 22 f3 01")));
            channel.setState(null);
        }
        catch (Exception e) {
            LOG.debug((Object)("reset failed: " + e.getMessage()));
        }
        finally {
            cardChannelManager.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized GovCS.ResultObject signHashServer(OCFCertificateInfo _info, byte[] _hashValue, char[] _pin, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws ResponseCodeException, WrongPinException, RetryCounterExpiredException, NotYetInitializedException, CardTerminalException, OperationCancelledException {
        if (this.getAvailableHashAlgorithmNames(_info).indexOf(_hashAlgorithm) < 0) {
            throw new ResponseCodeException(65535, "hash algorithm not supported by card: " + _hashAlgorithm, new NoSuchAlgorithmException("OperationCancelledException"));
        }
        ProgressSession session = new ProgressSession(2);
        session.setStepCount(6);
        session.setProgressMessage("init sign hash operation");
        if (this.progressSessionListener != null) {
            this.progressSessionListener.progressSessionWillStart(session);
            this.progressSessionListener.progressSessionStarted(session);
        }
        CardChannelManager cm = new CardChannelManager();
        try {
            cm.init(this, true, false);
            boolean localTransaction = cm.isTransactionLocallyStarted();
            try {
                this.checkSignCounter(null, localTransaction);
            }
            catch (MaxSignatureCountReachedException e) {
                cm.allocate();
                this.resetCard(cm.getCardChannel());
                throw e;
            }
            GovCS.ResultObject ro = this.signHashServerInt(_info, _hashValue, _pin, _hashAlgorithm, session, algorithmParameters);
            if (ro.getResultCode() == 36864) {
                try {
                    this.increaseAndCheckSignCounter(null, localTransaction);
                }
                catch (MaxSignatureCountReachedException e) {
                    cm.allocate();
                    this.resetCard(cm.getCardChannel());
                }
            }
            GovCS.ResultObject resultObject = ro;
            return resultObject;
        }
        finally {
            cm.destroy();
        }
    }

    @Override
    protected GovCS.ResultObject authentify(CardChannel _channel, OCFCertificateInfo _info, byte[] _hashValue, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, ResponseCodeException, CardTerminalException, ResponseCodeException, OperationCancelledException {
        this.selectForPin(_info, _channel);
        return super.signHash(_channel, _info, _hashValue, _hashAlgorithm, algorithmParameters);
    }

    @Override
    public final synchronized GovCS.ResultObject signHash(OCFCertificateInfo _info, byte[] _hashValue, char[] _pin, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws ResponseCodeException, WrongPinException, RetryCounterExpiredException, NotYetInitializedException, CardTerminalException, OperationCancelledException {
        if (OCFProvider.Settings.getInstance().isStapleSignatureEnabled() && this.isStapleSign() || OCFProvider.Settings.getInstance().isServerEnvironmentActive() && this.isMultiSign()) {
            return this.signHashServer(_info, _hashValue, _pin, _hashAlgorithm, algorithmParameters);
        }
        return super.signHash(_info, _hashValue, _pin, _hashAlgorithm, algorithmParameters);
    }

    @Override
    protected void selectMasterFile(CardChannel _channel) throws ResponseCodeException, InvalidCardChannelException, CardTerminalException {
        if (this.ctReference != null && !this.ctReference.isCardPresent(this.slotID)) {
            return;
        }
        CommandAPDU cmd = this.createSelectMasterFile();
        if (cmd == null) {
            return;
        }
        LOG.debug((Object)("SELECT MF CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        ResponseAPDU res = this.sendCommandAPDU(_channel, cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        LOG.debug((Object)("SELECT MF RES : " + HexString.hexify(res.getBuffer(), false)));
        int err = res.sw();
        if (err != 36864 && err != 25220) {
            cmd = this.createSelectMasterFile1();
            if (cmd == null) {
                return;
            }
            LOG.debug((Object)("SELECT MF CMD : " + HexString.hexify(cmd.getBuffer(), false)));
            res = this.sendCommandAPDU(_channel, cmd);
            if (res == null) {
                throw new ResponseCodeException(RESOURCES.getString("no_response"));
            }
            LOG.debug((Object)("SELECT MF RES : " + HexString.hexify(res.getBuffer(), false)));
            err = res.sw();
            if (err != 36864 && err != 25220) {
                cmd = this.createSelectMasterFile2();
                if (cmd == null) {
                    return;
                }
                LOG.debug((Object)("SELECT MF CMD : " + HexString.hexify(cmd.getBuffer(), false)));
                res = this.sendCommandAPDU(_channel, cmd);
                if (res == null) {
                    throw new ResponseCodeException(RESOURCES.getString("no_response"));
                }
                LOG.debug((Object)("SELECT MF RES : " + HexString.hexify(res.getBuffer(), false)));
                err = res.sw();
                if (err != 36864 && err != 25220) {
                    throw new ResponseCodeException(err, APDUCommands.getSelectErrorMsg(err));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final GovCS.ResultObject signHashServerInt(OCFCertificateInfo _info, byte[] _hashValue, char[] _pin, String _hashAlgorithm, ProgressSession session, AlgorithmParameters algorithmParameters) throws WrongPinException, RetryCounterExpiredException, NotYetInitializedException, ResponseCodeException, PinInputCancelledException, PinInputTooShortException, PinInputTooLongException, PinInputTimeoutException, OperationCancelledException {
        GovCS.ResultObject ro = new GovCS.ResultObject();
        CardChannelManager cardChannelManager = new CardChannelManager();
        boolean externalTransaction = !cardChannelManager.isTransactionLocallyStarted();
        CardChannel channel = null;
        try {
            this.fireProgressEvent(session, "get connection to the device");
            channel = cardChannelManager.init(this);
            this.fireProgressEvent(session, "select application on card");
            if (!this.checkChannelState(channel, _info)) {
                this.selectForPin(_info, channel);
            }
            boolean loop = true;
            this.fireProgressEvent(session, "install corresponding security environment");
            ro = this.setSecurityEnvironment(channel, _info, 0, _hashAlgorithm, algorithmParameters);
            if (ro.getResultCode() != 36864) {
                LOG.debug((Object)APDUCommands.getManageSecurityEnvironmentErrorMsg(ro.getResultCode()));
                GovCS.ResultObject resultObject = ro;
                return resultObject;
            }
            while (loop) {
                this.fireProgressEvent(session, "sign the given hash value");
                ro = this.signHash(channel, _info, _hashValue, _hashAlgorithm, algorithmParameters);
                if (ro.getResultCode() == 27010) {
                    this.resetChannelState(channel);
                    try {
                        this.checkSignCounter(channel, false);
                    }
                    catch (MaxSignatureCountReachedException e) {
                        LOG.debug((Object)"maximum of signatures reached - never happens in server mode and method");
                    }
                    this.selectFile(channel, _info, false);
                    this.fireProgressEvent(session, "verify the corresponding password");
                    ro.setResultCode(this.verifyPassword(channel, _info, _pin));
                    if (ro.getResultCode() != 36864) {
                        LOG.debug((Object)APDUCommands.getVerifyErrorMsg(ro.getResultCode()));
                        GovCS.ResultObject resultObject = ro;
                        return resultObject;
                    }
                    if (externalTransaction) {
                        this.setChannelState(channel, _info);
                    }
                    this.fireProgressEvent(session, "install corresponding security environment");
                    ro = this.setSecurityEnvironment(channel, _info, 0, _hashAlgorithm, algorithmParameters);
                    if (ro.getResultCode() != 36864) {
                        LOG.debug((Object)APDUCommands.getManageSecurityEnvironmentErrorMsg(ro.getResultCode()));
                        GovCS.ResultObject resultObject = ro;
                        return resultObject;
                    }
                    loop = true;
                    continue;
                }
                this.fireProgressEvent(session, "operation finished!");
                loop = false;
            }
            GovCS.ResultObject resultObject = ro;
            return resultObject;
        }
        catch (WrongPinException e) {
            throw e;
        }
        catch (RetryCounterExpiredException e) {
            throw e;
        }
        catch (NotYetInitializedException e) {
            throw e;
        }
        catch (PinInputTooShortException e) {
            throw e;
        }
        catch (PinInputTooLongException e) {
            throw e;
        }
        catch (PinInputTimeoutException e) {
            throw e;
        }
        catch (PinInputCancelledException e) {
            throw e;
        }
        catch (OperationCancelledException e) {
            throw e;
        }
        catch (ResponseCodeException e) {
            throw e;
        }
        catch (CardTerminalException ex) {
            LOG.debug((Object)"", (Throwable)ex);
            ro.setResultCode(0);
            GovCS.ResultObject resultObject = ro;
            return resultObject;
        }
        catch (Throwable ex) {
            LOG.debug((Object)"", ex);
            ro.setResultCode(0);
            GovCS.ResultObject resultObject = ro;
            return resultObject;
        }
        finally {
            cardChannelManager.destroy();
            if (this.progressSessionListener != null) {
                while (session.getCurrentStep() != session.getStepCount()) {
                    session.increaseCurrentStep();
                }
                session.setProgressMessage("done!");
                this.progressSessionListener.progressSessionWillStop(session);
                this.progressSessionListener.progressSessionStopped(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int verifyPasswordReaderClass1(CardChannel _channel, OCFCertificateInfo _info, char[] _pin, Integer retryCount, String pinName, GovCHVDialog chvDialog) throws ResponseCodeException, WrongPinException, RetryCounterExpiredException, NotYetInitializedException, ResponseCodeException, CardTerminalException, PinInputCancelledException, PinInputTooShortException, PinInputTooLongException, PinInputTimeoutException, OperationCancelledException, PinDeactivatedException {
        ResponseAPDU res;
        block7: {
            char[] pin = null;
            CommandAPDU cmd = null;
            try {
                if (_pin == null) {
                    chvDialog.show();
                    int result = chvDialog.getResult();
                    if (result == 2) {
                        throw new PinInputCancelledException(pinName, CardErrorUtil.getErrorCodeForRetries(retryCount), APDUCommands.getVerifyErrorMsg(0));
                    }
                    pin = chvDialog.getPIN();
                } else {
                    pin = new char[_pin.length];
                    System.arraycopy(_pin, 0, pin, 0, pin.length);
                }
                cmd = this.createVerifyPasswordCommand(_info, pin);
                LOG.debug((Object)("VP CMD : " + HexString.hexify(cmd.getBuffer(), 0, Math.min(5, cmd.getBuffer().length), false)));
                res = this.sendCommandAPDU(_channel, cmd);
                LOG.debug((Object)("VP RES : " + (res == null ? null : HexString.hexify(res.getBuffer(), false))));
                if (pin == null) break block7;
            }
            catch (Throwable throwable) {
                if (pin == null) throw throwable;
                int i = 0;
                while (i < pin.length) {
                    pin[i] = '\u0000';
                    ++i;
                }
                throw throwable;
            }
            for (int i = 0; i < pin.length; ++i) {
                pin[i] = '\u0000';
            }
        }
        if (res != null) return this.evaluateVerifyPasswordResultCode(pinName, retryCount, res.sw());
        throw new ResponseCodeException(RESOURCES.getString("no_response"));
    }

    protected ASN1 getPwdRecord(CardChannel cardChannel, OCFCertificateInfo info) throws CardTerminalException, ResponseCodeException {
        byte passwordType = StarCOS37.getPasswordType(info.getPinID());
        if (passwordType == -120) {
            this.selectMasterFile(cardChannel);
        } else {
            this.selectForPin(info, cardChannel);
        }
        return this.findEFKEYDRecord(cardChannel, new PwdRecordMatcher(info.getPinID()), info.getKey() != null ? info.getKey().getName() : null);
    }

    protected ASN1 findEFKEYDRecord(CardChannel cardChannel, ASN1RecordMatcher matcher, String cacheKeyName) throws CardTerminalException, ResponseCodeException {
        this.selectFile(cardChannel, new FileReference(2, FID_EFKEYD));
        boolean loop = true;
        int recordNo = 1;
        if (cacheKeyName != null && this.cacheKeyNameEFKEYDRecordNo.containsKey(cacheKeyName)) {
            recordNo = this.cacheKeyNameEFKEYDRecordNo.get(cacheKeyName);
            LOG.debug((Object)("using cached record no: " + cacheKeyName + " -> " + recordNo));
        }
        ResponseAPDU readRecord = null;
        while (loop) {
            LOG.debug((Object)("read record: " + recordNo));
            try {
                readRecord = this.readRecord(cardChannel, recordNo);
            }
            catch (InvalidCardChannelException e) {
                return null;
            }
            catch (CardTerminalException e) {
                return null;
            }
            if (readRecord.sw() == 36864) {
                LOG.debug((Object)("dump record data:\n" + HexUtil.dump(readRecord.data())));
                ASN1 select = matcher.match(readRecord.data());
                if (select != null) {
                    if (cacheKeyName != null) {
                        LOG.debug((Object)("caching record no: " + cacheKeyName + " -> " + recordNo));
                        this.cacheKeyNameEFKEYDRecordNo.put(cacheKeyName, recordNo);
                    }
                    return select;
                }
            } else {
                return null;
            }
            ++recordNo;
        }
        return null;
    }

    protected static byte getPasswordType(byte pinID) {
        byte passwordType = (pinID & 0xFFFFFFF0) == 0 ? (byte)-120 : -104;
        return passwordType;
    }

    protected static ASN1 getASN1Child(ASN1 asn1, byte[][] dtags) {
        if (dtags != null) {
            ASN1 tmpAsn1 = asn1;
            for (byte[] dtag : dtags) {
                if ((tmpAsn1 = StarCOS37.getASN1Child(tmpAsn1, dtag)) != null) continue;
                return null;
            }
            return tmpAsn1;
        }
        return null;
    }

    protected static ASN1 getASN1Child(ASN1 asn1, byte dtag) {
        return StarCOS37.getASN1Child(asn1, new byte[]{dtag});
    }

    protected static ASN1 getASN1Child(ASN1 asn1, byte[] dtag) {
        if (asn1 == null) {
            return null;
        }
        try {
            ASN1[] tagChildren = asn1.getChildElementsByDTagBytes(dtag);
            LOG.debug((Object)("children count of tag " + HexUtil.hexify(dtag) + ": " + (tagChildren == null ? "-" : String.valueOf(tagChildren.length))));
            if (tagChildren == null || tagChildren.length == 0 || tagChildren.length >= 2) {
                return null;
            }
            return tagChildren[0];
        }
        catch (IOException e) {
            LOG.debug((Object)("ASN.1 analyzation failed: " + e.getMessage()));
            return null;
        }
    }

    protected final AlgorithmProvider<OCFPrivateKey> createDefaultAlgorithmProviderDecryption() {
        List<UsageRelated.Usage> usageList01 = Arrays.asList(UsageRelated.Usage.CIPHER);
        ArrayList listKeyAlgorithms01 = new ArrayList();
        OCFDefaultAlgorithmFinder finder = OCFDefaultAlgorithmFinder.getInstance();
        try {
            String algorithmRSAOAEPSHA256 = "RSA/NONE/OAEPWithSHA256AndMGF1Padding";
            listKeyAlgorithms01.add(new Algorithm("OCF", usageList01, algorithmRSAOAEPSHA256, "RSA/ECB/OAEP-SHA256", new CardExecutionDecryptRSAParameterSpec(algorithmRSAOAEPSHA256, new AlgorithmIdentifier(PKCSObjectIdentifiers.id_RSAES_OAEP, (ASN1Encodable)AlgorithmIdentifierHelper.createRSAOAEPByHashAlgorithm("SHA256")), finder.findURI(algorithmRSAOAEPSHA256), null, HexUtil.parse(ALGORITHM_ID_CIPHER_RSA_OAEP))));
        }
        catch (Exception e) {
            LOG.debug((Object)e);
        }
        return this.createAlgorithmProvider(listKeyAlgorithms01);
    }

    protected final AlgorithmProvider<OCFPrivateKey> createDefaultAlgorithmProviderSignatureAndOrAuthentication(List<UsageRelated.Usage> usageList) {
        ArrayList listKeyAlgorithms01 = new ArrayList();
        try {
            listKeyAlgorithms01.addAll(DefaultBaseAlgorithmProviderBuilder.createSignatureAuthenticationRSAPSSAlgorithms(Arrays.asList("SHA256"), Arrays.asList(Boolean.FALSE), Arrays.asList(ALGORITHM_ID_SHA256_RSA_PSS), usageList));
        }
        catch (Exception e) {
            LOG.debug((Object)e);
        }
        return this.createAlgorithmProvider(listKeyAlgorithms01);
    }

    public static AlgorithmProvider<OCFPrivateKey> createDefaultECAlgorithmProviderSignature(List<UsageRelated.Usage> usageList01) {
        ArrayList listKeyAlgorithms01 = new ArrayList();
        StarCOS37.addECSignatureAuthenticationAlgorithms(usageList01, listKeyAlgorithms01);
        return StarCOS37.createAlgorithmProvider2(listKeyAlgorithms01);
    }

    protected static AlgorithmProvider<OCFPrivateKey> createAlgorithmProvider2(List<Algorithm<OCFPrivateKey, ?>> listKeyAlgorithms) {
        try {
            return DefaultBaseAlgorithmProviderBuilder.createAlgorithmProvider(listKeyAlgorithms);
        }
        catch (Exception e) {
            LOG.debug((Object)e);
            return null;
        }
    }

    private static void addECSignatureAuthenticationAlgorithms(List<UsageRelated.Usage> usageAlgorithms, List<Algorithm<OCFPrivateKey, ?>> listAlgorithms) {
        try {
            String hashAlgorithm = "SHA256";
            String algorithmID = ALGORITHM_ID_SHA256_ECDSA;
            String providerName = "OCF";
            String[] separators = new String[]{"with", "hashedWith"};
            String[] formats = new String[]{"ECDSA", "CVC-ECDSA"};
            for (String separator : separators) {
                for (String format : formats) {
                    String sigAutAlgorithmName;
                    String sigAutAlternativeAlgorithmName = sigAutAlgorithmName = hashAlgorithm + separator + format;
                    listAlgorithms.add(new Algorithm("OCF", usageAlgorithms, sigAutAlgorithmName, sigAutAlternativeAlgorithmName, new CardExecutionSignAuthenticateParameterSpec(sigAutAlgorithmName, OCFDefaultAlgorithmFinder.getInstance().find(sigAutAlgorithmName), OCFDefaultAlgorithmFinder.getInstance().findURI(sigAutAlgorithmName), false, HexUtil.parse(algorithmID))));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected final AlgorithmProvider<OCFPrivateKey> createDefaultAlgorithmProviderAuthentication() {
        List<UsageRelated.Usage> usageList = Arrays.asList(UsageRelated.Usage.AUTHENTICATION);
        ArrayList listKeyAlgorithms01 = new ArrayList();
        try {
            listKeyAlgorithms01.addAll(DefaultBaseAlgorithmProviderBuilder.createSignatureAuthenticationRSAPKCS1Algorithms(Arrays.asList("SHA256", "SHA512", "SHA224", "SHA384", "SHA1"), Arrays.asList(Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE), Arrays.asList(AUT_ALGORITHM_ID_SHA256_RSA_PKCS_1_5, AUT_ALGORITHM_ID_SHA512_RSA_PKCS_1_5, AUT_ALGORITHM_ID_SHA224_RSA_PKCS_1_5, AUT_ALGORITHM_ID_SHA384_RSA_PKCS_1_5, AUT_ALGORITHM_ID_SHA1_RSA_PKCS_1_5), usageList));
        }
        catch (Exception e) {
            LOG.debug((Object)e);
        }
        return this.createAlgorithmProvider(listKeyAlgorithms01);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getImageID(StarCOS37 cs, Map<String, String> mapImageID) {
        String imageID = null;
        CardChannelManager cardChannelManager = new CardChannelManager();
        try {
            CardChannel channel = cardChannelManager.init(cs);
            ResponseAPDU responseAPDU = channel.sendCommandAPDU(new CommandAPDU(HexUtil.parse("A0CA9f6704")));
            byte[] data = responseAPDU.data();
            if (responseAPDU.sw() == 36864 && data != null && data.length > 0) {
                imageID = HexUtil.hexify(data).toLowerCase();
                LOG.debug((Object)("Image-ID: " + imageID + (String)(mapImageID != null && !mapImageID.isEmpty() ? " (" + mapImageID.get(imageID) + ")" : "")));
            }
        }
        catch (Exception e) {
            imageID = null;
        }
        finally {
            if (cardChannelManager.getCardChannel() != null) {
                try {
                    cs.selectMasterFile(cardChannelManager.getCardChannel());
                }
                catch (Exception exception) {}
                cardChannelManager.destroy();
            }
        }
        return imageID;
    }

    @Override
    protected void resetAuthentication(CardChannel channel) {
        if (this.cardType == Card.CardTypeEnum.BNOTK3_BEA_STAPLE) {
            try {
                CommandAPDU cmd = new CommandAPDU(HexUtil.parse("00 22 f3 01"));
                LOG.debug((Object)("CARDOS50 RESET CMD : " + HexString.hexify(cmd.getBytes(), false)));
                ResponseAPDU res = channel.sendCommandAPDU(cmd);
                if (res == null) {
                    throw new ResponseCodeException(RESOURCES.getString("no_response"));
                }
                LOG.debug((Object)("CARDOS50 RESET RES : " + HexString.hexify(res.getBytes(), false)));
                super.resetAuthentication(channel);
            }
            catch (Exception e) {
                throw new RuntimeException("reset failed: " + e.getMessage(), e);
            }
        }
    }

    static {
        LinkedHashMap<String, String> tmp = new LinkedHashMap<String, String>();
        tmp.put("b6058903132310", "SHA1");
        tmp.put("b6058903132320", "RIPEMD160");
        tmp.put("b6058903132360", "SHA224");
        tmp.put("b6058903132340", "SHA384");
        tmp.put("b6058903132350", "SHA512");
        tmp.put("b6058903132330", "SHA256");
        MAP_SIG_ALGORITHM_PKCS1V15 = Collections.unmodifiableMap(tmp);
        tmp = new LinkedHashMap();
        tmp.put("b6058903133310", "SHA1");
        tmp.put("b6058903133320", "RIPEMD160");
        tmp.put("b6058903133360", "SHA224");
        tmp.put("b6058903133340", "SHA384");
        tmp.put("b6058903133350", "SHA512");
        tmp.put("b6058903133330", "SHA256");
        MAP_SIG_ALGORITHM_PKCS1PSS = Collections.unmodifiableMap(tmp);
        tmp = new LinkedHashMap();
        tmp.put("b6058903131310", "SHA1");
        tmp.put("b6058903131320", "RIPEMD160");
        tmp.put("b6058903131360", "SHA224");
        tmp.put("b6058903131340", "SHA384");
        tmp.put("b6058903131350", "SHA512");
        tmp.put("b6058903131330", "SHA256");
        MAP_SIG_ALGORITHM_DINSIG = Collections.unmodifiableMap(tmp);
        tmp = new LinkedHashMap();
        tmp.put("a4058903235310", "SHA1");
        tmp.put("a4058903235320", "RIPEMD160");
        tmp.put("a4058903235360", "SHA224");
        tmp.put("a4058903235340", "SHA384");
        tmp.put("a4058903235350", "SHA512");
        tmp.put("a4058903235330", "SHA256");
        MAP_AUT_ALGORITHM = Collections.unmodifiableMap(tmp);
        tmp = new LinkedHashMap();
        tmp.put("b6058903234153", "SHA256");
        MAP_SIG_ALGORITHM_ECDSA = Collections.unmodifiableMap(tmp);
        ASYMMETRIC_KEY_IDENTIFIER = new GDCardHelper.AsymmetricKeyIdentifier(){

            @Override
            public boolean isAsymmetricKey(byte[] recordBytes) {
                if (recordBytes == null || recordBytes.length == 0) {
                    return false;
                }
                return (recordBytes[0] & 0xFFFFFF84) == -124;
            }
        };
        SSEC_PATH = new byte[][]{{123}, {-92}, {-97, 34}};
        SSEC_CONTENT_PATH = new byte[][]{{-92}, {-97, 34}};
        LOG = LogFactory.getLog(StarCOS37.class);
    }

    static class PwdRecordMatcher
    implements ASN1RecordMatcher {
        private static final Log LOG2 = LogFactory.getLog(PwdRecordMatcher.class);
        private final byte passwordNo;
        private final byte passwordType;

        public PwdRecordMatcher(byte pinID) {
            this.passwordNo = (byte)(pinID & 0xF);
            this.passwordType = StarCOS37.getPasswordType(pinID);
        }

        @Override
        public ASN1 match(byte[] asn1RecordData) {
            ASN1 asn1;
            ASN1 asn1PwdNo;
            if (asn1RecordData == null || asn1RecordData.length == 0) {
                return null;
            }
            if (asn1RecordData[0] == this.passwordType && (asn1PwdNo = StarCOS37.getASN1Child(asn1 = new ASN1(48, asn1RecordData), this.passwordType)) != null) {
                byte[] pwdNoValue = asn1PwdNo.getValue();
                if (pwdNoValue != null && pwdNoValue.length == 2 && pwdNoValue[0] == this.passwordNo) {
                    return asn1;
                }
                if (pwdNoValue != null && pwdNoValue.length == 2) {
                    LOG2.debug((Object)("found record for another password: " + HexUtil.hexify(pwdNoValue[0])));
                }
            }
            return null;
        }
    }

    static interface ASN1RecordMatcher {
        public ASN1 match(byte[] var1);
    }
}

