/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.starcos;

import de.bos_bremen.basecard.common.crypto.AlgorithmProvider;
import de.bos_bremen.basecard.common.crypto.UsageRelated;
import de.bos_bremen.basecard.common.pin.coding.PinEncoder;
import de.bos_bremen.common.HexUtil;
import de.bos_bremen.common.asn1.ASN1;
import de.bos_bremen.gov2.jca_provider.OCFPrivateKey;
import de.bos_bremen.gov2.jca_provider.ocf.FileEntry;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.cards.FileReference;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.KeyID;
import de.bos_bremen.gov2.jca_provider.ocf.cards.starcos.StarCOS35;
import de.bos_bremen.gov2.jca_provider.ocf.model.Card;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardApplication;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardFile;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardKey;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardObjectManager;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardPin;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardRegistry;
import de.bos_bremen.gov2.jca_provider.ocf.model.Disposeable;
import de.bos_bremen.gov2.jca_provider.ocf.model.Terminal;
import de.bos_bremen.gov2.jca_provider.ocf.model.Type;
import de.bos_bremen.gov2.jca_provider.ocf.model.TypedType;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardApplicationImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardFileImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardKeyImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectManagerImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectRegistryImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardPinImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import opencard.core.service.CardChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StarCOS35SignTrustV3
extends StarCOS35 {
    private static final byte PINID_CH = 6;
    private static final String NAME_QES_SIGNATURE_KEY = "QESSignatureKey";
    private static final byte PINID_QES1 = -127;
    private static final String AID_EA = "a000000167455349474e";
    private static final Integer INIT_LENGTH = 5;
    private static final Log LOG = LogFactory.getLog(StarCOS35SignTrustV3.class);
    private final String displayName;
    private final String tokenLabel;
    private final boolean stapleSign;
    private final boolean multiSign;
    private final boolean issuerReadRequired;
    public static final String ISSUER_CONSTANT = "5a 0d 64 20 90 02 10";

    public StarCOS35SignTrustV3(String displayName, String issuerConstant, boolean stapleSign, boolean multiSign, Card.CardTypeEnum cardType, boolean issuerReadRequired) {
        super(cardType, new String[]{"80 59 53 69 67 6e 74 72 75 73 74 81 05"});
        this.displayName = displayName;
        this.tokenLabel = issuerConstant;
        this.stapleSign = stapleSign;
        this.multiSign = multiSign;
        this.issuerReadRequired = issuerReadRequired;
    }

    @Override
    public final String getDisplayName() {
        return this.displayName;
    }

    @Override
    public final boolean isMultiSign() {
        return this.multiSign;
    }

    @Override
    public boolean isStapleSign() {
        return this.stapleSign || GovCS.isStapleSign(this);
    }

    @Override
    protected final boolean isIssuerReadRequired() {
        return this.issuerReadRequired;
    }

    @Override
    protected String getIssuerConstant() {
        return this.tokenLabel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final String readIssuerFromATR(CardChannel _channel) {
        Object readIssuerFromATR = super.readIssuerFromATR(_channel);
        if (ISSUER_CONSTANT.equals(readIssuerFromATR)) {
            try {
                this.selectFile(_channel, new FileReference(2, "0013"));
                ASN1 mfPinCHRecord = this.findEFKEYDRecord(_channel, new StarCOS35.PwdRecordMatcher(6), null);
                StarCOS35SignTrustV3.logLifeCycle("PIN.CH", "MF", mfPinCHRecord);
                this.selectSubDirectory(_channel, new FileReference(4, "D2 76 00 00 66 01"));
                this.selectFile(_channel, new FileReference(2, "0013"));
                ASN1 dfPinQESRecord = this.findEFKEYDRecord(_channel, new StarCOS35.PwdRecordMatcher(-127), null);
                if (dfPinQESRecord != null) {
                    StarCOS35SignTrustV3.logLifeCycle("PIN.CH", "DF.QES", dfPinQESRecord);
                    ASN1 ssec = StarCOS35SignTrustV3.getASN1Child(dfPinQESRecord, SSEC_PATH);
                    if (ssec != null) {
                        LOG.debug((Object)("SSEC for password of QES:\n" + HexUtil.dump(ssec.getEncoded())));
                        readIssuerFromATR = (String)readIssuerFromATR + " " + HexUtil.hexify(ssec.getValue());
                    }
                }
            }
            catch (Exception e) {
                LOG.debug((Object)("failed reading EF.KEYD of MF/DF.QES for PIN.CH or PIN.QES: " + e.getMessage()), (Throwable)e);
            }
            finally {
                try {
                    this.selectMasterFile(_channel);
                }
                catch (Exception e) {
                    LOG.debug((Object)("select MF failed: " + e.getMessage()), (Throwable)e);
                }
            }
        }
        return readIssuerFromATR;
    }

    private static void logLifeCycle(String pinName, String dfName, ASN1 pwdRecord) {
        if (pwdRecord == null) {
            return;
        }
        LOG.debug((Object)("EF.KEYD of " + dfName + " for PINID of " + pinName + ":\n" + HexUtil.dump(pwdRecord.getEncoded())));
        ASN1 lifeCycle = StarCOS35SignTrustV3.getASN1Child(pwdRecord, (byte)-118);
        if (lifeCycle != null) {
            byte[] lifeCycleValue = lifeCycle.getValue();
            LOG.debug((Object)("lifeCycle " + pinName + " (active: " + (5 == lifeCycleValue[0]) + "): " + HexUtil.hexify(lifeCycleValue)));
        }
    }

    @Override
    public final Integer getStapleSignCounter() {
        return this.stapleSign ? Integer.valueOf(100) : (this.isStapleSign() ? MAXIMUM_COUNT_OF_STAPLE_SIGNATURES : null);
    }

    @Override
    protected final Card createCardInt(Terminal pTerminal, int pSlotID) {
        long idOfCard = CARD_OBJECT_REGISTRY.createNewCardID();
        long idOfMFApplication = 1000000L;
        long idOfPinCH = 2000001L;
        byte pinID = 6;
        FileReference dirRefMF = new FileReference(0, "3f00");
        FileEntry fileEntryMF = new FileEntry(dirRefMF, dirRefMF);
        CardPinImpl pinCH = new CardPinImpl(Disposeable.NO_LOCK, "PIN.CH", idOfPinCH, CardPin.CardPinTypeEnum.PIN.getType(), fileEntryMF, idOfCard, idOfMFApplication, pTerminal.getID(), pSlotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID, new long[]{4000001L});
        CardApplication applicationQES = this.createQESApp(pTerminal, pSlotID, idOfCard, idOfMFApplication);
        CardApplication applicationESIGN = this.createEAApp(pTerminal, pSlotID, idOfCard, idOfMFApplication, idOfPinCH);
        CardObjectManagerImpl mfManager = new CardObjectManagerImpl(idOfMFApplication);
        mfManager.putApplication(applicationQES);
        mfManager.putApplication(applicationESIGN);
        mfManager.putPin(pinCH);
        CardApplicationImpl mfApplication = new CardApplicationImpl("MF", idOfMFApplication, CardApplication.CardApplicationTypeEnum.MF.getType(), fileEntryMF, (CardObjectManager)mfManager, idOfCard, idOfMFApplication, pTerminal.getID(), pSlotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        CardImpl card = new CardImpl(this.getDisplayName() + "-" + String.valueOf(idOfCard), idOfCard, this.cardType.getType(), super.getCard(), mfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance());
        return card;
    }

    protected CardApplication createEAApp(Terminal pTerminal, int pSlotID, long idOfCard, long idOfMFApplication, long idOfPinCH) {
        String aid = AID_EA;
        long idOfApplication = 1000002L;
        long idOfFile01 = 3000005L;
        long idOfFile02 = 3000006L;
        long idOfFile03 = 3000007L;
        long idOfFile04 = 3000008L;
        long idOfFile05 = 3000009L;
        long idOfFile06 = 3000010L;
        long idOfKey01 = 4000002L;
        long idOfKey02 = 4000003L;
        KeyID k01 = new KeyID("86");
        KeyID k02 = new KeyID("93");
        FileReference dirRefApp = new FileReference(4, aid);
        FileReference cerRef01 = new FileReference(2, "c500");
        FileEntry fileEntry01 = new FileEntry(dirRefApp, cerRef01);
        FileReference cerRef02 = new FileReference(2, "c508");
        FileEntry fileEntry02 = new FileEntry(dirRefApp, cerRef02);
        FileReference cerRef03 = new FileReference(2, "c50e");
        FileEntry fileEntry03 = new FileEntry(dirRefApp, cerRef03);
        FileReference cerRef04 = new FileReference(2, "c200");
        FileEntry fileEntry04 = new FileEntry(dirRefApp, cerRef04);
        FileReference cerRef05 = new FileReference(2, "c208");
        FileEntry fileEntry05 = new FileEntry(dirRefApp, cerRef05);
        FileReference cerRef06 = new FileReference(2, "c20e");
        FileEntry fileEntry06 = new FileEntry(dirRefApp, cerRef06);
        OCFCertificateInfo info01 = new OCFCertificateInfo(idOfCard, idOfPinCH, idOfFile01, idOfKey01, OCFCertificateInfo.ChainEntry.USER, null, null);
        OCFCertificateInfo info02 = new OCFCertificateInfo(idOfCard, -1L, idOfFile02, -1L, OCFCertificateInfo.ChainEntry.CA, null, null);
        OCFCertificateInfo info03 = new OCFCertificateInfo(idOfCard, -1L, idOfFile03, -1L, OCFCertificateInfo.ChainEntry.ROOT, null, null);
        OCFCertificateInfo info04 = new OCFCertificateInfo(idOfCard, idOfPinCH, idOfFile04, idOfKey02, OCFCertificateInfo.ChainEntry.USER, null, null);
        OCFCertificateInfo info05 = new OCFCertificateInfo(idOfCard, -1L, idOfFile05, -1L, OCFCertificateInfo.ChainEntry.CA, null, null);
        OCFCertificateInfo info06 = new OCFCertificateInfo(idOfCard, -1L, idOfFile06, -1L, OCFCertificateInfo.ChainEntry.ROOT, null, null);
        CardFileImpl file01 = new CardFileImpl(Disposeable.NO_LOCK, "cerAut", idOfFile01, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry01, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), idOfKey01);
        CardFileImpl file02 = new CardFileImpl(Disposeable.NO_LOCK, "caAut", idOfFile02, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry02, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), -1L, info02);
        CardFileImpl file03 = new CardFileImpl(Disposeable.NO_LOCK, "rcaAut", idOfFile03, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry03, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), -1L, info03);
        CardFileImpl file04 = new CardFileImpl(Disposeable.NO_LOCK, "cerEnc", idOfFile04, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry04, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), idOfKey02);
        CardFileImpl file05 = new CardFileImpl(Disposeable.NO_LOCK, "caEnc", idOfFile05, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry05, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), -1L, info05);
        CardFileImpl file06 = new CardFileImpl(Disposeable.NO_LOCK, "rcaEnc", idOfFile06, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry06, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), -1L, info06);
        CardKeyImpl key01 = new CardKeyImpl(Disposeable.NO_LOCK, "AuthenticationKey", idOfKey01, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.SIGNATURE.getType(), CardKey.CardKeyTypeEnum.ADVANCED_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.DEFAULT_AUTHENTICATION.getType(), CardKey.CardKeyTypeEnum.AUTHENTICATION.getType()}), fileEntry01, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), info01, idOfFile01, idOfPinCH, k01);
        CardKeyImpl key02 = new CardKeyImpl(Disposeable.NO_LOCK, "DecryptionKey", idOfKey02, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DECRYPTION.getType(), CardKey.CardKeyTypeEnum.DEFAULT_DECRYPTION.getType()}), fileEntry04, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), info04, idOfFile04, idOfPinCH, k02);
        AlgorithmProvider<OCFPrivateKey> algorithmProvider01 = this.createDefaultAlgorithmProviderSignatureAndOrAuthentication(Arrays.asList(UsageRelated.Usage.SIGNATURE, UsageRelated.Usage.AUTHENTICATION));
        key01.setAlgorithmProvider(algorithmProvider01);
        AlgorithmProvider<OCFPrivateKey> algorithmProvider02 = this.createDefaultAlgorithmProviderDecryption();
        key02.setAlgorithmProvider(algorithmProvider02);
        CardObjectManagerImpl managerApp = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl applicationApp = new CardApplicationImpl(aid, idOfApplication, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.SIGNATURE.getType(), CardApplication.CardApplicationTypeEnum.AUTHENTICATION.getType(), CardApplication.CardApplicationTypeEnum.DECRYPTION.getType()}), fileEntry03, (CardObjectManager)managerApp, idOfCard, idOfMFApplication, pTerminal.getID(), pSlotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        applicationApp.putFile(file01);
        applicationApp.putFile(file02);
        applicationApp.putFile(file03);
        applicationApp.putFile(file04);
        applicationApp.putFile(file05);
        applicationApp.putFile(file06);
        applicationApp.putKey(key01);
        applicationApp.putKey(key02);
        return applicationApp;
    }

    private CardApplication createQESApp(Terminal pTerminal, int pSlotID, long idOfCard, long idOfMFApplication) {
        String aid = "d27600006601";
        long idOfApplication = 1000001L;
        long idOfPin01 = 2000002L;
        long idOfFile01 = 3000001L;
        long idOfFile02 = 3000002L;
        long idOfFile03 = 3000003L;
        long idOfFile04 = 3000004L;
        long idOfKey01 = 4000001L;
        KeyID k01 = new KeyID("84");
        byte pinID01 = -127;
        FileReference dirRefApp = new FileReference(4, aid);
        FileReference cerRef01 = new FileReference(2, "c000");
        FileEntry fileEntry01 = new FileEntry(dirRefApp, cerRef01);
        FileReference cerRef02 = new FileReference(2, "c008");
        FileEntry fileEntry02 = new FileEntry(dirRefApp, cerRef02);
        FileReference cerRef03 = new FileReference(2, "c00e");
        FileEntry fileEntry03 = new FileEntry(dirRefApp, cerRef03);
        FileReference cerRef04 = new FileReference(2, "c100");
        FileEntry fileEntry04 = new FileEntry(dirRefApp, cerRef04);
        OCFCertificateInfo info01 = new OCFCertificateInfo(idOfCard, idOfPin01, idOfFile01, idOfKey01, OCFCertificateInfo.ChainEntry.USER, null, null);
        OCFCertificateInfo info02 = new OCFCertificateInfo(idOfCard, -1L, idOfFile02, -1L, OCFCertificateInfo.ChainEntry.CA, null, null);
        OCFCertificateInfo info03 = new OCFCertificateInfo(idOfCard, -1L, idOfFile03, -1L, OCFCertificateInfo.ChainEntry.ROOT, null, null);
        CardPinImpl pin01 = new CardPinImpl(Disposeable.NO_LOCK, "Signatur-PIN", idOfPin01, CardPin.CardPinTypeEnum.PIN.getType(), fileEntry01, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID01, new long[]{idOfKey01});
        CardFileImpl file01 = new CardFileImpl(Disposeable.NO_LOCK, "cerQES", idOfFile01, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry01, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), idOfKey01);
        CardFileImpl file02 = new CardFileImpl(Disposeable.NO_LOCK, "caQES", idOfFile02, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry02, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), -1L, info02);
        CardFileImpl file03 = new CardFileImpl(Disposeable.NO_LOCK, "rcaQES", idOfFile03, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry03, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), -1L, info03);
        CardFileImpl file04 = new CardFileImpl(Disposeable.NO_LOCK, "attrCer", idOfFile04, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry04, idOfCard, idOfApplication, pTerminal.getID(), this.slotID, this, CardObjectRegistryImpl.getInstance(), -1L);
        CardKeyImpl key01 = new CardKeyImpl(Disposeable.NO_LOCK, NAME_QES_SIGNATURE_KEY, idOfKey01, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.SIGNATURE.getType(), CardKey.CardKeyTypeEnum.QUALIFIED_SIGNATURE.getType()}), fileEntry01, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), info01, new long[]{idOfFile01}, new long[]{idOfFile04}, new long[]{idOfPin01}, k01);
        AlgorithmProvider<OCFPrivateKey> algorithmProvider01 = this.createDefaultAlgorithmProviderSignatureAndOrAuthentication(Arrays.asList(UsageRelated.Usage.SIGNATURE));
        key01.setAlgorithmProvider(algorithmProvider01);
        CardObjectManagerImpl managerApp = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl applicationApp = new CardApplicationImpl(aid, idOfApplication, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.SIGNATURE.getType()}), fileEntry01, (CardObjectManager)managerApp, idOfCard, idOfMFApplication, pTerminal.getID(), pSlotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        applicationApp.putPin(pin01);
        applicationApp.putFile(file01);
        applicationApp.putFile(file02);
        applicationApp.putFile(file03);
        applicationApp.putFile(file04);
        applicationApp.putKey(key01);
        return applicationApp;
    }

    @Override
    public final Integer getMaxPINLengthInit(OCFCertificateInfo _info) {
        return INIT_LENGTH;
    }

    @Override
    public final Integer getMinPINLengthInit(OCFCertificateInfo _info) {
        return INIT_LENGTH;
    }

    @Override
    public final int getPasswordBlockLength(OCFCertificateInfo _info) {
        return 8;
    }

    @Override
    protected byte[] getPaddedPIN(OCFCertificateInfo _info, char[] _pin) {
        return this.getPinEncoder(_info).encode(_pin);
    }

    @Override
    public final PinEncoder getPinEncoder(OCFCertificateInfo _info) {
        return PinEncoder.ENCODER_FORMAT_2_PIN_BLOCK;
    }

    @Override
    public final byte getPasswordBlockFiller(OCFCertificateInfo _info) {
        return -1;
    }

    @Override
    public final int getMinPINLength(OCFCertificateInfo info) {
        return 6;
    }

    @Override
    public final int getMaxPINLength(OCFCertificateInfo info) {
        return 12;
    }

    @Override
    public List<String> getAvailableHashAlgorithmNames(OCFCertificateInfo _info) {
        ArrayList<String> c = new ArrayList<String>();
        if (_info.getUsage() != OCFCertificateInfo.Usage.ENC) {
            c.add("SHA1");
            c.add("SHA224");
            c.add("SHA384");
            c.add("SHA512");
            c.add("SHA256");
        }
        return c;
    }
}

